/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.HeapDumpNotSupportedException;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.rule.IRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleLookup;
import com.ibm.ws.performance.tuning.serverAlert.MBeanNotificationResponse;
import com.ibm.ws.performance.tuning.serverAlert.ParsedMbeanAttribute;
import com.ibm.ws.performance.tuning.serverAlert.ServerRuleDriver;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import com.ibm.wsspi.rasdiag.DiagnosticEventFactory;
import com.ibm.wsspi.rasdiag.DiagnosticProvider;
import com.ibm.wsspi.rasdiag.DiagnosticProviderHelper;
import com.ibm.wsspi.rasdiag.DiagnosticTypedValue;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.AttributeInfo;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.DiagnosticProviderInfo;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.TestInfo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class ServerRuleDriverMBean
extends ServerRuleDriver
implements DiagnosticProvider {
    private ObjectName on = null;
    private String diagnosticProviderID = null;
    public static final String SEPERATOR = "_";
    public static final String LOCAL_ID_SEP = "-";
    public static final String LOCAL_ID_JOIN = ":";
    private Integer outputType = new Integer(203);
    private Integer notificationLevel = new Integer(104);
    private HashMap ruleHash;
    private MBeanNotificationResponse mbeanResponse;
    private String dClassName = this.getClass().getName();
    private String dDescription = "perfalert.webui.title";
    private boolean resetTitle = false;
    private boolean registered = false;
    private int wait = 0;
    public static final String MBEAN_TYPE = "RuntimeAdvisor";
    public static final String MBEAN_ID = "RuntimeAdvisor";
    public static final String DP_NAME = "AdvisorDP";
    public static final int ALL_STATE = 0;
    public static final int CONFIGURATION_STATE = 1;
    public static final int DIAGNOSTIC_STATE = 2;
    private static TraceComponent tc = Tr.register(ServerRuleDriverMBean.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public void initStartup() throws Exception {
        Tr.entry(tc, "initStartup serverRuleDriverMBean");
        try {
            super.initStartup();
            if (!this.pmiEnabled) {
                this.issueWarning_noPmi(this.serverPmiEnabled, this.nodeAgentPmiEnabled);
            }
            this.registerMBean();
            this.createRegistryMBeanResponse();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServerRuleDriverMBean.initStartup: caught and rethrowing exception: " + exception.toString());
            }
            Tr.exit(tc, "initStartup serverRuleDriverMBean");
            throw exception;
        }
        Tr.exit(tc, "initStartup serverRuleDriverMBean");
    }

    protected void privateCompleteInit() throws Exception {
        Tr.entry(tc, "privateCompleteInit - mbean");
        super.privateCompleteInit();
        this.createRuleHash();
        Tr.exit(tc, "privateCompleteInit - mbean");
    }

    private void createRuleHash() {
        Tr.entry(tc, "createRuleHash");
        this.ruleHash = new HashMap();
        super.initRules();
        ArrayList arrayList = super.getRules();
        if (arrayList != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ruleList is not equal to null size is " + arrayList.size());
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                IRule iRule = (IRule)arrayList.get(i);
                String string = iRule.getRuleId();
                this.ruleHash.put(string, iRule);
            }
        }
        Tr.entry(tc, "createRuleHash");
    }

    public String getDiagnosticProviderName() {
        return DP_NAME;
    }

    public String getDiagnosticProviderId() {
        return this.diagnosticProviderID;
    }

    public DiagnosticProviderInfo getRegisteredDiagnostics() {
        Tr.entry(tc, "getRegisteredDiagnostics");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loading diag provider registration");
        }
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("com/ibm/ws/performance/tuning/AdvisorDiagnosticProvider.xml");
        DiagnosticProviderInfo diagnosticProviderInfo = DiagnosticProviderHelper.loadRegistry(inputStream, this.diagnosticProviderID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "generated diag provider info : " + diagnosticProviderInfo.toString());
        }
        Tr.exit(tc, "getRegisteredDiagnostics");
        return diagnosticProviderInfo;
    }

    private boolean checkIfTestRegistered(String string, TestInfo[] testInfoArray, boolean bl) {
        String[] stringArray = new String[testInfoArray.length];
        for (int i = 0; i < testInfoArray.length; ++i) {
            stringArray[i] = testInfoArray[i].id;
        }
        return this.checkIfIdRegistered(string, stringArray, bl);
    }

    private boolean checkIfAttributeRegistered(String string, AttributeInfo[] attributeInfoArray, boolean bl) {
        int n;
        Tr.entry(tc, "checkIfAttributeRegistered");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < attributeInfoArray.length; ++i) {
            AttributeInfo attributeInfo = attributeInfoArray[i];
            if (!attributeInfo.registered) continue;
            arrayList.add(attributeInfo.id);
        }
        String[] stringArray = new String[arrayList.size()];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "there are " + arrayList.size() + " registeredAttributes ");
        }
        for (n = 0; n < arrayList.size(); ++n) {
            stringArray[n] = (String)arrayList.get(n);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, stringArray[n] + " is registered ");
        }
        n = this.checkIfIdRegistered(string, stringArray, bl) ? 1 : 0;
        Tr.exit(tc, "checkIfAttributeRegistered");
        return n != 0;
    }

    private boolean checkIfIdRegistered(String string, String[] stringArray, boolean bl) {
        Tr.entry(tc, "checkIfRegistered");
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checking " + string + " against " + stringArray[i]);
                }
                if (!string.equals(stringArray[i])) continue;
                Tr.exit(tc, "checkIfRegistered - true");
                return true;
            }
            Tr.exit(tc, "checkIfRegistered - false");
            return false;
        }
        Tr.exit(tc, "checkIfRegistered - n/a");
        return true;
    }

    private HashMap getAttributeDescriptionKeyMap(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        String string;
        String string2;
        Object object;
        int n;
        Tr.entry(tc, "getAttributeDescriptionKeyMap");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (n = 0; n < arrayList.size(); ++n) {
            object = (ParsedMbeanAttribute)arrayList.get(n);
            string2 = ((ParsedMbeanAttribute)object).getParamId();
            string = ((ParsedMbeanAttribute)object).getDesLookup();
            hashMap.put(string2, string);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            object = (ParsedMbeanAttribute)arrayList2.get(n);
            string2 = ((ParsedMbeanAttribute)object).getParamId();
            string = ((ParsedMbeanAttribute)object).getDesLookup();
            hashMap.put(string2, string);
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            object = (ParsedMbeanAttribute)arrayList3.get(n);
            string2 = ((ParsedMbeanAttribute)object).getId() + SEPERATOR + ((ParsedMbeanAttribute)object).getParamId();
            string = ((ParsedMbeanAttribute)object).getDesLookup();
            hashMap.put(string2, string);
        }
        if (tc.isDebugEnabled()) {
            Set set = hashMap.keySet();
            Tr.debug(tc, "printing out descriptions keys");
            object = set.iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                string = (String)hashMap.get(string2);
                Tr.debug(tc, "   " + string2 + LOCAL_ID_JOIN + string);
            }
        }
        Tr.exit(tc, "getAttributeDescriptionKeyMap");
        return hashMap;
    }

    private void addTypedValueToHashMap(String string, String string2, Object object, HashMap hashMap, HashMap hashMap2) {
        block14: {
            Tr.entry(tc, "addTypedValueToHashMap");
            try {
                DiagnosticTypedValue diagnosticTypedValue = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, LOCAL_ID_SEP);
                String string3 = !hashMap.containsKey(string) ? "perftuningAdmin.attribute.des.unknown" : (String)hashMap.get(string);
                if (object instanceof Boolean) {
                    diagnosticTypedValue = new DiagnosticTypedValue((Boolean)object, string3);
                    hashMap2.put(string2, diagnosticTypedValue);
                } else if (object instanceof Integer) {
                    diagnosticTypedValue = new DiagnosticTypedValue((Integer)object, string3);
                    hashMap2.put(string2, diagnosticTypedValue);
                } else if (object instanceof String) {
                    diagnosticTypedValue = new DiagnosticTypedValue((String)object, string3);
                    hashMap2.put(string2, diagnosticTypedValue);
                } else if (object instanceof String[]) {
                    ArrayList<String> arrayList = new ArrayList<String>(((String[])object).length);
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        arrayList.add(((String[])object)[i]);
                    }
                    DiagnosticTypedValue.addCollectionToHashMap(hashMap2, string2, arrayList, string3);
                } else if (object instanceof Collection) {
                    DiagnosticTypedValue.addCollectionToHashMap(hashMap2, string2, (Collection)object, string3);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unsuported class : " + object.getClass().getName() + " for " + string2);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug(tc, "could not add key from param map : " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "addTypedValueToHashMap");
    }

    private Pattern[] createRegExArrayFromLocalId(String string) {
        try {
            if (string == null) {
                return new Pattern[0];
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, LOCAL_ID_JOIN);
            Pattern[] patternArray = new Pattern[stringTokenizer.countTokens()];
            for (int i = 0; i < patternArray.length; ++i) {
                try {
                    patternArray[i] = Pattern.compile(stringTokenizer.nextToken());
                    continue;
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "could not compile pattern : " + exception.toString());
                    exception.printStackTrace();
                }
            }
            return patternArray;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "could not create Pattern[] from : " + string);
                exception.printStackTrace();
            }
            return new Pattern[0];
        }
    }

    public DiagnosticEvent[] configDump(String string, boolean bl) {
        Tr.entry(tc, "configDump");
        if (!this.initializationCompleted) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configDump is calling completeInit");
            }
            this.completeInit();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "localID " + string);
            Tr.debug(tc, "registeredOnly " + bl);
        }
        DiagnosticEvent[] diagnosticEventArray = new DiagnosticEvent[1];
        if (string == null || string.equals("")) {
            string = ".*";
        }
        try {
            Object object;
            String string2;
            Object object2;
            RuleLookup ruleLookup = super.loadRuleLookup();
            ArrayList arrayList = ruleLookup.getRules();
            HashMap hashMap = ruleLookup.getParamMap();
            HashMap hashMap2 = new HashMap();
            ArrayList arrayList2 = new ArrayList();
            Pattern[] patternArray = null;
            try {
                patternArray = this.createRegExArrayFromLocalId(string);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "illegal pattern : " + exception.toString());
                    exception.printStackTrace();
                }
                return new DiagnosticEvent[0];
            }
            AttributeInfo[] attributeInfoArray = null;
            HashMap hashMap3 = null;
            HashMap hashMap4 = new HashMap();
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                string2 = object2;
                object = hashMap.get(object2);
                hashMap4.put(string2, object);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                object2 = (RuleData)arrayList.get(i);
                if (!((RuleData)object2).getType().equalsIgnoreCase("server") || !((RuleData)object2).getZos_enabled()) continue;
                string2 = ((RuleData)object2).getRuleID() + LOCAL_ID_SEP + "enable";
                object = new Boolean(((RuleData)object2).getEnabled());
                hashMap4.put(string2, object);
            }
            set = hashMap4.keySet();
            Object object3 = set.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                string2 = hashMap4.get(object2);
                object = "startup-" + (String)object2;
                boolean bl2 = false;
                for (int i = 0; i < patternArray.length; ++i) {
                    if (!patternArray[i].matcher((CharSequence)object).matches()) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    if (attributeInfoArray == null) {
                        attributeInfoArray = this.getRegisteredDiagnostics().configInfo.attributeInfo;
                    }
                    if (hashMap3 == null) {
                        hashMap3 = this.getAttributeDescriptionKeyMap(this.getRPAAttributeInfo(), this.getAdvancedRPAAttributeInfo(), this.getRulesInfo());
                    }
                    if (this.checkIfAttributeRegistered((String)object, attributeInfoArray, bl)) {
                        this.addTypedValueToHashMap((String)object2, (String)object, string2, hashMap3, hashMap2);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, (String)object2 + " did not pass registered test");
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, (String)object2 + " did not match " + string);
            }
            object3 = this.getStatePayLoadForDiagnosticEvent(patternArray, bl, 1, hashMap3);
            hashMap2.putAll(object3);
            diagnosticEventArray[0] = DiagnosticEventFactory.createConfigDump(this.diagnosticProviderID, this.getClass().getName().toString(), "configDump", hashMap2);
            return diagnosticEventArray;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error generating configDump : " + exception.toString());
                exception.printStackTrace();
            }
            return new DiagnosticEvent[0];
        }
    }

    public DiagnosticEvent[] stateDump(String string, boolean bl) {
        Tr.entry(tc, "stateDump");
        try {
            if (!this.initializationCompleted) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stateDump is calling completeInit");
                }
                this.completeInit();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "aLocalId : " + string + " aRegisteredOnliy : " + bl);
            }
            DiagnosticEvent[] diagnosticEventArray = new DiagnosticEvent[1];
            if (string == null || string.equals("")) {
                string = ".*";
            }
            Pattern[] patternArray = null;
            try {
                patternArray = this.createRegExArrayFromLocalId(string);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "illegal pattern : " + exception.toString());
                    exception.printStackTrace();
                }
                return new DiagnosticEvent[0];
            }
            HashMap hashMap = null;
            HashMap hashMap2 = this.getStatePayLoadForDiagnosticEvent(patternArray, bl, 2, hashMap);
            diagnosticEventArray[0] = DiagnosticEventFactory.createStateDump(this.diagnosticProviderID, this.getClass().getName().toString(), "stateDump", hashMap2);
            Tr.exit(tc, "stateDump");
            return diagnosticEventArray;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "state dump caught exception : " + exception.toString());
                exception.printStackTrace();
            }
            Tr.exit(tc, "stateDump");
            return new DiagnosticEvent[0];
        }
    }

    public HashMap getStatePayLoadForDiagnosticEvent(Pattern[] patternArray, boolean bl, int n, HashMap hashMap) {
        Tr.entry(tc, "getAttributesForDiagnosticEvent");
        try {
            if (!this.initializationCompleted) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getStatePayLoadForDiagnosticEvent is calling completeInit");
                }
                this.completeInit();
            }
            HashMap hashMap2 = new HashMap();
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.getAdvancedRPAAttributeInfo(n, false);
            ArrayList arrayList3 = this.getRulesInfo(n, false);
            ArrayList arrayList4 = new ArrayList(arrayList.size() + arrayList2.size() + arrayList3.size());
            arrayList4.addAll(arrayList);
            arrayList4.addAll(arrayList2);
            arrayList4.addAll(arrayList3);
            AttributeInfo[] attributeInfoArray = null;
            for (int i = 0; i < arrayList4.size(); ++i) {
                int n2;
                ParsedMbeanAttribute parsedMbeanAttribute = (ParsedMbeanAttribute)arrayList4.get(i);
                String string = null;
                String string2 = null;
                string2 = n == 1 ? "current-" : new String();
                if (parsedMbeanAttribute.isAdvice()) {
                    string2 = string2 + parsedMbeanAttribute.getId() + LOCAL_ID_SEP + parsedMbeanAttribute.getParamId();
                    string = parsedMbeanAttribute.getId() + SEPERATOR + parsedMbeanAttribute.getParamId();
                } else {
                    string2 = string2 + parsedMbeanAttribute.getParamId();
                    string = parsedMbeanAttribute.getParamId();
                }
                boolean bl2 = false;
                for (n2 = 0; n2 < patternArray.length; ++n2) {
                    if (!patternArray[n2].matcher(string2).matches()) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    if (hashMap == null) {
                        hashMap = this.getAttributeDescriptionKeyMap(arrayList, arrayList2, arrayList3);
                    }
                    if (bl) {
                        if (attributeInfoArray == null) {
                            attributeInfoArray = n == 1 ? this.getRegisteredDiagnostics().configInfo.attributeInfo : this.getRegisteredDiagnostics().stateInfo.attributeInfo;
                        }
                        n2 = this.checkIfAttributeRegistered(string2, attributeInfoArray, bl) ? 1 : 0;
                    } else {
                        n2 = 1;
                    }
                    if (n2 != 0) {
                        this.addTypedValueToHashMap(string, string2, this.getRPAAttributeValue(string), hashMap, hashMap2);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, string2 + " did not pass registered test");
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "did not match : " + string2);
            }
            Tr.exit(tc, "getAttributesForDiagnosticEvent");
            return hashMap2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getAttributesForDiagnosticEvent caught exception : " + exception.toString());
                exception.printStackTrace();
            }
            Tr.exit(tc, "getAttributesForDiagnosticEvent");
            return new HashMap();
        }
    }

    public DiagnosticEvent[] selfDiagnostic(String string, boolean bl) {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "selfDiagnostic - " + string + ", registeredOnly " + bl);
            }
            if (!this.initializationCompleted) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "selfDiagnstic is calling completeInit");
                }
                this.completeInit();
            }
            ArrayList<DiagnosticEvent> arrayList = new ArrayList<DiagnosticEvent>();
            if (!this.enabled) {
                DiagnosticEvent[] diagnosticEventArray = new DiagnosticEvent[1];
                HashMap<String, DiagnosticTypedValue> hashMap = new HashMap<String, DiagnosticTypedValue>();
                DiagnosticTypedValue diagnosticTypedValue = new DiagnosticTypedValue(false, "perfalert.selfDiagnostic.available");
                hashMap.put("Advisor-diagnosticAvailable", diagnosticTypedValue);
                diagnosticEventArray[0] = DiagnosticEventFactory.createDiagnosticEvent(this.diagnosticProviderID, "selfDiagnostic", 10, this.getClass().getName(), "selfDiagnostic", "com.ibm.ws.performance.tuning.properties.perftuning", "perfalert.selfDiagnostic.rpa.disabled", new Object[0], hashMap);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "rule engine is not enabled : " + diagnosticEventArray[0]);
                }
                return diagnosticEventArray;
            }
            if (string == null || string.equals("")) {
                string = ".*";
            }
            Pattern[] patternArray = null;
            try {
                patternArray = this.createRegExArrayFromLocalId(string);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "illegal pattern : " + exception.toString());
                    exception.printStackTrace();
                }
                return new DiagnosticEvent[0];
            }
            TestInfo[] testInfoArray = null;
            for (int i = 0; i < this.rules.size(); ++i) {
                int n;
                String string2;
                IRule iRule = (IRule)this.rules.get(i);
                String string3 = string2 = iRule.getRuleId();
                boolean bl2 = false;
                for (n = 0; n < patternArray.length; ++n) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attempting to match : " + string3 + " and " + patternArray[n].toString());
                    }
                    if (!patternArray[n].matcher(string3).matches()) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matched rule " + string3 + "with self diagnostic spec");
                }
                if (!bl) {
                    n = 1;
                } else {
                    if (testInfoArray == null) {
                        testInfoArray = this.getRegisteredDiagnostics().selfDiagnosticInfo.testInfo;
                    }
                    n = this.checkIfTestRegistered(string3, testInfoArray, bl) ? 1 : 0;
                }
                if (n != 0) {
                    DiagnosticEvent[] diagnosticEventArray = iRule.selfDiagnostic(this.diagnosticProviderID);
                    for (int j = 0; j < diagnosticEventArray.length; ++j) {
                        arrayList.add(diagnosticEventArray[j]);
                    }
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, string3 + " did not pass registration test");
            }
            DiagnosticEvent[] diagnosticEventArray = new DiagnosticEvent[arrayList.size()];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "returning " + arrayList.size() + " events ");
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                diagnosticEventArray[i] = (DiagnosticEvent)arrayList.get(i);
            }
            return diagnosticEventArray;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught in selfDiagnostic : " + exception.toString());
                exception.printStackTrace();
            }
            return new DiagnosticEvent[0];
        }
    }

    public String[] localize(String[] stringArray, Locale locale) {
        return DiagnosticProviderHelper.localize("com.ibm.ws.performance.tuning.properties.perftuning", stringArray, locale);
    }

    private void registerMBean() {
        block6: {
            try {
                block8: {
                    block7: {
                        if (this.registered) break block6;
                        Properties properties = this.buildGUIMetadata();
                        properties.setProperty("diagnosticProvider", "true");
                        properties.setProperty("name", "Runtime Advisor");
                        DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(this);
                        MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
                        String string = "com/ibm/ws/performance/tuning/ServerRuleDriverMBean.xml";
                        this.on = mBeanFactory.activateMBean("ServerRuleDriverMBean", defaultRuntimeCollaborator, "ServerRuleDriverMBean2", string, properties);
                        this.diagnosticProviderID = this.on.toString();
                        try {
                            DiagnosticProviderHelper.registerMBeanWithDiagnosticService(DP_NAME, this.on);
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block7;
                            Tr.debug(tc, "could not register with diagnostic provider : " + exception.toString());
                            exception.printStackTrace();
                        }
                    }
                    try {
                        tc.setDiagnosticProviderID(this.diagnosticProviderID);
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block8;
                        Tr.debug(tc, "could not register " + this.diagnosticProviderID + " with tc");
                    }
                }
                this.registered = true;
                Tr.debug(tc, "Registered Self as MBean");
            }
            catch (Exception exception) {
                this.registered = false;
                Tr.error(tc, "perfalert.Exception.error" + exception.toString(), new String("registerMBean exception caught registering self as MBean: "));
                exception.printStackTrace();
            }
        }
    }

    public AttributeList getRPAAttributeValues(String[] stringArray) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Tr.entry(tc, "getRPAAttributeValues");
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"), "Cannot invoke a getter of " + this.dClassName);
        }
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object = this.getRPAAttributeValue(stringArray[i]);
                attributeList.add(new Attribute(stringArray[i], object));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "getRPAAttributeValues");
        return attributeList;
    }

    public Object getRPAAttributeValue(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "  getRPAAttribute called for " + string);
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        if (!this.initializationCompleted) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getRPAAttributeValue is calling completeInit");
            }
            this.completeInit();
        }
        if (string.equals("enabled")) {
            return this.getEnabled();
        }
        if (string.equals("maxAlertStreak")) {
            return this.getMaxAlertStreak();
        }
        if (string.equals("heapDumpFileNames")) {
            return super.getHeapDumpFileNames();
        }
        if (string.equals("heapDumpStatus")) {
            return super.getHeapDumpStatus();
        }
        if (string.equals("heapDumpAutomatedGenerationApplicable")) {
            return new Boolean(this.heapDumpResponse.isApplicable());
        }
        if (string.equals("heapDumpNumberToBeAttempted")) {
            return new Integer(this.heapDumpResponse.getNumberOfDumps());
        }
        if (string.equals("heapDumpTriggerPolicy")) {
            return new Integer(this.heapDumpResponse.getPolicyType());
        }
        if (string.equals("duration")) {
            return this.getDuration();
        }
        if (string.equals("traceResponseEnabled")) {
            return new Boolean(this.traceResponse.isEnabled());
        }
        if (string.equals("traceResponseLevel")) {
            return new Integer(this.traceResponse.getNotificationLevel());
        }
        if (string.equals("fileResponseEnabled")) {
            return new Boolean(this.fileResponse.isEnabled());
        }
        if (string.equals("fileResponseLevel")) {
            return new Integer(this.fileResponse.getNotificationLevel());
        }
        if (string.equals("mBeanResponseEnabled")) {
            return new Boolean(this.mbeanResponse.isEnabled());
        }
        if (string.equals("mBeanResponseLevel")) {
            return new Integer(this.mbeanResponse.getNotificationLevel());
        }
        if (string.equals("calculationInterval")) {
            return new Integer(EngineParameters.getCalcInterval());
        }
        if (string.equals("minCpuUsage")) {
            return new Integer(EngineParameters.getMinCpuUsage());
        }
        if (string.equals("cpuSaturated")) {
            return new Integer(EngineParameters.getCpuSaturated());
        }
        if (string.equals("numberOfProcessors")) {
            return new Integer(EngineParameters.getNumProcessors());
        }
        if (string.equals("refreshIteration")) {
            return new Integer(EngineParameters.getRefreshIteration());
        }
        if (string.equals("warnings")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getting atttbute warnings returning " + super.getWarnings());
            }
            return super.getWarningWrappers();
        }
        if (string.equals("pmiDataAvailable")) {
            return new Boolean(this.pmiEnabled);
        }
        if (this.isRule(string)) {
            return this.isRuleEnabled(string);
        }
        if (this.immediateAlertBridge.isImmediateAlert(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "calling is enabled for : " + string);
            }
            return new Boolean(this.immediateAlertBridge.isAlertEnabled(string));
        }
        if (string.equals("heapDumpGenerationEnabled")) {
            return new Boolean(this.heapDumpResponse.isEnabled());
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, SEPERATOR, false);
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getAttribute, must be a rule attribute" + string);
                Tr.debug(tc, "ruleId =" + string2);
                Tr.debug(tc, "paramName =" + string3);
            }
            if (string3.equals("applicable")) {
                return "false";
            }
            if (string3.equals("enable")) {
                IRule iRule = (IRule)this.ruleHash.get(string2);
                if (iRule != null) {
                    return new Boolean(iRule.isEnabled());
                }
                if (this.immediateAlertBridge.isImmediateAlert(string2)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ruleId is an immediate alert");
                    }
                    return new Boolean(this.immediateAlertBridge.isAlertEnabled(string2));
                }
                if (tc.isDebugEnabled()) {
                    this.printRuleHash();
                }
                throw new Exception("could not find : " + string2 + " in ruleHash");
            }
            if (this.ruleHash.containsKey(string2)) {
                return ((IRule)this.ruleHash.get(string2)).getParam(string3);
            }
            if (this.immediateAlertBridge.isImmediateAlert(string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting attribute " + string3 + "  from immediate alert " + string2);
                }
                return this.immediateAlertBridge.getAlertAttribute(string2, string3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "could not find ruleID : " + string2 + " throwing exception");
            }
            throw new AttributeNotFoundException("Could not find alert : " + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AttributeNotFoundException("Exception caught setting " + string + " attribute in " + this.dClassName + ", original exception = " + exception.toString());
        }
    }

    public void setRPAAttributes(AttributeList attributeList) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Tr.entry(tc, "setRPAAttributes");
        for (int i = 0; i < attributeList.size(); ++i) {
            this.setRPAAttribute((Attribute)attributeList.get(i));
        }
        Tr.exit(tc, "setRPAAttributes");
    }

    /*
     * Unable to fully structure code
     */
    public void setRPAAttribute(Attribute var1_1) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block135: {
            Tr.entry(ServerRuleDriverMBean.tc, "setRPAAttribute");
            if (var1_1 == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
            }
            if (!this.initializationCompleted) {
                if (ServerRuleDriverMBean.tc.isDebugEnabled()) {
                    Tr.debug(ServerRuleDriverMBean.tc, "setRPAAttribute is calling completeInit");
                }
                this.completeInit();
            }
            var2_2 = var1_1.getName();
            var3_3 = var1_1.getValue();
            if (ServerRuleDriverMBean.tc.isDebugEnabled()) {
                Tr.debug(ServerRuleDriverMBean.tc, "setting : " + var2_2 + " to " + var3_3);
            }
            if (var2_2 == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.dClassName + " with null attribute name");
            }
            if (var2_2.equals("enabled")) {
                if (var3_3 == null) {
                    this.setEnabled(null);
                } else {
                    try {
                        if (!Class.forName("java.lang.Boolean").isAssignableFrom(var3_3.getClass())) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " object, Boolean expected");
                        }
                        this.setEnabled((Boolean)var3_3);
                    }
                    catch (ClassNotFoundException var4_4) {
                        var4_4.printStackTrace();
                    }
                }
            } else if (var2_2.equals("maxAlertStreak")) {
                if (var3_3 == null) {
                    try {
                        this.setMaxAlertStreak(null);
                    }
                    catch (Exception var4_5) {
                        throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to null");
                    }
                } else {
                    try {
                        if (!Class.forName("java.lang.Integer").isAssignableFrom(var3_3.getClass())) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Integer,  expected");
                        }
                        this.setMaxAlertStreak((Integer)var3_3);
                        EngineParameters.setParam("maxAlertStreak", var3_3);
                    }
                    catch (ClassNotFoundException var4_6) {
                        var4_6.printStackTrace();
                    }
                }
            } else if (var2_2.equals("duration")) {
                if (var3_3 == null) {
                    try {
                        this.setDuration(null);
                    }
                    catch (Exception var4_7) {
                        throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to null");
                    }
                } else {
                    try {
                        if (!Class.forName("java.lang.Integer").isAssignableFrom(var3_3.getClass())) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Integer,  expected");
                        }
                        this.setDuration((Integer)var3_3);
                        EngineParameters.setParam("duration", var3_3);
                    }
                    catch (ClassNotFoundException var4_8) {
                        var4_8.printStackTrace();
                    }
                }
            } else if (var2_2.equals("traceResponseEnabled")) {
                if (var3_3 == null) {
                    throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to null");
                }
                try {
                    if (!Class.forName("java.lang.Boolean").isAssignableFrom(var3_3.getClass())) {
                        throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Boolean,  expected");
                    }
                    this.traceResponse.setEnabled((Boolean)var3_3);
                    EngineParameters.setParam("traceResponseEnabled", var3_3);
                }
                catch (ClassNotFoundException var4_9) {
                    if (!ServerRuleDriverMBean.tc.isDebugEnabled()) ** GOTO lbl275
                    Tr.debug(ServerRuleDriverMBean.tc, "unexpected exception : " + var4_9.toString());
                    var4_9.printStackTrace();
                }
                catch (InvalidAttributeValueException var4_10) {
                    throw var4_10;
                }
                catch (Exception var4_11) {
                    throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to " + var3_3);
                }
            } else {
                if (var2_2.equals("traceResponseLevel")) {
                    if (var3_3 == null) {
                        throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to null");
                    }
                    try {
                        if (!Class.forName("java.lang.Integer").isAssignableFrom(var3_3.getClass())) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Integer,  expected");
                        }
                        this.traceResponse.setNotificationLevel((Integer)var3_3);
                        EngineParameters.setParam("traceResponseLevel", var3_3);
                    }
                    catch (ClassNotFoundException var4_12) {
                        if (ServerRuleDriverMBean.tc.isDebugEnabled()) {
                            Tr.debug(ServerRuleDriverMBean.tc, "unexpected exception : " + var4_12.toString());
                            var4_12.printStackTrace();
                        }
                        break block135;
                    }
                }
                if (var2_2.equals("fileResponseEnabled")) {
                    Tr.debug(ServerRuleDriverMBean.tc, "setting perfTuningAdmin.attribute.fileResponseEnabled");
                    if (var3_3 == null) {
                        throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to null");
                    }
                    try {
                        if (!Class.forName("java.lang.Boolean").isAssignableFrom(var3_3.getClass())) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Boolean,  expected");
                        }
                        this.fileResponse.setEnabled((Boolean)var3_3);
                        EngineParameters.setParam("fileResponseEnabled", var3_3);
                    }
                    catch (ClassNotFoundException var4_13) {
                        if (!ServerRuleDriverMBean.tc.isDebugEnabled()) ** GOTO lbl275
                        Tr.debug(ServerRuleDriverMBean.tc, "unexpected exception : " + var4_13.toString());
                        var4_13.printStackTrace();
                    }
                    catch (InvalidAttributeValueException var4_14) {
                        throw var4_14;
                    }
                    catch (Exception var4_15) {
                        throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to " + var3_3);
                    }
                } else if (var2_2.equals("fileResponseLevel")) {
                    Tr.debug(ServerRuleDriverMBean.tc, "setting perfTuningAdmin.attribute.fileResponseLevel");
                    if (var3_3 == null) {
                        throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to null");
                    }
                    try {
                        if (!Class.forName("java.lang.Integer").isAssignableFrom(var3_3.getClass())) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Integer,  expected");
                        }
                        this.fileResponse.setNotificationLevel((Integer)var3_3);
                        EngineParameters.setParam("fileResponseLevel", var3_3);
                    }
                    catch (ClassNotFoundException var4_16) {
                        var4_16.printStackTrace();
                    }
                } else if (var2_2.equals("mBeanResponseEnabled")) {
                    if (var3_3 == null) {
                        throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to null");
                    }
                    try {
                        if (!Class.forName("java.lang.Boolean").isAssignableFrom(var3_3.getClass())) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Boolean,  expected");
                        }
                        this.mbeanResponse.setEnabled((Boolean)var3_3);
                        EngineParameters.setParam("mBeanResponseEnabled", var3_3);
                    }
                    catch (ClassNotFoundException var4_17) {
                        if (!ServerRuleDriverMBean.tc.isDebugEnabled()) ** GOTO lbl275
                        Tr.debug(ServerRuleDriverMBean.tc, "unexpected exception : " + var4_17.toString());
                        var4_17.printStackTrace();
                    }
                    catch (InvalidAttributeValueException var4_18) {
                        throw var4_18;
                    }
                    catch (Exception var4_19) {
                        throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to " + var3_3);
                    }
                } else if (var2_2.equals("mBeanResponseLevel")) {
                    if (var3_3 == null) {
                        throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to null");
                    }
                    try {
                        if (!Class.forName("java.lang.Integer").isAssignableFrom(var3_3.getClass())) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Integer,  expected");
                        }
                        this.mbeanResponse.setNotificationLevel((Integer)var3_3);
                        EngineParameters.setParam("mBeanResponseLevel", var3_3);
                    }
                    catch (ClassNotFoundException var4_20) {
                        var4_20.printStackTrace();
                    }
                } else if (var2_2.equals("calculationInterval")) {
                    if (var3_3 == null) {
                        throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to null");
                    }
                    try {
                        if (!Class.forName("java.lang.Integer").isAssignableFrom(var3_3.getClass())) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Integer,  expected");
                        }
                        EngineParameters.setParam("calculationInterval", var3_3);
                    }
                    catch (ClassNotFoundException var4_21) {
                        var4_21.printStackTrace();
                    }
                } else if (var2_2.equals("minCpuUsage")) {
                    try {
                        if (!Class.forName("java.lang.Integer").isAssignableFrom(var3_3.getClass())) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Integer,  expected");
                        }
                        EngineParameters.setParam("minCpuUsage", var3_3);
                    }
                    catch (ClassNotFoundException var4_22) {
                        var4_22.printStackTrace();
                    }
                } else if (var2_2.equals("cpuSaturated")) {
                    try {
                        if (!Class.forName("java.lang.Integer").isAssignableFrom(var3_3.getClass())) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Integer,  expected");
                        }
                        EngineParameters.setParam("cpuSaturated", var3_3);
                    }
                    catch (ClassNotFoundException var4_23) {
                        var4_23.printStackTrace();
                    }
                } else if (var2_2.equals("refreshIteration")) {
                    try {
                        if (!Class.forName("java.lang.Integer").isAssignableFrom(var3_3.getClass())) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Integer,  expected");
                        }
                        EngineParameters.setParam("refreshIteration", var3_3);
                    }
                    catch (ClassNotFoundException var4_24) {
                        var4_24.printStackTrace();
                    }
                } else if (var2_2.equals("numberOfProcessors")) {
                    try {
                        if (!Class.forName("java.lang.Integer").isAssignableFrom(var3_3.getClass())) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Integer,  expected");
                        }
                        EngineParameters.setParam("numberOfProcessors", var3_3);
                    }
                    catch (ClassNotFoundException var4_25) {
                        var4_25.printStackTrace();
                    }
                } else if (var2_2.equals("heapDumpGenerationEnabled")) {
                    try {
                        if (!Class.forName("java.lang.Boolean").isAssignableFrom(var3_3.getClass())) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Integer,  expected");
                        }
                        EngineParameters.setParam("heapDumpGenerationEnabled", var3_3);
                        this.heapDumpResponse.setEnabled((Boolean)var3_3);
                    }
                    catch (ClassNotFoundException var4_26) {
                        var4_26.printStackTrace();
                    }
                    catch (HeapDumpNotSupportedException var4_27) {
                        throw new InvalidAttributeValueException(var4_27.getMessage());
                    }
                    catch (Exception var4_28) {
                        throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to " + var3_3);
                    }
                } else if (var2_2.equals("heapDumpNumberToBeAttempted")) {
                    try {
                        if (!Class.forName("java.lang.Integer").isAssignableFrom(var3_3.getClass())) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Integer,  expected");
                        }
                        EngineParameters.setParam("heapDumpNumberToBeAttempted", var3_3);
                        this.heapDumpResponse.setNumberOfDumps((Integer)var3_3);
                    }
                    catch (ClassNotFoundException var4_29) {
                        var4_29.printStackTrace();
                    }
                } else if (var2_2.equals("heapDumpTriggerPolicy")) {
                    try {
                        if (!Class.forName("java.lang.Integer").isAssignableFrom(var3_3.getClass())) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Integer,  expected");
                        }
                        EngineParameters.setParam("heapDumpTriggerPolicy", var3_3);
                        this.heapDumpResponse.setPolicy((Integer)var3_3);
                    }
                    catch (ClassNotFoundException var4_30) {
                        var4_30.printStackTrace();
                    }
                } else {
                    if (var2_2.equals("pdEnabled")) {
                        try {
                            if (!Class.forName("java.lang.Boolean").isAssignableFrom(var3_3.getClass())) {
                                throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to a " + var3_3.getClass().getName() + " Integer,  expected");
                            }
                            EngineParameters.setParam("pdEnabled", var3_3);
                            this.immediateAlertBridge.setEnabled((Boolean)var3_3);
                        }
                        catch (Exception var4_31) {
                            throw new InvalidAttributeValueException("Cannot set attribute " + var2_2 + " to " + var3_3);
                        }
                    }
                    if (this.isRule(var2_2)) {
                        ((IRule)this.ruleHash.get(var2_2)).setEnabled((Boolean)var3_3);
                    } else if (this.immediateAlertBridge.isImmediateAlert(var2_2)) {
                        this.immediateAlertBridge.setAlertEnabled(var2_2, (Boolean)var3_3);
                    } else {
                        var4_32 = new StringTokenizer(var2_2, "_", false);
                        var5_33 = var4_32.nextToken();
                        var6_34 = var4_32.nextToken();
                        try {
                            if (this.ruleHash.containsKey(var5_33)) {
                                if (var6_34.equals("enable")) {
                                    ((IRule)this.ruleHash.get(var5_33)).setEnabled((Boolean)var3_3);
                                } else if (!var6_34.equals("applicable")) {
                                    ((IRule)this.ruleHash.get(var5_33)).setParam(var6_34, (Double)var3_3);
                                }
                                break block135;
                            }
                            if (this.immediateAlertBridge.isImmediateAlert(var5_33)) {
                                if (var6_34.equals("enable")) {
                                    var7_35 = (Boolean)var3_3;
                                    if (ServerRuleDriverMBean.tc.isDebugEnabled()) {
                                        Tr.debug(ServerRuleDriverMBean.tc, "setting immediate alert " + var5_33 + " to  " + var7_35);
                                    }
                                    this.immediateAlertBridge.setAlertEnabled(var5_33, var7_35);
                                } else if (!var6_34.equals("applicable")) {
                                    if (ServerRuleDriverMBean.tc.isDebugEnabled()) {
                                        Tr.debug(ServerRuleDriverMBean.tc, "setting " + var6_34 + " on immediate alert " + var5_33 + " to value " + var3_3);
                                    }
                                    this.immediateAlertBridge.setAlertAttribute(var5_33, var6_34, (Double)var3_3);
                                }
                                break block135;
                            }
                            throw new Exception("Alert " + var5_33 + " is invalid");
                        }
                        catch (Exception var7_36) {
                            var7_36.printStackTrace();
                            throw new AttributeNotFoundException("Exception caught setting " + var6_34 + " attribute in " + var5_33);
                        }
                    }
                }
            }
        }
        Tr.exit(ServerRuleDriverMBean.tc, "setAttribute");
    }

    protected void refreshCachedData() {
        Tr.entry(tc, "refreshCachedData");
        this.mbeanResponse.sendRefreshNotification();
        Tr.exit(tc, "refreshCachedData");
    }

    public ArrayList getRuleAttributeInfo(String string) throws IllegalArgumentException {
        Tr.entry(tc, "getRuleAttributeInfo");
        ArrayList<ParsedMbeanAttribute> arrayList = new ArrayList<ParsedMbeanAttribute>();
        if (!this.initializationCompleted) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getRuleAttributeInfo is calling completeInit");
            }
            this.completeInit();
        }
        try {
            if (!this.ruleHash.containsKey(string)) {
                throw new IllegalArgumentException(string + " was not found ");
            }
            IRule iRule = (IRule)this.ruleHash.get(string);
            HashMap hashMap = iRule.getAttributeInfo();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "rule : " + iRule.getRuleId() + " has " + hashMap.size() + " attributes");
            }
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = (String)hashMap.get(string2);
                String string4 = string + SEPERATOR + string2;
                String string5 = string3.replace('=', ':').replace(',', '$');
                arrayList.add(new ParsedMbeanAttribute(string4, "java.lang.Double", string5));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getRuleAttributeInfo caught an illegal argument exception : " + illegalArgumentException.toString());
                illegalArgumentException.printStackTrace();
            }
            Tr.exit(tc, "getRuleAttributeInfo");
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.error" + exception.toString(), new String("exception getting attributes from rule"));
            exception.printStackTrace();
            Tr.exit(tc, "getRuleAttributeInfo");
            return new ArrayList();
        }
        Tr.exit(tc, "getRuleAttributeInfo");
        return arrayList;
    }

    private void printRuleHash() {
        if (tc.isDebugEnabled()) {
            Set set = this.ruleHash.keySet();
            Tr.debug(tc, "printing out rule hash: " + this.ruleHash.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = this.ruleHash.get(k);
                Tr.debug(tc, "       key=" + k + ", value=" + v);
            }
        }
    }

    public ArrayList getRulesInfo() {
        return this.getRulesInfo(0, true);
    }

    public ArrayList getRulesInfo(int n, boolean bl) {
        Tr.entry(tc, "getRulesInfo");
        ArrayList<ParsedMbeanAttribute> arrayList = new ArrayList<ParsedMbeanAttribute>();
        if (!this.initializationCompleted) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getRulesInfo is calling completeInit");
            }
            this.completeInit();
        }
        try {
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = super.getRules();
            for (int i = 0; i < arrayList3.size(); ++i) {
                arrayList2.add(arrayList3.get(i));
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                IRule iRule = (IRule)arrayList2.get(i);
                String string = iRule.getRuleId();
                String string2 = string;
                ParsedMbeanAttribute parsedMbeanAttribute = this.createRuleEnableMetaData(string2, string, iRule.getRuleNameLookup(), iRule.isApplicable(), n, bl);
                if (parsedMbeanAttribute == null) continue;
                arrayList.add(parsedMbeanAttribute);
            }
            String[] stringArray = this.immediateAlertBridge.getImmediateAlertIDs();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl2;
                String string = stringArray[i];
                String string3 = this.immediateAlertBridge.getImmediateAlertNameLookup(string);
                ParsedMbeanAttribute parsedMbeanAttribute = this.createRuleEnableMetaData(string, string, string3, bl2 = this.immediateAlertBridge.getImmediateAlertRuleApplicability(string), n, bl);
                if (parsedMbeanAttribute == null) continue;
                parsedMbeanAttribute.setIsPeriodicAlert(false);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding immediate alert attribute : " + parsedMbeanAttribute.toString());
                }
                arrayList.add(parsedMbeanAttribute);
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.error" + exception.toString(), new String("Exception caught trying to build rule attributes: "));
            exception.printStackTrace();
        }
        Tr.exit(tc, "getRulesInfo");
        return arrayList;
    }

    private ParsedMbeanAttribute createRuleEnableMetaData(String string, String string2, String string3, boolean bl, int n, boolean bl2) {
        block10: {
            block11: {
                block8: {
                    block9: {
                        if (!bl) break block8;
                        if (n == 0) break block9;
                        if (n != 1) break block10;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attName " + string);
                        Tr.debug(tc, "ruleID " + string2);
                        Tr.debug(tc, "lookupName " + string3);
                    }
                    StringBuffer stringBuffer = new StringBuffer(string3).append(".enable");
                    StringBuffer stringBuffer2 = new StringBuffer(string3).append(".des");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "enableAttName " + stringBuffer);
                        Tr.debug(tc, "desLookup " + stringBuffer2);
                    }
                    StringBuffer stringBuffer3 = bl2 ? new StringBuffer("Des:").append(TuningUtil.getNLSString(stringBuffer2.toString())).append("#Type:normal").append("#DesLookup:").append(stringBuffer2).append("#AttNameLookup:").append(stringBuffer).append("#ParamId:enable").append("#ID:").append(string2).append("#isAdvice:true#isAdviceApplicable:true") : new StringBuffer("DesLookup:").append(stringBuffer2).append("#ParamId:enable").append("#ID:").append(string2).append("#isAdvice:true#isAdviceApplicable:true");
                    return new ParsedMbeanAttribute(string, "java.lang.Boolean", stringBuffer3.toString());
                }
                if (n == 0) break block11;
                if (n != 2) break block10;
            }
            StringBuffer stringBuffer = new StringBuffer(string3).append(".applicable");
            StringBuffer stringBuffer4 = new StringBuffer(string3).append(".applicable").append(".des");
            StringBuffer stringBuffer5 = bl2 ? new StringBuffer("Des:").append(TuningUtil.getNLSString(stringBuffer4.toString())).append("#Type:normal").append("#Options:Not Applicable~false").append("#OptionsLookup:perfTuningAdmin.attribute.rule.applicable.notApplicable~false").append("#DesLookup:").append(stringBuffer4).append("#AttNameLookup:").append(stringBuffer).append("#ParamId:enable").append("#ID:").append(string2).append("#isAdvice:true#isAdviceApplicable:false") : new StringBuffer("DesLookup:").append(stringBuffer4).append("#ParamId:enable").append("#ID:").append(string2).append("#isAdvice:true#isAdviceApplicable:false");
            return new ParsedMbeanAttribute(string, "java.lang.Boolean", stringBuffer5.toString());
        }
        return null;
    }

    public ArrayList getAdvancedRPAAttributeInfo() {
        return this.getAdvancedRPAAttributeInfo(0, true);
    }

    public ArrayList getAdvancedRPAAttributeInfo(int n, boolean bl) {
        Tr.entry(tc, "getAdvancedRPAAttributeInfo");
        try {
            ArrayList arrayList;
            block5: {
                block4: {
                    arrayList = this.getRPAAttributeInfo(n, bl);
                    if (n == 0) break block4;
                    if (n != 1) break block5;
                }
                StringBuffer stringBuffer = bl ? new StringBuffer("Des:Whether or not Alerts are sent to the console and server logs").append("#DesLookup:perfTuningAdmin.attribute.des.traceResponseEnabled").append("#ParamId:traceResponseEnabled").append("#ID:").append(EngineParameters.getId()).append("#AttNameLookup:perfTuningAdmin.attribute.traceResponseEnabled").append("#Type:advanced") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.des.traceResponseEnabled").append("#ParamId:traceResponseEnabled");
                arrayList.add(new ParsedMbeanAttribute("traceResponseEnabled", "java.lang.Boolean", stringBuffer.toString()));
                stringBuffer = bl ? new StringBuffer("Des:What type of messages are logged").append("#DesLookup:perfTuningAdmin.attribute.des.logLevel").append("#Options:none~").append(109).append("$alertsOnly~").append(104).append("$all~").append(101).append("#OptionsLookup:perfTuningAdmin.options.alertLevelNone~").append(109).append("$perfTuningAdmin.options.alertLevelAlerts~").append(104).append("$perfTuningAdmin.options.alertLevelAll~").append(101).append("#ParamId:traceResponseLevel").append("#ID:").append(EngineParameters.getId()).append("#AttNameLookup:").append("perfTuningAdmin.attribute.traceResponseEnabled").append("#Type:advanced") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.des.logLevel").append("#ParamId:traceResponseLevel");
                arrayList.add(new ParsedMbeanAttribute("traceResponseLevel", "java.lang.Boolean", stringBuffer.toString()));
                stringBuffer = bl ? new StringBuffer("Des:Whether or not Alerts are sent to alertEngine.log").append("#DesLookup:perfTuningAdmin.attribute.des.fileResponseEnabled").append("#ParamId:fileResponseEnabled").append("#ID:").append(EngineParameters.getId()).append("#AttNameLookup:").append("perfTuningAdmin.attribute.fileResponseEnabled").append("#Type:advanced") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.des.fileResponseEnabled").append("#ParamId:fileResponseEnabled");
                arrayList.add(new ParsedMbeanAttribute("fileResponseEnabled", "java.lang.Boolean", stringBuffer.toString()));
                stringBuffer = bl ? new StringBuffer("Des:How much information to output").append("#DesLookup:perfTuningAdmin.attribute.des.logLevel").append("#OptionsLookup:perfTuningAdmin.options.alertLevelNone~").append(109).append("$perfTuningAdmin.options.alertLevelAlerts~").append(104).append("$perfTuningAdmin.options.alertLevelAll~").append(101).append("#ParamId:fileResponseLevel").append("#AttNameLookup:").append("fileResponseLevel").append("#ID:").append(EngineParameters.getId()).append("#Type:advanced") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.des.logLevel").append("#ParamId:fileResponseLevel");
                arrayList.add(new ParsedMbeanAttribute("fileResponseLevel", "java.lang.Integer", stringBuffer.toString()));
                stringBuffer = bl ? new StringBuffer("Des:Whether or not Alerts are sent out as JMX notifications for third party vendors").append("#DesLookup:perfTuningAdmin.attribute.des.mBeanResponseEnabled").append("#ParamId:mBeanResponseEnabled").append("#AttNameLookup:").append("perfTuningAdmin.attribute.mBeanResponseEnabled").append("#ID:").append(EngineParameters.getId()).append("#Type:advanced") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.des.mBeanResponseEnabled").append("#ParamId:mBeanResponseEnabled");
                arrayList.add(new ParsedMbeanAttribute("mBeanResponseEnabled", "java.lang.Boolean", stringBuffer.toString()));
                stringBuffer = bl ? new StringBuffer("Des:How much information to output").append("#DesLookup:perfTuningAdmin.attribute.des.logLevel").append("#OptionsLookup:perfTuningAdmin.options.alertLevelNone~").append(109).append("$perfTuningAdmin.options.alertLevelAlerts~").append(104).append("$perfTuningAdmin.options.alertLevelAll~").append(101).append("#ParamId:mBeanResponseLevel").append("#AttNameLookup:").append("perfTuningAdmin.attribute.mBeanResponseLevel").append("#ID:").append(EngineParameters.getId()).append("#Type:advanced") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.des.logLevel").append("#ParamId:mBeanResponseLevel");
                arrayList.add(new ParsedMbeanAttribute("mBeanResponseLevel", "java.lang.Integer", stringBuffer.toString()));
                stringBuffer = bl ? new StringBuffer("Des:Every x iterations the rule will search for new datapoints").append("#DesLookup:perfTuningAdmin.attribute.rule.RefreshIteration.des").append("#OptionsLookup:perfTuningAdmin.attribute.rule.RefreshIteration.option.0~0.0$perfTuningAdmin.attribute.rule.RefreshIteration.option.1~1.0$perfTuningAdmin.attribute.rule.RefreshIteration.option.3~3.0$perfTuningAdmin.attribute.rule.RefreshIteration.option.10~10.0").append("#ParamId:refreshIteration").append("#AttNameLookup:").append("perfTuning.attName.RefreshIteration").append("#ID:").append(EngineParameters.getId()).append("#Type:advanced") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.rule.RefreshIteration.des").append("#ParamId:refreshIteration");
                arrayList.add(new ParsedMbeanAttribute("refreshIteration", "java.lang.Integer", stringBuffer.toString()));
                stringBuffer = bl ? new StringBuffer("Des:The max number of times an alert can be issued in a row before it gets disabled (-1 equals never) ").append("#DesLookup:perfTuningAdmin.attribute.des.maxAlertStreak").append("#OptionsLookup:perfTuningAdmin.options.maxAlertStreak.one~1$perfTuningAdmin.options.maxAlertStreak.three~3$perfTuningAdmin.options.maxAlertStreak.never~0").append("#ParamId:maxAlertStreak").append("#AttNameLookup:").append("perfTuningAdmin.attribute.maxAlertStreak").append("#ID:").append(EngineParameters.getId()).append("#Type:advanced") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.des.maxAlertStreak").append("#ParamId:maxAlertStreak");
                arrayList.add(new ParsedMbeanAttribute("maxAlertStreak", "java.lang.Integer", stringBuffer.toString()));
                stringBuffer = bl ? new StringBuffer("Des:The number of milliseconds in between iterations of the ruleEngine").append("#DesLookup:perfTuningAdmin.attribute.des.duration").append("#OptionsLookup:perfTuningAdmin.options.duration.ten~10$perfTuningAdmin.options.duration.sixty~60$perfTuningAdmin.options.duration.30Minutes~1800").append("#ParamId:duration").append("#AttNameLookup:").append("perfTuningAdmin.attribute.duration").append("#ID:").append(EngineParameters.getId()).append("#Type:advanced") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.des.duration").append("#ParamId:duration");
                arrayList.add(new ParsedMbeanAttribute("duration", "java.lang.Integer", stringBuffer.toString()));
                stringBuffer = bl ? new StringBuffer("Des:The min cpu indicating that the system is under load").append("#DesLookup:perfTuningAdmin.attribute.rule.MinCpuUsageForWorkingSystem.des").append("#ID:").append(EngineParameters.getId()).append("#ParamId:minCpuUsage").append("#AttNameLookup:").append("perfTuning.attName.MinCpuUsageForWorkingSystem").append("#OptionsLookup:perfTuningAdmin.attribute.rule.MinCpuUsageForWorkingSystem.option.30~30$perfTuningAdmin.attribute.rule.MinCpuUsageForWorkingSystem.option.50~50$perfTuningAdmin.attribute.rule.MinCpuUsageForWorkingSystem.option.70~70$perfTuningAdmin.attribute.rule.MinCpuUsageForWorkingSystem.option.90~90").append("#Type:advanced") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.rule.MinCpuUsageForWorkingSystem.des").append("#ParamId:minCpuUsage");
                arrayList.add(new ParsedMbeanAttribute("minCpuUsage", "java.lang.Integer", stringBuffer.toString()));
                stringBuffer = bl ? new StringBuffer("Des:If the CPU is less than x then the system is not saturated").append("#DesLookup:perfTuningAdmin.attribute.rule.CpuNotSaturated.des").append("#ID:").append(EngineParameters.getId()).append("#ParamId:cpuSaturated").append("#AttNameLookup:").append("perfTuning.attName.CpuNotSaturated").append("#OptionsLookup:perfTuningAdmin.attribute.rule.CpuNotSaturated.option.75~75$perfTuningAdmin.attribute.rule.CpuNotSaturated.option.80~80$perfTuningAdmin.attribute.rule.CpuNotSaturated.option.85~85$perfTuningAdmin.attribute.rule.CpuNotSaturated.option.90~90").append("#Type:advanced") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.rule.CpuNotSaturated.des").append("#ParamId:cpuSaturated");
                arrayList.add(new ParsedMbeanAttribute("cpuSaturated", "java.lang.Integer", stringBuffer.toString()));
                stringBuffer = bl ? new StringBuffer("Des:The number of heap dumps that the Advisor will attempt to take").append("#DesLookup:perfTuningAdmin.attribute.heapDump.numberOfDumps.des").append("#ID:").append(EngineParameters.getId()).append("#ParamId:heapDumpNumberToBeAttempted").append("#AttNameLookup:").append("perfTuningAdmin.attribute.heapDump.numberOfDumps").append("#OptionsLookup:perfTuningAdmin.attribute.heapDump.numberOfDumps.option.1~1$perfTuningAdmin.attribute.heapDump.numberOfDumps.option.2~2$perfTuningAdmin.attribute.heapDump.numberOfDumps.option.4~4$perfTuningAdmin.attribute.heapDump.numberOfDumps.option.6~6$perfTuningAdmin.attribute.heapDump.numberOfDumps.option.8~8$perfTuningAdmin.attribute.heapDump.numberOfDumps.option.10~10$perfTuningAdmin.attribute.heapDump.numberOfDumps.option.12~12$perfTuningAdmin.attribute.heapDump.numberOfDumps.option.14~14$perfTuningAdmin.attribute.heapDump.numberOfDumps.option.16~16$perfTuningAdmin.attribute.heapDump.numberOfDumps.option.18~18$perfTuningAdmin.attribute.heapDump.numberOfDumps.option.20~20").append("#Type:advanced") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.heapDump.numberOfDumps.des").append("#ParamId:heapDumpNumberToBeAttempted");
                arrayList.add(new ParsedMbeanAttribute("heapDumpNumberToBeAttempted", "java.lang.Integer", stringBuffer.toString()));
                stringBuffer = bl ? new StringBuffer("Des:This policy defines how the Advisor will automatically take HeapDumps").append("#DesLookup:perfTuningAdmin.attribute.heapDump.heapDumpTriggerPolicy.des").append("#ID:").append(EngineParameters.getId()).append("#ParamId:heapDumpTriggerPolicy").append("#AttNameLookup:").append("perfTuningAdmin.attribute.heapDump.heapDumpTriggerPolicy").append("#OptionsLookup:perfTuningAdmin.attribute.heapDump.heapDumpTriggerPolicy.option.time~1$perfTuningAdmin.attribute.heapDump.heapDumpTriggerPolicy.option.memory~2$perfTuningAdmin.attribute.heapDump.heapDumpTriggerPolicy.option.not~3").append("#Type:advanced") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.heapDump.heapDumpTriggerPolicy.des").append("#ParamId:heapDumpTriggerPolicy");
                arrayList.add(new ParsedMbeanAttribute("heapDumpTriggerPolicy", "java.lang.Integer", stringBuffer.toString()));
            }
            Tr.exit(tc, "getAdvancedRPAAttributeInfo");
            return arrayList;
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.error" + exception.toString(), new String("Exception caught trying to create Advanced Attributes for ruleEngine "));
            exception.printStackTrace();
            Tr.exit(tc, "getAdvancedRPAAttributeInfo");
            return new ArrayList();
        }
    }

    public ArrayList getRPAAttributeInfo() {
        return this.getRPAAttributeInfo(0, true);
    }

    public ArrayList getRPAAttributeInfo(int n, boolean bl) {
        try {
            ArrayList<ParsedMbeanAttribute> arrayList;
            block13: {
                StringBuffer stringBuffer;
                block12: {
                    block11: {
                        block10: {
                            Tr.entry(tc, "getRPAAttributeInfo");
                            arrayList = new ArrayList<ParsedMbeanAttribute>();
                            if (!this.initializationCompleted) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "getRPAAttributeInfo is calling completeInit");
                                }
                                this.completeInit();
                            }
                            if (n == 0) break block10;
                            if (n != 1) break block11;
                        }
                        stringBuffer = bl ? new StringBuffer("Des:Whether or not the Runtime Advisor will execute any rules").append("#DesLookup:perfTuningAdmin.attribute.des.enabled").append("#ParamId:enabled").append("#AttNameLookup:").append("perfTuningAdmin.attribute.enabled").append("#ID:").append(EngineParameters.getId()).append("#Type:normal") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.des.enabled").append("#ParamId:enabled");
                        arrayList.add(new ParsedMbeanAttribute("enabled", "java.lang.Boolean", stringBuffer.toString()));
                        stringBuffer = bl ? new StringBuffer("Des:The length of the interval (in seconds) over which calculations will be made").append("#DesLookup:perfTuningAdmin.attribute.rule.CalculationInterval.des").append("#OptionsLookup:perfTuningAdmin.attribute.rule.CalculationInterval.option.60~60$perfTuningAdmin.attribute.rule.CalculationInterval.option.240~240$perfTuningAdmin.attribute.rule.CalculationInterval.option.1800~1800").append("#ParamId:calculationInterval").append("#AttNameLookup:").append("perfTuning.attName.CalculationInterval").append("#ID:").append(EngineParameters.getId()).append("#Type:normal") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.rule.CalculationInterval.des").append("#ParamId:calculationInterval");
                        arrayList.add(new ParsedMbeanAttribute("calculationInterval", "java.lang.Integer", stringBuffer.toString()));
                        stringBuffer = bl ? new StringBuffer("Des:The number of processors in the machine").append("#DesLookup:perfTuningAdmin.attribute.rule.numberOfProcessors.des").append("#OptionsLookup:perfTuningAdmin.attribute.rule.numberOfProcessors.option.1~1.0$perfTuningAdmin.attribute.rule.numberOfProcessors.option.2~2.0$perfTuningAdmin.attribute.rule.numberOfProcessors.option.4~4.0$perfTuningAdmin.attribute.rule.numberOfProcessors.option.8~8.0$perfTuningAdmin.attribute.rule.numberOfProcessors.option.12~12.0$perfTuningAdmin.attribute.rule.numberOfProcessors.option.24~24.0").append("#ParamId:numberOfProcessors").append("#AttNameLookup:").append("perfTuning.attName.numberOfProcessors").append("#ID:").append(EngineParameters.getId()).append("#Type:normal") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.rule.numberOfProcessors.des").append("#ParamId:numberOfProcessors");
                        arrayList.add(new ParsedMbeanAttribute("numberOfProcessors", "java.lang.Integer", stringBuffer.toString()));
                        stringBuffer = bl ? new StringBuffer("Des:Whether or not heap dumps will be automatically generated for post analysis when suspious memory activity is detected").append("#DesLookup:perfTuningAdmin.attribute.des.memoryLeakDataCollection").append("#ParamId:heapDumpGenerationEnabled").append("#AttNameLookup:").append("perfTuningAdmin.attribute.memoryLeakDataCollection").append("#ID:").append(EngineParameters.getId()).append("#Type:normal") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.des.memoryLeakDataCollection").append("#ParamId:heapDumpGenerationEnabled");
                        arrayList.add(new ParsedMbeanAttribute("heapDumpGenerationEnabled", "java.lang.Boolean", stringBuffer.toString()));
                    }
                    if (n == 0) break block12;
                    if (n != 2) break block13;
                }
                stringBuffer = bl ? new StringBuffer("Des:The status of the automated heap dump response to memory leak detection").append("#DesLookup:perfTuningAdmin.attribute.heapDump.status.des").append("#ParamId:heapDumpStatus").append("#AttNameLookup:").append("perfTuningAdmin.attribute.heapDump.status").append("#ID:").append(EngineParameters.getId()).append("#Type:normal") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.heapDump.status.des").append("#ParamId:heapDumpStatus");
                arrayList.add(new ParsedMbeanAttribute("heapDumpStatus", "[Ljava.lang.String;", stringBuffer.toString()));
                stringBuffer = bl ? new StringBuffer("Des:The names of the heap dump files automatically generated").append("#DesLookup:perfTuningAdmin.attribute.heapDump.fileNames.des").append("#ParamId:heapDumpStatus").append("#AttNameLookup:").append("perfTuningAdmin.attribute.heapDump.fileNames").append("#ID:").append(EngineParameters.getId()).append("#Type:normal") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.heapDump.fileNames.des").append("#ParamId:heapDumpFileNames");
                arrayList.add(new ParsedMbeanAttribute("heapDumpFileNames", "java.util.ArrayList", stringBuffer.toString()));
                stringBuffer = bl ? new StringBuffer("Des:Whether or not automated heap dumps are available").append("#DesLookup:perfTuningAdmin.attribute.heapDump.automatedHeapDumpsApplicable.des").append("#ParamId:heapDumpAutomatedGenerationApplicable").append("#AttNameLookup:").append("perfalert.attribute.heapDump.automatedHeapDumpsApplicable").append("#ID:").append(EngineParameters.getId()).append("#Type:normal") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.heapDump.automatedHeapDumpsApplicable.des").append("#ParamId:heapDumpAutomatedGenerationApplicable");
                arrayList.add(new ParsedMbeanAttribute("heapDumpAutomatedGenerationApplicable", "java.lang.Boolean", stringBuffer.toString()));
                stringBuffer = bl ? new StringBuffer("Des:Runtime Performance Advisor warnings").append("#DesLookup:perfTuningAdmin.attribute.des.warnings").append("#AttNameLookup:").append("perfTuning.attName.warnings").append("#ID:").append("ruleEngine").append("#ParamId:warnings").append("#Type:normal") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.des.warnings").append("#ParamId:warnings");
                arrayList.add(new ParsedMbeanAttribute("warnings", "java.lang.String", stringBuffer.toString()));
                stringBuffer = bl ? new StringBuffer("Des:whether or not pmi is enabled").append("#DesLookup:perfTuningAdmin.attribute.des.pmiEnabled").append("#AttNameLookup:").append("perfTuning.attName.noPmi").append("#ParamId:pmiDataAvailable").append("#ID:").append("ruleEngine").append("#Type:normal") : new StringBuffer("DesLookup:perfTuningAdmin.attribute.des.pmiEnabled").append("#ParamId:pmiDataAvailable");
                arrayList.add(new ParsedMbeanAttribute("pmiDataAvailable", "java.lang.Boolean", stringBuffer.toString()));
            }
            Tr.exit(tc, "getRPAAttributeInfo");
            return arrayList;
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.error" + exception.toString(), new String("Exception caught trying to create Attributes for ruleEngine "));
            exception.printStackTrace();
            Tr.exit(tc, "getRPAAttributeInfo");
            return new ArrayList();
        }
    }

    private Properties buildGUIMetadata() {
        Tr.entry(tc, "buildGUIMetadata");
        Properties properties = new Properties();
        try {
            StringBuffer stringBuffer = new StringBuffer("Des:reinitialize the Runtime Performance Advisor.").append("#DesLookup:perfTuningAdmin.operation.reInit.des");
            properties.put("reInit", ObjectName.quote(new String(stringBuffer)));
            stringBuffer = new StringBuffer("Des:Triggers IBM JDK to take a multiple heap dumps based upon downward trends in memory").append("#DesLookup:perfTuningAdmin.operation.takeHeapDump.des");
            properties.put("perfTuningAdmin.operation.takeHeapDump", ObjectName.quote(new String(stringBuffer)));
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.error" + exception.toString(), new String("Exception building MBean meta data: "));
            exception.printStackTrace();
        }
        Tr.exit(tc, "buildGUIMetadata");
        return properties;
    }

    private void issueWarning_noPmi(boolean bl, boolean bl2) {
        Tr.entry(tc, "buildDynamicMBeanInfo_noPmi");
        String string = new String();
        String string2 = new String("Please enable Performance Monitoring Server on, and then restart both the Node and the Application Server if you wish to use the Runtime Performance Advisor.");
        if (!bl && !bl2) {
            Object[] objectArray = new String[]{this.serverName, this.nodeName};
            String string3 = "perfalert.webui.title.noPmi";
            string = TuningUtil.getNLSString(string3, objectArray, string2);
            MessageWrapper messageWrapper = new MessageWrapper(string3, objectArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "buildDynamicMBeanInfo_noPmi adding " + string + " + to warning");
            }
            super.clearWarnings(2);
            super.addWarning(messageWrapper, 2);
        } else if (!bl) {
            String string4 = "perfalert.webui.title.noPmi.server";
            String string5 = this.serverName;
            string = TuningUtil.getNLSString(string4, (Object)string5, string2);
            MessageWrapper messageWrapper = new MessageWrapper(string4, string5);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "buildDynamicMBeanInfo_noPmi adding " + string + " + to warning");
            }
            super.clearWarnings(2);
            super.addWarning(messageWrapper, 2);
        } else if (!bl2) {
            String string6 = "perfalert.webui.title.noPmi.nodeAgent";
            String string7 = this.nodeName;
            string = TuningUtil.getNLSString(string6, (Object)string7, string2);
            MessageWrapper messageWrapper = new MessageWrapper(string6, string7);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "buildDynamicMBeanInfo_noPmi adding " + string + " + to warning");
            }
            super.clearWarnings(2);
            super.addWarning(messageWrapper, 2);
        }
        Tr.exit(tc, "buildDynamicMBeanInfo_noPmi");
    }

    public void reInit() {
        Tr.entry(tc, "reInit");
        try {
            boolean bl = this.getEnabled();
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "disabling RuleEngine while reinit is called");
                }
                this.setEnabled(Boolean.FALSE);
            }
            this.rules = new ArrayList();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   calling init");
            }
            super.initAndRegister();
            if (!this.initializationCompleted) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getRulesInfo is calling completeInit");
                }
                this.completeInit();
            }
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "enabling RuleEngine after reinit is called");
                }
                this.setEnabled(Boolean.TRUE);
            }
            Tr.exit(tc, "reInit");
            return;
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.error" + exception.toString(), new String("Exception caught calling reInit for ServerRuleDriverMBean : "));
            exception.printStackTrace();
            Tr.exit(tc, "reInit");
            return;
        }
    }

    public void alarm(Object object) {
        super.alarm(object);
    }

    protected void handleResponse(ArrayList arrayList) {
        Tr.entry(tc, "handleResponse");
        try {
            if (this.mbeanResponse.isEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.entry(tc, "sending response as mbean notification ");
                }
                this.mbeanResponse.handleOutput(arrayList);
            }
            super.handleResponse(arrayList);
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.error" + exception.toString(), new String("handleResponse EXCEPTION : "));
            exception.printStackTrace();
        }
        Tr.exit(tc, "handleResponse");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createRegistryMBeanResponse() {
        if (this.mbeanResponse == null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Registering MBean response");
                }
                this.mbeanResponse = new MBeanNotificationResponse();
                MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
                String string = "com/ibm/ws/performance/tuning/AdvisorNotificationMBean.xml";
                this.on = mBeanFactory.activateMBean("AdvisorNotificationMBean", this.mbeanResponse, "AdvisorNotificationMBean", string, null);
                if (!tc.isDebugEnabled()) return;
                Tr.debug(tc, "Registered MBean response : " + this.on.toString());
                return;
            }
            catch (Exception exception) {
                Tr.error(tc, "perfalert.Exception.error" + exception.toString(), new String("could not register mbeanResponse "));
                exception.printStackTrace();
                return;
            }
        } else {
            if (!tc.isDebugEnabled()) return;
            Tr.debug(tc, "Not Registering MBean response as it is already created");
        }
    }

    protected void initResponse() {
        Tr.entry(tc, "initResponse");
        try {
            super.initResponse();
            if (this.mbeanResponse == null) {
                this.createRegistryMBeanResponse();
            }
            if (this.mbeanResponse == null) {
                Tr.error(tc, "mbeanResponse is null");
            } else {
                Tr.debug(tc, "mBeanResponse is not null");
            }
            Integer n = (Integer)EngineParameters.getParam("mBeanResponseLevel");
            Boolean bl = (Boolean)EngineParameters.getParam("mBeanResponseEnabled");
            if (n != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting notification level for mbeanResponse to " + n);
                }
                this.mbeanResponse.setNotificationLevel(n);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "did not get mBeanResponseLevel from EngineParameters");
                }
                this.mbeanResponse.setNotificationLevel(104);
            }
            if (bl != null) {
                this.mbeanResponse.setVerbose(false);
                this.mbeanResponse.setEnabled(bl);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "did not get mBeanResponseEnabled from EngineParameters");
                }
                this.mbeanResponse.setVerbose(false);
                this.mbeanResponse.setEnabled(false);
            }
            this.heapDumpResponse.setNotificationSender(this.mbeanResponse);
        }
        catch (Exception exception) {
            block14: {
                Tr.error(tc, "perfalert.Exception.error" + exception.toString(), new String("Exception when trying to init response "));
                this.mbeanResponse.setNotificationLevel(104);
                this.mbeanResponse.setVerbose(false);
                try {
                    this.mbeanResponse.setEnabled(false);
                }
                catch (Exception exception2) {
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "could not set enabled on mbean response : " + exception2.toString());
                    exception2.toString();
                }
            }
            exception.printStackTrace();
        }
        Tr.exit(tc, "initResponse");
    }

    private boolean isRule(String string) {
        return this.ruleHash.containsKey(string);
    }

    private Boolean isRuleEnabled(String string) {
        Tr.entry(tc, "isRuleEnabled");
        IRule iRule = (IRule)this.ruleHash.get(string);
        Tr.debug(tc, "rule  " + iRule);
        if (!iRule.isApplicable()) {
            Tr.exit(tc, "isRuleEnabled notApplicable");
            return new Boolean(false);
        }
        if (iRule.isEnabled()) {
            Tr.exit(tc, "isRuleEnabled enabled");
            return new Boolean(true);
        }
        Tr.exit(tc, "isRuleEnabled disabled");
        return new Boolean(false);
    }

    private boolean isRuleApplicable(String string) {
        Tr.entry(tc, "isRuleApplicable");
        IRule iRule = (IRule)this.ruleHash.get(string);
        Tr.exit(tc, "isRuleApplicable");
        return iRule.isApplicable();
    }

    public void enableRule(String[] stringArray) throws AttributeNotFoundException, MBeanException, InvalidAttributeValueException, ReflectionException {
        if (stringArray == null) {
            System.out.println("No rules to enable ");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                this.enableRule(stringArray[i]);
                Tr.debug(tc, "Rule enabled -" + stringArray[i]);
            }
        }
    }

    private void enableRule(String string) throws AttributeNotFoundException, MBeanException, InvalidAttributeValueException, ReflectionException {
        if (!this.initializationCompleted) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "enableRule is calling completeInit");
            }
            this.completeInit();
        }
        Attribute attribute = new Attribute(string, new Boolean(true));
        if (this.getEnabled().booleanValue()) {
            Tr.debug(tc, "RPA is enabled");
            if (!this.isRuleEnabled(string).booleanValue()) {
                this.setRPAAttribute(attribute);
            }
        } else {
            Tr.debug(tc, "RPA is not enabled");
            this.setEnabled(new Boolean(true));
            ArrayList arrayList = super.getRules();
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    IRule iRule = (IRule)arrayList.get(i);
                    String string2 = iRule.getRuleId();
                    if (!string2.equals(string)) {
                        Attribute attribute2 = new Attribute(string2, new Boolean(false));
                        this.setRPAAttribute(attribute2);
                        continue;
                    }
                    this.setRPAAttribute(attribute);
                }
            }
        }
    }
}

