/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.performance.tuning.serverAlert.ResponseInterface;
import java.util.ArrayList;

public class TraceResponse
implements TuningConstants,
ResponseInterface {
    private int notificationLevel = 101;
    private boolean verbose = false;
    private boolean enabled = true;
    private static TraceComponent tc = Tr.register(TraceResponse.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) throws Exception {
        this.enabled = bl;
    }

    public int getNotificationLevel() {
        return this.notificationLevel;
    }

    public void setNotificationLevel(int n) {
        if (n == 101 || n == 104 || n == 109) {
            this.notificationLevel = n;
            if (this.notificationLevel == 101) {
                Tr.audit(tc, "UPDATE:  set notification level to ALL");
            }
        } else {
            Tr.warning(tc, "attempt to set notification level to illegal value: " + n);
        }
    }

    public void handleOutput(RuleOutput ruleOutput) {
        if (this.enabled) {
            int n = ruleOutput.getOutputType();
            if (this.notificationLevel <= n) {
                Object object;
                String string = new String();
                String string2 = ruleOutput.getMessageId();
                Object[] objectArray = ruleOutput.getMessageArgs();
                if (objectArray == null) {
                    objectArray = new Object[]{};
                }
                StringBuffer stringBuffer = new StringBuffer();
                if (this.verbose) {
                    stringBuffer.append(TuningUtil.getNLSString("perfalert.name"));
                    stringBuffer.append(ruleOutput.getName());
                    stringBuffer.append("\n").append(TuningUtil.getNLSString("perfalert.alertType"));
                    stringBuffer.append(TuningUtil.getRuleOutputType(ruleOutput.getOutputType()));
                    object = ruleOutput.getDescription();
                    if (object == null) {
                        object = new String("Description not available for " + ruleOutput.getMessageId());
                    }
                    stringBuffer.append("\n").append(TuningUtil.getNLSString("perfalert.description")).append((String)object);
                }
                stringBuffer.append("\n").append(TuningUtil.getNLSString("perfalert.list"));
                object = ruleOutput.getSymptoms();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    stringBuffer.append("\n").append(object[i]);
                }
                String string3 = stringBuffer.toString();
                Object[] objectArray2 = new Object[objectArray.length + 1];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = objectArray[i];
                }
                objectArray2[objectArray.length] = string3;
                objectArray = objectArray2;
                Tr.debug(tc, "I am calling mid=" + string2 + "with " + objectArray.length + " arguments");
                Tr.warning(tc, string2, objectArray);
            }
        } else {
            Tr.debug(tc, "TraceResponce is not enabled");
        }
    }

    public void handleOutput(ArrayList arrayList) {
        if (this.enabled) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.handleOutput((RuleOutput)arrayList.get(i));
            }
        } else {
            Tr.debug(tc, "TraceResponse is not enabled");
        }
    }

    public void handleOutput(RuleOutput[] ruleOutputArray) {
        for (int i = 0; i < ruleOutputArray.length; ++i) {
            this.handleOutput(ruleOutputArray[i]);
        }
    }
}

