/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.StatLevelSpec;
import com.ibm.websphere.pmi.stat.WSAverageStatistic;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.websphere.pmi.stat.WSDoubleStatistic;
import com.ibm.websphere.pmi.stat.WSRangeStatistic;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.websphere.pmi.stat.WSTimeStatistic;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiCollaborator;
import com.ibm.ws.pmi.server.PmiCollaboratorFactory;
import com.ibm.ws.pmi.server.PmiRegistry;
import java.util.Date;

public class DataAccessWrapper
implements TuningConstants {
    private static TraceComponent tc = Tr.register(DataAccessWrapper.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    public static final int COUNT_STATISTIC = 11;
    public static final int DOUBLE_STATISTIC = 12;
    public static final int RANGE_STATISTIC = 13;
    public static final int TIME_STATISTIC = 14;
    public static final int AVERAGE_STATISTIC = 15;
    private int dataType = -102;
    public static final int STAT_INTERFACE = 102;
    private Object myData = null;
    private boolean isValid = false;
    private WSStats myCol = null;
    private ModuleItem moduleItem = null;
    DataDescriptor myDD = null;
    int dataId = -1;

    public DataAccessWrapper(DataDescriptor dataDescriptor, int n) {
        try {
            Tr.entry(tc, "DataAccessWrapper");
            this.myDD = dataDescriptor;
            this.dataId = n;
            Tr.debug(tc, "*****creating new pmi registry");
            Tr.debug(tc, "******* about to get data");
            Tr.exit(tc, "DataAccessWrapper");
        }
        catch (Exception exception) {
            Tr.error(tc, "DataAccessWRapper constructor exception.  Problem seems to be with PMI counters, please do not disable counters while RPA is running." + exception.toString());
            exception.printStackTrace();
            Tr.exit(tc, "DataAccessWrapper");
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    private int getData() {
        Tr.entry(tc, "getData");
        try {
            if (tc.isDebugEnabled()) {
                String[] stringArray = this.myDD.getPath();
                String string = new String();
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + "-" + stringArray[i];
                }
                Tr.debug(tc, "Getting Data for " + string + " using dataID " + this.dataId);
            }
            this.myCol = this.getStats();
            if (this.myCol != null) {
                Tr.debug(tc, "calling new getStatistics ");
                this.myData = this.myCol.getStatistic(this.dataId);
                if (this.myData == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getData mydata (StatsImpl) is null and I have just tried to get it using dataId=" + this.dataId);
                        if (this.myCol != null) {
                            Tr.debug(tc, "printing out collection");
                            Tr.debug(tc, ((Object)this.myCol).toString());
                        }
                    }
                    return this.checkInstrumentationLevel();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getData mydata is not null. myData :" + this.myData + " dataID " + this.dataId);
                }
                Tr.debug(tc, "getData returning no problem");
                Tr.exit(tc, "getData");
                return 101;
            }
            Tr.debug(tc, "myCol is null");
            Tr.exit(tc, "getData");
            return -102;
        }
        catch (Exception exception) {
            Tr.error(tc, "DataAccessWrapper.getData unexpected exception, see error log for stack trace, " + exception.toString());
            exception.printStackTrace();
            this.myData = null;
            Tr.exit(tc, "getData");
            return -102;
        }
    }

    public WSStats getStats() {
        PmiCollaborator pmiCollaborator = PmiCollaboratorFactory.getPmiCollaborator();
        StatDescriptor[] statDescriptorArray = new StatDescriptor[1];
        String[] stringArray = this.myDD.getPath();
        statDescriptorArray[0] = new StatDescriptor(stringArray);
        WSStats[] wSStatsArray = pmiCollaborator.getStatsArray(statDescriptorArray, new Boolean(false));
        return wSStatsArray[0];
    }

    private void setType() {
        if (this.myData == null) {
            this.dataType = -102;
        }
        if (this.myData instanceof WSCountStatistic) {
            Tr.debug(tc, "instance of count statistic");
            this.dataType = 11;
        } else if (this.myData instanceof WSDoubleStatistic) {
            Tr.debug(tc, "instance of double statistic");
            this.dataType = 12;
        } else if (this.myData instanceof WSRangeStatistic) {
            Tr.debug(tc, "instance of range statistic");
            this.dataType = 13;
        } else if (this.myData instanceof WSTimeStatistic) {
            Tr.debug(tc, "instance of time statistic");
            this.dataType = 14;
        } else if (this.myData instanceof WSAverageStatistic) {
            Tr.debug(tc, "instance of time statistic");
            this.dataType = 15;
        } else {
            this.isValid = false;
            Tr.error(tc, "perfalert.NoDataType", this.myData.getClass().getName());
        }
    }

    public long getLong() {
        try {
            if (this.dataType == 11) {
                return ((WSCountStatistic)this.myData).getCount();
            }
            if (this.dataType == 12) {
                return new Double(((WSDoubleStatistic)this.myData).getDouble()).longValue();
            }
            if (this.dataType == 13) {
                long l = ((WSRangeStatistic)this.myData).getCurrent();
                Tr.debug(tc, "Range Statistic = " + l);
                return l;
            }
            if (this.dataType == 14) {
                long l = ((WSTimeStatistic)this.myData).getTotal();
                Tr.debug(tc, "Time Statistic = " + l);
                return l;
            }
            if (this.dataType == 15) {
                long l = ((WSAverageStatistic)this.myData).getTotal();
                Tr.debug(tc, "Average Statistic = " + l);
                return l;
            }
            if (this.dataType == -102) {
                return -102L;
            }
            this.isValid = false;
            Tr.error(tc, "perfalert.NoDataType");
            return -100L;
        }
        catch (Exception exception) {
            return this.handleError(exception);
        }
    }

    public double getDouble() {
        try {
            if (this.dataType == 11) {
                return new Long(((WSCountStatistic)this.myData).getCount()).doubleValue();
            }
            if (this.dataType == 12) {
                return ((WSDoubleStatistic)this.myData).getDouble();
            }
            if (this.dataType == 13) {
                double d = new Long(((WSRangeStatistic)this.myData).getCurrent()).doubleValue();
                Tr.debug(tc, "Rangle Statistic " + d);
                return d;
            }
            if (this.dataType == 14) {
                double d = new Double(((WSTimeStatistic)this.myData).getTotal());
                Tr.debug(tc, "Time Statistic = " + d);
                return d;
            }
            if (this.dataType == 15) {
                double d = new Double(((WSAverageStatistic)this.myData).getTotal());
                Tr.debug(tc, "Average Statistic = " + d);
                return d;
            }
            if (this.dataType == -102) {
                return -102.0;
            }
            this.isValid = false;
            Tr.error(tc, "perfalert.NoDataType");
            return -100.0;
        }
        catch (Exception exception) {
            return this.handleError(exception);
        }
    }

    public double getIntegral() {
        try {
            if (this.dataType == 13) {
                double d = ((WSRangeStatistic)this.myData).getIntegral();
                Tr.debug(tc, "DataAccessWrapper getIntegral returning value = " + d);
                return d;
            }
            Tr.error(tc, "getIntegral is not valid for datatype " + this.dataType);
            return -100.0;
        }
        catch (Exception exception) {
            return this.handleError(exception);
        }
    }

    public long getCount() {
        try {
            if (this.dataType == 11) {
                return ((WSCountStatistic)this.myData).getCount();
            }
            if (this.dataType == 12) {
                return 1L;
            }
            if (this.dataType == 13) {
                return 1L;
            }
            if (this.dataType == 14) {
                return ((WSTimeStatistic)this.myData).getCount();
            }
            if (this.dataType == 15) {
                return ((WSAverageStatistic)this.myData).getCount();
            }
            if (this.dataType == -102) {
                return -102L;
            }
            Tr.error(tc, "Datatype " + this.dataType + " is not implemented for getCount");
            return -100L;
        }
        catch (Exception exception) {
            return this.handleError(exception);
        }
    }

    private int checkInstrumentationLevel() {
        Tr.entry(tc, "checkInstrumentationLevel");
        boolean bl = false;
        try {
            Object object;
            if (PmiRegistry.isDisabled()) {
                Tr.error(tc, "perfalert.PmiDisabled");
                return -103;
            }
            String[] stringArray = this.myDD.getPath();
            if (tc.isDebugEnabled()) {
                object = new String();
                for (int i = 0; i < stringArray.length; ++i) {
                    object = (String)object + "->" + stringArray[i];
                }
                Tr.debug(tc, "dd path = " + (String)object);
            }
            object = new StatDescriptor(stringArray);
            StatLevelSpec[] statLevelSpecArray = PmiRegistry.getInstrumentationLevel((StatDescriptor)object, false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "instrumentationLevel : " + statLevelSpecArray[0]);
            }
            int[] nArray = statLevelSpecArray[0].getEnabled();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != this.dataId) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Enable instrumentation for " + object + ", counter=" + this.dataId);
                }
                int[] nArray2 = new int[nArray.length + 1];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray2[nArray.length] = this.dataId;
                StatLevelSpec[] statLevelSpecArray2 = new StatLevelSpec[]{new StatLevelSpec(stringArray, nArray2)};
                PmiRegistry.setInstrumentationLevel(statLevelSpecArray2, true);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, object + ":" + this.dataId + "is already enabled");
            }
            if (tc.isDebugEnabled()) {
                StatLevelSpec[] statLevelSpecArray3 = PmiRegistry.getInstrumentationLevel((StatDescriptor)object, false);
                Tr.debug(tc, "checkInstruemnationlevel returning NO_DATA---now level is " + statLevelSpecArray3[0]);
            }
            Tr.exit(tc, "checkInstrumentationLevel");
            return -102;
        }
        catch (Exception exception) {
            Tr.error(tc, "Unexpected Exception in SeverRateIncreaseCalc.checkInstrumentationLevel, see error log for stack trace," + exception.toString());
            exception.printStackTrace();
            Tr.exit(tc, "checkInstrumentationLevel");
            return -100;
        }
    }

    public long getTime() {
        try {
            Date date = new Date();
            return date.getTime();
        }
        catch (Exception exception) {
            return this.handleError(exception);
        }
    }

    private int handleError(Exception exception) {
        int n = this.checkInstrumentationLevel();
        if (n == -102) {
            Tr.error(tc, "Advisor caught exception.  Advisor was unable to get pmi data.  Advisor has enabled PMI counter and will attempt to continue.  If you are using the Advisor please do not disable pmi counters while Advisor is running.If you wish to have all PMI counters disabled then disable Runtime Performance Advsior.  Original Exception :" + exception.toString());
            if (tc.isDebugEnabled()) {
                exception.printStackTrace();
            }
        } else if (n == -100) {
            Tr.error(tc, "Advisor caught unexpected exception while accessing PMI data.  Please make sure PMI Service is started and that counters are not modified." + exception.toString());
            exception.printStackTrace();
        }
        return n;
    }

    public int update() {
        Tr.entry(tc, "update");
        int n = this.getData();
        if (n == 101) {
            Tr.debug(tc, "****got data no problem");
            this.isValid = true;
            this.setType();
        } else {
            this.isValid = false;
            Tr.debug(tc, "*****DataAccessWrapper not valid returning " + n);
        }
        Tr.exit(tc, "update");
        return n;
    }

    public String toString() {
        if (this.myData != null) {
            return "DataAccessWrapper.  data:" + this.myData.toString() + " ,dataType:" + this.dataType + ", is Valid:" + this.isValid;
        }
        return "DataAccessWrapper.  data: null ,dataType:" + this.dataType + ", is Valid:" + this.isValid;
    }

    public int getDataType() {
        return this.dataType;
    }
}

