/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc;

import com.ibm.ws.pmi.wire.WpdData;
import com.ibm.ws.pmi.wire.WpdDouble;
import com.ibm.ws.pmi.wire.WpdInt;
import com.ibm.ws.pmi.wire.WpdLoad;
import com.ibm.ws.pmi.wire.WpdLong;
import com.ibm.ws.pmi.wire.WpdStat;

public class DataWrapper {
    public static final int NODATA = -1;
    public static final int WPDLONG = 1;
    public static final int WPDINT = 2;
    public static final int WPDDOUBLE = 3;
    public static final int WPDSTAT = 4;
    public static final int WPDLOAD = 5;
    private int dataType = -1;
    private Object myData = null;

    public DataWrapper(Object object) {
        if (object != null) {
            this.myData = object;
            this.setType();
        }
    }

    private void setType() {
        if (this.myData == null) {
            this.dataType = -1;
        } else if (this.myData instanceof WpdLong) {
            this.dataType = 1;
        } else if (this.myData instanceof WpdDouble) {
            this.dataType = 3;
        } else if (this.myData instanceof WpdInt) {
            this.dataType = 2;
        } else if (this.myData instanceof WpdLoad) {
            this.dataType = 5;
        } else if (this.myData instanceof WpdStat) {
            this.dataType = 4;
        }
    }

    public long getLong() {
        if (this.dataType == 1) {
            return ((WpdLong)this.myData).getLongValue();
        }
        if (this.dataType == -1) {
            return -99L;
        }
        return -1L;
    }

    public long getTime() {
        if (this.dataType > 0 && this.dataType < 10) {
            return ((WpdData)this.myData).getTime();
        }
        return -1L;
    }

    public void update(Object object) {
        this.myData = object;
        if (this.dataType == -1) {
            this.setType();
        }
    }

    public String toString() {
        return "DataWrapper.  data:" + this.myData.toString() + " ,dataType:" + this.dataType;
    }

    public int getDataType() {
        return this.dataType;
    }
}

