/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.DataAccessWrapper;

public class ServerBasicDataPointCalc
implements IBasicDataPointCalc,
TuningConstants {
    private int counter;
    private DataAccessWrapper data;
    private PerfDescriptor perfD;
    private boolean dataCached;
    private static TraceComponent tc = Tr.register(ServerBasicDataPointCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public PerfDescriptor getPD() {
        return this.perfD;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setUserId(String string) {
    }

    public void init(PerfDescriptor perfDescriptor, int n) throws IllegalArgumentException {
        this.data = new DataAccessWrapper(perfDescriptor.getDataDescriptor(), n);
        this.perfD = perfDescriptor;
        this.counter = n;
        this.dataCached = false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("BasicDataPointCalc:\n");
        if (this.perfD != null) {
            stringBuffer.append("Node: " + this.perfD.getNodeName());
            stringBuffer.append("Server: " + this.perfD.getServerName());
            stringBuffer.append("DataDescriptor Name: ").append(this.perfD.getDataDescriptor().getName());
            stringBuffer.append("\nCounter: " + this.counter);
            stringBuffer.append("\n");
        } else {
            stringBuffer.append("data is null");
        }
        return stringBuffer.toString();
    }

    public long getLongValue() {
        if (!this.dataCached) {
            this.data.update();
            this.dataCached = true;
        }
        if (this.data.isValid()) {
            return this.data.getLong();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerBasicDataPointCalc.getLongValue data Access Wrapper is not valid");
        }
        return this.data.getLong();
    }

    public double getDoubleValue() {
        Tr.entry(tc, "getDoubleValue");
        if (!this.dataCached) {
            this.data.update();
            this.dataCached = true;
            Tr.debug(tc, "data.update has been called");
        }
        if (this.data.isValid()) {
            Tr.exit(tc, "getDoubleValue");
            return this.data.getDouble();
        }
        double d = this.data.getDouble();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerBasicDataPointCalc.getDoubleValue data Access Wrapper is not valid, returning " + d);
        }
        Tr.exit(tc, "getDoubleValue");
        return d;
    }

    public double getCountValue() {
        if (!this.dataCached) {
            int n = this.data.update();
            this.dataCached = true;
            Tr.debug(tc, "data.update has been called " + n);
        }
        if (this.data.isValid()) {
            return this.data.getCount();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerBasicDataPointCalc.getCount data Access Wrapper is not valid");
        }
        return this.data.getCount();
    }

    public double getIntegral() {
        if (!this.dataCached) {
            int n = this.data.update();
            this.dataCached = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "data.update has been called " + n);
            }
        }
        if (this.data.isValid()) {
            return this.data.getIntegral();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerBasicDataPointCalc.getIntegral data Access Wrapper is not valid");
        }
        return this.data.getIntegral();
    }

    protected boolean hasIntegral() {
        return this.data.getDataType() == 13;
    }

    public void clear() {
        Tr.entry(tc, "clear");
        this.dataCached = false;
        Tr.exit(tc, "clear");
    }
}

