/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointHistoryCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.ServerBasicDataPointCalc;

public class ServerBasicDataPointHistoryCalc
extends ServerBasicDataPointCalc
implements IBasicDataPointHistoryCalc {
    private static TraceComponent tc = Tr.register(ServerBasicDataPointHistoryCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    protected boolean updatedData = false;
    protected double min = -102.0;
    protected double max = -102.0;
    protected double average = -102.0;
    protected double total = 0.0;
    protected double count = 0.0;
    protected boolean haveInterval = false;
    protected double lastTotal = 0.0;
    protected double lastCount = 0.0;
    protected double differenceOverCount = 0.0;

    public double getAverageDouble() {
        if (!this.updatedData) {
            this.updateHistory();
        }
        return this.average;
    }

    public double getMaxDouble() {
        if (!this.updatedData) {
            this.updateHistory();
        }
        return this.max;
    }

    public double getMinDouble() {
        if (!this.updatedData) {
            this.updateHistory();
        }
        return this.min;
    }

    public double getCount() {
        if (!this.updatedData) {
            this.updateHistory();
        }
        return this.count;
    }

    public double getDifferenceOverCount() {
        if (!this.updatedData) {
            this.updateHistory();
        }
        return this.differenceOverCount;
    }

    protected void updateHistory() {
        Tr.entry(tc, "BasicDataPointHistoryCalc.updateHistory()");
        this.updateHistory(super.getDoubleValue());
        Tr.exit(tc, "BasicDataPointHistoryCalc.updateHistory()");
    }

    protected void updateHistory(double d) {
        Tr.entry(tc, "BasicDataPointHistoryCalc.updateHistory(double)");
        if (!TuningUtil.isErrorCode(d)) {
            if (d < this.min || this.min == -102.0) {
                this.min = d;
            }
            if (this.max == -102.0 || d > this.max) {
                this.max = d;
            }
            this.total += d;
            this.count += 1.0;
            this.average = this.total / this.count;
            this.updatedData = true;
            double d2 = super.getCountValue();
            if (!TuningUtil.isErrorCode(d2)) {
                if (this.haveInterval) {
                    double d3 = d - this.lastTotal;
                    this.differenceOverCount = d3 > 0.0 ? d3 / (d2 - this.lastCount) : 0.0;
                    this.lastTotal = d;
                    this.lastCount = d2;
                } else {
                    this.lastCount = d2;
                    this.lastTotal = d;
                    this.differenceOverCount = -101.0;
                    this.haveInterval = true;
                }
            } else {
                Tr.debug(tc, "SBDPHistory.update num units is an error code, should set NO_DATA here");
                this.haveInterval = false;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SBDPHistory.update new data was error code, setting NO_DATA");
            }
            this.min = -102.0;
            this.max = -102.0;
            this.average = -102.0;
            this.differenceOverCount = -102.0;
            this.total = 0.0;
            this.count = 0.0;
            this.updatedData = true;
            this.haveInterval = false;
        }
        Tr.exit(tc, "BasicDataPointHistoryCalc.updateHistory(double)");
    }

    public void init(PerfDescriptor perfDescriptor, int n) {
        this.min = -102.0;
        this.max = -102.0;
        this.average = -102.0;
        this.total = 0.0;
        this.count = 0.0;
        this.updatedData = false;
        this.haveInterval = false;
        this.lastTotal = 0.0;
        this.lastCount = 0.0;
        this.differenceOverCount = -101.0;
        super.init(perfDescriptor, n);
    }

    public long getLongValue() {
        if (!this.updatedData) {
            Long l = new Long(super.getLongValue());
            this.updateHistory(l.doubleValue());
            return l;
        }
        return super.getLongValue();
    }

    public double getDoubleValue() {
        if (!this.updatedData) {
            double d = super.getDoubleValue();
            this.updateHistory(d);
            return d;
        }
        return super.getDoubleValue();
    }

    protected double getTotal() {
        Tr.entry(tc, "BasicDataPointHistoryCalc.getTotal");
        if (!this.updatedData) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "in HistoryCalc.getTotal updatedData is false so calling updateHistory");
            }
            this.updateHistory();
            Tr.entry(tc, "BasicDataPointHistoryCalc.getTotal");
            return this.total;
        }
        Tr.exit(tc, "BasicDataPointHistoryCalc.getTotal");
        return this.total;
    }

    public void clear() {
        if (!this.updatedData) {
            this.updateHistory();
        }
        this.updatedData = false;
        super.clear();
    }
}

