/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointHistoryTimeCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.ServerBasicDataPointHistoryCalc;
import java.util.Date;
import java.util.LinkedList;

public class ServerBasicDataPointHistoryTimeCalc
extends ServerBasicDataPointHistoryCalc
implements IBasicDataPointHistoryTimeCalc {
    private Date initialDate = new Date();
    private LinkedList times;
    private LinkedList totals;
    private LinkedList currentVals;
    private double currentIntervalLength;
    private double intervalTime;
    private boolean increased = false;
    private boolean intAverageInitialized = false;
    private boolean hasIntegral;
    private boolean usesDefaultCalcInterval = false;
    private static TraceComponent tc = Tr.register(ServerBasicDataPointHistoryTimeCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public void clear() {
        if (this.usesDefaultCalcInterval) {
            Tr.debug(tc, "uses defaultCalcInterval, updating");
            this.intervalTime = EngineParameters.getCalcInterval();
        }
        super.clear();
    }

    protected void updateHistory(double d) {
        Tr.entry(tc, "BasicDataPointHistoryTimeCalc.updateHistory(val), value" + d);
        super.updateHistory(d);
        if (!TuningUtil.isErrorCode(d)) {
            double d2;
            this.increased = this.max == -102.0 || d > this.max;
            if (this.hasIntegral) {
                d2 = super.getIntegral();
                Tr.debug(tc, "updateHistory called getIntegral");
            } else {
                d2 = super.getTotal();
                Tr.debug(tc, "updateHistory called getTotal");
            }
            Tr.debug(tc, "ServerBasicDataPointHistoryTime, update called. Got new Total " + d2);
            if (!TuningUtil.isErrorCode(d2)) {
                Date date = new Date();
                this.times.addLast(date);
                this.currentVals.addLast(new Double(d));
                this.totals.addLast(new Double(d2));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "size of linked lists:times=" + this.times.size() + ",current=" + this.currentVals.size() + ",totals=" + this.totals.size());
                }
                this.currentIntervalLength = ((Date)this.times.getLast()).getTime() - ((Date)this.times.getFirst()).getTime();
                if (this.times.size() > 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SesrverBasicDataPointHisorytTimeCalc.update num elements " + this.times.size() + ", interval Time = " + this.intervalTime);
                        for (int i = 0; i < this.times.size(); ++i) {
                            Tr.debug(tc, i + ":val=" + this.currentVals.get(i) + ", time=" + this.times.get(i) + ",total=" + this.totals.get(i));
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "currentLength=" + this.currentIntervalLength / 1000.0 + ", intervalTime=" + this.intervalTime);
                    }
                    if (this.currentIntervalLength / 1000.0 > this.intervalTime) {
                        this.intAverageInitialized = true;
                        Tr.debug(tc, "SesrverBasicDataPointHisorytTimeCalc.update removing first element");
                        this.times.removeFirst();
                        this.totals.removeFirst();
                        this.currentVals.removeFirst();
                        this.currentIntervalLength = ((Date)this.times.getLast()).getTime() - ((Date)this.times.getFirst()).getTime();
                    } else {
                        this.intAverageInitialized = false;
                        Tr.debug(tc, "SesrverBasicDataPointHisorytTimeCalc did not remove element, setting intAverageInitialized to false");
                    }
                } else {
                    Tr.debug(tc, "ServerBasicDataPointHisorytTimeCalc.update only one element");
                    this.intAverageInitialized = false;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "did not add new total because error code " + d2 + " was returned");
            }
        } else {
            Tr.debug(tc, "SBDPHistoryTime.update value is an error code");
            this.increased = false;
        }
        Tr.exit(tc, "BasicDataPointHistoryTimeCalc.updateHistory(val)");
    }

    public long getInitialTime() {
        return this.initialDate.getTime();
    }

    public long getDuration() {
        return ((Date)this.times.getLast()).getTime() - this.initialDate.getTime();
    }

    public long getCurrentTime() {
        return ((Date)this.times.getLast()).getTime();
    }

    public boolean hasIncreased() {
        if (!this.updatedData) {
            this.updateHistory();
        }
        return this.increased;
    }

    public void init(PerfDescriptor perfDescriptor, int n) throws IllegalArgumentException {
        this.usesDefaultCalcInterval = true;
        this.init(perfDescriptor, n, new Integer(EngineParameters.getCalcInterval()).doubleValue());
    }

    public void init(PerfDescriptor perfDescriptor, int n, double d) throws IllegalArgumentException {
        Tr.entry(tc, "BasicDataPointHistoryTimeCalc.init");
        super.init(perfDescriptor, n);
        this.times = new LinkedList();
        this.totals = new LinkedList();
        this.currentVals = new LinkedList();
        this.intervalTime = d;
        this.hasIntegral = super.hasIntegral();
        Tr.exit(tc, "BasicDataPointHistoryTimeCalc.init");
    }

    public void setIntervalTime(double d) {
        this.intervalTime = d;
    }

    public double getIntervalTime() {
        return this.intervalTime;
    }

    public double getIntervalAverage() {
        Tr.entry(tc, "BasicDataPointHistoryTime.getIntervalAverage");
        Tr.debug(tc, "Value before calling updatedData :" + this.updatedData);
        if (!this.updatedData) {
            this.updateHistory();
        }
        Tr.debug(tc, "Value after calling updatedData :" + this.updatedData);
        if (!this.intAverageInitialized) {
            Tr.exit(tc, "BasicDataPointHistoryTime.getIntervalAverage - not initialized yet");
            return -101.0;
        }
        int n = this.times.size();
        if (n > 1) {
            double d = (Double)this.totals.getLast() - (Double)this.totals.getFirst();
            if (this.hasIntegral) {
                Tr.debug(tc, "getIntervalAverage (has integral) interval total=" + d + ",length=" + this.currentIntervalLength);
                Tr.exit(tc, "BasicDataPointHistoryTimegetIntervalAverage");
                return d / this.currentIntervalLength;
            }
            Tr.debug(tc, "does not have integral");
            int n2 = this.totals.size();
            Tr.debug(tc, "getIntervalAverage (no integral) interval total=" + (d += ((Double)this.currentVals.getFirst()).doubleValue()) + ",count=" + n2);
            Tr.exit(tc, "BasicDataPointHistoryTimegetIntervalAverage");
            return d / (double)n2;
        }
        Tr.exit(tc, "BasicDataPointHistoryTimegetIntervalAverage");
        return -102.0;
    }

    public double getIntervalStdDev() {
        Tr.entry(tc, "BasicDataPointHistoryTimeCalc.getIntervalStdDev");
        double d = this.getIntervalStdDevSquared();
        if (TuningUtil.isErrorCode(d)) {
            Tr.exit(tc, "BasicDataPointHistoryTimeCalc.getIntervalStdDev");
            return d;
        }
        Tr.exit(tc, "BasicDataPointHistoryTimeCalc.getIntervalStdDev");
        return Math.sqrt(d);
    }

    public double getIntervalStdDevSquared() {
        Tr.entry(tc, "BasicDataPointHistoryTimeCalc.getIntervalStdDevSquared");
        if (!this.updatedData) {
            this.updateHistory();
        } else {
            Tr.debug(tc, "not calling updateHistory as it has been called this round");
        }
        double d = this.currentVals.size();
        if (d > 1.0) {
            double d2 = this.getIntervalAverage();
            if (TuningUtil.isErrorCode(d2)) {
                Tr.exit(tc, "BasicDataPointHistoryTimeCalc.getIntervalStdDevSquared");
                return d2;
            }
            double d3 = 0.0;
            int n = 0;
            while ((double)n < d) {
                double d4 = d2 - (Double)this.currentVals.get(n);
                d3 += d4 * d4;
                ++n;
            }
            return d3 / d;
        }
        Tr.exit(tc, "BasicDataPointHistoryTimeCalc.getIntervalStdDevSquared");
        return 0.0;
    }

    public void clearHistory() {
        Tr.entry(tc, "BasicDataPointHistoryTimeCalc.clearHistory");
        this.times = new LinkedList();
        this.totals = new LinkedList();
        this.currentVals = new LinkedList();
        this.intAverageInitialized = false;
        Tr.exit(tc, "BasicDataPointHistoryTimeCalc.clearHistory");
    }
}

