/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.ICpuCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.ServerBasicDataPointHistoryTimeCalc;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import com.ibm.ws.pmi.server.DataDescriptor;

public class ServerCpuCalc
implements ICpuCalc {
    private static TraceComponent tc = Tr.register(ServerCpuCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private String nodeName = null;
    private String serverName = null;
    private ServerBasicDataPointHistoryTimeCalc cpuCalc = null;
    protected static final String[] systemModule = new String[]{"systemModule"};
    protected static final DataDescriptor systemModuleDD = new DataDescriptor(systemModule);
    private boolean usesDefaultInterval = false;
    private double myInterval;

    public void setUserId(String string) {
    }

    public void init(String string, String string2) {
        this.usesDefaultInterval = true;
        this.init(string, string2, EngineParameters.getCalcInterval());
    }

    public void init(String string, String string2, int n) {
        Tr.entry(tc, "init");
        this.nodeName = string;
        this.serverName = string2;
        this.usesDefaultInterval = false;
        PerfDescriptorImpl perfDescriptorImpl = new PerfDescriptorImpl(string, string2, systemModuleDD);
        this.cpuCalc = (ServerBasicDataPointHistoryTimeCalc)CalcCreator.createBasicDataPointHistoryTimeCalc("server");
        this.myInterval = n;
        this.cpuCalc.init(perfDescriptorImpl, 1, this.myInterval);
        Tr.exit(tc, "init");
    }

    public double getCurrentUsage() {
        Tr.entry(tc, "getCurrentUsage");
        double d = this.cpuCalc.getDoubleValue();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerCpuCalc.getcurrentUsage is returning " + d);
        }
        Tr.exit(tc, "getCurrentUsage");
        return d;
    }

    public double getIntervalUsage() {
        Tr.entry(tc, "getIntervalUsage");
        double d = this.cpuCalc.getIntervalAverage();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerCpuCalc.getIntervalUsage is returning  " + d);
        }
        Tr.exit(tc, "getIntervalUsage");
        return d;
    }

    public void clear() {
        Tr.entry(tc, "clear");
        if (this.usesDefaultInterval && (double)EngineParameters.getCalcInterval() != this.myInterval) {
            Tr.debug(tc, "EngineParameters.calcInterval has changed, updating cpuCalcInterval");
            this.cpuCalc.setIntervalTime(EngineParameters.getCalcInterval());
        }
        this.cpuCalc.clear();
        Tr.exit(tc, "clear");
    }

    public void setIntervalTime(int n) {
        this.usesDefaultInterval = false;
        this.myInterval = n;
        this.cpuCalc.setIntervalTime(this.myInterval);
    }

    public void clearHistory() {
        this.cpuCalc.clearHistory();
    }
}

