/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.performance.tuning.ConfigUtil;
import com.ibm.ws.performance.tuning.calc.IOrbThreadPoolConfigCalc;
import java.util.ArrayList;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ServerOrbConfigCalc
implements IOrbThreadPoolConfigCalc {
    private boolean initialized = false;
    private int maxPool;
    private int minPool;
    private boolean growable;
    private String server;
    private String node;
    private ObjectName matchedServer;
    private ConfigService cs;
    private static TraceComponent tc = Tr.register(ServerOrbConfigCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public ServerOrbConfigCalc() {
        this.setDefault();
    }

    public void setUserId(String string) {
    }

    public void init(String string, String string2) {
        this.server = string2;
        this.node = string;
        this.setDefault();
    }

    private void setDefault() {
        this.initialized = false;
        this.maxPool = -102;
        this.minPool = -102;
        this.growable = false;
    }

    public void refresh() {
        try {
            if (this.cs == null) {
                this.cs = ConfigServiceFactory.getConfigService();
            }
            if (this.matchedServer == null) {
                this.matchedServer = ConfigUtil.getAppServer(this.server);
            }
            Object var1_1 = null;
            ArrayList arrayList = null;
            if (this.matchedServer != null) {
                ObjectName objectName = ConfigServiceHelper.createObjectName(null, "ObjectRequestBroker");
                ObjectName[] objectNameArray = this.cs.queryConfigObjects(null, this.matchedServer, objectName, null);
                if (objectNameArray != null) {
                    if (objectNameArray[0] != null) {
                        String[] stringArray = new String[]{"threadPool"};
                        AttributeList attributeList = this.cs.getAttributes(null, objectNameArray[0], stringArray, true);
                        arrayList = ConfigUtil.getArrayListValue(attributeList, "threadPool");
                        if (arrayList != null) {
                            this.setPoolFromArrayList(arrayList);
                        } else {
                            Tr.error(tc, "aList of poolAtt is null");
                            attributeList = this.cs.getAttributes(null, objectNameArray[0], null, true);
                            ConfigUtil.printAttributeList(attributeList);
                        }
                    } else {
                        Tr.debug(tc, "orbON[o] is null");
                    }
                } else {
                    Tr.debug(tc, "orb Object name is null");
                }
            } else {
                Tr.debug(tc, "could not match server");
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "General exception caught trying to get config information for connection Pool:" + exception.toString());
            exception.printStackTrace();
        }
    }

    private void setPoolFromArrayList(ArrayList arrayList) {
        Object object = ConfigUtil.getAttributeValueFromArrayList(arrayList, "minimumSize");
        if (object != null) {
            this.minPool = (Integer)object;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got min pool " + this.minPool);
            }
        }
        if ((object = ConfigUtil.getAttributeValueFromArrayList(arrayList, "maximumSize")) != null) {
            this.maxPool = (Integer)object;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got max pool " + this.maxPool);
            }
        }
        if ((object = ConfigUtil.getAttributeValueFromArrayList(arrayList, "isGrowable")) != null) {
            this.growable = (Boolean)object;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got growable " + this.growable);
            }
        }
        this.initialized = true;
    }

    public boolean isGrowable() {
        if (!this.initialized) {
            this.refresh();
        }
        return this.growable;
    }

    public int minPoolSize() {
        if (!this.initialized) {
            this.refresh();
        }
        return this.minPool;
    }

    public int maxPoolSize() {
        if (!this.initialized) {
            this.refresh();
        }
        return this.maxPool;
    }

    public void clear() {
        Tr.entry(tc, "clear");
        Tr.exit(tc, "clear");
    }
}

