/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.calc.IRateIncreaseCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.DataAccessWrapper;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import com.ibm.ws.pmi.server.PmiRegistry;
import java.util.Date;

public class ServerRateIncreaseCalc
implements TuningConstants,
IRateIncreaseCalc {
    private static TraceComponent tc = Tr.register(ServerRateIncreaseCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    boolean gotData = false;
    boolean initialized = false;
    boolean haveValidInterval = false;
    boolean currentIntervalEx = false;
    DataAccessWrapper data = null;
    long initialTime;
    long lastTime;
    long currentTime;
    double initialTotal;
    double lastTotal;
    double currentTotal;
    int streak;
    double numIntervals;
    double numEx;
    Date myDate;
    PerfDescriptor perfD;
    int dataId = -9;
    double myThreshold = -1.0;
    PmiRegistry myReg = null;

    public double getPercentExceed() {
        int n;
        double d = 0.0;
        if (!this.gotData && (n = this.getNewData()) != 101) {
            return n;
        }
        if (this.haveValidInterval) {
            this.numIntervals += 1.0;
            if (this.currentIntervalEx) {
                this.numEx += 1.0;
            }
            d = this.numEx / this.numIntervals * 100.0;
        } else {
            d = -101.0;
        }
        return d;
    }

    private int getNewData() {
        int n = 101;
        try {
            int n2;
            Tr.entry(tc, "getNewData");
            if (tc.isDebugEnabled()) {
                if (this.perfD == null) {
                    Tr.debug(tc, "ServerRateIncrease.getNewData perfD is null");
                } else if (this.perfD.getPath() == null) {
                    Tr.debug(tc, "ServerRateIncrease.getNewData perfD.getPath is null");
                } else {
                    Tr.debug(tc, "about to create dataaccesswrapper using " + this.perfD.getPath() + "and dataId " + this.dataId);
                }
            }
            if (this.data == null) {
                this.data = new DataAccessWrapper(this.perfD.getDataDescriptor(), this.dataId);
                Tr.debug(tc, "****getNewData just created data " + this.data.toString());
            }
            if ((n2 = this.data.update()) == -102) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DataAccessWrapper returned no data");
                }
                this.gotData = false;
                return n2;
            }
            if (n2 == -103) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PMI not enabled, please enable PMI and restart the server.");
                }
                return n2;
            }
            if (this.data.isValid()) {
                Tr.debug(tc, "***data is valid");
                this.myDate = new Date();
                this.gotData = true;
                if (!this.initialized) {
                    this.setInitialValues();
                    return -101;
                }
                this.haveValidInterval = true;
                this.lastTotal = this.currentTotal;
                this.lastTime = this.currentTime;
                this.currentTotal = this.data.getLong();
                this.currentTime = this.myDate.getTime();
                if (this.currentTotal == -100.0 || this.currentTime == -100L) {
                    Tr.exit(tc, "getNewData");
                    return -100;
                }
                this.currentIntervalEx = this.getIntervalRateIncrease() > this.myThreshold;
                n = 101;
            }
        }
        catch (Exception exception) {
            this.gotData = false;
            exception.printStackTrace();
            Tr.error(tc, "Unexpected exception in ServerRateIncreaseCalc.getNewData, " + exception.toString());
        }
        Tr.exit(tc, "getNewData");
        return n;
    }

    private void setInitialValues() {
        this.myDate = new Date();
        this.initialTime = this.myDate.getTime();
        this.initialTotal = this.data.getLong();
        this.initialized = true;
        this.lastTotal = this.initialTotal;
        this.lastTime = this.initialTime;
        this.haveValidInterval = false;
    }

    public double getAverageRateOfIncrease() {
        int n;
        Tr.entry(tc, "getAverageRateOfIncrease");
        if (!this.gotData && (n = this.getNewData()) != 101) {
            Tr.debug(tc, "getNewData returned a problem, returning " + n);
            return n;
        }
        if (this.haveValidInterval) {
            Tr.debug(tc, "I have a valid interval - ServerRateIncreaseCalc.getAverageRateOfIncrease");
            long l = (this.currentTime - this.initialTime) / 1000L;
            double d = (this.currentTotal - this.initialTotal) / (double)l;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getAverageRateIncrease:  initialTime=" + this.initialTime + ",initialTotal=" + this.initialTotal + "CurrentTime=" + this.currentTime + ",CurrentTotal=" + this.currentTotal);
                Tr.debug(tc, "Time: " + l + ", Average RATE=" + d);
            }
            Tr.exit(tc, "getAverageRateOfIncrease");
            return d;
        }
        Tr.debug(tc, "ServerRateIncreaseCalc.getAverageRateOfIncrease do not have a valid interval");
        Tr.exit(tc, "getAverageRateOfIncrease");
        return -101.0;
    }

    public double getIntervalRateIncrease() {
        int n;
        if (!this.gotData && (n = this.getNewData()) != 101) {
            return n;
        }
        if (this.haveValidInterval) {
            long l = (this.currentTime - this.lastTime) / 1000L;
            double d = (this.currentTotal - this.lastTotal) / (double)l;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "currentTime " + this.currentTime);
                Tr.debug(tc, "lastTime " + this.lastTime);
                Tr.debug(tc, "currentTotal " + this.currentTotal);
                Tr.debug(tc, "lastTotal: " + this.lastTotal);
                Tr.debug(tc, "rate: " + d);
                Tr.debug(tc, "time : " + l);
            }
            if (l == 0L) {
                return 0.0;
            }
            return d;
        }
        return -101.0;
    }

    public int getMaxInARowCount() {
        int n;
        if (!this.gotData && (n = this.getNewData()) != 101) {
            return n;
        }
        if (this.haveValidInterval) {
            this.streak = this.currentIntervalEx ? ++this.streak : 0;
        } else {
            return -101;
        }
        return this.streak;
    }

    public void setUserId(String string) {
    }

    public void init(PerfDescriptor perfDescriptor, int n, double d) {
        PerfDescriptorImpl perfDescriptorImpl = new PerfDescriptorImpl(perfDescriptor.getPath(), n);
        perfDescriptorImpl.postInit();
        this.init(perfDescriptorImpl, d);
    }

    public void init(PerfDescriptor perfDescriptor, double d) {
        Tr.entry(tc, "init");
        this.myReg = new PmiRegistry();
        this.perfD = perfDescriptor;
        if (this.perfD == null) {
            Tr.error(tc, "PERFD IS SET TO NULL IN THE INIT");
        }
        this.myThreshold = d;
        this.initialized = false;
        this.initialTime = 0L;
        this.lastTime = 0L;
        this.currentTime = 0L;
        this.initialTotal = 0.0;
        this.lastTotal = 0.0;
        this.currentTotal = 0.0;
        this.streak = 0;
        this.numIntervals = 0.0;
        this.numEx = 0.0;
        this.dataId = this.perfD.getDataDescriptor().getDataId();
        this.gotData = false;
        Tr.exit(tc, "init");
    }

    public void setThreshold(double d) {
        if (d > 0.0) {
            this.myThreshold = d;
        }
    }

    public void clear() {
        Tr.entry(tc, "clear");
        this.gotData = false;
        Tr.exit(tc, "clear");
    }

    public double getThreshold() {
        return this.myThreshold;
    }
}

