/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.performance.tuning.ConfigUtil;
import com.ibm.ws.performance.tuning.calc.ISessionConfigCalc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ServerSessionConfigCalc
implements ISessionConfigCalc {
    private static TraceComponent tc = Tr.register(ServerSessionConfigCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private boolean initialized;
    private boolean allowOverflow;
    private double maxInMemory;
    private double sessionTimeout;
    private boolean persistance;
    private ObjectName matchedServer;
    private ConfigService cs;
    private String server;
    private String node;
    private HashMap cachedServers;

    public void setUserId(String string) {
    }

    public void init(String string, String string2) {
        this.server = string2;
        this.node = string;
        this.setDefault();
    }

    private void setDefault() {
        this.initialized = false;
        this.matchedServer = null;
        this.cs = null;
        this.allowOverflow = false;
        this.maxInMemory = 0.0;
        this.persistance = false;
        this.sessionTimeout = 30000.0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refresh() {
        Tr.entry(tc, "refresh");
        try {
            Attribute attribute;
            Iterator iterator;
            int n;
            if (this.matchedServer == null && this.server != null) {
                this.matchedServer = ConfigUtil.getAppServer(this.server);
            }
            if (this.cs == null) {
                this.cs = ConfigServiceFactory.getConfigService();
            }
            Object object = null;
            ArrayList arrayList = null;
            AttributeList attributeList = null;
            if (this.matchedServer != null) {
                object = this.cs.getAttribute(null, this.matchedServer, "components");
                if (!(object instanceof ArrayList)) {
                    Tr.error(tc, "expected an arrayList");
                    this.setDefault();
                    Tr.exit(tc, "refresh");
                    return;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "did not match application server");
                }
                this.setDefault();
                Tr.exit(tc, "refresh");
                return;
            }
            for (n = 0; n < ((ArrayList)object).size() && arrayList == null; ++n) {
                AttributeList attributeList2 = (AttributeList)((ArrayList)object).get(n);
                if (ConfigUtil.isWebComponent(attributeList2)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "this is a web component");
                    }
                    iterator = attributeList2.iterator();
                    while (iterator.hasNext()) {
                        attribute = (Attribute)iterator.next();
                        if (attribute.getName().equals("name") && tc.isDebugEnabled()) {
                            Tr.debug(tc, "name = " + attribute.getValue());
                        }
                        if (!attribute.getName().equals("services")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "*** attribute.getValue is a " + attribute.getValue().getClass().getName());
                        }
                        arrayList = (ArrayList)attribute.getValue();
                    }
                    continue;
                }
                Tr.debug(tc, "this is not the web component");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "*** now I have an arrayList of the component services " + arrayList.getClass().getName());
            }
            n = 0;
            while (true) {
                block30: {
                    block32: {
                        block28: {
                            Object e2;
                            block31: {
                                block29: {
                                    if (n >= arrayList.size()) break block28;
                                    e2 = arrayList.get(n);
                                    if (!(e2 instanceof Attribute)) break block29;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "got compServices is Attribute");
                                    }
                                    break block30;
                                }
                                if (!(e2 instanceof AttributeList)) break block31;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "got compServices is AttributeList");
                                }
                                iterator = ((AttributeList)e2).iterator();
                                break block32;
                            }
                            if (!tc.isDebugEnabled()) break block30;
                            Tr.debug(tc, "got compServices, type=" + e2.getClass().getName() + " toString=" + e2.toString());
                            break block30;
                        }
                        if (attributeList == null) {
                            Tr.error(tc, "could not find tuningParms for session");
                            this.setDefault();
                            Tr.exit(tc, "refresh");
                            return;
                        }
                        this.setTuningParams(attributeList);
                        this.initialized = true;
                        break;
                    }
                    while (iterator.hasNext()) {
                        attribute = (Attribute)iterator.next();
                        String string = attribute.getName();
                        if (string.equals("tuningParams")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "matched the tuningParams");
                            }
                            attributeList = (AttributeList)attribute.getValue();
                            break;
                        }
                        if (string.equals("sessionPersistenceMode")) {
                            String string2;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "got sessionPersistenceMode");
                            }
                            if ((string2 = (String)attribute.getValue()).equals("NONE")) {
                                this.persistance = false;
                                Tr.debug(tc, "setting persistance to false");
                                continue;
                            }
                            if (string2.equals("DATABASE") || string2.equals("DATA_REPLICATION")) {
                                Tr.debug(tc, "setting persistance to true");
                                this.persistance = true;
                                continue;
                            }
                            Tr.error(tc, "unknown persistance type " + string2);
                            this.setDefault();
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "was not a tuningParams " + attribute.getName());
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.setDefault();
            Tr.error(tc, "Exception caught in ServerSessionConfigCalc.refresh " + exception.toString());
            exception.printStackTrace();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Session information for " + this.server);
            Tr.debug(tc, "initiazlied=" + this.initialized + " overflow=" + this.allowOverflow + " maxInMemory=" + this.maxInMemory + "persistance=" + this.persistance);
        }
        Tr.exit(tc, "refresh");
    }

    private void setTuningParams(AttributeList attributeList) {
        if (attributeList != null) {
            if (attributeList instanceof AttributeList) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "result is a list");
                }
                Iterator iterator = attributeList.iterator();
                while (iterator.hasNext()) {
                    Attribute attribute = (Attribute)iterator.next();
                    if (attribute.getName().equals("allowOverflow")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "got OVERFLOW");
                        }
                        this.allowOverflow = (Boolean)attribute.getValue();
                        continue;
                    }
                    if (attribute.getName().equals("maxInMemorySessionCount")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "got max sessions");
                        }
                        this.maxInMemory = ((Integer)attribute.getValue()).intValue();
                        continue;
                    }
                    if (attribute.getName().equals("invalidationTimeout")) {
                        try {
                            this.sessionTimeout = ((Integer)attribute.getValue()).doubleValue();
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "get session timeout " + this.sessionTimeout);
                        }
                        catch (Exception exception) {
                            System.out.println("*** NRFNW **** exception getting and casting value for sessionTimeout " + exception.toString());
                            exception.printStackTrace();
                            System.out.println("*** NRFNW **** did not get sesssion timeout setting to 3001,class is a " + attribute.getClass().getName());
                            this.sessionTimeout = 30001.0;
                        }
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "no Match:" + attribute.getName() + "=" + attribute.getValue());
                }
                this.initialized = true;
            } else if (tc.isDebugEnabled()) {
                this.setDefault();
                Tr.debug(tc, "result of query on SessionManager did not return a AttributeList, returned " + attributeList.getClass().getName());
            }
        } else {
            this.setDefault();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "query for SessionManager result is NULL");
            }
        }
    }

    private void refreshGetSessionDirectly() {
        block23: {
            Tr.entry(tc, "refreshGetSessionDirectly");
            try {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                ObjectName objectName = ConfigServiceHelper.createObjectName(null, "SessionManager", null);
                ObjectName[] objectNameArray = configService.queryConfigObjects(null, null, objectName, null);
                if (objectNameArray != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, objectNameArray.length + " number of SessionManagers were returned");
                    }
                    for (int i = 0; i < objectNameArray.length; ++i) {
                        AttributeList attributeList;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, ">>>test2 " + objectNameArray[i].toString());
                        }
                        AttributeList attributeList2 = configService.getAttributes(null, objectNameArray[i], null, true);
                        ConfigUtil.printAttributeList(attributeList2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "<<<test2");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding " + ConfigServiceHelper.getDisplayName(objectNameArray[i]) + " to map of session managers");
                            Tr.debug(tc, "Full ObjectName " + objectNameArray[i].toString());
                        }
                        Object object = null;
                        try {
                            object = configService.getAttribute(null, objectNameArray[i], "context");
                            if (object instanceof ObjectName) {
                                attributeList = configService.getAttributes(null, (ObjectName)object, null, true);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, ">>>printing out the webcontainer attribute list");
                                }
                                ConfigUtil.printAttributeList(attributeList);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "<<<printing out the webcontainer attribute list");
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, ">>app server");
                                }
                                object = configService.getAttribute(null, (ObjectName)object, "parentComponent");
                                attributeList = configService.getAttributes(null, (ObjectName)object, null, true);
                                ConfigUtil.printAttribute(attributeList);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, ">>app server");
                                }
                            }
                        }
                        catch (Exception exception) {
                            Tr.error(tc, "could not get the context:" + exception.toString());
                            exception.printStackTrace();
                            this.setDefault();
                        }
                        try {
                            object = configService.getAttribute(null, objectNameArray[i], "sessionPersistenceMode");
                            if (object instanceof String) {
                                if (((String)object).equals("NONE")) {
                                    this.persistance = false;
                                    Tr.debug(tc, "setting persistance to false");
                                } else if (((String)object).equals("DATABASE") || ((String)object).equals("DATA_REPLICATION")) {
                                    Tr.debug(tc, "setting persistance to true");
                                    this.persistance = true;
                                } else {
                                    Tr.error(tc, "unknown persistance type " + object);
                                    this.setDefault();
                                }
                            } else {
                                this.setDefault();
                                Tr.error(tc, "Expected a String for SessionPersistance but got a " + object.getClass().getName());
                            }
                        }
                        catch (Exception exception) {
                            this.setDefault();
                            exception.printStackTrace();
                            Tr.debug(tc, exception.toString());
                        }
                        attributeList = (AttributeList)configService.getAttribute(null, objectNameArray[i], "tuningParams");
                        this.setTuningParams(attributeList);
                    }
                    break block23;
                }
                this.setDefault();
                Tr.debug(tc, "queryConfig Objects returned null");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Tr.exit(tc, "refreshGetSessionDirectly");
    }

    public boolean getAllowOverflow() {
        if (!this.initialized) {
            this.refresh();
        }
        return this.allowOverflow;
    }

    public double getMaxInMemorySessionCount() {
        if (!this.initialized) {
            this.refresh();
        }
        return this.maxInMemory;
    }

    public double getSessionTimeout() {
        if (!this.initialized) {
            this.refresh();
        }
        return this.sessionTimeout;
    }

    public boolean isSetPersistentSessions() {
        if (!this.initialized) {
            this.refresh();
        }
        return this.persistance;
    }

    public void clear() {
        Tr.entry(tc, "clear");
        Tr.exit(tc, "clear");
    }
}

