/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.performance.tuning.ConfigUtil;
import com.ibm.ws.performance.tuning.calc.IServletEngineThreadPoolConfigCalc;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ServerWebAppConfigCalc
implements IServletEngineThreadPoolConfigCalc {
    private boolean initialized = false;
    private int maxPool;
    private int minPool;
    private boolean growable;
    private String server;
    private String node;
    private ObjectName matchedServer;
    private ConfigService cs;
    private static TraceComponent tc = Tr.register(ServerWebAppConfigCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public ServerWebAppConfigCalc() {
        this.setDefault();
    }

    public void setUserId(String string) {
    }

    public void init(String string, String string2) {
        this.server = string2;
        this.node = string;
        this.setDefault();
    }

    private void setDefault() {
        this.initialized = false;
        this.maxPool = -102;
        this.minPool = -102;
        this.growable = false;
    }

    public void refresh() {
        block8: {
            try {
                if (this.matchedServer == null) {
                    this.matchedServer = ConfigUtil.getAppServer(this.server);
                }
                if (this.cs == null) {
                    this.cs = ConfigServiceFactory.getConfigService();
                }
                Object object = null;
                Object var2_3 = null;
                Object var3_4 = null;
                if (this.matchedServer == null || !((object = this.cs.getAttribute(null, this.matchedServer, "components")) instanceof ArrayList)) break block8;
                for (int i = 0; i < ((ArrayList)object).size() && var2_3 == null; ++i) {
                    AttributeList attributeList = (AttributeList)((ArrayList)object).get(i);
                    if (ConfigUtil.isWebComponent(attributeList)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "this is a web component");
                        }
                        Iterator iterator = attributeList.iterator();
                        while (iterator.hasNext()) {
                            Attribute attribute = (Attribute)iterator.next();
                            if (!attribute.getName().equals("threadPool")) continue;
                            this.setPool((AttributeList)attribute.getValue());
                        }
                        break;
                    }
                    Tr.debug(tc, "this is not the web component");
                }
            }
            catch (Exception exception) {
                Tr.error(tc, "General exception caught trying to get config information for connection Pool:" + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    private void setPool(AttributeList attributeList) {
        if (attributeList != null) {
            if (attributeList instanceof AttributeList) {
                Iterator iterator = attributeList.iterator();
                while (iterator.hasNext()) {
                    Attribute attribute = (Attribute)iterator.next();
                    if (attribute.getName().equals("minimumSize")) {
                        this.minPool = (Integer)attribute.getValue();
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "got min pool");
                        continue;
                    }
                    if (attribute.getName().equals("maximumSize")) {
                        this.maxPool = (Integer)attribute.getValue();
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "got max pool");
                        continue;
                    }
                    if (attribute.getName().equals("isGrowable")) {
                        this.growable = (Boolean)attribute.getValue();
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "got growable pool");
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "no Match:" + attribute.getName() + "=" + attribute.getValue());
                }
                this.initialized = true;
            } else if (tc.isDebugEnabled()) {
                this.setDefault();
                Tr.debug(tc, "result of query on WebApp did not return a AttributeList, returned " + attributeList.getClass().getName());
            }
        } else {
            this.setDefault();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "query for WebApp result is NULL");
            }
        }
    }

    public boolean isGrowable() {
        if (!this.initialized) {
            this.refresh();
        }
        return this.growable;
    }

    public int minPoolSize() {
        if (!this.initialized) {
            this.refresh();
        }
        return this.minPool;
    }

    public int maxPoolSize() {
        if (!this.initialized) {
            this.refresh();
        }
        return this.maxPool;
    }

    public void clear() {
        Tr.entry(tc, "clear");
        Tr.exit(tc, "clear");
    }
}

