/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc.config;

import com.ibm.ejs.models.base.resources.ConnectionPool;
import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ejs.models.base.resources.jdbc.JDBCProvider;
import com.ibm.ejs.models.base.resources.jdbc.WAS40ConnectionPool;
import com.ibm.ejs.models.base.resources.jdbc.WAS40DataSource;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.DynamicCache;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionManager;
import com.ibm.websphere.models.config.applicationserver.webcontainer.TuningParams;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.orb.ObjectRequestBroker;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.ServerInstance;
import com.ibm.websphere.models.config.process.ThreadPool;
import com.ibm.websphere.models.config.processexec.JavaProcessDef;
import com.ibm.websphere.models.config.processexec.JavaVirtualMachine;
import com.ibm.websphere.models.config.threadpoolmanager.ThreadPoolManager;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.websphere.models.config.traceservice.TraceService;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.ConfigRootFactory;
import com.ibm.ws.runtime.service.Repository;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.util.EList;

public class RepositoryCache {
    public static final String WEB_CONTAINER = "WebContainer";
    public static final String OBJECT_REQUEST_BROKER = "ObjectRequestBroker";
    public static final String THREAD_POOL = "ThreadPool";
    public static final String MIN_SIZE = "MinSize";
    public static final String MAX_SIZE = "MaxSize";
    public static final String GROWABLE = "Growable";
    public static final String SERVLET_CACHE_ENABLED = "servletCachingEnabled";
    public static final String DATASOURCE = "DataSource";
    public static final String PREP_STMT_CACHE = "PrepStmtCache";
    public static final String JNDI_NAME = "JndiName";
    public static final String DISPLAY_NAME = "DisplayName";
    public static final String PMI_NAME = "PmiName";
    public static final String SESSION = "Session";
    public static final String MANAGER = "SessionManager";
    public static final String MAX_IN_MEMORY = "MaxInMemorySessionCount";
    public static final String ALLOW_OVERFLOW = "allowOverFlow";
    public static final String PERSISTANCE_MODE = "persistanceMode";
    public static final String TIMEOUT = "timeOut";
    public static final String JAVA_VIRTUAL_MACHINE = "JavaVirtualMachine";
    public static final String INITIAL_HEAP_SIZE = "initialHeapSize";
    public static final String MAX_HEAP_SIZE = "maxHeapSize";
    public static final String DISABLE_JIT = "disableJIT";
    public static final String DYNAMIC_CACHE = "DynamicCache";
    public static final String DYNAMIC_CACHE_ENABLED = "dynamicCacheEnabled";
    public static final String DYNAMIC_CACHE_SIZE = "dynamicCacheSize";
    public static final String TRACE_SERVICE = "TraceService";
    public static final String TRACE_SERVICE_ENABLED = "TraceServiceEnabled";
    public static final String TRACE_SERVICE_SPEC = "TraceServiceSpec";
    public static final String SERVER_INSTANCE = "ServerInstance";
    public static final String SINGLE_SERVANT_MODE = "SingleServantMode";
    public static final String DELIM = "-";
    public static final String LOG = "LOG|";
    private static Collection dataSources;
    private static int defaultInitialHeap;
    private static int defaultMaxHeap;
    private static boolean gotStartupValues;
    private static final int DEFAULT_INITIAL_HEAP = 49;
    private static final int DEFAULT_MAX_HEAP = 255;
    private static TraceComponent tc;
    private static boolean initialized;
    private static RepositoryWrapper repository;
    private static String nodeName;
    private static String serverName;
    private static HashMap rMap;
    private static HashMap lMap;

    public static void init(Repository repository2) throws Exception {
        Tr.entry(tc, "init");
        if (!initialized) {
            repository.init(repository2);
            rMap = new HashMap();
            RepositoryCache.initNames();
            initialized = true;
        }
        Tr.exit(tc, "init");
    }

    public static void init(Repository repository2, String string, String string2) throws Exception {
        Tr.entry(tc, "init2");
        if (!initialized) {
            repository.init(repository2, string, string2);
            rMap = new HashMap();
            RepositoryCache.initNames();
            initialized = true;
        }
        Tr.exit(tc, "init2");
    }

    private static void initNames() {
        nodeName = RepositoryCache.getNodeResource().getName();
        serverName = RepositoryCache.getServerResource().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName=" + nodeName);
            Tr.debug(tc, "serverName=" + serverName);
        }
    }

    public static void storeLog(String string, Object object) {
        if (lMap == null) {
            lMap = new HashMap();
        }
        lMap.put(string, object);
    }

    public static Object lookupLog(String string) {
        if (lMap == null) {
            return null;
        }
        Object v = lMap.get(string);
        if (v == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "   RepositoryCache did not find " + string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   printing out log cache");
                Set set = lMap.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    Tr.debug(tc, "       " + string2 + "=" + lMap.get(string2));
                }
            }
        }
        return v;
    }

    public static Object lookup(String[] stringArray) {
        Tr.entry(tc, "lookup");
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(DELIM).append(stringArray[i]);
        }
        String string = stringBuffer.toString();
        Object v = rMap.get(string);
        if (v == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "   RepositoryCache did not find " + string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   printing out repository cache");
                Set set = rMap.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    Tr.debug(tc, "       " + string2 + "=" + rMap.get(string2));
                }
            }
        }
        Tr.exit(tc, "lookup");
        return v;
    }

    public static Object lookup(String string) {
        Tr.entry(tc, "lookup");
        Object v = rMap.get(string);
        if (v == null && tc.isDebugEnabled() && v == null) {
            Tr.debug(tc, "   RepositoryCache did not find " + string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   printing out repository cache");
                Set set = rMap.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    Tr.debug(tc, "       " + string2 + "=" + rMap.get(string2));
                }
            }
        }
        Tr.exit(tc, "lookup");
        return v;
    }

    public static void refreshAll() throws Exception {
        try {
            Tr.entry(tc, "refreshAll");
            rMap = new HashMap();
            RepositoryCache.refreshWebContainer();
            RepositoryCache.refreshObjectRequestBroker();
            RepositoryCache.refreshThreadPools();
            RepositoryCache.refreshAllDataSources();
            RepositoryCache.refreshSession();
            RepositoryCache.refreshJvm();
            RepositoryCache.refreshDynamicCache();
            RepositoryCache.refreshTraceService();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "printing out repository cache");
                Set set = rMap.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Tr.debug(tc, "   " + string + "=" + rMap.get(string));
                }
            }
            Tr.exit(tc, "refreshAll");
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.couldNotRefreshRepositoryCache");
            Tr.exit(tc, "refreshAll");
            throw exception;
        }
    }

    public static void refreshSession() throws Exception {
        try {
            Tr.entry(tc, "refreshSession");
            SessionManager sessionManager = RepositoryCache.getSessionManagerResource();
            TuningParams tuningParams = sessionManager.getTuningParams();
            String string = nodeName + DELIM + serverName + DELIM + SESSION + DELIM + MANAGER + DELIM;
            rMap.put(string + MAX_IN_MEMORY, new Integer(tuningParams.getMaxInMemorySessionCount()));
            rMap.put(string + ALLOW_OVERFLOW, new Boolean(tuningParams.isAllowOverflow()));
            rMap.put(string + TIMEOUT, new Integer(tuningParams.getInvalidationTimeout()));
            rMap.put(string + PERSISTANCE_MODE, sessionManager.getSessionPersistenceMode());
            Tr.exit(tc, "refreshSession");
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.couldNotRefreshConfiguration", new String(SESSION));
            Tr.exit(tc, "refreshSession");
            throw exception;
        }
    }

    public static void refreshAllDataSources() throws Exception {
        try {
            Tr.entry(tc, "refreshAllDataSources");
            Collection collection = RepositoryCache.getAllDataSources();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (e2 instanceof DataSource) {
                    RepositoryCache.addDataSource((DataSource)e2);
                    continue;
                }
                if (!(e2 instanceof WAS40DataSource)) continue;
                RepositoryCache.addWAS40DataSource((WAS40DataSource)e2);
            }
            Tr.exit(tc, "refreshAllDataSources");
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.couldNotRefreshConfiguration", new String("DataSources"));
            Tr.exit(tc, "refreshAllDataSources");
        }
    }

    private static void addWAS40DataSource(WAS40DataSource wAS40DataSource) {
        Tr.entry(tc, "addWAS40DataSource");
        String string = "DataSource-PmiName-" + wAS40DataSource.getName() + DELIM;
        String string2 = "DataSource-JndiName-" + wAS40DataSource.getJndiName() + DELIM;
        WAS40ConnectionPool wAS40ConnectionPool = wAS40DataSource.getConnectionPool();
        rMap.put(string + JNDI_NAME, wAS40DataSource.getJndiName());
        rMap.put(string + DISPLAY_NAME, wAS40DataSource.getName());
        rMap.put(string + THREAD_POOL + DELIM + MIN_SIZE, new Integer(wAS40ConnectionPool.getMinimumPoolSize()));
        rMap.put(string + THREAD_POOL + DELIM + MAX_SIZE, new Integer(wAS40ConnectionPool.getMaximumPoolSize()));
        rMap.put(string + PREP_STMT_CACHE, new Integer(wAS40ConnectionPool.getStatementCacheSize()));
        rMap.put(string2 + JNDI_NAME, wAS40DataSource.getJndiName());
        rMap.put(string2 + DISPLAY_NAME, wAS40DataSource.getName());
        rMap.put(string2 + THREAD_POOL + DELIM + MIN_SIZE, new Integer(wAS40ConnectionPool.getMinimumPoolSize()));
        rMap.put(string2 + THREAD_POOL + DELIM + MAX_SIZE, new Integer(wAS40ConnectionPool.getMaximumPoolSize()));
        rMap.put(string2 + PREP_STMT_CACHE, new Integer(wAS40ConnectionPool.getStatementCacheSize()));
        Tr.exit(tc, "addWAS40DataSource");
    }

    private static void addDataSource(DataSource dataSource) {
        Tr.entry(tc, "addDataSource");
        String string = "DataSource-PmiName-" + dataSource.getJndiName() + DELIM;
        String string2 = "DataSource-JndiName-" + dataSource.getJndiName() + DELIM;
        ConnectionPool connectionPool = dataSource.getConnectionPool();
        rMap.put(string + JNDI_NAME, dataSource.getJndiName());
        rMap.put(string + THREAD_POOL + DELIM + MIN_SIZE, new Integer(connectionPool.getMinConnections()));
        rMap.put(string + THREAD_POOL + DELIM + MAX_SIZE, new Integer(connectionPool.getMaxConnections()));
        rMap.put(string + PREP_STMT_CACHE, new Integer(dataSource.getStatementCacheSize()));
        rMap.put(string2 + DISPLAY_NAME, dataSource.getName());
        rMap.put(string2 + THREAD_POOL + DELIM + MIN_SIZE, new Integer(connectionPool.getMinConnections()));
        rMap.put(string2 + THREAD_POOL + DELIM + MAX_SIZE, new Integer(connectionPool.getMaxConnections()));
        rMap.put(string2 + PREP_STMT_CACHE, new Integer(dataSource.getStatementCacheSize()));
        Tr.exit(tc, "addDataSource");
    }

    public static void refreshWebContainer() throws Exception {
        try {
            String string;
            Tr.entry(tc, "refreshWebContainer");
            WebContainer webContainer = RepositoryCache.getWebContainerResource();
            ThreadPool threadPool = webContainer.getThreadPool();
            if (threadPool != null) {
                string = nodeName + DELIM + serverName + DELIM + WEB_CONTAINER + DELIM + THREAD_POOL + DELIM;
                rMap.put(string + GROWABLE, new Boolean(threadPool.isIsGrowable()));
                rMap.put(string + MIN_SIZE, new Integer(threadPool.getMinimumSize()));
                rMap.put(string + MAX_SIZE, new Integer(threadPool.getMaximumSize()));
            }
            string = nodeName + DELIM + serverName + DELIM + DYNAMIC_CACHE + DELIM;
            rMap.put(string + SERVLET_CACHE_ENABLED, new Boolean(webContainer.isEnableServletCaching()));
            Tr.exit(tc, "refreshWebContainer");
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.couldNotRefreshConfiguration", new String(WEB_CONTAINER));
            Tr.exit(tc, "refreshWebContainer");
            throw exception;
        }
    }

    public static void refreshThreadPools() throws Exception {
        try {
            Tr.entry(tc, "refreshThreadPools");
            ThreadPoolManager threadPoolManager = RepositoryCache.getThreadPoolResource();
            EList eList = threadPoolManager.getThreadPools();
            for (int i = 0; i < eList.size(); ++i) {
                Object object = eList.get(i);
                if (!(object instanceof ThreadPool)) continue;
                ThreadPool threadPool = (ThreadPool)object;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding attributes for ThreadPool " + threadPool.getName());
                }
                String string = nodeName + DELIM + serverName + DELIM + THREAD_POOL + DELIM + threadPool.getName() + DELIM;
                rMap.put(string + GROWABLE, new Boolean(threadPool.isIsGrowable()));
                rMap.put(string + MIN_SIZE, new Integer(threadPool.getMinimumSize()));
                rMap.put(string + MAX_SIZE, new Integer(threadPool.getMaximumSize()));
            }
            Tr.exit(tc, "refreshThreadPools");
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.couldNotRefreshConfiguration", new String("ThreadPools"));
            Tr.exit(tc, "refreshThreadPools");
            throw exception;
        }
    }

    public static void refreshTraceService() throws Exception {
        try {
            Tr.entry(tc, "refreshTraceService");
            TraceService traceService = RepositoryCache.getTraceService();
            String string = nodeName + DELIM + serverName + DELIM + TRACE_SERVICE + DELIM;
            String string2 = new String(traceService.getStartupTraceSpecification());
            boolean bl = traceService.isEnable();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got trace enabled : " + bl);
                Tr.debug(tc, "got trace spec :  " + string2);
            }
            rMap.put(string + TRACE_SERVICE_ENABLED, new Boolean(bl));
            rMap.put(string + TRACE_SERVICE_SPEC, string2);
            Tr.exit(tc, "refreshTraceService");
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.couldNotRefreshConfiguration", new String(TRACE_SERVICE));
            Tr.exit(tc, "refreshTraceService");
            throw exception;
        }
    }

    public static void refreshObjectRequestBroker() throws Exception {
        try {
            Tr.entry(tc, "refreshOrb");
            ObjectRequestBroker objectRequestBroker = RepositoryCache.getObjectRequestBrokerResource();
            ThreadPool threadPool = objectRequestBroker.getThreadPool();
            if (threadPool != null) {
                String string = nodeName + DELIM + serverName + DELIM + OBJECT_REQUEST_BROKER + DELIM + THREAD_POOL + DELIM;
                rMap.put(string + GROWABLE, new Boolean(threadPool.isIsGrowable()));
                rMap.put(string + MIN_SIZE, new Integer(threadPool.getMinimumSize()));
                rMap.put(string + MAX_SIZE, new Integer(threadPool.getMaximumSize()));
            }
            Tr.exit(tc, "refreshOrb");
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.couldNotRefreshConfiguration", new String("OrbRequestBroker"));
            Tr.exit(tc, "refreshOrb");
            throw exception;
        }
    }

    public static void refreshJvm() throws Exception {
        try {
            Tr.entry(tc, "refreshJvm");
            JavaVirtualMachine javaVirtualMachine = RepositoryCache.getJvmResource();
            String string = nodeName + DELIM + serverName + DELIM + JAVA_VIRTUAL_MACHINE + DELIM;
            int n = javaVirtualMachine.getInitialHeapSize();
            if (n == 0) {
                n = RepositoryCache.getDefaultInitialHeap();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got initial heap size from jvm config : " + n);
            }
            rMap.put(string + INITIAL_HEAP_SIZE, new Integer(n));
            int n2 = javaVirtualMachine.getMaximumHeapSize();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got max heap size from jvm config : " + n2);
            }
            if (n2 == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting max heap to default max heap size because jvm config max heap = 0");
                }
                n2 = RepositoryCache.getDefaultMaxHeap();
            }
            rMap.put(string + MAX_HEAP_SIZE, new Integer(n2));
            boolean bl = javaVirtualMachine.isDisableJIT();
            rMap.put(string + DISABLE_JIT, new Boolean(bl));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got jit disabled : " + bl);
            }
            Tr.exit(tc, "refreshJvm");
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.couldNotRefreshConfiguration", new String("JVM"));
            Tr.exit(tc, "refreshJvm");
            throw exception;
        }
    }

    private static int getOS400MaxHeapSystemProperty() {
        try {
            String string = System.getProperty("os400.gc.heap.size.max");
            if (string == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "did not get system property for os400.gc.heap.size.max");
                }
                return -102;
            }
            int n = new Integer(string);
            n /= 1024;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got system property for os400.gc.heap.size.max " + string + " - converted to Mb  " + n);
            }
            return n;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getOS400HeapSystemHeap got exception and handled : " + exception.toString());
            }
            return -102;
        }
    }

    private static int getOS400InitialHeapSystemProperty() {
        try {
            String string = System.getProperty("os400.gc.heap.size.init");
            if (string == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "did not get system property for os400.gc.heap.size.init");
                }
                return -102;
            }
            int n = new Integer(string);
            n /= 1024;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got system property for os400.gc.heap.size.init " + string + " - converted to Mb  " + n);
            }
            return n;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getOS400InitialHeapSystemHeap got exception and handled : " + exception.toString());
            }
            return -102;
        }
    }

    private static void getStartupValues() {
        Tr.entry(tc, "getStartupValues");
        boolean bl = false;
        boolean bl2 = false;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Properties properties = new Properties();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = RepositoryCache.class.getClassLoader();
            }
            String string = System.getProperty("os.name").toLowerCase();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "os : " + string);
            }
            if (string.startsWith("hp")) {
                string = string.substring(0, 2);
                object4 = System.getProperty("os.arch");
                if (((String)object4).startsWith("IA64")) {
                    string = string + "IA64";
                }
            } else if (string.startsWith("os/400")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "printing out system properties");
                    object4 = System.getProperties();
                    object3 = ((Properties)object4).keySet();
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = object2.next();
                        Object object5 = ((Properties)object4).get(object);
                        Tr.debug(tc, "       key: " + object + ", value: " + object5);
                    }
                }
                if (System.getProperty("os400.use.j9", "false").equals("true")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "using os400 and J9 - only read system launch file");
                    }
                    string = "os400j9";
                } else {
                    string = "os400";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "using os400 classic -  reading system properties and if not defined will read system launch file");
                    }
                    try {
                        defaultMaxHeap = RepositoryCache.getOS400MaxHeapSystemProperty();
                        if (defaultMaxHeap != -102) {
                            bl2 = true;
                        }
                        if ((defaultInitialHeap = RepositoryCache.getOS400InitialHeapSystemProperty()) != -102) {
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "got unexpected exception when getting system property for heap : " + exception.toString());
                        }
                        bl2 = false;
                        bl = false;
                    }
                }
            } else if (string.length() > 3) {
                string = string.substring(0, 3);
            }
            if (!bl || !bl2) {
                object4 = "properties/systemlaunch.properties";
                object3 = "properties/" + string + ".systemlaunch.properties";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "reading system launch properties file : " + (String)object3);
                }
                object2 = classLoader.getResourceAsStream((String)object4);
                properties.load((InputStream)object2);
                object2 = classLoader.getResourceAsStream((String)object3);
                if (object2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "got input stream to os specific systemlaunch.properties " + (String)object3);
                    }
                    properties.load((InputStream)object2);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "did not get os specfic properties file : " + (String)object3 + ".  Will use default systemLaunch Properties file");
                }
                if (!bl) {
                    if (properties.containsKey("com.ibm.websphere.management.launcher.defaultMinHeapSize")) {
                        object = properties.getProperty("com.ibm.websphere.management.launcher.defaultMinHeapSize");
                        if (object != null) {
                            defaultInitialHeap = Integer.parseInt(((String)object).substring(4, ((String)object).lastIndexOf(109)));
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "got initial heap from sys properties file : " + defaultInitialHeap);
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "did not get initial heap size from the properites file, will use hard coded default of : 49");
                            }
                            defaultInitialHeap = 49;
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "did not contain initial heap property, will use default : 49");
                        }
                        defaultInitialHeap = 49;
                    }
                }
                if (!bl2) {
                    if (properties.containsKey("com.ibm.websphere.management.launcher.defaultMaxHeapSize")) {
                        object = properties.getProperty("com.ibm.websphere.management.launcher.defaultMaxHeapSize");
                        if (object != null) {
                            defaultMaxHeap = Integer.parseInt(((String)object).substring(4, ((String)object).lastIndexOf(109)));
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "got max heap from sys properties file : " + defaultMaxHeap);
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "max heap property existed but was null, this must be an unbounded heap");
                            }
                            defaultMaxHeap = Integer.MAX_VALUE;
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "properites file did not contain max heap, will assume unbounded hard coded default of : 2147483647");
                        }
                        defaultMaxHeap = Integer.MAX_VALUE;
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got heap setting via system properties not readying system launch properties");
            }
            gotStartupValues = true;
        }
        catch (Exception exception) {
            Tr.debug(tc, "could not get startup heap from system properites : " + exception.toString());
            defaultInitialHeap = 49;
            defaultMaxHeap = 255;
        }
        Tr.exit(tc, "getStartupValues");
    }

    private static int getDefaultInitialHeap() {
        Tr.entry(tc, "getDefaultInitialHeap");
        if (!gotStartupValues) {
            RepositoryCache.getStartupValues();
        }
        Tr.exit(tc, "getDefaultInitialHeap");
        return defaultInitialHeap;
    }

    private static int getDefaultMaxHeap() {
        Tr.entry(tc, "getDefaultMaxHeap");
        if (!gotStartupValues) {
            RepositoryCache.getStartupValues();
        }
        Tr.exit(tc, "getDefaultMaxHeap");
        return defaultMaxHeap;
    }

    public static void refreshServerInstance() throws Exception {
        block4: {
            Tr.entry(tc, "refreshServerInstance");
            try {
                ServerInstance serverInstance = RepositoryCache.getServerInstanceResource();
                String string = nodeName + DELIM + serverName + DELIM + SERVER_INSTANCE + DELIM + SINGLE_SERVANT_MODE;
                if (serverInstance == null) {
                    Tr.debug(tc, "server instance is null must be runinng on Z");
                    rMap.put(string, new Boolean(false));
                    Tr.exit(tc, "refreshServerInstance");
                    return;
                }
                boolean bl = serverInstance.isEnableMultipleServerInstances();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "enableMultipleServants = " + bl + ", setting single servant mode to " + !bl);
                }
                rMap.put(string, new Boolean(!bl));
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "unexpected error when refreshingServerInstance " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "refreshServerInstance");
    }

    public static void refreshDynamicCache() throws Exception {
        try {
            Tr.entry(tc, "refreshDynamicCache");
            DynamicCache dynamicCache = RepositoryCache.getDynamicCacheResource();
            String string = nodeName + DELIM + serverName + DELIM + DYNAMIC_CACHE + DELIM;
            rMap.put(string + DYNAMIC_CACHE_ENABLED, new Boolean(dynamicCache.isEnable()));
            rMap.put(string + DYNAMIC_CACHE_SIZE, new Integer(dynamicCache.getCacheSize()));
            Tr.exit(tc, "refreshDynamicCache");
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.couldNotRefreshConfiguration", new String(DYNAMIC_CACHE));
            Tr.exit(tc, "refreshDynamicCache");
            throw exception;
        }
    }

    private static Collection getAllDataSources() {
        Collection collection = RepositoryCache.getDataSourceResources(0);
        Collection collection2 = RepositoryCache.getDataSourceResources(3);
        Collection collection3 = RepositoryCache.getDataSourceResources(4);
        collection.addAll(collection2);
        collection.addAll(collection3);
        dataSources = collection;
        return collection;
    }

    public static Collection getDataSources() {
        return dataSources;
    }

    private static Collection getDataSourceResources(int n) {
        try {
            ArrayList arrayList = new ArrayList();
            Tr.entry(tc, "getDataSourceResources");
            ConfigRoot configRoot = repository.getConfigRoot();
            List list = configRoot.getResourceElements(n, "resources.xml");
            for (int i = 0; i < list.size(); ++i) {
                Object e2 = list.get(i);
                if (!(e2 instanceof JDBCProvider)) continue;
                EList eList = ((JDBCProvider)e2).getFactories();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    Object e3 = iterator.next();
                    if (e3 instanceof DataSource) {
                        arrayList.add(e3);
                        continue;
                    }
                    if (!(e3 instanceof WAS40DataSource)) continue;
                    arrayList.add(e3);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getDataSourceResources, configRoot=" + n + ", has " + arrayList.size() + " datasources");
            }
            Tr.exit(tc, "getDataSourceResources");
            return arrayList;
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.couldNotFindResource", new String("resources.xml"));
            exception.printStackTrace();
            Tr.exit(tc, "getDataSourceResources error");
            return null;
        }
    }

    private static Node getNodeResource() {
        return (Node)RepositoryCache.getResourceElement(3, "node.xml");
    }

    private static Object getResourceElement(int n, String string) {
        Object var2_2 = null;
        Exception exception = null;
        try {
            ConfigRoot configRoot = repository.getConfigRoot();
            List list = configRoot.getResourceElements(n, string);
            if (list != null && !list.isEmpty()) {
                var2_2 = list.get(0);
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (var2_2 == null) {
            Tr.error(tc, "perfalert.Exception.couldNotFindResource", string);
            if (exception == null) {
                Thread.dumpStack();
            } else {
                exception.printStackTrace();
            }
        }
        return var2_2;
    }

    private static TraceService getTraceService() {
        Tr.entry(tc, "getTraceService");
        Server server2 = RepositoryCache.getServerResource();
        if (server2 == null) {
            Tr.debug(tc, "server resource is null");
            Tr.exit(tc, "getTraceService");
            return null;
        }
        Tr.debug(tc, "got server resource");
        EList eList = server2.getServices();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof TraceService)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got TraceService");
            }
            Tr.exit(tc, "getTraceService");
            return (TraceService)e2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "did not find object request broker");
        }
        Tr.exit(tc, "getTraceService");
        return null;
    }

    private static ServerInstance getServerInstanceResource() {
        Tr.entry(tc, "getServerInstance");
        Server server2 = RepositoryCache.getServerResource();
        if (server2 == null) {
            Tr.debug(tc, "server was null could not get server instance");
            Tr.exit(tc, "getServerInstance");
            return null;
        }
        Tr.entry(tc, "got server");
        ServerInstance serverInstance = server2.getServerInstance();
        if (tc.isDebugEnabled()) {
            if (serverInstance == null) {
                Tr.debug(tc, "could not get server instance it was null");
            } else {
                Tr.debug(tc, "got server instance");
            }
        }
        Tr.exit(tc, "getServerInstance");
        return serverInstance;
    }

    private static Server getServerResource() {
        return (Server)RepositoryCache.getResourceElement(4, "server.xml");
    }

    private static ApplicationServer getApplicationServerResource() {
        Tr.entry(tc, "getApplicationServerResource");
        Server server2 = RepositoryCache.getServerResource();
        if (server2 == null) {
            Tr.debug(tc, "server resource is null");
            Tr.exit(tc, "getApplicationServerResource");
            return null;
        }
        Tr.debug(tc, "got server resource");
        EList eList = server2.getComponents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Component component2 = (Component)iterator.next();
            if (!(component2 instanceof ApplicationServer)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got application server ");
            }
            Tr.exit(tc, "getApplicationServerResource");
            return (ApplicationServer)component2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "did not find application server");
        }
        Tr.exit(tc, "getApplicationServerResource");
        return null;
    }

    private static WebContainer getWebContainerResource() {
        Tr.entry(tc, "getWebContainerResource");
        ApplicationServer applicationServer = RepositoryCache.getApplicationServerResource();
        if (applicationServer == null) {
            Tr.debug(tc, "applicationserver resource is null");
            Tr.exit(tc, "getWebContainerResource");
            return null;
        }
        Tr.debug(tc, "got server resource");
        EList eList = applicationServer.getComponents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Component component2 = (Component)iterator.next();
            if (!(component2 instanceof WebContainer)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got web container ");
            }
            Tr.exit(tc, "getWebContainerResource");
            return (WebContainer)component2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "did not find web container");
        }
        Tr.exit(tc, "getWebContainerResource");
        return null;
    }

    private static ThreadPoolManager getThreadPoolResource() {
        Tr.entry(tc, "getThreadPoolResource");
        Server server2 = RepositoryCache.getServerResource();
        if (server2 == null) {
            Tr.debug(tc, "applicationserver resource is null");
            Tr.exit(tc, "getThreadPoolResource");
            return null;
        }
        Tr.debug(tc, "got server resource");
        EList eList = server2.getServices();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof ThreadPoolManager)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got ThreadPoolManager ");
            }
            Tr.exit(tc, "getThreadPoolResource");
            return (ThreadPoolManager)e2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "did not find ThreadPool Manager");
        }
        Tr.exit(tc, "getThreadPoolResource");
        return null;
    }

    private static SessionManager getSessionManagerResource() {
        Tr.entry(tc, "getSessionManagerResource");
        WebContainer webContainer = RepositoryCache.getWebContainerResource();
        if (webContainer == null) {
            Tr.debug(tc, "webcontainer resource is null");
            Tr.exit(tc, "getSessionManagerResource");
            return null;
        }
        Tr.debug(tc, "got webcontainer resource");
        EList eList = webContainer.getServices();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof SessionManager)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got session manager ");
            }
            Tr.exit(tc, "getSessionManagerResource");
            return (SessionManager)e2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "did not find session manager");
        }
        Tr.exit(tc, "getSessionManagerResource");
        return null;
    }

    private static ObjectRequestBroker getObjectRequestBrokerResource() {
        Tr.entry(tc, "getObjectRequestBrokerResource");
        Server server2 = RepositoryCache.getServerResource();
        if (server2 == null) {
            Tr.debug(tc, "server resource is null");
            Tr.exit(tc, "getObjectRequestBrokerResource");
            return null;
        }
        Tr.debug(tc, "got server resource");
        EList eList = server2.getServices();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof ObjectRequestBroker)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got object request broker ");
            }
            Tr.exit(tc, "getObjectRequestBrokerResource");
            return (ObjectRequestBroker)e2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "did not find object request broker");
        }
        Tr.exit(tc, "getObjectRequestBrokerResource");
        return null;
    }

    private static JavaVirtualMachine getJvmResource() {
        Object e2;
        Iterator iterator;
        EList eList;
        Tr.entry(tc, "getJvmResource");
        Server server2 = RepositoryCache.getServerResource();
        if (server2 == null) {
            Tr.debug(tc, "server resource is null");
            Tr.exit(tc, "getJvmResource");
            return null;
        }
        Tr.debug(tc, "got server resource");
        JavaProcessDef javaProcessDef = (JavaProcessDef)server2.getProcessDefinition();
        Tr.debug(tc, "could not get JavaProcessDefintion resource");
        if (javaProcessDef == null) {
            eList = server2.getProcessDefinitions();
            iterator = eList.iterator();
            while (iterator.hasNext()) {
                String string;
                e2 = iterator.next();
                if (!(e2 instanceof JavaProcessDef)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "got JavaProcessDefinition.");
                }
                if ((string = (javaProcessDef = (JavaProcessDef)e2).getProcessType()) != null && !string.equalsIgnoreCase("Servant")) continue;
                break;
            }
        }
        eList = javaProcessDef.getJvmEntries();
        iterator = eList.iterator();
        while (iterator.hasNext()) {
            e2 = iterator.next();
            if (!(e2 instanceof JavaVirtualMachine)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got java virtual machine ");
            }
            Tr.exit(tc, "getJvmResource");
            return (JavaVirtualMachine)e2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "did not find java virtual machine");
        }
        Tr.exit(tc, "getJvmResource");
        return null;
    }

    private static DynamicCache getDynamicCacheResource() {
        Tr.entry(tc, "getDynamicCacheResource");
        ApplicationServer applicationServer = RepositoryCache.getApplicationServerResource();
        if (applicationServer == null) {
            Tr.debug(tc, "appserver resource is null");
            Tr.exit(tc, "getDynamicCacheResource");
            return null;
        }
        Tr.debug(tc, "got appserver resource");
        EList eList = applicationServer.getServices();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof DynamicCache)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got dynamic cache ");
            }
            Tr.exit(tc, "getDynamicCacheResource");
            return (DynamicCache)e2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "did not find dynamic cache");
        }
        Tr.exit(tc, "getDynamicCacheResource");
        return null;
    }

    public String toString() {
        return RepositoryCache.dumpRepository();
    }

    public static String dumpRepository() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Repository Cache Dump \n");
        Set set = rMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            stringBuffer.append(k).append("\n").append("     ").append(rMap.get(k)).append("\n");
        }
        stringBuffer.append("Dump Finished");
        return stringBuffer.toString();
    }

    public static boolean isInitialized() {
        return initialized;
    }

    static {
        defaultInitialHeap = -102;
        defaultMaxHeap = -102;
        gotStartupValues = false;
        tc = Tr.register(RepositoryCache.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
        repository = new RepositoryWrapper();
    }

    public static class RepositoryWrapper {
        private Repository rep;
        private String node = null;
        private String server = null;

        public void init(Repository repository2) {
            this.rep = repository2;
            this.node = null;
            this.server = null;
        }

        public void init(Repository repository2, String string, String string2) {
            this.rep = repository2;
            this.node = string;
            this.server = string2;
        }

        public ConfigRoot getConfigRoot() {
            if (this.node == null && this.server == null) {
                return this.rep.getConfigRoot();
            }
            return this.getConfigRoot(this.node, this.server);
        }

        private ConfigRoot getConfigRoot(String string, String string2) {
            ConfigRoot configRoot = this.rep.getConfigRoot();
            ConfigRoot configRoot2 = ConfigRootFactory.createConfigRoot(configRoot.getConfigRootPath(), this.rep.getCellName(), string, string2, null);
            return configRoot2;
        }
    }
}

