/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.calc.cachedCalc.AbstractCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.ICachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IDataSourceConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISharedCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.RepositoryCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ServerRDataSourceConfig
extends AbstractCachedCalc
implements IDataSourceConfigCachedCalc,
ISharedCalc,
ICachedCalc {
    private static final long serialVersionUID = 1549326997075984941L;
    private static TraceComponent tc = Tr.register(ServerRDataSourceConfig.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    String lookup = "DataSource-PmiName";
    String jndiKey = "DataSource-JndiName";
    private boolean _static = false;

    public void init(String string, String string2) {
        super.init(string, string2);
    }

    public void init(String string, HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            RepositoryCache.storeLog(string + "-" + string2, hashMap.get(string2));
        }
        this.jndiKey = string + "-" + this.jndiKey;
        this._static = true;
    }

    public void refreshCache() {
        if (this.isStatic()) {
            return;
        }
        try {
            RepositoryCache.refreshAllDataSources();
            this.needToRefresh = false;
        }
        catch (Exception exception) {
            Tr.error(tc, "could not refresh " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void update() {
    }

    public void clear() {
    }

    public int getMaxConnectionPoolSize(PerfDescriptor perfDescriptor) {
        if (this.isStatic()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getMaxConnectionPoolSize - when running from logs, must use jndiName, not PerfDescriptor");
            }
            return -1;
        }
        if (this.needToRefresh) {
            this.refreshCache();
        }
        String string = this.lookup + "-" + this.formatPmiName(perfDescriptor.getName()) + "-" + "ThreadPool" + "-" + "MaxSize";
        return (Integer)RepositoryCache.lookup(string);
    }

    public int getMinConnectionPoolSize(PerfDescriptor perfDescriptor) {
        if (this.isStatic()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getMinConnectionPoolSize - when running from logs, must use jndiName, not PerfDescriptor");
            }
            return -1;
        }
        if (this.needToRefresh) {
            this.refreshCache();
        }
        String string = this.lookup + "-" + this.formatPmiName(perfDescriptor.getName()) + "-" + "ThreadPool" + "-" + "MinSize";
        return (Integer)RepositoryCache.lookup(string);
    }

    public int getPrepStmtCacheSize(PerfDescriptor perfDescriptor) {
        if (this.isStatic()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getPrepStmtCacheSize - when running from logs, must use jndiName, not PerfDescriptor");
            }
            return -1;
        }
        if (this.needToRefresh) {
            this.refreshCache();
        }
        String string = this.lookup + "-" + this.formatPmiName(perfDescriptor.getName()) + "-" + "PrepStmtCache";
        return (Integer)RepositoryCache.lookup(string);
    }

    private String formatPmiName(String string) {
        return string.replace('#', '/');
    }

    public ArrayList getAllJndiNames() {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        return null;
    }

    public int getMaxConnectionPoolSize(String string) {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        String string2 = this.jndiKey + "-" + string + "-" + "ThreadPool" + "-" + "MaxSize";
        if (this.isStatic()) {
            Integer n = (Integer)RepositoryCache.lookupLog(string2);
            return n;
        }
        return (Integer)RepositoryCache.lookup(string2);
    }

    public int getMinConnectionPoolSize(String string) {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        String string2 = this.jndiKey + "-" + string + "-" + "ThreadPool" + "-" + "MinSize";
        if (this.isStatic()) {
            Integer n = (Integer)RepositoryCache.lookupLog(string2);
            return n;
        }
        return (Integer)RepositoryCache.lookup(string2);
    }

    public int getPrepStmtCacheSize(String string) {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        String string2 = this.jndiKey + "-" + string + "-" + "PrepStmtCache";
        if (this.isStatic()) {
            Integer n = (Integer)RepositoryCache.lookupLog(string2);
            return n;
        }
        return (Integer)RepositoryCache.lookup(string2);
    }

    public String getDatasourceHelperClassName(String string) {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        return null;
    }

    public boolean isDatasourceLive(String string) {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        return false;
    }

    public String getDatasourcePath(String string) {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        return null;
    }

    public boolean isStatic() {
        return this._static;
    }

    public HashMap getConfigMap() {
        return null;
    }

    public HashMap getConfigMap(String[] stringArray) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            Integer n;
            String string;
            block8: {
                block7: {
                    try {
                        string = this.jndiKey + "-" + stringArray[i] + "-" + "ThreadPool" + "-" + "MaxSize";
                        n = new Integer(this.getMaxConnectionPoolSize(stringArray[i]));
                        hashMap.put(string, n);
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block7;
                        Tr.debug(tc, "getConfigMap - unable to get param maxConnectionPoolSize");
                    }
                }
                try {
                    string = this.jndiKey + "-" + stringArray[i] + "-" + "ThreadPool" + "-" + "MinSize";
                    n = new Integer(this.getMinConnectionPoolSize(stringArray[i]));
                    hashMap.put(string, n);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "getConfigMap - unable to get param minConnectionPoolSize");
                }
            }
            try {
                string = this.jndiKey + "-" + stringArray[i] + "-" + "PrepStmtCache";
                n = new Integer(this.getPrepStmtCacheSize(stringArray[i]));
                hashMap.put(string, n);
                continue;
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getConfigMap - unable to get param prepStmtCacheSize");
            }
        }
        return hashMap;
    }
}

