/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.calc.cachedCalc.AbstractCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IDynamicCacheConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISharedCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.RepositoryCache;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.ServerRJvmConfigCalc;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Iterator;

public class ServerRDynamicCacheConfigCalc
extends AbstractCachedCalc
implements IDynamicCacheConfigCachedCalc,
ISharedCalc {
    private static final long serialVersionUID = -6622827945799631621L;
    private static TraceComponent tc = Tr.register(ServerRJvmConfigCalc.class, "PerformanceTuningAdvisor", "com.ibm.ws.performance.tuning.properties.perftuning");
    private String server;
    private String node;
    private String baseKey;
    private boolean _static = false;

    public void init(String string, String string2) {
        if (this._static) {
            return;
        }
        this.server = string2;
        this.node = string;
        this.baseKey = string + "-" + this.server + "-" + "DynamicCache" + "-";
    }

    public void init(String string, HashMap hashMap) {
        this.baseKey = string + "-" + "DynamicCache" + "-";
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "init - key=" + this.baseKey + string2 + " value=" + hashMap.get(string2));
            }
            RepositoryCache.storeLog(this.baseKey + string2, hashMap.get(string2));
        }
        this._static = true;
    }

    public void refreshCache() {
        Tr.entry(tc, "refreshCache");
        if (this.isStatic()) {
            Tr.exit(tc, "refreshCache - from log, returning");
            return;
        }
        try {
            RepositoryCache.refreshDynamicCache();
            this.needToRefresh = false;
        }
        catch (Exception exception) {
            Tr.error(tc, "could not refreshCache" + exception.toString());
            exception.printStackTrace();
        }
        Tr.exit(tc, "refreshCache");
    }

    public void update() {
        if (this.isStatic()) {
            return;
        }
    }

    public double getCacheSize() {
        if (this.isStatic()) {
            String string = this.baseKey + "dynamicCacheSize";
            Double d = (Double)RepositoryCache.lookupLog(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getCacheSize - key=" + string + " val=" + d);
            }
            if (d == null) {
                return -1.0;
            }
            return d;
        }
        if (this.needToRefresh) {
            this.refreshCache();
        }
        try {
            String string = this.baseKey + "dynamicCacheSize";
            return ((Integer)RepositoryCache.lookup(string)).doubleValue();
        }
        catch (Exception exception) {
            Tr.error(tc, "ServerRDynamicCacheConfigCalc unexpected exception " + exception.toString());
            exception.printStackTrace();
            return 0.0;
        }
    }

    public boolean isDynamicCacheEnabled() {
        if (this.isStatic()) {
            String string = this.baseKey + "dynamicCacheEnabled";
            Boolean bl = (Boolean)RepositoryCache.lookupLog(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isDynamicCacheEnabled - key=" + string + " val=" + bl);
            }
            return bl;
        }
        if (this.needToRefresh) {
            this.refreshCache();
        }
        try {
            String string = this.baseKey + "dynamicCacheEnabled";
            return (Boolean)RepositoryCache.lookup(string);
        }
        catch (Exception exception) {
            Tr.error(tc, "ServerRDynamicCacheConfigCalc unexpected exception " + exception.toString());
            exception.printStackTrace();
            return false;
        }
    }

    public boolean isServletCacheEnabled() {
        if (this.isStatic()) {
            String string = this.baseKey + "servletCachingEnabled";
            Boolean bl = (Boolean)RepositoryCache.lookupLog(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isServletCacheEnabled - key=" + string + " val=" + bl);
            }
            return bl;
        }
        if (this.needToRefresh) {
            this.refreshCache();
        }
        try {
            String string = this.baseKey + "servletCachingEnabled";
            return (Boolean)RepositoryCache.lookup(string);
        }
        catch (Exception exception) {
            Tr.error(tc, "ServerRDynamicCacheConfigCalc unexpected exception " + exception.toString());
            exception.printStackTrace();
            return false;
        }
    }

    public void clear() {
        Tr.entry(tc, "clear");
        Tr.exit(tc, "clear");
    }

    public boolean isStatic() {
        return this._static;
    }

    public HashMap getConfigMap() {
        HashMap<String, Double> hashMap;
        block8: {
            Constable constable;
            block7: {
                block6: {
                    hashMap = new HashMap<String, Double>();
                    try {
                        constable = new Double(this.getCacheSize());
                        hashMap.put("dynamicCacheSize", (Double)constable);
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block6;
                        Tr.debug(tc, "getConfigMap - unable to get param cacheSize");
                    }
                }
                try {
                    constable = new Boolean(this.isDynamicCacheEnabled());
                    hashMap.put("dynamicCacheEnabled", (Double)constable);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "getConfigMap - unable to get param dynamicCacheEnabled");
                }
            }
            try {
                constable = new Boolean(this.isServletCacheEnabled());
                hashMap.put("servletCachingEnabled", (Double)constable);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "getConfigMap - unable to get param servletCacheEnabled");
            }
        }
        return hashMap;
    }
}

