/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.calc.cachedCalc.AbstractCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IJvmConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISharedCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.RepositoryCache;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Iterator;

public class ServerRJvmConfigCalc
extends AbstractCachedCalc
implements IJvmConfigCachedCalc,
ISharedCalc {
    private static final long serialVersionUID = -8722782349576999739L;
    private static TraceComponent tc = Tr.register(ServerRJvmConfigCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private String server;
    private String node;
    private String baseKey;
    private boolean _static = false;

    public void init(String string, String string2) {
        if (this._static) {
            return;
        }
        this.server = string2;
        this.node = string;
        this.baseKey = string + "-" + this.server + "-" + "JavaVirtualMachine" + "-";
    }

    public void init(String string, HashMap hashMap) {
        this.baseKey = string + "-" + "JavaVirtualMachine" + "-";
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            RepositoryCache.storeLog(this.baseKey + string2, hashMap.get(string2));
        }
        this._static = true;
    }

    public void refreshCache() {
        Tr.entry(tc, "refreshCache");
        if (this.isStatic()) {
            Tr.exit(tc, "refreshCache - from log, returning");
            return;
        }
        try {
            RepositoryCache.refreshJvm();
            this.needToRefresh = false;
        }
        catch (Exception exception) {
            Tr.error(tc, "could not refreshCache" + exception.toString());
            exception.printStackTrace();
        }
        Tr.exit(tc, "refreshCache");
    }

    public void update() {
        if (this.isStatic()) {
            return;
        }
    }

    public double getInitialHeapSize() {
        if (this.isStatic()) {
            String string = this.baseKey + "initialHeapSize";
            Double d = (Double)RepositoryCache.lookupLog(string);
            if (d == null) {
                return -1.0;
            }
            return d;
        }
        if (this.needToRefresh) {
            this.refreshCache();
        }
        try {
            String string = this.baseKey + "initialHeapSize";
            return ((Integer)RepositoryCache.lookup(string)).doubleValue();
        }
        catch (Exception exception) {
            Tr.error(tc, "ServerRJvmConfigCalc unexpected exception " + exception.toString());
            exception.printStackTrace();
            return -102.0;
        }
    }

    public double getMaxHeapSize() {
        if (this.isStatic()) {
            String string = this.baseKey + "maxHeapSize";
            Double d = (Double)RepositoryCache.lookupLog(string);
            if (d == null) {
                return -1.0;
            }
            return d;
        }
        if (this.needToRefresh) {
            this.refreshCache();
        }
        try {
            String string = this.baseKey + "maxHeapSize";
            return ((Integer)RepositoryCache.lookup(string)).doubleValue();
        }
        catch (Exception exception) {
            Tr.error(tc, "ServerRJvmConfigCalc unexpected exception " + exception.toString());
            exception.printStackTrace();
            return -102.0;
        }
    }

    public boolean getJITEnabled() {
        if (this.isStatic()) {
            String string = this.baseKey + "disableJIT";
            Boolean bl = (Boolean)RepositoryCache.lookupLog(string);
            if (bl == null) {
                return false;
            }
            return bl == false;
        }
        if (this.needToRefresh) {
            this.refreshCache();
        }
        try {
            String string = this.baseKey + "disableJIT";
            return (Boolean)RepositoryCache.lookup(string) == false;
        }
        catch (Exception exception) {
            Tr.error(tc, "ServerRJvmConfigCalc unexpected exception " + exception.toString());
            exception.printStackTrace();
            return false;
        }
    }

    public void clear() {
        Tr.entry(tc, "clear");
        Tr.exit(tc, "clear");
    }

    public HashMap getConfigMap() {
        HashMap<String, Constable> hashMap;
        block8: {
            block7: {
                double d;
                block6: {
                    hashMap = new HashMap<String, Constable>();
                    try {
                        d = this.getInitialHeapSize();
                        hashMap.put("initialHeapSize", new Double(d));
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block6;
                        Tr.debug(tc, "getConfigMap - unable to get param initialHeapSize");
                    }
                }
                try {
                    d = this.getMaxHeapSize();
                    hashMap.put("maxHeapSize", new Double(d));
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "getConfigMap - unable to get param maxHeapSize");
                }
            }
            try {
                boolean bl = this.getJITEnabled();
                hashMap.put("disableJIT", new Boolean(!bl));
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "getConfigMap - unable to get param getJitEnabled");
            }
        }
        return hashMap;
    }

    public boolean isStatic() {
        return this._static;
    }
}

