/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.cachedCalc.AbstractCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IOrbThreadPoolConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IServletEngineThreadPoolConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISharedCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.RepositoryCache;
import java.util.HashMap;
import java.util.Iterator;

public class ServerROrbThreadPoolConfigCalc
extends AbstractCachedCalc
implements IOrbThreadPoolConfigCachedCalc,
ISharedCalc {
    private static final long serialVersionUID = 5726667028945094156L;
    private String server;
    private String node;
    private String baseKey;
    private String threadPoolName = "ORB.thread.pool";
    private boolean _static = false;
    private IServletEngineThreadPoolConfigCachedCalc threadPoolConfig;
    private static TraceComponent tc = Tr.register(ServerROrbThreadPoolConfigCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public void init(String string, String string2) {
        if (this._static) {
            return;
        }
        super.init(string, string2);
        this.server = string2;
        this.node = string;
        this.baseKey = string + "-" + string2 + "-" + "ObjectRequestBroker" + "-";
        this.threadPoolConfig = CalcCreator.getServletEngineThreadPoolConfigCachedCalc("server", string, string2);
    }

    public void init(String string, HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            RepositoryCache.storeLog(string + string2, hashMap.get(string2));
        }
        this.baseKey = string + "-" + "ObjectRequestBroker" + "-";
        this._static = true;
    }

    public void refreshCache() {
        if (this.isStatic()) {
            return;
        }
        try {
            RepositoryCache.refreshObjectRequestBroker();
            RepositoryCache.refreshThreadPools();
            this.needToRefresh = false;
        }
        catch (Exception exception) {
            Tr.error(tc, "could not refresh" + exception.toString());
            exception.printStackTrace();
        }
    }

    public void update() {
        if (this.isStatic()) {
            return;
        }
    }

    public boolean isGrowable() {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        String string = this.baseKey + "ThreadPool" + "-" + "Growable";
        Boolean bl = this.isStatic() ? (Boolean)RepositoryCache.lookupLog(string) : (Boolean)RepositoryCache.lookup(string);
        if (bl == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isGrowable - could not find " + string + " look in ThreadPoolManager");
            }
            try {
                bl = new Boolean(this.threadPoolConfig.isGrowable(this.threadPoolName));
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isGrowable - from log, couldn't find value, returning false");
                    exception.printStackTrace();
                }
                return false;
            }
        }
        return bl;
    }

    public int minPoolSize() {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        String string = this.baseKey + "ThreadPool" + "-" + "MinSize";
        Integer n = this.isStatic() ? (Integer)RepositoryCache.lookupLog(string) : (Integer)RepositoryCache.lookup(string);
        if (n == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "minPoolSize - could not find " + string + " look in ThreadPoolManager");
            }
            try {
                n = new Integer(this.threadPoolConfig.minPoolSize(this.threadPoolName));
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "minPoolSize - could not find value returning noData");
                    exception.printStackTrace();
                }
                return -102;
            }
        }
        return n;
    }

    public int maxPoolSize() {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        String string = this.baseKey + "ThreadPool" + "-" + "MaxSize";
        Integer n = this.isStatic() ? (Integer)RepositoryCache.lookupLog(string) : (Integer)RepositoryCache.lookup(string);
        if (n == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "maxPoolSize - could not find " + string + " look in ThreadPoolManager");
            }
            try {
                n = new Integer(this.threadPoolConfig.maxPoolSize(this.threadPoolName));
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "maxPoolSize - could not find value returning noData");
                    exception.printStackTrace();
                }
                return -102;
            }
        }
        return n;
    }

    public void clear() {
        Tr.entry(tc, "clear");
        Tr.exit(tc, "clear");
    }

    public HashMap getConfigMap() {
        HashMap<String, Boolean> hashMap;
        block8: {
            Comparable<Boolean> comparable;
            String string;
            block7: {
                block6: {
                    hashMap = new HashMap<String, Boolean>();
                    string = "-ObjectRequestBroker-ThreadPool-";
                    try {
                        comparable = new Boolean(this.isGrowable());
                        hashMap.put(string + "Growable", (Boolean)comparable);
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block6;
                        Tr.debug(tc, "getConfigMap - unable to get param isGrowable");
                    }
                }
                try {
                    comparable = new Integer(this.minPoolSize());
                    hashMap.put(string + "MinSize", (Boolean)comparable);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "getConfigMap - unable to get param maxPoolSize");
                }
            }
            try {
                comparable = new Integer(this.maxPoolSize());
                hashMap.put(string + "MaxSize", (Boolean)comparable);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "getConfigMap - unable to get param minPoolSize");
            }
        }
        return hashMap;
    }

    public boolean isStatic() {
        return this._static;
    }
}

