/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc.config;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.performance.tuning.calc.cachedCalc.AbstractCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IServicesConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISharedCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.RepositoryCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class ServerRServicesConfigCalc
extends AbstractCachedCalc
implements IServicesConfigCachedCalc,
ISharedCalc {
    private static final long serialVersionUID = 1L;
    private static final String levelLimit = "detail";
    private static TraceComponent tc = Tr.register(ServerRServicesConfigCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private String server;
    private String node;
    private String baseKey_trace;
    private boolean _static = false;

    public void init(String string, String string2) {
        if (this._static) {
            return;
        }
        this.server = string2;
        this.node = string;
        this.baseKey_trace = string + "-" + this.server + "-" + "TraceService" + "-";
    }

    public void init(String string, HashMap hashMap) {
        this.baseKey_trace = string + "-" + "TraceService" + "-";
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            RepositoryCache.storeLog(this.baseKey_trace + string2, hashMap.get(string2));
        }
        this._static = true;
    }

    public void refreshCache() {
        Tr.entry(tc, "refreshCache");
        if (this.isStatic()) {
            Tr.exit(tc, "refreshCache - from log, returning");
            return;
        }
        try {
            RepositoryCache.refreshTraceService();
            this.needToRefresh = false;
        }
        catch (Exception exception) {
            Tr.error(tc, "could not refreshCache" + exception.toString());
            exception.printStackTrace();
        }
        Tr.exit(tc, "refreshCache");
    }

    public boolean getIsTraceServiceEnabled() {
        Tr.entry(tc, "getIsTraceServiceEnabled");
        if (this.isStatic()) {
            String string = this.baseKey_trace + "TraceServiceEnabled";
            Boolean bl = (Boolean)RepositoryCache.lookupLog(string);
            if (bl == null) {
                return false;
            }
            Tr.exit(tc, "getIsTraceServiceEnabled");
            return bl;
        }
        if (this.needToRefresh) {
            this.refreshCache();
        }
        try {
            String string = this.baseKey_trace + "TraceServiceEnabled";
            Tr.debug(tc, "Looking for " + string);
            Tr.exit(tc, "getIsTraceServiceEnabled");
            return (Boolean)RepositoryCache.lookup(string);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception getting TraceServiceEnabled : " + exception.toString());
                exception.printStackTrace();
            }
            Tr.exit(tc, "getIsTraceServiceEnabled");
            return false;
        }
    }

    public String getTraceSpec() {
        Tr.entry(tc, "getTraceSpec");
        if (this.isStatic()) {
            String string = this.baseKey_trace + "TraceServiceSpec";
            String string2 = (String)RepositoryCache.lookupLog(string);
            if (string2 == null) {
                return "";
            }
            Tr.exit(tc, "getTraceSpec");
            return string2;
        }
        if (this.needToRefresh) {
            this.refreshCache();
        }
        try {
            String string = this.baseKey_trace + "TraceServiceSpec";
            Tr.exit(tc, "getTraceSpec");
            return (String)RepositoryCache.lookup(string);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception getting TraceServiceSpec : " + exception.toString());
                exception.printStackTrace();
            }
            Tr.exit(tc, "getTraceSpec");
            return "";
        }
    }

    public ArrayList getEnabledTraceComponents() {
        ArrayList<String> arrayList;
        block4: {
            Tr.entry(tc, "getEnabledTraceComponents");
            arrayList = new ArrayList<String>();
            try {
                String string = this.getTraceSpec();
                Vector vector = ManagerAdmin.parseLoggingSpecString(string, false);
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    String[] stringArray = (String[])iterator.next();
                    String string2 = stringArray[0];
                    String string3 = stringArray[1];
                    String string4 = stringArray[2];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "   comp:   " + string2);
                        Tr.debug(tc, "   level:  " + string3);
                        Tr.debug(tc, "   enabled:" + string4);
                    }
                    if (this.levelOk(string3)) continue;
                    arrayList.add(string2);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "exception caught parsing trace string " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.entry(tc, "getEnabledTraceComponents");
        return arrayList;
    }

    private boolean levelOk(String string) {
        Tr.entry(tc, "levelOk");
        String[] stringArray = LevelConstants.NAMES;
        boolean bl = true;
        for (int i = 0; i < stringArray.length && !stringArray[i].equals(levelLimit); ++i) {
            if (!stringArray[i].equals(string)) continue;
            bl = false;
            break;
        }
        Tr.exit(tc, "levelOk");
        return bl;
    }

    public HashMap getConfigMap() {
        HashMap<String, Object> hashMap;
        block5: {
            block4: {
                hashMap = new HashMap<String, Object>();
                try {
                    boolean bl = this.getIsTraceServiceEnabled();
                    hashMap.put("TraceServiceEnabled", new Boolean(bl));
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "getConfigMap - unable to get param TraceServiceEnabled : " + exception.toString());
                    exception.printStackTrace();
                }
            }
            try {
                String string = this.getTraceSpec();
                hashMap.put("TraceServiceSpec", string);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "getConfigMap - unable to get param TraceServiceSpec : " + exception.toString());
                exception.printStackTrace();
            }
        }
        return hashMap;
    }

    public void update() {
        if (this.isStatic()) {
            return;
        }
    }

    public void clear() {
        Tr.entry(tc, "clear");
        Tr.exit(tc, "clear");
    }

    public boolean isStatic() {
        return this._static;
    }
}

