/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.calc.cachedCalc.AbstractCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IServletEngineThreadPoolConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISharedCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.RepositoryCache;
import com.ibm.ws.performance.tuning.serverAlert.util.MBeanJmxHelper;
import com.ibm.ws.performance.tuning.serverAlert.util.MBeanJmxHelperFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;

public class ServerRServletEngineThreadPoolConfigCalc
extends AbstractCachedCalc
implements IServletEngineThreadPoolConfigCachedCalc,
ISharedCalc {
    private static final long serialVersionUID = -3358347594683154952L;
    private static TraceComponent tc = Tr.register(ServerRServletEngineThreadPoolConfigCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private String server;
    private String node;
    private boolean _static = false;
    private String baseKey;
    private String threadPoolKey;

    public void init(String string, String string2) {
        if (this._static) {
            return;
        }
        super.init(string, string2);
        this.server = string2;
        this.node = string;
        this.baseKey = string + "-" + string2 + "-" + "WebContainer" + "-";
        this.threadPoolKey = string + "-" + string2 + "-" + "ThreadPool" + "-";
    }

    public void init(String string, HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            RepositoryCache.storeLog(string + string2, hashMap.get(string2));
        }
        this.baseKey = string + "-" + "WebContainer" + "-";
        this.threadPoolKey = string + "-" + "ThreadPool" + "-";
        this._static = true;
    }

    public void refreshCache() {
        if (this.isStatic()) {
            return;
        }
        Tr.entry(tc, "refresh");
        try {
            RepositoryCache.refreshWebContainer();
            RepositoryCache.refreshThreadPools();
            this.needToRefresh = false;
        }
        catch (Exception exception) {
            Tr.error(tc, "could not refresh " + exception.toString());
            exception.printStackTrace();
        }
        Tr.exit(tc, "refresh");
    }

    public void update() {
        if (this.isStatic()) {
            return;
        }
    }

    public boolean isGrowable() {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        String string = this.baseKey + "ThreadPool" + "-" + "Growable";
        if (this.isStatic()) {
            Boolean bl = (Boolean)RepositoryCache.lookupLog(string);
            if (bl == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isGrowable - from log, couldn't find value, returning false");
                }
                return false;
            }
            return bl;
        }
        return (Boolean)RepositoryCache.lookup(string);
    }

    public boolean isGrowable(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrowable", string);
        }
        if (this.needToRefresh) {
            this.refreshCache();
        }
        String string2 = this.threadPoolKey + string + "-" + "Growable";
        if (this.isStatic()) {
            Boolean bl = (Boolean)RepositoryCache.lookupLog(string2);
            if (bl == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isGrowable - from log, couldn't find value, returning false");
                }
                return false;
            }
            return bl;
        }
        Boolean bl = (Boolean)RepositoryCache.lookup(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrowable", bl);
        }
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public int minPoolSize() {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        String string = this.baseKey + "ThreadPool" + "-" + "MinSize";
        if (this.isStatic()) {
            Integer n = (Integer)RepositoryCache.lookupLog(string);
            if (n == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "minPoolSize - from log, couldn't find value, returning -1");
                }
                return -1;
            }
            return n;
        }
        return (Integer)RepositoryCache.lookup(string);
    }

    public int minPoolSize(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "minPoolSize", string);
        }
        if (this.needToRefresh) {
            this.refreshCache();
        }
        String string2 = this.threadPoolKey + string + "-" + "MinSize";
        if (this.isStatic()) {
            Integer n = (Integer)RepositoryCache.lookupLog(string2);
            if (n == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "minPoolSize - from log, couldn't find value, returning -1");
                }
                return -1;
            }
            return n;
        }
        Integer n = (Integer)RepositoryCache.lookup(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "minPoolSize", n);
        }
        if (n == null) {
            return -1;
        }
        return n;
    }

    public int maxPoolSize() {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        String string = this.baseKey + "ThreadPool" + "-" + "MaxSize";
        if (this.isStatic()) {
            Integer n = (Integer)RepositoryCache.lookupLog(string);
            if (n == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "maxPoolSize - from log, couldn't find value, returning -1");
                }
                return -1;
            }
            return n;
        }
        return (Integer)RepositoryCache.lookup(string);
    }

    public int maxPoolSize(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "maxPoolSize", string);
        }
        if (this.needToRefresh) {
            this.refreshCache();
        }
        String string2 = this.threadPoolKey + string + "-" + "MaxSize";
        if (this.isStatic()) {
            Integer n = (Integer)RepositoryCache.lookupLog(string2);
            if (n == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "maxPoolSize - from log, couldn't find value, returning -1");
                }
                return -1;
            }
            return n;
        }
        Integer n = (Integer)RepositoryCache.lookup(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "maxPoolSize", n);
        }
        if (n == null) {
            return -1;
        }
        return n;
    }

    public void clear() {
        Tr.entry(tc, "clear");
        Tr.exit(tc, "clear");
    }

    public HashMap getConfigMap() {
        Comparable<Boolean> comparable;
        String string;
        HashMap<String, Boolean> hashMap;
        block12: {
            block11: {
                block10: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "getConfigMap");
                    }
                    hashMap = new HashMap<String, Boolean>();
                    string = "-WebContainer-ThreadPool-";
                    try {
                        comparable = new Boolean(this.isGrowable());
                        hashMap.put(string + "Growable", (Boolean)comparable);
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "getConfigMap - unable to get param growable");
                    }
                }
                try {
                    comparable = new Integer(this.maxPoolSize());
                    hashMap.put(string + "MaxSize", (Boolean)comparable);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "getConfigMap - unable to get param maxPoolSize");
                }
            }
            try {
                comparable = new Integer(this.minPoolSize());
                hashMap.put(string + "MinSize", (Boolean)comparable);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "getConfigMap - unable to get param minPoolSize");
            }
        }
        String[] stringArray = this.getThreadPoolNames();
        string = "-ThreadPool-";
        for (int i = 0; i < stringArray.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding attributes for ThreadPool", stringArray[i]);
            }
            comparable = new Integer(this.minPoolSize(stringArray[i]));
            hashMap.put(string + stringArray[i] + "-" + "MinSize", (Boolean)comparable);
            comparable = new Integer(this.maxPoolSize(stringArray[i]));
            hashMap.put(string + stringArray[i] + "-" + "MaxSize", (Boolean)comparable);
            comparable = new Boolean(this.isGrowable(stringArray[i]));
            hashMap.put(string + stringArray[i] + "-" + "Growable", (Boolean)comparable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigMap", ServerRServletEngineThreadPoolConfigCalc.dumpConfigMap(hashMap));
        }
        return hashMap;
    }

    public boolean isStatic() {
        return this._static;
    }

    private String[] getThreadPoolNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadPoolNames");
        }
        try {
            MBeanJmxHelper mBeanJmxHelper = MBeanJmxHelperFactory.getMBeanJmxHelper(this.node, this.server);
            ObjectName objectName = mBeanJmxHelper.getServerRuleDriverMBean();
            String[] stringArray = (String[])mBeanJmxHelper.getAttribute(objectName, "ThreadPoolNames");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "          " + stringArray + " :" + stringArray);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getThreadPoolNames");
            }
            return stringArray;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not get threadPoolNames");
            }
            exception.printStackTrace();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getThreadPoolNames");
            }
            return null;
        }
    }

    public static String dumpConfigMap(HashMap hashMap) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ServerRServletEngineThreadPoolConfigCalc Dump \n");
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            stringBuffer.append(k).append("\n").append("     ").append(hashMap.get(k)).append("\n");
        }
        stringBuffer.append("Dump Finished");
        return stringBuffer.toString();
    }
}

