/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionPersistenceKind;
import com.ibm.ws.performance.tuning.calc.cachedCalc.AbstractCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.ISessionConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISharedCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.RepositoryCache;
import java.util.HashMap;
import java.util.Iterator;

public class ServerRSessionConfigCalc
extends AbstractCachedCalc
implements ISessionConfigCachedCalc,
ISharedCalc {
    private static final long serialVersionUID = -2920823258001438113L;
    private static TraceComponent tc = Tr.register(ServerRSessionConfigCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private String server;
    private String node;
    private String baseKey;
    private boolean _static = false;

    public void init(String string, String string2) {
        if (this._static) {
            return;
        }
        super.init(string, this.server);
        this.server = string2;
        this.node = string;
        this.baseKey = string + "-" + this.server + "-" + "Session" + "-" + "SessionManager" + "-";
    }

    public void init(String string, HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            RepositoryCache.storeLog(string + string2, hashMap.get(string2));
        }
        this.baseKey = string + "-" + "Session" + "-" + "SessionManager" + "-";
        this._static = true;
    }

    public void refreshCache() {
        Tr.entry(tc, "refreshCache");
        if (this.isStatic()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "refreshCache - from log, returning");
            }
            return;
        }
        try {
            RepositoryCache.refreshSession();
            this.needToRefresh = false;
        }
        catch (Exception exception) {
            Tr.error(tc, "could not refreshCache" + exception.toString());
            exception.printStackTrace();
        }
        Tr.exit(tc, "refreshCache");
    }

    public void update() {
        if (this.isStatic()) {
            return;
        }
    }

    public boolean getAllowOverflow() {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        if (this.isStatic()) {
            String string = this.baseKey + "allowOverFlow";
            Boolean bl = (Boolean)RepositoryCache.lookupLog(string);
            if (bl == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAllowedOverflow - from log, couldn't find value, returning false");
                }
                return false;
            }
            return bl;
        }
        try {
            String string = this.baseKey + "allowOverFlow";
            return (Boolean)RepositoryCache.lookup(string);
        }
        catch (Exception exception) {
            Tr.error(tc, "SererRSessionConfigCalc unexpected exception " + exception.toString());
            exception.printStackTrace();
            return false;
        }
    }

    public double getMaxInMemorySessionCount() {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        if (this.isStatic()) {
            String string = this.baseKey + "MaxInMemorySessionCount";
            Double d = (Double)RepositoryCache.lookupLog(string);
            if (d == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getMaxInMemorySessionCount - from log, couldn't find value, returning -1");
                }
                return -1.0;
            }
            return d;
        }
        try {
            String string = this.baseKey + "MaxInMemorySessionCount";
            return ((Integer)RepositoryCache.lookup(string)).doubleValue();
        }
        catch (Exception exception) {
            Tr.error(tc, "SererRSessionConfigCalc unexpected exception " + exception.toString());
            exception.printStackTrace();
            return 0.0;
        }
    }

    public double getSessionTimeout() {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        if (this.isStatic()) {
            String string = this.baseKey + "timeOut";
            Double d = (Double)RepositoryCache.lookupLog(string);
            if (d == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getSessionTimeout - from log, couldn't find value, returning -1");
                }
                return -1.0;
            }
            return d;
        }
        try {
            String string = this.baseKey + "timeOut";
            return ((Integer)RepositoryCache.lookup(string)).doubleValue();
        }
        catch (Exception exception) {
            Tr.error(tc, "SererRSessionConfigCalc unexpected exception " + exception.toString());
            exception.printStackTrace();
            return 0.0;
        }
    }

    public boolean isSetPersistentSessions() {
        if (this.needToRefresh) {
            this.refreshCache();
        }
        if (this.isStatic()) {
            String string = this.baseKey + "persistanceMode";
            Boolean bl = (Boolean)RepositoryCache.lookupLog(string);
            if (bl == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isSetPersistentSessions - from log, couldn't find value, returning false");
                }
                return false;
            }
            return bl;
        }
        try {
            String string = this.baseKey + "persistanceMode";
            Object object = RepositoryCache.lookup(string);
            if (object == SessionPersistenceKind.get((String)"DATABASE")) {
                return true;
            }
            if (object == SessionPersistenceKind.get((String)"NONE")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "session persistence kind is NONE");
                }
                return false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "session persistence kind not DATABASE or NONE, must be DRS");
            }
            return false;
        }
        catch (Exception exception) {
            Tr.error(tc, "SererRSessionConfigCalc unexpected exception " + exception.toString());
            exception.printStackTrace();
            return false;
        }
    }

    public void clear() {
        Tr.entry(tc, "clear");
        Tr.exit(tc, "clear");
    }

    public boolean isStatic() {
        return this._static;
    }

    public HashMap getConfigMap() {
        HashMap<String, Boolean> hashMap;
        block11: {
            Comparable<Boolean> comparable;
            String string;
            block10: {
                block9: {
                    block8: {
                        hashMap = new HashMap<String, Boolean>();
                        string = "-Session-SessionManager-";
                        try {
                            comparable = new Boolean(this.getAllowOverflow());
                            hashMap.put(string + "allowOverFlow", (Boolean)comparable);
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block8;
                            Tr.debug(tc, "getConfigMap - unable to get param allowOverflow");
                        }
                    }
                    try {
                        comparable = new Double(this.getMaxInMemorySessionCount());
                        hashMap.put(string + "MaxInMemorySessionCount", (Boolean)comparable);
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug(tc, "getConfigMap - unable to get param maxInMemorySessionCount");
                    }
                }
                try {
                    comparable = new Double(this.getSessionTimeout());
                    hashMap.put(string + "timeOut", (Boolean)comparable);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "getConfigMap - unable to get param sessionTimeout");
                }
            }
            try {
                comparable = new Boolean(this.isSetPersistentSessions());
                hashMap.put(string + "persistanceMode", (Boolean)comparable);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "getConfigMap - unable to get param persistentSessions");
            }
        }
        return hashMap;
    }
}

