/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc.sharedCalc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.pmi.stat.WSAverageStatistic;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ICpuSharedCalc;
import com.ibm.ws.performance.tuning.serverAlert.NodeAgentUtil;
import com.ibm.ws.pmi.j2ee.StatsImpl;
import com.ibm.ws.security.core.SecurityContext;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.management.ObjectName;

public class ServerCpuSharedCalc_ND
implements ICpuSharedCalc {
    private boolean updated = false;
    private String server;
    private String node;
    private AdminClient nodeAdminClient;
    private ObjectName systemMetricObjectN;
    private LinkedList cpuStatList;
    boolean hasInterval;
    private WSCountStatistic currentStat;
    private int calcInterval;
    private static TraceComponent tc = Tr.register(ServerCpuSharedCalc_ND.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public void setUserId(String string) {
    }

    public void init(String string, String string2) {
        this.init(string, string2, EngineParameters.getCalcInterval());
    }

    public void init(String string, String string2, int n) {
        Tr.entry(tc, "init");
        this.server = string2;
        this.node = string;
        this.calcInterval = n;
        this.setDefaultValues();
        Tr.exit(tc, "init");
    }

    public int getCalcInterval() {
        return this.calcInterval;
    }

    private void setDefaultValues() {
        this.updated = false;
        this.cpuStatList = new LinkedList();
        this.hasInterval = false;
        this.currentStat = null;
    }

    private void refresh() {
        Tr.entry(tc, "refresh");
        if (EngineParameters.getOS().equalsIgnoreCase("z/OS")) {
            return;
        }
        try {
            if (this.nodeAdminClient == null) {
                this.nodeAdminClient = NodeAgentUtil.getNodeAdminClient(this.node, this.server);
            }
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (ServerCpuSharedCalc_ND.this.systemMetricObjectN == null) {
                        ServerCpuSharedCalc_ND.this.getSystemMetricObjectName();
                    }
                    ServerCpuSharedCalc_ND.this.refreshStats();
                    return null;
                }
            };
            SecurityContext.runAsSystem(privilegedExceptionAction);
            this.updated = true;
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.adminClient", exception);
            exception.printStackTrace();
            Tr.exit(tc, "refresh");
        }
        Tr.exit(tc, "refresh");
    }

    private void checkInstrumentationLevel() throws Exception {
        Tr.entry(tc, "checkInstrumentationLevel");
        NodeAgentUtil.setInstrumentationLevel(this.node, this.server, this.systemMetricObjectN);
        Tr.exit(tc, "checkInstrumentationLevel");
    }

    private void refreshStats() {
        block14: {
            Tr.entry(tc, "refreshStats");
            if (this.systemMetricObjectN == null) {
                this.setDefaultValues();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ServerCpuCachedCalc_ND: could not refresh SystemMetric Stats because the object Name was null, will set defaults");
                }
                Tr.exit(tc, "refreshStats");
                return;
            }
            try {
                String string = "stats";
                StatsImpl statsImpl = (StatsImpl)this.nodeAdminClient.getAttribute(this.systemMetricObjectN, string);
                WSStats wSStats = statsImpl.getWSImpl();
                if (wSStats == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ServerCpuCachedCalc_ND: could not find attribute " + string + " setting defaults");
                    }
                    this.setDefaultValues();
                    Tr.exit(tc, "refreshStats");
                    return;
                }
                WSStatistic[] wSStatisticArray = wSStats.getStatistics();
                if (wSStatisticArray != null && wSStatisticArray.length > 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "got : " + wSStatisticArray.length + " statistics ");
                    }
                    for (int i = 0; i < wSStatisticArray.length; ++i) {
                        if (wSStatisticArray[i].getId() == 1) {
                            Tr.debug(tc, "got current cpu stat");
                            this.currentStat = (WSCountStatistic)wSStatisticArray[i];
                            continue;
                        }
                        if (wSStatisticArray[i].getId() == 2) {
                            Tr.debug(tc, "got average cpu util stat");
                            WSAverageStatistic wSAverageStatistic = (WSAverageStatistic)wSStatisticArray[i];
                            this.cpuStatList.addLast(wSAverageStatistic);
                            WSAverageStatistic wSAverageStatistic2 = (WSAverageStatistic)this.cpuStatList.getFirst();
                            double d = wSAverageStatistic.getLastSampleTime() - wSAverageStatistic2.getLastSampleTime();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "current interval length " + d / 1000.0);
                            }
                            if (d / 1000.0 > (double)this.calcInterval) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "removing first");
                                }
                                this.hasInterval = true;
                                this.cpuStatList.removeFirst();
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "not removing first");
                            this.hasInterval = false;
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, wSStatisticArray[i].getId() + " was not cpu utilization, or average utilization ");
                    }
                    break block14;
                }
                Tr.debug(tc, "statistics were null, try setting instrumentation level");
                this.checkInstrumentationLevel();
                this.setDefaultValues();
                Tr.exit(tc, "refreshStats");
                return;
            }
            catch (Exception exception) {
                this.setDefaultValues();
                exception.printStackTrace();
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug(tc, "could not refresh stats, exception caught " + exception.toString());
            }
        }
        Tr.exit(tc, "refreshStats");
    }

    private void getSystemMetricObjectName() {
        block13: {
            Tr.entry(tc, "getSystemMetricObjectName");
            if (this.nodeAdminClient == null) {
                this.systemMetricObjectN = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "could not get systemMetricObject name becasue node admnin client was null");
                }
                Tr.exit(tc, "getSystemMetricObjectName");
                return;
            }
            try {
                String string = this.nodeAdminClient.getDomainName();
                String string2 = string + ":mbeanIdentifier=SystemMetrics" + ",node=" + this.node + ",*";
                ObjectName objectName = new ObjectName(string2);
                Set set = this.nodeAdminClient.queryNames(objectName, null);
                if (set != null) {
                    Iterator iterator;
                    if (tc.isDebugEnabled()) {
                        if (set.size() != 1) {
                            Tr.debug(tc, "ServerCpuCachedCalc_ND:  set contained " + set.size() + " mbeans expected one");
                        } else {
                            Tr.debug(tc, "ServerCpuCachedCalc_ND:  set contained just one mbean - good");
                        }
                    }
                    if (!(iterator = set.iterator()).hasNext()) {
                        if (tc.isDebugEnabled()) {
                            string2 = string + ":node=" + this.node + ",*";
                            objectName = new ObjectName(string2);
                            set = this.nodeAdminClient.queryNames(objectName, null);
                            Tr.debug(tc, "printing out all object names");
                            iterator = set.iterator();
                            while (iterator.hasNext()) {
                                Tr.debug(tc, "        objectName = " + iterator.next());
                            }
                        }
                        throw new Exception("ServerCpuCachedCalc_ND:  set did not have any ObjectNames after query for SystemMetrics");
                    }
                    this.systemMetricObjectN = (ObjectName)iterator.next();
                    if (this.systemMetricObjectN == null) {
                        throw new Exception("ServerCpuCachedCalc_ND:  Object name for SystemMetrics is null ");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "got SystemMetricsObjectName");
                    }
                    break block13;
                }
                throw new Exception("ServerCpuCachedCalc_ND:  Set of Object Names returned from query on nodeAdminClient was null: " + objectName.toString());
            }
            catch (Exception exception) {
                System.out.println("ServerCpuCachedCalc_ND Exception caught trying to get SystemMetrics MBean from nodeAdminClient " + exception.toString());
                exception.printStackTrace();
                this.systemMetricObjectN = null;
            }
        }
    }

    public double getCurrentUsage() {
        Tr.entry(tc, "getCurrentUsage");
        if (!this.updated) {
            this.refresh();
        }
        if (this.currentStat != null) {
            Tr.exit(tc, "getCurrentUsage");
            return this.currentStat.getCount();
        }
        Tr.exit(tc, "getCurrentUsage");
        return -102.0;
    }

    public double getIntervalUsage() {
        Tr.entry(tc, "getIntervalUsage");
        if (!this.updated) {
            this.refresh();
        }
        if (tc.isDebugEnabled()) {
            this.dump();
        }
        if (this.hasInterval) {
            WSAverageStatistic wSAverageStatistic = (WSAverageStatistic)this.cpuStatList.getFirst();
            WSAverageStatistic wSAverageStatistic2 = (WSAverageStatistic)this.cpuStatList.getLast();
            WSAverageStatistic wSAverageStatistic3 = (WSAverageStatistic)wSAverageStatistic2.delta(wSAverageStatistic);
            Tr.exit(tc, "getIntervalUsage");
            return wSAverageStatistic3.getMean();
        }
        Tr.exit(tc, "getIntervalUsage no interval");
        return -102.0;
    }

    public double getAverageUsage() {
        WSAverageStatistic wSAverageStatistic;
        Tr.entry(tc, "getAverageUsage");
        if (!this.updated) {
            this.refresh();
        }
        if ((wSAverageStatistic = (WSAverageStatistic)this.cpuStatList.getLast()) != null) {
            Tr.exit(tc, "getAverageUsage");
            return wSAverageStatistic.getMean();
        }
        Tr.exit(tc, "getAverageUsage");
        return -102.0;
    }

    public void update() {
        Tr.entry(tc, "update");
        if (!this.updated) {
            this.refresh();
        }
        this.updated = false;
        Tr.exit(tc, "update");
    }

    private void dump() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerCpuCachedCalc_ND is dumping data");
            Tr.debug(tc, "size of list is " + this.cpuStatList.size());
            if (this.cpuStatList.size() > 1) {
                WSAverageStatistic wSAverageStatistic;
                for (int i = 0; i < this.cpuStatList.size(); ++i) {
                    wSAverageStatistic = (WSAverageStatistic)this.cpuStatList.get(i);
                    Tr.debug(tc, i + " mean:" + wSAverageStatistic.getMean() + ", " + wSAverageStatistic.getLastSampleTime() / 1000L);
                }
                WSAverageStatistic wSAverageStatistic2 = (WSAverageStatistic)this.cpuStatList.getFirst();
                wSAverageStatistic = (WSAverageStatistic)this.cpuStatList.getLast();
                WSAverageStatistic wSAverageStatistic3 = (WSAverageStatistic)wSAverageStatistic.delta(wSAverageStatistic2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "delta " + wSAverageStatistic3.toString());
                    Tr.debug(tc, "      ,mean=" + wSAverageStatistic3.getMean());
                    Tr.debug(tc, "current " + this.currentStat.toString());
                    Tr.debug(tc, "      ,count=" + this.currentStat.getCount());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list is not big enough");
            }
        }
    }

    public void clearHistory() {
        this.setDefaultValues();
    }
}

