/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc.sharedCalc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.calc.cachedCalc.AbstractCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IDataSourceConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.IDataSourceMBeanSharedCalc;
import com.ibm.ws.performance.tuning.serverAlert.util.MBeanJmxHelper;
import com.ibm.ws.performance.tuning.serverAlert.util.MBeanJmxHelperFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ServerDataSourceMBeanCalc
extends AbstractCachedCalc
implements IDataSourceMBeanSharedCalc,
NotificationListener {
    private static final long serialVersionUID = 5267297946511957366L;
    private IDataSourceConfigCachedCalc backupConfig;
    private MBeanJmxHelper jmxHelper;
    private HashMap jndiNameMap;
    private ArrayList jndiNames;
    private boolean _static = false;
    public static final String DATASOURCE_TYPE = "DataSource";
    public static final String DATASOURCE_ATTRIBUTE_JNDINAME = "jndiName";
    public static final String DATASOURCE_ATTRIBUTE_NAME = "dataSourceName";
    public static final String DATASOURCE_ATTRIBUTE_FACTOTRY = "connectionFactoryType";
    public static final String DATASOURCE_ATTRIBUTE_HELPER = "dataStoreHelperClass";
    public static final String DATASOURCE_ATTRIBUTE_CACHESIZE = "statementCacheSize";
    public static final String DATASOURCE_ATTRIBUTE_MINPOOL = "unvailableAttribute_minPoolSize";
    public static final String DATASOURCE_ATTRIBUTE_MAXPOOL = "unavailableAttribute_maxPoolSize";
    public static final String KEY_DELIM = "_";
    public static final String[] DATASOURCE_ATTRIBUTES = new String[]{"jndiName", "dataSourceName", "connectionFactoryType", "dataStoreHelperClass", "statementCacheSize"};
    private static TraceComponent tc = Tr.register(ServerDataSourceMBeanCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public void init(String string, String string2) {
        try {
            super.init(string, string2);
            this.jmxHelper = MBeanJmxHelperFactory.getMBeanJmxHelper(string, string2);
            this.jndiNameMap = new HashMap();
            this.initCache();
            this.registerForMBeanAdditionDeletionNotifications();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "init caught exception " + exception.toString());
                exception.printStackTrace();
            }
            this.jmxHelper = null;
        }
    }

    public void init(String string, HashMap hashMap) {
        this._static = true;
        this.jndiNameMap = hashMap;
        this.jndiNames = new ArrayList(hashMap.size());
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.endsWith(DATASOURCE_ATTRIBUTE_JNDINAME)) continue;
            this.jndiNames.add(hashMap.get(string2));
        }
    }

    private String formatPmiName(String string) {
        return string.replace('#', '/');
    }

    public void initCache() {
        block4: {
            Tr.entry(tc, "initCache");
            if (this.isStatic()) {
                Tr.exit(tc, "initCache - from log, returning");
                return;
            }
            try {
                Set set = this.jmxHelper.getAllObjectNames(DATASOURCE_TYPE);
                this.jndiNames = new ArrayList();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName = (ObjectName)iterator.next();
                    this.addToCache(objectName);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "initCache caught exception : " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "initCache");
    }

    public void finalize() {
        block6: {
            Tr.entry(tc, "finalize");
            if (this.isStatic()) {
                Tr.exit(tc, "finalize - from log, returning");
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "finalize is going to remove notifications");
            }
            try {
                if (this.jmxHelper != null) {
                    Set set = this.jmxHelper.getAllObjectNames(DATASOURCE_TYPE);
                    this.jndiNames = new ArrayList();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        ObjectName objectName = (ObjectName)iterator.next();
                        this.removeFromCache(objectName);
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "finalize caught exception : " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.entry(tc, "finalize");
    }

    private void removeFromCache(ObjectName objectName) throws Exception {
        int n;
        Tr.entry(tc, "removeFromCache");
        if (this.isStatic()) {
            Tr.exit(tc, "removeFromCache - from log, returning");
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DataSourceConfig is removing " + objectName + "from the cache because mbean has been unregistered");
        }
        String string = (String)this.jmxHelper.getAttribute(objectName, DATASOURCE_ATTRIBUTE_JNDINAME);
        for (n = 0; n < this.jndiNames.size(); ++n) {
            if (!((String)this.jndiNames.get(n)).equals(string)) continue;
            this.jndiNames.remove(n);
            break;
        }
        for (n = 0; n < DATASOURCE_ATTRIBUTES.length; ++n) {
            String string2 = DATASOURCE_ATTRIBUTES[n];
            String string3 = string + KEY_DELIM + string2;
            this.jndiNameMap.remove(string3);
        }
        this.unRegisterForNotificationsOnMBean(objectName);
    }

    private void addToCache(ObjectName objectName) throws Exception {
        Tr.entry(tc, "addToCache");
        if (this.isStatic()) {
            Tr.exit(tc, "addToCache - from log, returning");
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "objectName :" + objectName);
        }
        String string = (String)this.jmxHelper.getAttribute(objectName, DATASOURCE_ATTRIBUTE_JNDINAME);
        this.jndiNames.add(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "     caching runtime settings for " + string);
        }
        for (int i = 0; i < DATASOURCE_ATTRIBUTES.length; ++i) {
            String string2 = DATASOURCE_ATTRIBUTES[i];
            String string3 = string + KEY_DELIM + string2;
            try {
                Object object = this.jmxHelper.getAttribute(objectName, string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "   \t" + string3 + ": " + object);
                    Tr.debug(tc, "value type " + object.getClass());
                }
                if (object == null || object instanceof Integer && (Integer)object < 0) continue;
                if (object instanceof Class) {
                    object = ((Class)object).getName();
                }
                this.jndiNameMap.put(string3, object);
                continue;
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{string2, string};
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "perfalert.Exception.AttributeNotFound", objectArray);
            }
        }
        this.registerForNotificationsOnMBean(objectName);
        Tr.exit(tc, "addToCache");
    }

    private void registerForNotificationsOnMBean(ObjectName objectName) throws Exception {
        if (this.isStatic()) {
            return;
        }
        AttributeChangeNotificationFilter attributeChangeNotificationFilter = new AttributeChangeNotificationFilter();
        for (int i = 0; i < DATASOURCE_ATTRIBUTES.length; ++i) {
            attributeChangeNotificationFilter.enableAttribute(DATASOURCE_ATTRIBUTES[i]);
        }
        String string = (String)this.jmxHelper.getAttribute(objectName, DATASOURCE_ATTRIBUTE_JNDINAME);
        try {
            this.jmxHelper.addNotification(objectName, this, attributeChangeNotificationFilter, string);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{objectName.toString(), exception.toString()};
            Tr.error(tc, "perfalert.Exception.couldNotRegisterForNotification", stringArray);
            exception.printStackTrace();
        }
    }

    private void registerForMBeanAdditionDeletionNotifications() {
        Tr.entry(tc, "registerForMBeanAdditionDeletionNotifications");
        if (this.isStatic()) {
            Tr.exit(tc, "registerForMBeanAdditionDeletionNotifications - from log, returning");
            return;
        }
        try {
            this.jmxHelper.registerForRegistrationNotifications(this, DATASOURCE_TYPE);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{DATASOURCE_TYPE, exception.toString()};
            Tr.error(tc, "perfalert.Exception.couldNotRegisterForNotification.mBeanServerDelegate", objectArray);
            exception.printStackTrace();
        }
        Tr.exit(tc, "registerForMBeanAdditionDeletionNotifications");
    }

    private void unRegisterForNotificationsOnMBean(ObjectName objectName) {
        if (this.isStatic()) {
            Tr.exit(tc, "unRegisterForNotificationsOnMBean - from log, returning");
            return;
        }
        try {
            this.jmxHelper.removeNotification(objectName, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handleNotification(Notification notification, Object object) {
        Tr.entry(tc, "handleNotification");
        if (this.isStatic()) {
            Tr.exit(tc, "handleNotification - from log, returning");
            return;
        }
        String string = notification.getType();
        if (string.equals("jmx.attribute.change")) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "\tnotification:  type=" + notification.getType() + ", attributeName=" + ((AttributeChangeNotification)notification).getAttributeName() + ", oldValue=" + ((AttributeChangeNotification)notification).getOldValue() + ", newValue=" + ((AttributeChangeNotification)notification).getNewValue());
                }
                String string2 = object + KEY_DELIM + ((AttributeChangeNotification)notification).getAttributeName();
                Object object2 = ((AttributeChangeNotification)notification).getNewValue();
                if (object2 instanceof Class) {
                    object2 = ((Class)object2).getName();
                }
                this.jndiNameMap.put(string2, object2);
            }
            catch (ClassCastException classCastException) {
                String[] stringArray = new String[]{notification.toString(), classCastException.toString()};
                Tr.error(tc, "perfalert.Exception.NotificationClassCastException", stringArray);
                classCastException.printStackTrace();
            }
        } else {
            super.handleNotification(notification, object);
        }
        Tr.exit(tc, "handleNotification");
    }

    public void update() {
        Tr.entry(tc, "update");
        if (this.isStatic()) {
            Tr.exit(tc, "update - from log, returning");
            return;
        }
        this.refreshCache();
        Tr.exit(tc, "update");
    }

    public void refreshCache() {
        if (this.isStatic()) {
            return;
        }
        this.initCache();
        this.needToRefresh = false;
    }

    public int getMaxConnectionPoolSize(PerfDescriptor perfDescriptor) {
        return this.getMaxConnectionPoolSize(this.formatPmiName(perfDescriptor.getName()));
    }

    public int getMinConnectionPoolSize(PerfDescriptor perfDescriptor) {
        return this.getMinConnectionPoolSize(this.formatPmiName(perfDescriptor.getName()));
    }

    public int getPrepStmtCacheSize(PerfDescriptor perfDescriptor) {
        String string = this.formatPmiName(perfDescriptor.getName());
        return this.getPrepStmtCacheSize(string);
    }

    public ArrayList getAllJndiNames() {
        Tr.entry(tc, "getAllJndiNames");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "jndiNames :" + this.jndiNames);
        }
        Tr.exit(tc, "getAllJndiNames");
        return this.jndiNames;
    }

    public int getMaxConnectionPoolSize(String string) {
        String string2 = string + KEY_DELIM + DATASOURCE_ATTRIBUTE_MAXPOOL;
        if (this.jndiNameMap.containsKey(string2)) {
            return ((Double)this.jndiNameMap.get(string2)).intValue();
        }
        Object[] objectArray = new Object[]{string2, DATASOURCE_TYPE};
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "perfalert.Exception.mBeanAttributeNotAvailable", objectArray);
        }
        return this.backupConfig.getMaxConnectionPoolSize(string);
    }

    public int getMinConnectionPoolSize(String string) {
        String string2 = string + KEY_DELIM + DATASOURCE_ATTRIBUTE_MINPOOL;
        if (this.jndiNameMap.containsKey(string2)) {
            return ((Double)this.jndiNameMap.get(string2)).intValue();
        }
        Object[] objectArray = new Object[]{string2, DATASOURCE_TYPE};
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "perfalert.Exception.mBeanAttributeNotAvailable", objectArray);
        }
        return this.backupConfig.getMinConnectionPoolSize(string);
    }

    public int getPrepStmtCacheSize(String string) {
        String string2 = string + KEY_DELIM + DATASOURCE_ATTRIBUTE_CACHESIZE;
        if (this.jndiNameMap.containsKey(string2)) {
            return (Integer)this.jndiNameMap.get(string2);
        }
        Object[] objectArray = new Object[]{string2, DATASOURCE_TYPE};
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "perfalert.Exception.mBeanAttributeNotAvailable", objectArray);
        }
        return this.backupConfig.getPrepStmtCacheSize(string);
    }

    public String getDatasourceHelperClassName(String string) {
        String string2 = string + KEY_DELIM + DATASOURCE_ATTRIBUTE_HELPER;
        if (this.jndiNameMap.containsKey(string2)) {
            return (String)this.jndiNameMap.get(string2);
        }
        Object[] objectArray = new Object[]{DATASOURCE_ATTRIBUTE_HELPER, DATASOURCE_TYPE};
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "perfalert.Exception.mBeanAttributeNotAvailable", objectArray);
        }
        return this.backupConfig.getDatasourceHelperClassName(string);
    }

    public boolean isDatasourceLive(String string) {
        return false;
    }

    public String getDatasourcePath(String string) {
        return null;
    }

    public void setBackUp(IDataSourceConfigCachedCalc iDataSourceConfigCachedCalc) {
        Tr.entry(tc, "setBackUp");
        this.backupConfig = iDataSourceConfigCachedCalc;
        Tr.exit(tc, "setBackUp");
    }

    public String toString() {
        String string = new String("DataSourceMBeanCalc: ");
        try {
            for (int i = 0; i < this.jndiNames.size(); ++i) {
                String string2 = (String)this.jndiNames.get(i);
                string = string + "\n   " + string2;
                string = string + "CLASSNAME:" + this.getDatasourceHelperClassName(string2);
                string = string + " - PATH:" + this.getDatasourcePath(string2);
                string = string + " - MAX:" + this.getMaxConnectionPoolSize(string2);
                string = string + " - MIN " + this.getMinConnectionPoolSize(string2);
                string = string + " - PREP " + this.getPrepStmtCacheSize(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public HashMap getConfigMap() {
        return this.jndiNameMap;
    }

    public boolean isStatic() {
        return this._static;
    }
}

