/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc.sharedCalc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.calc.cachedCalc.AbstractCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.ISessionConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISessionMBeanSharedCalc;
import com.ibm.ws.performance.tuning.serverAlert.util.MBeanJmxHelper;
import com.ibm.ws.performance.tuning.serverAlert.util.MBeanJmxHelperFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ServerSessionMBeanCalc
extends AbstractCachedCalc
implements ISessionMBeanSharedCalc,
NotificationListener {
    private static final long serialVersionUID = -2004179738371039895L;
    private ISessionConfigCachedCalc backupConfig;
    private MBeanJmxHelper jmxHelper;
    public static final String SESSION_TYPE = "SessionManager";
    public static final String SESSION_ATTRIBUTE_GROWABLE = "unavailable_growable";
    public static final String SESSION_ATTRIBUTE_CACHESIZE = "unavailable_cacheSize";
    public static final String SESSION_ATTRIBUTE_PERSISTENCE = "unavailable_presistence";
    public static final String SESSION_ATTRIBUTE_TIMEOUT = "unavailable_timeout";
    public static final String[] SESSION_ATTRIBUTES = new String[0];
    public static final String KEY_DELIM = "_";
    private HashMap configMap;
    private boolean _static = false;
    private static TraceComponent tc = Tr.register(ServerSessionMBeanCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public void init(String string, String string2) {
        block2: {
            Tr.entry(tc, "init");
            super.init(string, string2);
            try {
                this.jmxHelper = MBeanJmxHelperFactory.getMBeanJmxHelper(string, string2);
                this.configMap = new HashMap();
                this.registerForMBeanAdditionDeletionNotifications();
                this.initCache();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "init caught exception " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "init");
    }

    public void init(String string, HashMap hashMap) {
        this._static = true;
        this.configMap = hashMap;
    }

    public void finalize() {
        block5: {
            Tr.entry(tc, "finalize");
            if (this.isStatic()) {
                Tr.exit(tc, "finalize - from log, returning");
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "finalize is going to remove notifications");
            }
            try {
                Set set = this.jmxHelper.getServerObjectNames(SESSION_TYPE);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName = (ObjectName)iterator.next();
                    this.removeFromCache(objectName);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "finalize caught exception : " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.entry(tc, "finalize");
    }

    public void initCache() {
        block4: {
            Tr.entry(tc, "initCache");
            if (this.isStatic()) {
                Tr.exit(tc, "initCache - from log, returning");
                return;
            }
            try {
                Set set = this.jmxHelper.getServerObjectNames(SESSION_TYPE);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName = (ObjectName)iterator.next();
                    this.addToCache(objectName);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception caught trying to get the session mbeans : " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "initCache");
    }

    private void addToCache(ObjectName objectName) {
        Tr.entry(tc, "addToCache");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "objectName :" + objectName);
        }
        try {
            String string = objectName.getKeyProperty("name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   adding " + string + " tocache");
            }
            for (int i = 0; i < SESSION_ATTRIBUTES.length; ++i) {
                String string2 = SESSION_ATTRIBUTES[i];
                String string3 = string + KEY_DELIM + string2;
                try {
                    this.configMap.put(string3, this.jmxHelper.getAttribute(objectName, string2));
                    continue;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[]{string2, objectName};
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "perfalert.Exception.AttributeNotFound", objectArray);
                }
            }
            this.registerForNotificationsOnMBean(objectName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Tr.exit(tc, "addToCache");
    }

    private void removeFromCache(ObjectName objectName) {
        Tr.entry(tc, "removeFromCache");
        String string = objectName.getKeyProperty("name");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "   removing " + string + " from cache");
        }
        for (int i = 0; i < SESSION_ATTRIBUTES.length; ++i) {
            String string2 = SESSION_ATTRIBUTES[i];
            String string3 = string + KEY_DELIM + string2;
            this.configMap.remove(string3);
        }
        this.unRegisterForNotificationsOnMBean(objectName);
    }

    public void update() {
        Tr.entry(tc, "update");
        if (this.isStatic()) {
            Tr.exit(tc, "update - from log, returning");
            return;
        }
        if (this.needToRefresh) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServerSessionMBeanCalc is going to refresh all information because do not trust attribute changed notifications");
            }
            this.refreshCache();
        }
        Tr.exit(tc, "update");
    }

    public void refreshCache() {
        if (this.isStatic()) {
            return;
        }
        this.initCache();
        this.needToRefresh = false;
    }

    private void registerForNotificationsOnMBean(ObjectName objectName) {
        AttributeChangeNotificationFilter attributeChangeNotificationFilter = new AttributeChangeNotificationFilter();
        for (int i = 0; i < SESSION_ATTRIBUTES.length; ++i) {
            attributeChangeNotificationFilter.enableAttribute(SESSION_ATTRIBUTES[i]);
        }
        String string = objectName.getKeyProperty("name");
        try {
            this.jmxHelper.addNotification(objectName, this, attributeChangeNotificationFilter, string);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{objectName.toString(), exception.toString()};
            Tr.error(tc, "perfalert.Exception.couldNotRegisterForNotification", stringArray);
            exception.printStackTrace();
        }
    }

    private void unRegisterForNotificationsOnMBean(ObjectName objectName) {
        try {
            this.jmxHelper.removeNotification(objectName, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerForMBeanAdditionDeletionNotifications() {
        Tr.entry(tc, "registerForMBeanAdditionDeletionNotifications");
        try {
            this.jmxHelper.registerForRegistrationNotifications(this, SESSION_TYPE);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{SESSION_TYPE, exception.toString()};
            Tr.error(tc, "perfalert.Exception.couldNotRegisterForNotification.mBeanServerDelegate", objectArray);
            exception.printStackTrace();
        }
        Tr.exit(tc, "registerForMBeanAdditionDeletionNotifications");
    }

    public void handleNotification(Notification notification, Object object) {
        Tr.entry(tc, "handleNotification");
        String string = notification.getType();
        if (string.equals("jmx.attribute.change")) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "\tnotification:  type=" + notification.getType() + ", attributeName=" + ((AttributeChangeNotification)notification).getAttributeName() + ", oldValue=" + ((AttributeChangeNotification)notification).getOldValue() + ", newValue=" + ((AttributeChangeNotification)notification).getNewValue());
                }
                String string2 = object + KEY_DELIM + ((AttributeChangeNotification)notification).getAttributeName();
                this.configMap.put(string2, ((AttributeChangeNotification)notification).getNewValue());
            }
            catch (ClassCastException classCastException) {
                String[] stringArray = new String[]{notification.toString(), classCastException.toString()};
                Tr.error(tc, "perfalert.Exception.NotificationClassCastException", stringArray);
            }
        } else if (string.equals("JMX.mbean.registered")) {
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SessionConfig recieved notification that mbean was added : " + objectName);
            }
            this.addToCache(objectName);
        } else if (string.equals("JMX.mbean.unregistered")) {
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ThreadPoolConfig recieved notification that mbean was removed : " + objectName);
            }
            this.removeFromCache(objectName);
        } else {
            super.handleNotification(notification, object);
        }
        Tr.exit(tc, "handleNotification");
    }

    public double getMaxInMemorySessionCount(PerfDescriptor perfDescriptor) {
        return this.getMaxInMemorySessionCount(this.getWebAppName(perfDescriptor));
    }

    public double getMaxInMemorySessionCount(String string) {
        String string2 = string + KEY_DELIM + SESSION_ATTRIBUTE_CACHESIZE;
        if (this.configMap.containsKey(string2)) {
            return (Double)this.configMap.get(string2);
        }
        Object[] objectArray = new Object[]{SESSION_ATTRIBUTE_CACHESIZE, SESSION_TYPE};
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "perfalert.Exception.mBeanAttributeNotAvailable", objectArray);
        }
        return this.backupConfig.getMaxInMemorySessionCount();
    }

    public boolean getAllowOverflow(PerfDescriptor perfDescriptor) {
        return this.getAllowOverflow(this.getWebAppName(perfDescriptor));
    }

    public boolean getAllowOverflow(String string) {
        boolean bl;
        String string2 = string + KEY_DELIM + SESSION_ATTRIBUTE_GROWABLE;
        if (this.configMap.containsKey(string2)) {
            bl = (Boolean)this.configMap.get(string2);
        } else {
            Object[] objectArray = new Object[]{SESSION_ATTRIBUTE_GROWABLE, SESSION_TYPE};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "perfalert.Exception.mBeanAttributeNotAvailable", objectArray);
            }
            bl = this.backupConfig.getAllowOverflow();
        }
        return bl;
    }

    public boolean isSetPersistentSessions(PerfDescriptor perfDescriptor) {
        return this.isSetPersistentSessions(this.getWebAppName(perfDescriptor));
    }

    public boolean isSetPersistentSessions(String string) {
        boolean bl;
        String string2 = string + KEY_DELIM + SESSION_ATTRIBUTE_PERSISTENCE;
        if (this.configMap.containsKey(string2)) {
            bl = (Boolean)this.configMap.get(string2);
        } else {
            Object[] objectArray = new Object[]{SESSION_ATTRIBUTE_PERSISTENCE, SESSION_TYPE};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "perfalert.Exception.mBeanAttributeNotAvailable", objectArray);
            }
            bl = this.backupConfig.isSetPersistentSessions();
        }
        return bl;
    }

    public double getSessionTimeout(PerfDescriptor perfDescriptor) {
        return this.getSessionTimeout(this.getWebAppName(perfDescriptor));
    }

    public double getSessionTimeout(String string) {
        String string2 = string + KEY_DELIM + SESSION_ATTRIBUTE_TIMEOUT;
        double d = this.configMap.containsKey(string2) ? ((Double)this.configMap.get(string2)).doubleValue() : this.getBackupConfig_SessionTimeout();
        return d;
    }

    private double getBackupConfig_SessionTimeout() {
        Object[] objectArray = new Object[]{SESSION_ATTRIBUTE_TIMEOUT, SESSION_TYPE};
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "perfalert.Exception.mBeanAttributeNotAvailable", objectArray);
        }
        return this.backupConfig.getSessionTimeout();
    }

    private String getWebAppName(PerfDescriptor perfDescriptor) {
        return perfDescriptor.getName();
    }

    public void setBackUp(ISessionConfigCachedCalc iSessionConfigCachedCalc) {
        this.backupConfig = iSessionConfigCachedCalc;
    }

    public HashMap getConfigMap() {
        return this.configMap;
    }

    public boolean isStatic() {
        return this._static;
    }
}

