/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc.sharedCalc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.calc.cachedCalc.AbstractCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IOrbThreadPoolConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IServletEngineThreadPoolConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.IThreadPoolMBeanSharedCalc;
import com.ibm.ws.performance.tuning.serverAlert.util.MBeanJmxHelper;
import com.ibm.ws.performance.tuning.serverAlert.util.MBeanJmxHelperFactory;
import com.ibm.ws.security.core.SecurityContext;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ServerThreadPoolMBeanCalc
extends AbstractCachedCalc
implements IThreadPoolMBeanSharedCalc,
NotificationListener {
    private static final long serialVersionUID = 79575442459926649L;
    private MBeanJmxHelper jmxHelper;
    private IServletEngineThreadPoolConfigCachedCalc backupSeConfig;
    private IOrbThreadPoolConfigCachedCalc backupOrbConfig;
    public static final String THREAD_POOL_COUNT = "threadPoolCount";
    public static final String THREAD_POOL_NAME = "threadPoolName#";
    private static final String AVAILABLE_MBEAN_COUNT = "availableMBeanCount";
    private static final String AVAILABLE_MBEAN_NAME = "availableMBeanName#";
    public static final String THREAD_POOL_TYPE = "ThreadPool";
    public static final String ORB_NAME = "ORB";
    public static final String DEFAULT_NAME = "default";
    public static final String SE_NAME = "Servlet.Engine.Transports";
    public static final String SOAP_NAME = "SoapConnectorThreadPool";
    public static final String POOL_ATTRIBUTE_MAX = "maximumSize";
    public static final String POOL_ATTRIBUTE_MIN = "minimumSize";
    public static final String POOL_ATTRIBUTE_GROWABLE = "growable";
    public static final String POOL_ATTRIBUTE_TIMEOUT = "inactivityTimeout";
    private ObjectName serverRuleDriverMBean;
    private Vector mBeansAvailable = new Vector();
    public static final String[] POOL_ATTRIBUTES = new String[]{"maximumSize", "minimumSize", "growable", "inactivityTimeout"};
    public static final String KEY_DELIM = "_";
    private boolean _static = false;
    private HashMap configMap;
    private static TraceComponent tc = Tr.register(ServerThreadPoolMBeanCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public void init(String string, String string2) {
        Tr.entry(tc, "init");
        super.init(string, string2);
        try {
            this.jmxHelper = MBeanJmxHelperFactory.getMBeanJmxHelper(string, string2);
            this.configMap = new HashMap();
            this.registerForMBeanAdditionDeletionNotifications();
            this.initCache();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "init caught exception " + exception.toString());
                exception.printStackTrace();
            }
            this.jmxHelper = null;
        }
        Tr.exit(tc, "init");
    }

    public void init(String string, HashMap hashMap) {
        this._static = true;
        this.configMap = hashMap;
        this.setAvailableMBeans(hashMap);
    }

    public void finalize() {
        block5: {
            Tr.entry(tc, "finalize");
            if (this.isStatic()) {
                Tr.exit(tc, "finalize - from log, returning");
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "finalize is going to remove notifications");
            }
            try {
                Set set = this.jmxHelper.getServerObjectNames(THREAD_POOL_TYPE);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName = (ObjectName)iterator.next();
                    this.removeFromCache(objectName);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "finalize caught exception : " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.entry(tc, "finalize");
    }

    public void initCache() {
        block4: {
            Tr.entry(tc, "initCache");
            if (this.isStatic()) {
                Tr.exit(tc, "initCache - from log, returning");
                return;
            }
            try {
                Set set = this.jmxHelper.getServerObjectNames(THREAD_POOL_TYPE);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName = (ObjectName)iterator.next();
                    this.addToCache(objectName);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception caught trying to get the thread pool mbeans : " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "initCache");
    }

    private void removeFromCache(ObjectName objectName) {
        Tr.entry(tc, "removeFromCache");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ThreadPoolConfig is removing " + objectName + "from the cache because it has been removed");
        }
        String string = objectName.getKeyProperty("name");
        for (int i = 0; i < POOL_ATTRIBUTES.length; ++i) {
            String string2 = POOL_ATTRIBUTES[i];
            String string3 = string + KEY_DELIM + string2;
            this.configMap.remove(string3);
        }
        this.unRegisterForNotificationsOnMBean(objectName);
    }

    private void addToCache(ObjectName objectName) {
        String string;
        Tr.entry(tc, "addToCache");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "objectName :" + objectName);
        }
        if (!this.mBeansAvailable.contains(string = objectName.getKeyProperty("name"))) {
            this.mBeansAvailable.add(string);
        }
        Tr.debug(tc, "     caching runtime settings for " + string);
        for (int i = 0; i < POOL_ATTRIBUTES.length; ++i) {
            String string2 = POOL_ATTRIBUTES[i];
            String string3 = string + KEY_DELIM + string2;
            try {
                Object object = this.jmxHelper.getAttribute(objectName, string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "          " + string3 + " :" + object);
                }
                this.configMap.put(string3, object);
                continue;
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{string2, objectName};
                Tr.debug(tc, "perfalert.Exception.AttributeNotFound", objectArray);
                exception.printStackTrace();
            }
        }
        this.registerForNotificationsOnMBean(objectName);
        Tr.exit(tc, "addToCache");
    }

    public boolean isMBeanAvailable(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isMBeanAvailable", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMBeanAvailable", this.mBeansAvailable.toString());
        }
        return this.mBeansAvailable.contains(string);
    }

    public void update() {
        Tr.entry(tc, "update");
        if (this.isStatic()) {
            Tr.exit(tc, "update - from log, returning");
            return;
        }
        if (this.needToRefresh) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   refreshing cache");
            }
            this.refreshCache();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "   not refreshing cache");
        }
        Tr.exit(tc, "update");
    }

    public void refreshCache() {
        if (this.isStatic()) {
            return;
        }
        this.initCache();
        this.needToRefresh = false;
    }

    private void registerForNotificationsOnMBean(ObjectName objectName) {
        AttributeChangeNotificationFilter attributeChangeNotificationFilter = new AttributeChangeNotificationFilter();
        for (int i = 0; i < POOL_ATTRIBUTES.length; ++i) {
            attributeChangeNotificationFilter.enableAttribute(POOL_ATTRIBUTES[i]);
        }
        String string = objectName.getKeyProperty("name");
        try {
            this.jmxHelper.addNotification(objectName, this, attributeChangeNotificationFilter, string);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{objectName.toString(), exception.toString()};
            Tr.error(tc, "perfalert.Exception.couldNotRegisterForNotification", stringArray);
            exception.printStackTrace();
        }
    }

    private void unRegisterForNotificationsOnMBean(ObjectName objectName) {
        try {
            this.jmxHelper.removeNotification(objectName, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerForMBeanAdditionDeletionNotifications() {
        Tr.entry(tc, "registerForMBeanAdditionDeletionNotifications");
        try {
            this.jmxHelper.registerForRegistrationNotifications(this, THREAD_POOL_TYPE);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{THREAD_POOL_TYPE, exception.toString()};
            Tr.error(tc, "perfalert.Exception.couldNotRegisterForNotification.mBeanServerDelegate", objectArray);
            exception.printStackTrace();
        }
        Tr.exit(tc, "registerForMBeanAdditionDeletionNotifications");
    }

    public void handleNotification(Notification notification, Object object) {
        Tr.entry(tc, "handleNotification");
        String string = notification.getType();
        if (string.equals("jmx.attribute.change")) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "\tnotification:  type=" + notification.getType() + ", attributeName=" + ((AttributeChangeNotification)notification).getAttributeName() + ", oldValue=" + ((AttributeChangeNotification)notification).getOldValue() + ", newValue=" + ((AttributeChangeNotification)notification).getNewValue());
                }
                String string2 = (String)object + KEY_DELIM + ((AttributeChangeNotification)notification).getAttributeName();
                this.configMap.put(string2, ((AttributeChangeNotification)notification).getNewValue());
            }
            catch (ClassCastException classCastException) {
                String[] stringArray = new String[]{notification.toString(), classCastException.toString()};
                Tr.error(tc, "perfalert.Exception.NotificationClassCastException", stringArray);
            }
        } else if (string.equals("JMX.mbean.registered")) {
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ThreadPoolConfig recieved notification that mbean was added : " + objectName);
            }
            this.addToCache(objectName);
        } else if (string.equals("JMX.mbean.unregistered")) {
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ThreadPoolConfig recieved notification that mbean was removed : " + objectName);
            }
            this.removeFromCache(objectName);
        } else {
            super.handleNotification(notification, object);
        }
        Tr.exit(tc, "handleNotification");
    }

    public boolean isGrowable(String string) {
        String string2 = string + KEY_DELIM + POOL_ATTRIBUTE_GROWABLE;
        if (this.configMap.containsKey(string2)) {
            return (Boolean)this.configMap.get(string2);
        }
        Object[] objectArray = new Object[]{POOL_ATTRIBUTE_GROWABLE, THREAD_POOL_TYPE};
        Tr.debug(tc, "perfalert.Exception.mBeanAttributeNotAvailable", objectArray);
        if (string.equals(ORB_NAME)) {
            return this.backupOrbConfig.isGrowable();
        }
        return this.backupSeConfig.isGrowable(string);
    }

    public int minPoolSize(String string) {
        String string2 = string + KEY_DELIM + POOL_ATTRIBUTE_MIN;
        if (this.configMap.containsKey(string2)) {
            return (Integer)this.configMap.get(string2);
        }
        Object[] objectArray = new Object[]{POOL_ATTRIBUTE_MIN, THREAD_POOL_TYPE};
        Tr.debug(tc, "perfalert.Exception.mBeanAttributeNotAvailable", objectArray);
        if (string.equals(ORB_NAME)) {
            return this.backupOrbConfig.minPoolSize();
        }
        return this.backupSeConfig.minPoolSize(string);
    }

    public int maxPoolSize(String string) {
        String string2 = string + KEY_DELIM + POOL_ATTRIBUTE_MAX;
        if (this.configMap.containsKey(string2)) {
            return (Integer)this.configMap.get(string2);
        }
        Object[] objectArray = new Object[]{string2, THREAD_POOL_TYPE};
        Tr.debug(tc, "perfalert.Exception.mBeanAttributeNotAvailable", objectArray);
        if (string.equals(ORB_NAME)) {
            return this.backupOrbConfig.maxPoolSize();
        }
        return this.backupSeConfig.maxPoolSize(string);
    }

    public void setBackUp(IOrbThreadPoolConfigCachedCalc iOrbThreadPoolConfigCachedCalc, IServletEngineThreadPoolConfigCachedCalc iServletEngineThreadPoolConfigCachedCalc) {
        this.backupOrbConfig = iOrbThreadPoolConfigCachedCalc;
        this.backupSeConfig = iServletEngineThreadPoolConfigCachedCalc;
    }

    public String toString() {
        String string = new String("ThreadPool MBean Calc");
        return string;
    }

    public String[] getThreadPoolNames() {
        if (!this.isStatic()) {
            try {
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        try {
                            if (ServerThreadPoolMBeanCalc.this.serverRuleDriverMBean == null) {
                                ServerThreadPoolMBeanCalc.this.serverRuleDriverMBean = ServerThreadPoolMBeanCalc.this.jmxHelper.getServerRuleDriverMBean();
                            }
                            String[] stringArray = (String[])ServerThreadPoolMBeanCalc.this.jmxHelper.getAttribute(ServerThreadPoolMBeanCalc.this.serverRuleDriverMBean, "ThreadPoolNames");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "          " + stringArray + " :" + stringArray);
                            }
                            return stringArray;
                        }
                        catch (Exception exception) {
                            Object[] objectArray = new Object[]{"ThreadPoolNames", ServerThreadPoolMBeanCalc.this.serverRuleDriverMBean};
                            Tr.debug(tc, "perfalert.Exception.AttributeNotFound", objectArray);
                            exception.printStackTrace();
                            return null;
                        }
                    }
                };
                return (String[])SecurityContext.runAsSystem(privilegedExceptionAction);
            }
            catch (Exception exception) {
                Tr.error(tc, "perfalert.Exception.adminClient", exception);
                exception.printStackTrace();
                Tr.exit(tc, "getJvmVendor");
                return null;
            }
        }
        int n = (Integer)this.configMap.get(THREAD_POOL_COUNT);
        if (n <= 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.configMap.get(THREAD_POOL_NAME + i);
        }
        return stringArray;
    }

    private Vector getAvailableMBeanNames() {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAvailableMBeanNames");
            }
            try {
                Set set = this.jmxHelper.getServerObjectNames(THREAD_POOL_TYPE);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName = (ObjectName)iterator.next();
                    String string = objectName.getKeyProperty("name");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "got ThreadPool", string);
                    }
                    if (this.mBeansAvailable.contains(string)) continue;
                    this.mBeansAvailable.add(string);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "added ThreadPool", string);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Exception caught trying to get the thread pool mbeans : " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMBeanAvailable ", this.mBeansAvailable.toString());
        }
        return this.mBeansAvailable;
    }

    public void setAvailableMBeans(HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAvailableMBeans");
        }
        int n = (Integer)hashMap.get(AVAILABLE_MBEAN_COUNT);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "count : " + n);
        }
        if (n <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.mBeansAvailable.add(hashMap.get(AVAILABLE_MBEAN_NAME + i));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "added ThreadPool", hashMap.get("availableMBeanName#1"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAvailableMBeans");
        }
    }

    public HashMap getConfigMap() {
        String[] stringArray = this.getThreadPoolNames();
        int n = stringArray == null ? 0 : stringArray.length;
        this.configMap.put(THREAD_POOL_COUNT, new Integer(n));
        for (int i = 0; i < n; ++i) {
            this.configMap.put(THREAD_POOL_NAME + i, stringArray[i]);
        }
        Vector vector = this.getAvailableMBeanNames();
        int n2 = vector.size();
        this.configMap.put(AVAILABLE_MBEAN_COUNT, new Integer(n2));
        for (int i = 0; i < n2; ++i) {
            this.configMap.put(AVAILABLE_MBEAN_NAME + i, vector.get(i));
        }
        return this.configMap;
    }

    public boolean isStatic() {
        return this._static;
    }
}

