/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.calc.sharedCalc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISystemSharedCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.RepositoryCache;
import com.ibm.ws.performance.tuning.serverAlert.util.MBeanJmxHelper;
import com.ibm.ws.performance.tuning.serverAlert.util.MBeanJmxHelperFactory;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.util.HashMap;
import java.util.Set;
import javax.management.ObjectName;

public class SystemMBeanCalc
implements ISystemSharedCalc {
    private MBeanJmxHelper jmxHelper;
    private ObjectName JVMMBean = null;
    private ObjectName adminOperationMBean = null;
    private String node;
    private String server;
    private static final String JVM = "JVM";
    private static final String OS = "0S";
    private String jvm;
    private String os;
    private boolean _static = false;
    private static TraceComponent tc = Tr.register(SystemMBeanCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public void init(String string, String string2) {
        this.jvm = null;
        this.os = null;
        this.node = string;
        this.server = string2;
        Tr.entry(tc, "init");
        try {
            this.jmxHelper = MBeanJmxHelperFactory.getMBeanJmxHelper(string, string2);
            this.initCache();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "init caught exception " + exception.toString());
                exception.printStackTrace();
            }
            this.jmxHelper = null;
        }
        this.getOperatingSystem();
        this.getJvmVendor();
        Tr.exit(tc, "init");
    }

    public void init(String string, HashMap hashMap) {
        this._static = true;
        this.os = (String)hashMap.get(OS);
        this.jvm = (String)hashMap.get(JVM);
    }

    public void initCache() {
        block6: {
            Tr.entry(tc, "initCache");
            if (this.isStatic()) {
                Tr.exit(tc, "initCache - from log, returning");
                return;
            }
            try {
                Set set = this.jmxHelper.getServerObjectNames(JVM);
                if (!set.isEmpty()) {
                    this.JVMMBean = (ObjectName)set.iterator().next();
                }
                if (!(set = this.jmxHelper.getServerObjectNames("AdminOperations")).isEmpty()) {
                    this.adminOperationMBean = (ObjectName)set.iterator().next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "got AdminOperations MBean : " + this.adminOperationMBean.toString());
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Exception caught trying to get the jvm or admin operation mbeans : " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "initCache");
    }

    public void update() {
        if (this.isStatic()) {
            return;
        }
    }

    public String getOperatingSystem() {
        if (this.os != null) {
            return this.os;
        }
        if (this.isStatic()) {
            return null;
        }
        try {
            String[] stringArray = new String[]{"java.lang.String"};
            Object[] objectArray = new String[]{"os.name"};
            this.os = (String)this.jmxHelper.invoke(this.JVMMBean, "getProperty", objectArray, stringArray);
            return this.os;
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.adminClient", exception);
            exception.printStackTrace();
            Tr.exit(tc, "getJvmVendor");
            return null;
        }
    }

    public String getJvmVendor() {
        Tr.entry(tc, "getJvmVendor");
        if (this.jvm != null) {
            return this.jvm;
        }
        if (this.isStatic()) {
            return null;
        }
        try {
            String[] stringArray = new String[]{"java.lang.String"};
            Object[] objectArray = new String[]{"java.vm.vendor"};
            this.jvm = (String)this.jmxHelper.invoke(this.JVMMBean, "getProperty", objectArray, stringArray);
            return this.jvm;
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.adminClient", exception);
            exception.printStackTrace();
            Tr.exit(tc, "getJvmVendor");
            return null;
        }
    }

    public boolean getZSeriesSingleServantMode() {
        Tr.entry(tc, "getZSeriesSingleServantMode");
        try {
            if (RepositoryCache.isInitialized()) {
                RepositoryCache.refreshServerInstance();
                String string = this.node + "-" + this.server + "-" + "ServerInstance" + "-" + "SingleServantMode";
                if (this.isStatic()) {
                    Boolean bl = (Boolean)RepositoryCache.lookupLog(string);
                    if (bl == null) {
                        return false;
                    }
                    Tr.exit(tc, "getZSeriesSingleServantMode");
                    return bl == false;
                }
                Tr.exit(tc, "getZSeriesSingleServantMode");
                return (Boolean)RepositoryCache.lookup(string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Repository Cache is not initialized will return false for singleServantMode");
            }
            return false;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception when getting getZSeriesSingleServantMode : " + exception.toString());
                exception.printStackTrace();
            }
            Tr.exit(tc, "getZSeriesSingleServantMode");
            return false;
        }
    }

    public String generateHeapDump() throws Exception {
        Tr.entry(tc, "generateHeapDump");
        if (this.isStatic()) {
            return null;
        }
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        if (platformHelper.isZOS()) {
            byte[] byArray = platformHelper.getStoken();
            String string = new String(byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stoken is : " + byArray);
                Tr.debug(tc, "stoken String is : " + byArray);
            }
            Object[] objectArray = new Object[]{string};
            String[] stringArray = new String[]{new String("java.lang.String")};
            String[] stringArray2 = (String[])this.jmxHelper.invoke(this.JVMMBean, "generateHeapDump", objectArray, stringArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invoked generateHeapDumps on servant : " + byArray + "got back : " + stringArray2.length + " fileNames");
                for (int i = 0; i < stringArray2.length; ++i) {
                    Tr.debug(tc, "       heapDump:" + stringArray2[i]);
                }
            }
            if (stringArray2 != null && stringArray2.length >= 1) {
                return stringArray2[0];
            }
            return "unknown file name";
        }
        String string = (String)this.jmxHelper.invoke(this.JVMMBean, "generateHeapDump");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "jvm mbean called generate heap dump and returned : " + string);
        }
        Tr.exit(tc, "generateHeapDump");
        return string;
    }

    public String getWebSphereVariable(String string) {
        String string2;
        block5: {
            Tr.entry(tc, "getWebSphereVariable");
            string = "${" + string + "}";
            if (this.isStatic()) {
                return null;
            }
            string2 = null;
            String[] stringArray = new String[]{"java.lang.String"};
            Object[] objectArray = new String[]{string};
            try {
                string2 = (String)this.jmxHelper.invoke(this.adminOperationMBean, "expandVariable", objectArray, stringArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "calling expandVariable on " + string + " got value : " + string2);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "MBeanJmxHelper could not call invoke " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "getWebSphereVariable");
        if (string.equals(string2)) {
            return null;
        }
        return string2;
    }

    public HashMap getConfigMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(OS, this.os);
        hashMap.put(JVM, this.jvm);
        return hashMap;
    }

    public boolean isStatic() {
        return this._static;
    }
}

