/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.security.core.SecurityContext;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class MBeanJmxHelper
implements Serializable {
    private static final long serialVersionUID = 3683754224209412214L;
    private transient AdminService as = null;
    private String server;
    private String node;
    private static transient TraceComponent tc = Tr.register(MBeanJmxHelper.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    public static final String MBEAN_SERVER_DELEGATE_DOMAIN = "JMImplementation";
    public static final String MBEAN_SERVER_DELEGATE_TYPE = "MBeanServerDelegate";
    private transient ObjectName mBeanServerDelegateObjectName;
    private transient ObjectName rpaNotificationObjectName = null;
    private transient Object lock;

    public MBeanJmxHelper(String string, String string2) throws Exception {
        try {
            this.node = string;
            this.server = string2;
            this.createAdminService();
            this.lock = new Object();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  registering for notifications");
            }
            Tr.exit(tc, "MBeanJmxHelper constructor");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "could not intialized MBeanJmxHelper : " + exception.toString());
                exception.printStackTrace();
            }
            Tr.exit(tc, "MBeanJmxHelper constructor exception thrown");
        }
    }

    public void addNotification(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws Exception {
        try {
            this.as.addNotificationListener(objectName, notificationListener, notificationFilter, object);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addNotification caught an error: " + exception.toString());
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public void registerForRegistrationNotifications(NotificationListener notificationListener, String string) throws Exception {
        this.registerForRegistrationNotifications(notificationListener, string, new Object());
    }

    public void registerForRegistrationNotifications(NotificationListener notificationListener, String string, Object object) throws Exception {
        Tr.entry(tc, "registerForRegistrationNotifications");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "   registering for registration of type :" + string);
        }
        MBeanDelegateNotificationFilter mBeanDelegateNotificationFilter = new MBeanDelegateNotificationFilter(string);
        this.as.addNotificationListener(this.getMBeanServerDelegate(), notificationListener, (NotificationFilter)mBeanDelegateNotificationFilter, object);
        Tr.entry(tc, "registerForRegistrationNotifications");
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) {
        try {
            return this.as.getMBeanInfo(objectName);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "*** robbie *** exception getting mbeaninfo " + exception.toString());
            }
            exception.printStackTrace();
            return null;
        }
    }

    public void printMBeanInfo(ObjectName objectName) {
        if (tc.isDebugEnabled()) {
            int n;
            Tr.entry(tc, "printMBeanInfo");
            Tr.debug(tc, "   printing out information for " + objectName);
            MBeanInfo mBeanInfo = this.getMBeanInfo(objectName);
            MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
            MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
            Tr.debug(tc, "   attributes");
            for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                Tr.debug(tc, "       " + mBeanAttributeInfoArray[n].getName() + ",    writeable=" + mBeanAttributeInfoArray[n].isWritable() + ",  readable=" + mBeanAttributeInfoArray[n].isReadable() + ", description=" + mBeanAttributeInfoArray[n].getDescription());
            }
            Tr.debug(tc, "   operations");
            for (n = 0; n < mBeanOperationInfoArray.length; ++n) {
                Tr.debug(tc, "       " + mBeanOperationInfoArray[n].getName() + ",   description=" + mBeanOperationInfoArray[n].getDescription() + ",   return=" + mBeanOperationInfoArray[n].getReturnType());
            }
            Tr.exit(tc, "printMBeanInfo");
        }
    }

    public Object getAttribute(final ObjectName objectName, final String string) throws Exception {
        try {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){
                Object returnValue;

                public Object run() throws Exception {
                    this.returnValue = MBeanJmxHelper.this.as.getAttribute(objectName, string);
                    return this.returnValue;
                }
            };
            return SecurityContext.runAsSystem(privilegedExceptionAction);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ObjectName=" + objectName + ", name=" + string);
                Tr.debug(tc, "MBeanJmxHelper exception caught getting attrbute " + string + " : " + exception.toString());
            }
            throw exception;
        }
    }

    public void setAttribute(ObjectName objectName, String string, int n) throws Exception {
        this.setAttribute(objectName, string, new Integer(n));
    }

    public void setAttribute(ObjectName objectName, String string, boolean bl) throws Exception {
        this.setAttribute(objectName, string, new Boolean(bl));
    }

    public void setAttribute(final ObjectName objectName, final String string, final Object object) throws Exception {
        try {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (object != null) {
                        Attribute attribute = new Attribute(string, object);
                        MBeanJmxHelper.this.as.setAttribute(objectName, attribute);
                    }
                    return null;
                }
            };
            SecurityContext.runAsSystem(privilegedExceptionAction);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ObjectName=" + objectName + ", name=" + string + " value=" + object);
                Tr.debug(tc, "*** Robbie *** MBeanJmxHelper Exception updating attribute " + exception.toString());
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public void setAttribute(final ObjectName objectName, final String string, String string2, String string3) throws Exception {
        try {
            Class<?> clazz = Class.forName(string2);
            Class[] classArray = new Class[]{Class.forName("java.lang.String")};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{string3};
            final Object obj = constructor.newInstance(objectArray);
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (obj != null) {
                        Attribute attribute = new Attribute(string, obj);
                        MBeanJmxHelper.this.as.setAttribute(objectName, attribute);
                    }
                    return null;
                }
            };
            SecurityContext.runAsSystem(privilegedExceptionAction);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name=" + string + " type=" + string2 + " classtype: " + string3.getClass().getName());
                Tr.debug(tc, "*** Robbie *** MBeanJmxHelper Exception updating attribute " + exception.toString());
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public Object invoke(final ObjectName objectName, final String string, final Object[] objectArray, final String[] stringArray) throws Exception {
        try {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){
                Object returnValue;

                public Object run() throws Exception {
                    try {
                        this.returnValue = MBeanJmxHelper.this.as.invoke(objectName, string, objectArray, stringArray);
                        return this.returnValue;
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "MBeanJmxHelper could not call invoke " + exception.toString());
                            exception.printStackTrace();
                        }
                        return null;
                    }
                }
            };
            return SecurityContext.runAsSystem(privilegedExceptionAction);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MBeanJmxHelper could not call invoke " + exception.toString());
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public Object invoke(ObjectName objectName, String string) throws Exception {
        try {
            return this.invoke(objectName, string, new Object[0], new String[0]);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MBeanJmxHelper could not call invoke " + exception.toString());
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public Set getServerObjectNames(String string) throws Exception {
        return this.getServerObjectNames(string, null);
    }

    public Set getServerObjectNames(String string, String string2) throws Exception {
        return this.getServerObjectNames(this.as.getDomainName(), string, string2);
    }

    public Set getServerObjectNames(String string, String string2, String string3) throws Exception {
        return this.getObjectNames(string, string2, this.node, this.server, string3);
    }

    public ObjectName getServerRuleDriverMBean() throws Exception {
        Tr.entry(tc, "getServerRuleDriverMBean");
        ObjectName objectName = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.as.getDomainName()).append(":mbeanIdentifier=ServerRuleDriverMBean2");
        if (this.node != null) {
            stringBuffer.append(",node=" + this.node);
        }
        if (this.server != null) {
            stringBuffer.append(",process=" + this.server);
        }
        stringBuffer.append(",*");
        String string = stringBuffer.toString();
        ObjectName objectName2 = new ObjectName(string);
        Set set = this.as.queryNames(objectName2, null);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                objectName = (ObjectName)iterator.next();
            }
            if (objectName == null) {
                Tr.exit(tc, "getServerRuleDriverMBean, objectN is null");
                throw new Exception("PerfTuningAdminJmxHelper:  Object name was null " + objectName);
            }
        } else {
            Tr.exit(tc, "getServerRuleDriverMBean, Set s is null");
            throw new Exception("PerfTuningAdminJmxHelper:  Set of Object Names returned from query was null: " + objectName2.toString());
        }
        Tr.exit(tc, "getServerRuleDriverMBean");
        return objectName;
    }

    public Set getNodeObjectNames(String string) throws Exception {
        return this.getNodeObjectNames(string, null);
    }

    public Set getNodeObjectNames(String string, String string2) throws Exception {
        return this.getNodeObjectNames(this.as.getDomainName(), string, string2);
    }

    public Set getNodeObjectNames(String string, String string2, String string3) throws Exception {
        return this.getObjectNames(string, string2, this.node, null, string3);
    }

    public Set getObjectNames(Hashtable hashtable) throws Exception {
        Tr.entry(tc, "getObjectNames(hash)");
        try {
            ObjectName objectName = new ObjectName(this.as.getDefaultDomain(), hashtable);
            Set set = this.as.queryNames(objectName, null);
            if (set == null) {
                throw new Exception("MBeanJmxHelper:  Set of Object Names returned from query was null: " + objectName.toString());
            }
            Tr.exit(tc, "getObjectNames(hash)");
            return set;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getObjectNames(hash) caught an exception : " + exception.toString());
                exception.printStackTrace();
            }
            Tr.exit(tc, "getObjectNames(hash)");
            throw exception;
        }
    }

    public Set getObjectNames(String string, String string2, String string3, String string4, String string5) throws Exception {
        Tr.entry(tc, "getObjectNames");
        try {
            if (this.as != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string).append(":type=" + string2);
                if (string3 != null) {
                    stringBuffer.append(",node=" + string3);
                }
                if (string4 != null) {
                    stringBuffer.append(",process=" + string4);
                }
                if (string5 != null) {
                    stringBuffer.append("," + string5);
                }
                stringBuffer.append(",*");
                String string6 = stringBuffer.toString();
                ObjectName objectName = new ObjectName(string6);
                Set set = this.as.queryNames(objectName, null);
                if (set != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "looking for object names with type = " + string2);
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            ObjectName objectName2 = (ObjectName)iterator.next();
                            Tr.debug(tc, "   " + objectName2.toString());
                        }
                    }
                } else {
                    throw new Exception("MBeanJmxHelper:  Set of Object Names returned from query was null: " + objectName.toString());
                }
                Tr.exit(tc, "getObjectNames");
                return set;
            }
            Tr.exit(tc, "getObjectNames");
            throw new Exception("MBeanJmxHelper: AdminClient was null");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            malformedObjectNameException.printStackTrace();
            Tr.exit(tc, "getObjectNames");
            throw malformedObjectNameException;
        }
        catch (Exception exception) {
            Tr.exit(tc, "getObjectNames");
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName getMBeanServerDelegate() throws Exception {
        Tr.entry(tc, "getMBeanServerDelegate");
        try {
            if (this.mBeanServerDelegateObjectName == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.mBeanServerDelegateObjectName == null) {
                        Set set = this.getObjectNames(MBEAN_SERVER_DELEGATE_DOMAIN, MBEAN_SERVER_DELEGATE_TYPE, null, null, null);
                        if (set.size() == 1) {
                            Iterator iterator = set.iterator();
                            this.mBeanServerDelegateObjectName = (ObjectName)iterator.next();
                            Tr.exit(tc, "getMBeanServerDelegate");
                            return this.mBeanServerDelegateObjectName;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "excpected one MBeanServerDelegate  but got  " + set.size());
                        }
                        if (set.size() > 0) {
                            Iterator iterator = set.iterator();
                            this.mBeanServerDelegateObjectName = (ObjectName)iterator.next();
                            Tr.exit(tc, "getMBeanServerDelegate");
                            return this.mBeanServerDelegateObjectName;
                        }
                        Exception exception = new Exception("excpected one MBeanServerDelegate  but got  " + set.size());
                        throw exception;
                    }
                    Tr.exit(tc, "getMBeanServerDelegate");
                    return this.mBeanServerDelegateObjectName;
                }
            }
            Tr.exit(tc, "getMBeanServerDelegate");
            return this.mBeanServerDelegateObjectName;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   getMBeanServerDelegate: caught unexpected exception: " + exception.toString());
                Tr.exit(tc, "getMBeanServerDelegate");
            }
            throw exception;
        }
    }

    public synchronized ObjectName getRpaNotificationObjectName(String string, String string2) throws Exception {
        Tr.entry(tc, "getRpaNotificationObjectName");
        try {
            if (this.rpaNotificationObjectName == null) {
                String string3 = "AdvisorNotificationMBean";
                Set set = this.getServerObjectNames(string3);
                if (set.size() == 1) {
                    Iterator iterator = set.iterator();
                    this.rpaNotificationObjectName = (ObjectName)iterator.next();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "expected one " + string3 + "for node=" + string + " and server=" + string2 + "  but got  " + set.size());
                    }
                    if (set.size() > 0) {
                        Iterator iterator = set.iterator();
                        this.rpaNotificationObjectName = (ObjectName)iterator.next();
                    } else {
                        Exception exception = new Exception("did not get a " + string3 + "for node=" + string + " and server=" + string2);
                        if (tc.isDebugEnabled()) {
                            throw exception;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   getRpaNotificationObjectName: caught unexpected exception: " + exception.toString());
                Tr.exit(tc, "getRpaNotificationObjectName");
            }
            throw exception;
        }
        Tr.exit(tc, "getRpaNotificationObjectName");
        return this.rpaNotificationObjectName;
    }

    public Set getAllObjectNames(String string) throws Exception {
        Tr.entry(tc, "getAllObjectNames(type)");
        try {
            if (this.as != null) {
                String string2 = this.as.getDomainName();
                return this.getObjectNames(string2, string, this.node, this.server, null);
            }
            throw new Exception("MBeanJmxHelper: AdminClient was null");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Tr.entry(tc, "getAllObjectNames(type)");
            throw malformedObjectNameException;
        }
        catch (Exception exception) {
            Tr.entry(tc, "getAllObjectNames(type)");
            throw exception;
        }
    }

    public Set getAllObjectNames() throws Exception {
        Tr.entry(tc, "getAllObjectNames");
        try {
            if (this.as != null) {
                String string = this.as.getDomainName();
                String string2 = string + ":*";
                ObjectName objectName = new ObjectName(string2);
                Set set = this.as.queryNames(objectName, null);
                if (set != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "looking for object names");
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            ObjectName objectName2 = (ObjectName)iterator.next();
                            Tr.debug(tc, "   " + objectName2.toString());
                        }
                    }
                } else {
                    throw new Exception("MBeanJmxHelper:  Set of Object Names returned from query was null: " + objectName.toString());
                }
                Tr.entry(tc, "getAllObjectNames");
                return set;
            }
            throw new Exception("MBeanJmxHelper: AdminClient was null");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Tr.entry(tc, "getAllObjectNames");
            throw malformedObjectNameException;
        }
        catch (Exception exception) {
            Tr.entry(tc, "getAllObjectNames");
            throw exception;
        }
    }

    private void createAdminService() throws Exception {
        try {
            this.as = AdminServiceFactory.getAdminService();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.as = null;
            throw exception;
        }
    }

    public void removeNotification(ObjectName objectName, NotificationListener notificationListener) throws Exception {
        try {
            this.as.removeNotificationListener(objectName, notificationListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dumpObjectNames() {
        try {
            Tr.entry(tc, "dumpObjectNames");
            Tr.debug(tc, "node=" + this.as.getNodeName() + ", server=" + this.as.getProcessName());
            String string = this.as.getDomainName();
            String[] stringArray = new String[]{"WebSphere:node=asia,*", "WebSphere:node=asia,process=server1,*"};
            for (int i = 0; i < stringArray.length; ++i) {
                ObjectName objectName = new ObjectName(stringArray[i]);
                Tr.debug(tc, "trying to get " + objectName);
                Set set = this.as.queryNames(objectName, null);
                if (set == null) {
                    Tr.debug(tc, "set is null");
                }
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    System.out.println("        objectName = " + iterator.next());
                }
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "dumpObjectNames caught exception : " + exception.toString());
            exception.printStackTrace();
        }
        Tr.exit(tc, "dumpObjectNames");
    }

    public void dumpMBeanInfo(ObjectName objectName) {
        try {
            MBeanFeatureInfo mBeanFeatureInfo;
            int n;
            Tr.entry(tc, "dumpMBeanInfo");
            MBeanInfo mBeanInfo = this.getMBeanInfo(objectName);
            MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
            MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
            Tr.debug(tc, "MBean = " + objectName);
            Tr.debug(tc, "   attributes");
            for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                mBeanFeatureInfo = mBeanAttributeInfoArray[n];
                Tr.debug(tc, "       " + mBeanFeatureInfo.getName() + ", " + ((MBeanAttributeInfo)mBeanFeatureInfo).getType() + ", " + ((MBeanAttributeInfo)mBeanFeatureInfo).isWritable());
            }
            Tr.debug(tc, "   operations");
            for (n = 0; n < mBeanOperationInfoArray.length; ++n) {
                mBeanFeatureInfo = mBeanOperationInfoArray[n];
                Tr.debug(tc, "       " + mBeanFeatureInfo.getName());
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "dumpMBeanInfo caught exception : " + exception.toString());
            exception.printStackTrace();
        }
        Tr.exit(tc, "dumpMBeanInfo");
    }

    public class MBeanDelegateNotificationFilter
    implements NotificationFilter {
        private static final long serialVersionUID = 682341058262225533L;
        String mBeanType;

        public MBeanDelegateNotificationFilter(String string) {
            this.mBeanType = string;
        }

        public boolean isNotificationEnabled(Notification notification) {
            String string = notification.getType();
            if ((string.equals("JMX.mbean.registered") || string.equals("JMX.mbean.unregistered")) && notification instanceof MBeanServerNotification) {
                ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
                if (this.mBeanType == null) {
                    return true;
                }
                String string2 = objectName.getKeyProperty("type");
                if (string2 != null) {
                    if (string2.equals(this.mBeanType)) {
                        return true;
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "originType is null for notification " + notification.toString());
                }
            }
            return false;
        }
    }
}

