/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.client;

import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.client.CpdData;
import com.ibm.websphere.pmi.client.CpdValue;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.client.event.CpdEventSenderImpl;

public class CpdDataImpl
extends CpdEventSenderImpl
implements CpdData {
    private static final long serialVersionUID = 8271117250304792596L;
    protected CpdValue value = null;
    protected transient CpdValue baseValue = null;
    protected PerfDescriptor descriptor = null;
    protected int id;
    protected Object parent = null;
    transient PmiDataInfo info = null;

    public CpdDataImpl(PmiDataInfo pmiDataInfo, PerfDescriptor perfDescriptor, CpdValue cpdValue) {
        this.id = pmiDataInfo.getId();
        this.descriptor = perfDescriptor;
        this.value = cpdValue;
        this.info = pmiDataInfo;
    }

    public CpdDataImpl(PmiDataInfo pmiDataInfo, PerfDescriptor perfDescriptor, CpdValue cpdValue, CpdValue cpdValue2) {
        this.id = pmiDataInfo.getId();
        this.descriptor = perfDescriptor;
        this.value = cpdValue;
        this.info = pmiDataInfo;
        this.baseValue = cpdValue2;
    }

    public int getId() {
        return this.id;
    }

    public PerfDescriptor getDescriptor() {
        return this.descriptor;
    }

    public PmiDataInfo getPmiDataInfo() {
        return this.info;
    }

    public void setPmiDataInfo(PmiDataInfo pmiDataInfo) {
        this.info = pmiDataInfo;
    }

    public String getDescription() {
        return this.info.getDescription();
    }

    public void setValue(CpdValue cpdValue) {
        this.value = cpdValue;
        this.notifyListeners(2);
    }

    public void update(CpdData cpdData) {
        if (cpdData == null) {
            return;
        }
        if (this.descriptor.equals(cpdData.getDescriptor())) {
            this.value = cpdData.getValue();
            this.notifyListeners(2);
        }
    }

    public CpdValue getValue() {
        CpdValue cpdValue = this.value;
        if (this.baseValue != null) {
            cpdValue = this.value.delta(this.baseValue);
        }
        return cpdValue;
    }

    public CpdValue getBaseValue() {
        return this.baseValue;
    }

    public void setBaseValue(CpdValue cpdValue) {
        if (cpdValue != null) {
            this.baseValue = cpdValue;
        }
    }

    public boolean reset() {
        if (this.info.isResettable()) {
            this.baseValue = this.value;
            return true;
        }
        return false;
    }

    public boolean undoReset() {
        if (this.info.isResettable()) {
            this.baseValue = null;
            return true;
        }
        return false;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object object) {
        this.parent = object;
    }

    public String toXML() {
        return this.toXML("");
    }

    public String toXML(String string) {
        return this.toXML(string, false);
    }

    public String toXML(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string).append("    ");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(string);
        stringBuffer2.append("<CpdData name=\"");
        stringBuffer2.append(this.descriptor.getName());
        stringBuffer2.append("\" id=\"");
        stringBuffer2.append(this.id);
        stringBuffer2.append("\">\n");
        stringBuffer2.append(this.value.toXML(stringBuffer.toString()));
        stringBuffer2.append("\n");
        if (bl && this.baseValue != null) {
            stringBuffer2.append(stringBuffer.toString());
            stringBuffer2.append("<baseValue>").append("\n");
            stringBuffer2.append(this.baseValue.toXML(stringBuffer.toString() + "    "));
            stringBuffer2.append("\n");
            stringBuffer2.append(stringBuffer.toString());
            stringBuffer2.append("</baseValue>");
            stringBuffer2.append("\n");
        }
        stringBuffer2.append(string);
        stringBuffer2.append("</CpdData>");
        return stringBuffer2.toString();
    }

    public void fromXML(String string) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Data Id=");
        stringBuffer.append(this.id);
        stringBuffer.append(" name=");
        stringBuffer.append(this.descriptor.getName());
        stringBuffer.append(" description=");
        stringBuffer.append(this.info.getDescription());
        stringBuffer.append(this.value.toString());
        return stringBuffer.toString();
    }
}

