/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.models.config.pmiservice.PMIService;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.processexec.JavaProcessDef;
import com.ibm.websphere.models.config.processexec.JavaVirtualMachine;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.xml.product.product;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.repository.ConfigStructureHelper;
import com.ibm.ws.pmi.component.PMI;
import com.ibm.ws.pmi.server.PMIServiceState;
import com.ibm.ws.pmi.server.PerfPrivate;
import com.ibm.ws.pmi.server.PmiCollaboratorFactory;
import com.ibm.ws.pmi.server.PmiConfigManager;
import com.ibm.ws.pmi.server.PmiFactory;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.modules.RuntimeModule;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.util.PlatformHelper;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class PMIImpl
extends ComponentImpl
implements PMI {
    public static final String PMI_CONFIGFILE = "pmi-config.xml";
    private static PMIServiceState serviceState = new PMIServiceState();
    private boolean enabled = false;
    private static boolean bIsCustomSet = false;
    private static boolean bSpecChanged = false;
    private static TraceComponent tc = Tr.register(PMIImpl.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private static URI pmiConfigURI;
    private static Repository repository;

    public void initialize(Object object) {
        Object object2;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", object);
        }
        this.addService(PMI.class);
        PMIService pMIService = (PMIService)object;
        this.enabled = pMIService.isEnable();
        if (this.isXD()) {
            this.enabled = true;
        }
        if (!this.enabled) {
            return;
        }
        String string2 = AdminServiceFactory.getAdminService().getProcessType();
        if (string2.equals("DeploymentManager")) {
            Tr.warning(tc, "PMI0032W");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
            return;
        }
        Tr.audit(tc, "PMI0001A");
        PmiRegistry.init();
        String string3 = pMIService.getInitialSpecLevel();
        if (string3 != null && string3.length() > 0 && tc.isDebugEnabled()) {
            Tr.warning(tc, "PMI0031W");
        }
        if ((string = pMIService.getStatisticSet()) == null || string.length() == 0) {
            string = "custom";
        }
        serviceState.setSynchronizedUpdate(pMIService.isSynchronizedUpdate());
        serviceState.setStatisticSet(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "statisticSet=" + string + "; syncUpdate=" + serviceState.getSynchronizedUpdate());
        }
        repository = (Repository)this.getService(Repository.class);
        if (string.equals("custom")) {
            bIsCustomSet = true;
            PMIImpl.initSpecFromPmiConfigDocument();
        }
        if (pmiConfigURI == null) {
            object2 = repository.getConfigRoot();
            pmiConfigURI = URI.createURI((String)ConfigStructureHelper.getURI(repository.getCellName(), repository.getNodeName(), repository.getServerName(), PMI_CONFIGFILE));
        }
        PmiRegistry.restorePmiLevel();
        try {
            object2 = PmiCollaboratorFactory.getPmiCollaborator(string2);
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(object2);
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            mBeanFactory.activateMBean("Perf", defaultRuntimeCollaborator, "PerfMBean", null);
            if (PmiRegistry.Z) {
                if (AdminHelper.getPlatformHelper().isServantJvm() || AdminHelper.getPlatformHelper().isCRAJvm() || string2.equals("NodeAgent")) {
                    PerfPrivate.init();
                }
            } else {
                PerfPrivate.init();
            }
            if (string2.equals("NodeAgent") || string2.equals("UnManagedProcess")) {
                DefaultRuntimeCollaborator defaultRuntimeCollaborator2 = new DefaultRuntimeCollaborator(this, "SystemMetrics");
                mBeanFactory.activateMBean("SystemMetrics", defaultRuntimeCollaborator2, "SystemMetrics", null);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.pmi.component.PMIImpl.initialize", "52", this);
            Tr.warning(tc, "PMI9999E", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public static boolean initSpecFromPmiConfigDocument() {
        ConfigRoot configRoot = repository.getConfigRoot();
        pmiConfigURI = URI.createURI((String)ConfigStructureHelper.getURI(repository.getCellName(), repository.getNodeName(), repository.getServerName(), PMI_CONFIGFILE));
        Resource resource = null;
        try {
            resource = configRoot.getResource(4, PMI_CONFIGFILE);
        }
        catch (Exception exception) {
            resource = null;
            Tr.warning(tc, "PMI0026W", exception);
        }
        if (resource != null) {
            PmiConfigManager.initSpec(resource);
            return true;
        }
        return false;
    }

    public void start() {
        if (!this.enabled) {
            return;
        }
        int[] nArray = this.readJVMConfig();
        if (nArray[2] == 1) {
            RuntimeModule.setJVMPIEnabled(true);
        }
        if (nArray[2] == 2) {
            RuntimeModule.setJVMTIEnabled(true);
        }
        RuntimeModule runtimeModule = PmiFactory.createJvmPerf(nArray[0], nArray[1]);
        try {
            String string = AdminServiceFactory.getAdminService().getProcessType();
            if (string.equals("NodeAgent") || string.equals("UnManagedProcess")) {
                PmiFactory.createSystemPerf("sys module");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.pmi.component.PMIImpl.start", "75", this);
            Tr.warning(tc, "PMI9999E", exception);
        }
    }

    public void stop() {
    }

    public void destroy() {
    }

    private int[] readJVMConfig() {
        Object object;
        PlatformHelper platformHelper = AdminHelper.getPlatformHelper();
        String string = "Servant";
        if (platformHelper.isControlJvm()) {
            string = "Control";
        } else if (platformHelper.isServantJvm()) {
            string = "Servant";
        } else if (platformHelper.isServantJvm()) {
            string = "Adjunct";
        }
        int[] nArray = new int[]{0, 0, 0};
        JavaVirtualMachine javaVirtualMachine = null;
        try {
            Object object2;
            Object object3;
            object = (Repository)this.getService(Repository.class);
            ConfigRoot configRoot = object.getConfigRoot();
            Resource resource = configRoot.getResource(4, "server.xml");
            Server server2 = (Server)resource.getContents().get(0);
            JavaProcessDef javaProcessDef = null;
            Iterator iterator = server2.getProcessDefinitions().iterator();
            if (iterator != null) {
                while (iterator.hasNext() && ((object3 = iterator.next()) == null || !(object3 instanceof JavaProcessDef) || (object2 = (javaProcessDef = (JavaProcessDef)object3).getProcessType()) != null && !((String)object2).equalsIgnoreCase(string))) {
                }
            }
            if (javaProcessDef == null && (object3 = server2.getProcessDefinition()) != null && object3 instanceof JavaProcessDef) {
                javaProcessDef = (JavaProcessDef)object3;
            }
            if (javaProcessDef != null && (object2 = (object3 = javaProcessDef.getJvmEntries()).iterator()).hasNext()) {
                javaVirtualMachine = (JavaVirtualMachine)object2.next();
            }
        }
        catch (Exception exception) {
            Tr.warning(tc, "PMI9999E", exception);
        }
        if (javaVirtualMachine != null) {
            nArray[0] = javaVirtualMachine.getInitialHeapSize();
            if (nArray[0] == 0) {
                nArray[0] = 50;
            }
            nArray[0] = 1024 * nArray[0];
            nArray[1] = javaVirtualMachine.getMaximumHeapSize();
            if (nArray[1] == 0) {
                nArray[1] = 256;
            }
            nArray[1] = 1024 * nArray[1];
            object = javaVirtualMachine.getGenericJvmArguments();
            if (object != null && ((String)object).length() > 0) {
                if (((String)object).indexOf("pmiJvmpiProfiler") > -1 || ((String)object).indexOf("QWASJVMPI") > -1) {
                    nArray[2] = 1;
                }
                if (((String)object).indexOf("pmiJvmtiProfiler") > -1 || ((String)object).indexOf("QWASJVMTI") > -1) {
                    nArray[2] = 2;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JVM config {ms, mx, jvmpi}: " + nArray[0] + ", " + nArray[1] + ", " + nArray[2]);
            }
        } else {
            Tr.warning(tc, "PMI9999E", "Error getting JavaVirtualMachine configuration");
        }
        return nArray;
    }

    public static URI getPMIConfigURI() {
        return pmiConfigURI;
    }

    public static void setSynchronizedUpdate(boolean bl) {
        if (serviceState.getSynchronizedUpdate() == bl) {
            return;
        }
        bSpecChanged = true;
        serviceState.setSynchronizedUpdate(bl);
    }

    public static boolean getSynchronizedUpdate() {
        return serviceState.getSynchronizedUpdate();
    }

    public static void setStatisticSet(String string) {
        if (serviceState.getStatisticSet().equals(string)) {
            return;
        }
        bSpecChanged = true;
        serviceState.setStatisticSet(string);
        if (string.equals("custom")) {
            bIsCustomSet = true;
        }
    }

    public static String getStatisticSet() {
        return serviceState.getStatisticSet();
    }

    public static boolean isCustomSet() {
        return bIsCustomSet;
    }

    public static boolean isSpecUpdated() {
        return bSpecChanged;
    }

    public static PMIServiceState getStateObject() {
        return serviceState;
    }

    public static void updateRuntimeWithStateObject(PMIServiceState pMIServiceState) {
        serviceState.setStatisticSet(pMIServiceState.getStatisticSet());
        serviceState.setSynchronizedUpdate(pMIServiceState.getSynchronizedUpdate());
        PmiConfigManager.updateSpec(pMIServiceState.getInstrumentationSpec());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private boolean isXD() {
        boolean bl = false;
        try {
            Object object;
            WASProduct wASProduct = new WASProduct();
            Iterator iterator = wASProduct.getProducts();
            while (iterator.hasNext()) {
                object = (product)iterator.next();
                String string = ((product)object).getId();
                if (string == null || string.indexOf("XD") == -1) continue;
                if (string.equalsIgnoreCase("XDMS")) {
                    bl = false;
                    continue;
                }
                bl = true;
            }
            if (!bl) {
                try {
                    object = Thread.currentThread().getContextClassLoader().loadClass("com.ibm.ws.xd.pmi.async.server.Publisher");
                    bl = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
            }
        }
        catch (Exception exception) {
            Tr.warning(tc, "PMI9999E", "Error getting WAS Version");
        }
        return bl;
    }
}

