/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.dynamicproxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.dynamicproxy.AggregationHandler;
import com.ibm.websphere.management.dynamicproxy.ServantMBeanResult;
import com.ibm.websphere.management.dynamicproxy.StateObject;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.ws.pmi.dynamicproxy.PerfPrivateLocal;
import com.ibm.ws.pmi.dynamicproxy.PmiStateObject;
import com.ibm.ws.pmi.dynamicproxy.StatsUtil;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.stat.StatsImpl;
import java.io.Serializable;
import javax.management.ObjectName;

public class PerfMBeanAggregationHandler
implements AggregationHandler {
    private static TraceComponent tc = Tr.register(PerfMBeanAggregationHandler.class, "PMI", null);
    private static boolean obtainedSystemStats = false;
    private static boolean obtainedJVMStats = false;

    public Object aggregateResults(String string, Object[] objectArray, String[] stringArray, ServantMBeanResult[] servantMBeanResultArray, StateObject stateObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "aggregateResults", new Object[]{string, objectArray[0], stringArray[0]});
        }
        if (string.equals("getStatsObject")) {
            DataDescriptor dataDescriptor = null;
            if (stringArray[0].equals("javax.management.ObjectName")) {
                dataDescriptor = PerfPrivateLocal.get().getDataDescriptor((ObjectName)objectArray[0]);
            } else if (stringArray[0].equals("com.ibm.websphere.pmi.stat.MBeanStatDescriptor")) {
                dataDescriptor = PerfPrivateLocal.get().getDataDescriptor((MBeanStatDescriptor)objectArray[0]);
            } else if (stringArray[0].equals("com.ibm.ws.pmi.server.DataDescriptor")) {
                dataDescriptor = (DataDescriptor)objectArray[0];
            }
            StatsImpl statsImpl = null;
            StatsImpl[] statsImplArray = null;
            String[] stringArray2 = null;
            if (servantMBeanResultArray != null && servantMBeanResultArray.length > 0) {
                statsImplArray = new StatsImpl[servantMBeanResultArray.length];
                stringArray2 = new String[servantMBeanResultArray.length];
                for (int i = 0; i < servantMBeanResultArray.length; ++i) {
                    statsImplArray[i] = (StatsImpl)servantMBeanResultArray[i].getResult();
                    stringArray2[i] = servantMBeanResultArray[i].getStoken();
                }
            }
            statsImpl = PerfMBeanAggregationHandler.aggregate(dataDescriptor, stringArray2, statsImplArray);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "aggregateResults", statsImpl);
            }
            return statsImpl;
        }
        if (string.equals("getStatsArray")) {
            int n;
            int n2;
            Serializable[] serializableArray;
            DataDescriptor[] dataDescriptorArray = null;
            boolean bl = false;
            if (stringArray[0].equals("[Ljavax.management.ObjectName;")) {
                serializableArray = (ObjectName[])objectArray[0];
                dataDescriptorArray = new DataDescriptor[serializableArray.length];
                for (n2 = 0; n2 < serializableArray.length; ++n2) {
                    dataDescriptorArray[n2] = PerfPrivateLocal.get().getDataDescriptor((ObjectName)serializableArray[n2]);
                }
            } else if (stringArray[0].equals("[Lcom.ibm.websphere.pmi.stat.MBeanStatDescriptor;")) {
                serializableArray = (MBeanStatDescriptor[])objectArray[0];
                dataDescriptorArray = new DataDescriptor[serializableArray.length];
                for (n2 = 0; n2 < serializableArray.length; ++n2) {
                    dataDescriptorArray[n2] = PerfPrivateLocal.get().getDataDescriptor((MBeanStatDescriptor)serializableArray[n2]);
                }
            } else if (stringArray[0].equals("[Lcom.ibm.ws.pmi.server.DataDescriptor;")) {
                dataDescriptorArray = (DataDescriptor[])objectArray[0];
                bl = true;
            } else if (stringArray[0].equals("[Lcom.ibm.websphere.pmi.stat.StatDescriptor;")) {
                serializableArray = (StatDescriptor[])objectArray[0];
                dataDescriptorArray = new DataDescriptor[serializableArray.length];
                for (n2 = 0; n2 < serializableArray.length; ++n2) {
                    dataDescriptorArray[n2] = ((StatDescriptor)serializableArray[n2]).getPath() == null ? new DataDescriptor(new String[]{"pmi"}) : new DataDescriptor(((StatDescriptor)serializableArray[n2]).getPath());
                }
            }
            serializableArray = new StatsImpl[dataDescriptorArray.length];
            StatsImpl[][] statsImplArray = null;
            String[] stringArray3 = null;
            StatsImpl[] statsImplArray2 = null;
            if (servantMBeanResultArray != null && servantMBeanResultArray.length > 0) {
                statsImplArray = new StatsImpl[dataDescriptorArray.length][servantMBeanResultArray.length];
                stringArray3 = new String[servantMBeanResultArray.length];
                for (n = 0; n < dataDescriptorArray.length; ++n) {
                    for (int i = 0; i < servantMBeanResultArray.length; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "aggregateResults - result(" + i + ")", servantMBeanResultArray[i].getResult());
                        }
                        statsImplArray2 = (StatsImpl[])servantMBeanResultArray[i].getResult();
                        statsImplArray[n][i] = statsImplArray2[n];
                        stringArray3[i] = servantMBeanResultArray[i].getStoken();
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "aggregateResults - aggregate passing in " + dataDescriptorArray.length + " elements!");
            }
            for (n = 0; n < dataDescriptorArray.length; ++n) {
                if (statsImplArray == null) {
                    if (tc.isDebugEnabled() && dataDescriptorArray[n] != null) {
                        Tr.debug(tc, "aggregateResults - result[" + n + "] set to NULL (\n" + "dds[" + n + "] ==|" + dataDescriptorArray[n].getModuleName() + "|==,\n" + "stoken ==|" + stringArray3 + "|==,\n" + "stats ==|" + statsImplArray + "|==)");
                    }
                    serializableArray[n] = null;
                    continue;
                }
                if (tc.isDebugEnabled() && dataDescriptorArray[n] != null) {
                    Tr.debug(tc, "aggregateResults - aggregate(\ndds[" + n + "] ==|" + dataDescriptorArray[n].getModuleName() + "|==,\n" + "stoken ==|" + stringArray3 + "|==,\n" + "stats[" + n + "] ==|" + statsImplArray[n] + "|==)");
                }
                serializableArray[n] = PerfMBeanAggregationHandler.aggregate(dataDescriptorArray[n], stringArray3, statsImplArray[n]);
                if (!bl || serializableArray[n] != null || dataDescriptorArray[n] == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "aggregateResults - aggregate result[" + n + "] for " + dataDescriptorArray[n].getModuleName() + " ==|" + serializableArray[n] + "|==");
                }
                serializableArray[n] = new StatsImpl(dataDescriptorArray[n].getModuleName(), 13);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "aggregateResults - aggregate null result filled with ==|" + serializableArray[n] + "|==");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "aggregateResults", serializableArray);
            }
            return serializableArray;
        }
        return string + " is NOT handled by " + this.getClass().getName();
    }

    public static StatsImpl aggregate(DataDescriptor dataDescriptor, String[] stringArray, StatsImpl[] statsImplArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "aggregate", dataDescriptor);
        }
        StatsImpl statsImpl = null;
        StatsImpl statsImpl2 = null;
        StatsImpl statsImpl3 = null;
        obtainedSystemStats = false;
        obtainedJVMStats = false;
        if (stringArray != null && statsImplArray != null) {
            for (int i = 0; i < statsImplArray.length; ++i) {
                if (statsImplArray[i] == null) continue;
                PmiStateObject.setActiveServerStats(stringArray[i], dataDescriptor, statsImplArray[i]);
            }
        }
        statsImpl = PmiStateObject.getActiveServerStats(dataDescriptor);
        statsImpl3 = PmiStateObject.getIdleServerStats(dataDescriptor);
        if (statsImpl3 != null) {
            if (statsImpl == null) {
                statsImpl = statsImpl3;
            } else {
                StatsUtil.combine(statsImpl, statsImpl3);
            }
        }
        if ((statsImpl2 = PmiStateObject.getTerminatedServerStats(dataDescriptor)) != null) {
            if (statsImpl == null) {
                statsImpl = statsImpl2;
            } else {
                StatsUtil.combine(statsImpl, statsImpl2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "aggregate", StatsUtil.getStatsName(statsImpl));
        }
        return statsImpl;
    }

    public static boolean obtainedSystemStats() {
        return obtainedSystemStats;
    }

    public static void setObtainedSystemStats(boolean bl) {
        obtainedSystemStats = bl;
    }

    public static boolean obtainedJVMStats() {
        return obtainedJVMStats;
    }

    public static void setObtainedJVMStats(boolean bl) {
        obtainedJVMStats = bl;
    }
}

