/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.dynamicproxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.ws.pmi.dynamicproxy.PerfMBeanAggregationHandler;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PmiCollaborator;
import com.ibm.ws.pmi.server.PmiCollaboratorFactory;
import com.ibm.ws.pmi.stat.AverageStatisticImpl;
import com.ibm.ws.pmi.stat.BoundaryStatisticImpl;
import com.ibm.ws.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.DoubleStatisticImpl;
import com.ibm.ws.pmi.stat.JCAConnectionPoolStatsImpl;
import com.ibm.ws.pmi.stat.JCAConnectionStatsImpl;
import com.ibm.ws.pmi.stat.JCAStatsImpl;
import com.ibm.ws.pmi.stat.JDBCConnectionPoolStatsImpl;
import com.ibm.ws.pmi.stat.JDBCConnectionStatsImpl;
import com.ibm.ws.pmi.stat.JDBCStatsImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import java.util.ArrayList;

public class StatsUtil {
    private static TraceComponent tc = Tr.register(StatsUtil.class, "PMI", null);
    private static final String[] systemModule = new String[]{"systemModule"};
    private static final String[] runtimeModule = new String[]{"jvmRuntimeModule"};

    public static StatsImpl combine(StatsImpl statsImpl, StatsImpl statsImpl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "combine", new Object[]{StatsUtil.getStatsName(statsImpl), StatsUtil.getStatsName(statsImpl2)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "combine - StatsImpl params", new Object[]{statsImpl, statsImpl2});
        }
        StatisticImpl[] statisticImplArray = (StatisticImpl[])statsImpl.listStatistics();
        StatisticImpl[] statisticImplArray2 = (StatisticImpl[])statsImpl2.listStatistics();
        int n = 0;
        int n2 = 0;
        if (statisticImplArray != null && statisticImplArray2 != null) {
            block0: for (n = 0; n < statisticImplArray.length; ++n) {
                int n3 = statisticImplArray[n].getId();
                for (n2 = 0; n2 < statisticImplArray2.length; ++n2) {
                    if (n3 != statisticImplArray2[n2].getId()) continue;
                    if (StatsUtil.getStatsName(statsImpl).equals("jvmRuntimeModule") && n3 == 4) {
                        statisticImplArray[n] = statisticImplArray2[n2];
                        continue;
                    }
                    statisticImplArray[n].combine(statisticImplArray2[n2]);
                    continue block0;
                }
            }
        }
        StatsImpl[] statsImplArray = (StatsImpl[])statsImpl.listSubStats();
        StatsImpl[] statsImplArray2 = (StatsImpl[])statsImpl2.listSubStats();
        if (statsImplArray != null && statsImplArray2 != null) {
            block2: for (n = 0; n < statsImplArray.length; ++n) {
                String string = statsImplArray[n].getName();
                for (n2 = 0; n2 < statsImplArray2.length; ++n2) {
                    if (string.compareTo(statsImplArray2[n2].getName()) != 0) continue;
                    StatsUtil.combine(statsImplArray[n], statsImplArray2[n2]);
                    continue block2;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "combine - return val", statsImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "combine", StatsUtil.getStatsName(statsImpl));
        }
        return statsImpl;
    }

    public static StatsImpl combineAll(StatsImpl statsImpl, StatsImpl statsImpl2) {
        Object[] objectArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "combineAll", new Object[]{StatsUtil.getStatsName(statsImpl), StatsUtil.getStatsName(statsImpl2)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "combineAll - StatsImpl params", new Object[]{statsImpl, statsImpl2});
        }
        StatsImpl statsImpl3 = statsImpl;
        StatsImpl statsImpl4 = statsImpl2;
        if (((StatsImpl[])statsImpl2.listSubStats()).length > ((StatsImpl[])statsImpl.listSubStats()).length) {
            statsImpl3 = statsImpl2;
            statsImpl4 = statsImpl;
        }
        StatisticImpl[] statisticImplArray = (StatisticImpl[])statsImpl3.listStatistics();
        StatisticImpl[] statisticImplArray2 = (StatisticImpl[])statsImpl4.listStatistics();
        int n = 0;
        int n2 = 0;
        if (statisticImplArray != null && statisticImplArray2 != null) {
            objectArray = new byte[statisticImplArray2.length];
            block0: for (n = 0; n < statisticImplArray.length; ++n) {
                for (n2 = 0; n2 < statisticImplArray2.length; ++n2) {
                    if (statisticImplArray[n].getId() != statisticImplArray2[n2].getId()) continue;
                    statisticImplArray[n].combine(statisticImplArray2[n2]);
                    objectArray[n2] = (StatsImpl)true;
                    continue block0;
                }
            }
            for (n = 0; n < objectArray.length; ++n) {
                if (objectArray[n] != false) continue;
                statsImpl3.add(statisticImplArray2[n]);
            }
        }
        objectArray = (StatsImpl[])statsImpl3.listSubStats();
        StatsImpl[] statsImplArray = (StatsImpl[])statsImpl4.listSubStats();
        if (objectArray != null && statsImplArray != null) {
            byte[] byArray = new byte[statsImplArray.length];
            block3: for (n = 0; n < objectArray.length; ++n) {
                String string = objectArray[n].getName();
                for (n2 = 0; n2 < statsImplArray.length; ++n2) {
                    if (string.compareTo(statsImplArray[n2].getName()) != 0) continue;
                    StatsImpl statsImpl5 = null;
                    statsImpl5 = StatsUtil.combineAll(objectArray[n], statsImplArray[n2]);
                    statsImpl3.remove(statsImpl5.getName());
                    statsImpl3.add(statsImpl5);
                    byArray[n2] = 1;
                    continue block3;
                }
            }
            for (n = 0; n < byArray.length; ++n) {
                if (byArray[n] != 0) continue;
                statsImpl3.add(statsImplArray[n]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "combineAll - return val", statsImpl3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "combineAll", StatsUtil.getStatsName(statsImpl3));
        }
        return statsImpl3;
    }

    public static StatsImpl aggregate(StatsImpl statsImpl, StatsImpl statsImpl2) {
        StatsImpl[] statsImplArray;
        StatisticImpl[] statisticImplArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "aggregate", new Object[]{StatsUtil.getStatsName(statsImpl), StatsUtil.getStatsName(statsImpl2)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "aggregate - StatsImpl params", new Object[]{statsImpl, statsImpl2});
        }
        if ((statisticImplArray = (StatisticImpl[])statsImpl.listStatistics()) != null) {
            for (int i = 0; i < statisticImplArray.length; ++i) {
                StatisticImpl statisticImpl = (StatisticImpl)statsImpl2.getStatistic(statisticImplArray[i].getId());
                if (statisticImplArray[i] instanceof RangeStatisticImpl) {
                    ((RangeStatisticImpl)statisticImplArray[i]).set(0L);
                }
                if (statisticImpl == null) continue;
                statisticImplArray[i].combine(statisticImpl);
            }
        }
        if ((statsImplArray = (StatsImpl[])statsImpl.listSubStats()) != null) {
            for (int i = 0; i < statsImplArray.length; ++i) {
                StatsImpl statsImpl3 = (StatsImpl)statsImpl2.getStats(statsImplArray[i].getName());
                if (statsImpl3 == null) continue;
                StatsUtil.aggregate(statsImplArray[i], statsImpl3);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "aggregate - return val", statsImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "aggregate", StatsUtil.getStatsName(statsImpl));
        }
        return statsImpl;
    }

    public static StatsImpl copyStats(StatsImpl statsImpl) {
        StatisticImpl[] statisticImplArray;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyStats", StatsUtil.getStatsName(statsImpl));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "copyStats - StatsImpl param", statsImpl);
        }
        if (statsImpl == null) {
            return null;
        }
        ArrayList<StatsImpl> arrayList = null;
        ArrayList arrayList2 = null;
        StatsImpl[] statsImplArray = (StatsImpl[])statsImpl.listSubStats();
        if (statsImplArray != null && statsImplArray.length > 0) {
            arrayList = new ArrayList<StatsImpl>();
            for (int i = 0; i < statsImplArray.length; ++i) {
                arrayList.add(StatsUtil.copyStats(statsImplArray[i]));
            }
        }
        if (StatsUtil.getStatsName(statsImpl).equals("systemModule")) {
            if (!PerfMBeanAggregationHandler.obtainedSystemStats()) {
                PmiCollaborator pmiCollaborator = PmiCollaboratorFactory.getPmiCollaborator();
                object = new StatDescriptor[]{new StatDescriptor(systemModule)};
                StatsImpl[] statsImplArray2 = (StatsImpl[])pmiCollaborator.getStatsArray((StatDescriptor[])object, new Boolean(false));
                statsImpl = statsImplArray2[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got SystemStats from ControlRegion \n" + statsImpl);
                }
                PerfMBeanAggregationHandler.setObtainedSystemStats(true);
            }
        } else if (StatsUtil.getStatsName(statsImpl).equals("jvmRuntimeModule") && !PerfMBeanAggregationHandler.obtainedJVMStats()) {
            PmiCollaborator pmiCollaborator = PmiCollaboratorFactory.getPmiCollaborator();
            object = new StatDescriptor[]{new StatDescriptor(runtimeModule)};
            StatsImpl[] statsImplArray3 = (StatsImpl[])pmiCollaborator.getStatsArray((StatDescriptor[])object, new Boolean(false));
            StatsImpl statsImpl2 = statsImplArray3[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got JVMStats from ControlRegion \n" + statsImpl2);
            }
            StatsUtil.combine(statsImpl, statsImpl2);
            PerfMBeanAggregationHandler.setObtainedJVMStats(true);
        }
        if ((statisticImplArray = (StatisticImpl[])statsImpl.listStatistics()) != null && statisticImplArray.length > 0) {
            arrayList2 = StatsUtil.copyStatistics(statisticImplArray);
        }
        object = new StatsImpl(statsImpl.getStatsType(), statsImpl.getName(), statsImpl.getType(), statsImpl.getLevel(), arrayList2, arrayList);
        if (statsImpl instanceof JCAStatsImpl) {
            object = new JCAStatsImpl(statsImpl.getStatsType(), statsImpl.getName(), statsImpl.getType(), statsImpl.getLevel(), arrayList2, arrayList);
        } else if (statsImpl instanceof JCAConnectionStatsImpl) {
            object = new JCAConnectionStatsImpl(statsImpl.getStatsType(), statsImpl.getName(), statsImpl.getType(), statsImpl.getLevel(), arrayList2, arrayList);
            ((JCAConnectionStatsImpl)object).setConnectionFactory(((JCAConnectionStatsImpl)statsImpl).getConnectionFactoryObjectName());
            ((JCAConnectionStatsImpl)object).setManagedConnectionFactory(((JCAConnectionStatsImpl)statsImpl).getManagedConnectionFactoryObjectName());
        } else if (statsImpl instanceof JCAConnectionPoolStatsImpl) {
            object = new JCAConnectionPoolStatsImpl(statsImpl.getStatsType(), statsImpl.getName(), statsImpl.getType(), statsImpl.getLevel(), arrayList2, arrayList);
        } else if (statsImpl instanceof JDBCStatsImpl) {
            object = new JDBCStatsImpl(statsImpl.getStatsType(), statsImpl.getName(), statsImpl.getType(), statsImpl.getLevel(), arrayList2, arrayList);
        } else if (statsImpl instanceof JDBCConnectionStatsImpl) {
            object = new JDBCConnectionStatsImpl(statsImpl.getStatsType(), statsImpl.getName(), statsImpl.getType(), statsImpl.getLevel(), arrayList2, arrayList);
        } else if (statsImpl instanceof JDBCConnectionPoolStatsImpl) {
            object = new JDBCConnectionPoolStatsImpl(statsImpl.getStatsType(), statsImpl.getName(), statsImpl.getType(), statsImpl.getLevel(), arrayList2, arrayList);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "copyStats - return val", object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyStats", StatsUtil.getStatsName((StatsImpl)object));
        }
        return object;
    }

    private static ArrayList copyStatistics(StatisticImpl[] statisticImplArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyStatistics");
        }
        ArrayList<StatisticImpl> arrayList = null;
        if (statisticImplArray != null) {
            arrayList = new ArrayList<StatisticImpl>(statisticImplArray.length);
            for (int i = 0; i < statisticImplArray.length; ++i) {
                arrayList.add(StatsUtil.copyStatistic(statisticImplArray[i]));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyStatistics");
        }
        return arrayList;
    }

    private static StatisticImpl copyStatistic(StatisticImpl statisticImpl) {
        StatisticImpl statisticImpl2 = null;
        if (statisticImpl instanceof BoundedRangeStatisticImpl) {
            BoundedRangeStatisticImpl boundedRangeStatisticImpl = (BoundedRangeStatisticImpl)statisticImpl;
            BoundedRangeStatisticImpl boundedRangeStatisticImpl2 = new BoundedRangeStatisticImpl(statisticImpl.getId());
            boundedRangeStatisticImpl2.set(boundedRangeStatisticImpl.getLowerBound(), boundedRangeStatisticImpl.getUpperBound(), boundedRangeStatisticImpl.getLowWaterMark(), boundedRangeStatisticImpl.getHighWaterMark(), boundedRangeStatisticImpl.getCurrent(), boundedRangeStatisticImpl.getIntegral(), boundedRangeStatisticImpl.getStartTime(), boundedRangeStatisticImpl.getLastSampleTime());
            boundedRangeStatisticImpl2.setDataInfo(statisticImpl.getDataInfo());
            statisticImpl2 = boundedRangeStatisticImpl2;
        } else if (statisticImpl instanceof RangeStatisticImpl) {
            RangeStatisticImpl rangeStatisticImpl = (RangeStatisticImpl)statisticImpl;
            RangeStatisticImpl rangeStatisticImpl2 = new RangeStatisticImpl(statisticImpl.getId());
            rangeStatisticImpl2.set(rangeStatisticImpl.getLowWaterMark(), rangeStatisticImpl.getHighWaterMark(), rangeStatisticImpl.getCurrent(), rangeStatisticImpl.getIntegral(), rangeStatisticImpl.getStartTime(), rangeStatisticImpl.getLastSampleTime());
            rangeStatisticImpl2.setDataInfo(statisticImpl.getDataInfo());
            statisticImpl2 = rangeStatisticImpl2;
        } else if (statisticImpl instanceof BoundaryStatisticImpl) {
            BoundaryStatisticImpl boundaryStatisticImpl = (BoundaryStatisticImpl)statisticImpl;
            BoundaryStatisticImpl boundaryStatisticImpl2 = new BoundaryStatisticImpl(statisticImpl.getId());
            boundaryStatisticImpl2.set(boundaryStatisticImpl.getLowerBound(), boundaryStatisticImpl.getUpperBound(), boundaryStatisticImpl.getStartTime(), boundaryStatisticImpl.getLastSampleTime());
            boundaryStatisticImpl2.setDataInfo(statisticImpl.getDataInfo());
            statisticImpl2 = boundaryStatisticImpl2;
        } else if (statisticImpl instanceof CountStatisticImpl) {
            CountStatisticImpl countStatisticImpl = (CountStatisticImpl)statisticImpl;
            CountStatisticImpl countStatisticImpl2 = new CountStatisticImpl(statisticImpl.getId());
            countStatisticImpl2.set(countStatisticImpl.getCount(), countStatisticImpl.getStartTime(), countStatisticImpl.getLastSampleTime());
            countStatisticImpl2.setDataInfo(statisticImpl.getDataInfo());
            statisticImpl2 = countStatisticImpl2;
        } else if (statisticImpl instanceof TimeStatisticImpl) {
            TimeStatisticImpl timeStatisticImpl = (TimeStatisticImpl)statisticImpl;
            TimeStatisticImpl timeStatisticImpl2 = new TimeStatisticImpl(statisticImpl.getId());
            timeStatisticImpl2.set(timeStatisticImpl.getCount(), timeStatisticImpl.getMinTime(), timeStatisticImpl.getMaxTime(), timeStatisticImpl.getTotalTime(), timeStatisticImpl.getSumOfSquares(), timeStatisticImpl.getStartTime(), timeStatisticImpl.getLastSampleTime());
            timeStatisticImpl2.setDataInfo(statisticImpl.getDataInfo());
            statisticImpl2 = timeStatisticImpl2;
        } else if (statisticImpl instanceof AverageStatisticImpl) {
            AverageStatisticImpl averageStatisticImpl = (AverageStatisticImpl)statisticImpl;
            AverageStatisticImpl averageStatisticImpl2 = new AverageStatisticImpl(statisticImpl.getId());
            averageStatisticImpl2.set(averageStatisticImpl.getCount(), averageStatisticImpl.getMin(), averageStatisticImpl.getMax(), averageStatisticImpl.getTotal(), averageStatisticImpl.getSumOfSquares(), averageStatisticImpl.getStartTime(), averageStatisticImpl.getLastSampleTime());
            averageStatisticImpl2.setDataInfo(statisticImpl.getDataInfo());
            statisticImpl2 = averageStatisticImpl2;
        } else if (statisticImpl instanceof DoubleStatisticImpl) {
            DoubleStatisticImpl doubleStatisticImpl = (DoubleStatisticImpl)statisticImpl;
            DoubleStatisticImpl doubleStatisticImpl2 = new DoubleStatisticImpl(statisticImpl.getId());
            doubleStatisticImpl2.set(doubleStatisticImpl.getDouble(), doubleStatisticImpl.getStartTime(), doubleStatisticImpl.getLastSampleTime());
            doubleStatisticImpl2.setDataInfo(statisticImpl.getDataInfo());
            statisticImpl2 = doubleStatisticImpl2;
        }
        return statisticImpl2;
    }

    public static StatsImpl findStats(StatsImpl statsImpl, DataDescriptor dataDescriptor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findStats", new Object[]{StatsUtil.getStatsName(statsImpl), dataDescriptor});
        }
        if (statsImpl == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findStats - null seedStats passed in", null);
            }
            return null;
        }
        if (dataDescriptor == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findStats - Server StatsImpl (null DataDescriptor)", StatsUtil.getStatsName(statsImpl));
            }
            return statsImpl;
        }
        String[] stringArray = dataDescriptor.getPath();
        if (stringArray == null || stringArray.length == 0 || stringArray.length == 1 && stringArray[0].equals("pmi")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findStats - Server StatsImpl (null Path)", StatsUtil.getStatsName(statsImpl));
            }
            return statsImpl;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "findStats - path", stringArray[0]);
        }
        StatsImpl statsImpl2 = statsImpl;
        Object var4_4 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if ((statsImpl2 = (StatsImpl)statsImpl2.getStats(string)) != null) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findStats - stats not found", null);
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "findStats - return val", statsImpl2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findStats", StatsUtil.getStatsName(statsImpl2));
        }
        return statsImpl2;
    }

    public static final String getStatsName(StatsImpl statsImpl) {
        if (statsImpl == null) {
            return "null";
        }
        return statsImpl.getName();
    }
}

