/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.factory;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import javax.management.ObjectName;

public class StatsFactoryUtil {
    public static final String DEFAULT_MBEAN = "CustomStats";
    private static final String DEFAULT_MBEAN_DESCRIPTOR = "com/ibm/ws/pmi/factory/CustomStats.xml";
    private static final TraceComponent tc = Tr.register(StatsFactoryUtil.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.pmi.properties.PMIMessages");

    public static MBeanStatDescriptor createMBean(Object object, String string, ObjectName objectName, boolean bl) throws StatsFactoryException {
        if (objectName != null) {
            return new MBeanStatDescriptor(objectName);
        }
        return null;
    }

    private static ObjectName createDefaultMBean(Object object, String string) throws StatsFactoryException {
        return null;
    }

    public static void registerModule(PmiModule pmiModule, MBeanStatDescriptor mBeanStatDescriptor) throws StatsFactoryException {
        ModuleItem moduleItem = PmiRegistry.registerModule(pmiModule);
        if (moduleItem == null) {
            Tr.warning(tc, "PMI0103W", pmiModule.getName());
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0103W", new Object[]{pmiModule.getName()}, "Unable to register custom PMI module due to duplicate name under the same parent or invalid PMI tree path: {0}"));
        }
        if (mBeanStatDescriptor != null) {
            StatsFactoryUtil.setMBeanMapping(moduleItem, mBeanStatDescriptor);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No MBean associated with " + pmiModule.getName());
        }
    }

    public static void setMBeanMapping(ModuleItem moduleItem, MBeanStatDescriptor mBeanStatDescriptor) {
        PmiRegistry.setMBeanToModuleMap(moduleItem, mBeanStatDescriptor);
    }

    public static void setMBeanMapping(ModuleItem moduleItem, ObjectName objectName) {
        MBeanStatDescriptor mBeanStatDescriptor = new MBeanStatDescriptor(objectName);
        PmiRegistry.setMBeanToModuleMap(moduleItem, mBeanStatDescriptor);
    }

    private static String getMBeanID(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append("#").append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static void unRegisterStats(PmiModule pmiModule, ObjectName objectName) throws StatsFactoryException {
        PmiRegistry.unregisterModule(pmiModule);
    }

    public static void deactivateMBean(ObjectName objectName) {
    }

    public static void checkDataIDUniqueness(PmiModule pmiModule, PmiModuleConfig pmiModuleConfig) throws StatsFactoryException {
        for (ModuleItem moduleItem = PmiRegistry.findModuleItem(pmiModule.getPath()); moduleItem != null && moduleItem.getInstance() != null; moduleItem = moduleItem.getParent()) {
            PmiModuleConfig pmiModuleConfig2 = moduleItem.getInstance().getModuleConfig();
            if (pmiModuleConfig2.getUID().equals(pmiModuleConfig.getUID())) continue;
            PmiDataInfo[] pmiDataInfoArray = pmiModuleConfig2.listAllData();
            PmiDataInfo[] pmiDataInfoArray2 = pmiModuleConfig.listAllData();
            for (int i = 0; i < pmiDataInfoArray.length; ++i) {
                int n = pmiDataInfoArray[i].getId();
                for (int j = 0; j < pmiDataInfoArray2.length; ++j) {
                    if (pmiDataInfoArray2[j].getId() != n) continue;
                    throw new StatsFactoryException(nls.getFormattedMessage("PMI0108W", new Object[]{new Integer(n), pmiModuleConfig2.getUID()}, "Unable to register custom PMI module due to duplicate statistic id in the parent stats group/instance: ID={0}; ParentStats={1}"));
                }
            }
        }
    }
}

