/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.perfServer;

import com.ibm.ejs.perf.client.PerfValue;
import com.ibm.ejs.perf.epm.EpmSpec;
import com.ibm.ejs.perf.value.PerfValueGroup;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.beans.Attributes;
import com.ibm.ejs.sm.beans.EpmService;
import com.ibm.ejs.sm.beans.EpmServiceHome;
import com.ibm.ejs.sm.beans.Node;
import com.ibm.ejs.sm.beans.NodeHome;
import com.ibm.ejs.sm.exception.OpException;
import com.ibm.ejs.sm.server.ManagedServer;
import com.ibm.ejs.sm.util.Utils;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.client.PmiClient;
import com.ibm.ws.pmi.perfServer.AbstractCollector;
import com.ibm.ws.pmi.perfServer.DataCache;
import com.ibm.ws.pmi.perfServer.EpmMapper;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.wire.WpdCollection;
import com.ibm.ws.pmi.wire.WpdCollectionImpl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class CollectorEPM
extends AbstractCollector {
    private String host = null;
    private String nodeName = null;
    private String port = null;
    private boolean inAppServer = false;
    private ManagedServer appServer = null;
    private InitialContext ic = null;
    private String qualifiedPrefix;
    private EpmServiceHome epmHome = null;
    private EpmService epmService = null;
    private static final TraceComponent tc = Tr.register(CollectorEPM.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private static Hashtable Nodes = new Hashtable(5);
    private static HashMap webAppNames = new HashMap(5);

    public CollectorEPM(boolean bl) throws RemoteException {
        this(null, null, bl);
    }

    public CollectorEPM() throws RemoteException {
    }

    public CollectorEPM(String string, String string2, boolean bl) throws RemoteException {
        Tr.entry(tc, "CollectorEPM");
        this.init(string, string2, bl);
        Tr.exit(tc, "CollectorEPM");
    }

    public void init(String string, String string2, boolean bl) throws RemoteException {
        Tr.entry(tc, "CollectorEPM.init");
        if (bl) {
            this.inAppServer = true;
            this.host = string;
            System.out.println("CollectorEPM is called in appserver");
            this.appServer = ManagedServer.getInstance();
            if (this.appServer == null) {
                throw new RemoteException("cannot get the app server handle");
            }
        } else {
            try {
                this.host = string;
                this.nodeName = DataCache.nodeName;
                if (this.nodeName == null) {
                    this.nodeName = Utils.defaultNodeName(string, true);
                }
            }
            catch (Exception exception) {
                throw new RemoteException("Cannot get local host name", exception);
            }
        }
        this.port = string2 != null ? string2 : "900";
        this.getInitialContext(this.inAppServer);
        this.initHomes(this.inAppServer);
        this.createEpmService();
        String[] stringArray = this.listNodes();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = this.listServers(stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                String string3 = EpmMapper.NodeAndServerString(stringArray[i], stringArray2[j]);
                this.checkWebAppNames(string3, stringArray[i], stringArray2[j]);
            }
        }
        Tr.exit(tc, "CollectorEPM.init");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkWebAppNames(String string, String string2, String string3) {
        HashMap hashMap = webAppNames;
        synchronized (hashMap) {
            block6: {
                if (webAppNames.get(string) == null) {
                    try {
                        webAppNames.put(string.toString(), this.epmService.getWebAppNames(string2, string3));
                    }
                    catch (Exception exception) {
                        if (!this.debug) break block6;
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getWebAppNames(String string, String string2) {
        String string3 = EpmMapper.NodeAndServerString(string, string2);
        HashMap hashMap = webAppNames;
        synchronized (hashMap) {
            return (String[])webAppNames.get(string3);
        }
    }

    private boolean getInitialContext(boolean bl) throws RemoteException {
        Tr.entry(tc, "getInitialContext");
        try {
            if (bl) {
                this.ic = new InitialContext();
            } else {
                Properties properties = new Properties();
                if (System.getProperty("java.naming.factory.initial") != null) {
                    properties.put("java.naming.factory.initial", System.getProperty("java.naming.factory.initial"));
                } else {
                    properties.put("java.naming.factory.initial", "com.ibm.ejs.ns.jndi.CNInitialContextFactory");
                }
                properties.put("java.naming.provider.url", "iiop://" + this.host + ":" + this.port);
                this.ic = new InitialContext(properties);
            }
        }
        catch (Exception exception) {
            Tr.warning(tc, "Exception getting initial context: ", exception);
            this.ic = null;
            Tr.exit(tc, "getInitialContext");
            throw new RemoteException("Exception getting initial context: ", exception);
        }
        Tr.exit(tc, "getInitialContext");
        return true;
    }

    private void initHomes(boolean bl) throws RemoteException {
        Tr.entry(tc, "initHomes");
        String string = null;
        try {
            if (bl) {
                string = Attributes.qualifyRepositoryHomeName((String)"EpmServiceHome", (String)"");
            } else {
                if (this.host == null) {
                    throw new RemoteException("Host name is null");
                }
                this.qualifiedPrefix = Attributes.qualifyRepositoryHomeName((String)this.nodeName, (String)"");
                string = this.qualifiedPrefix + "EpmServiceHome";
            }
        }
        catch (Exception exception) {
            throw new RemoteException("cannot get qualified home name", exception);
        }
        try {
            Object object = this.ic.lookup(string);
            this.epmHome = (EpmServiceHome)PortableRemoteObject.narrow((Object)object, (Class)EpmServiceHome.class);
        }
        catch (Exception exception) {
            throw new RemoteException("Exception to lookup home", exception);
        }
        Tr.exit(tc, "initHomes");
    }

    private boolean createEpmService() throws RemoteException {
        Tr.entry(tc, "createEpmService");
        try {
            if (this.epmService != null) {
                this.epmService.remove();
            }
            this.epmService = this.epmHome.create();
        }
        catch (Exception exception) {
            try {
                try {
                    this.host = Utils.defaultNodeName(null, true);
                }
                catch (Exception exception2) {
                    throw new RemoteException("Cannot get default node name", exception);
                }
                this.port = "900";
                this.getInitialContext(false);
                this.initHomes(false);
                this.createEpmService();
            }
            catch (Exception exception3) {
                this.epmService = null;
                this.errMsg = "Exception to create EpmService bean object";
                Tr.warning(tc, "cannot create epmService", exception3);
                Tr.exit(tc, "createEpmService");
                throw new RemoteException("Cannot create EpmService bean obj", exception3);
            }
        }
        Tr.exit(tc, "createEpmService");
        return true;
    }

    public String[] listNodes() {
        Tr.entry(tc, "listNodes");
        this.errCode = 0;
        this.errMsg = "";
        String[] stringArray = null;
        try {
            stringArray = this.epmService.listNodes();
        }
        catch (Exception exception) {
            try {
                this.createEpmService();
                stringArray = this.epmService.listNodes();
            }
            catch (Exception exception2) {
                if (this.debug) {
                    exception2.printStackTrace();
                }
                this.errCode = 3;
                this.errMsg = "Exception to listNodes\n" + exception2.toString();
            }
        }
        Tr.exit(tc, "listNodes");
        return stringArray;
    }

    public String[] listServers(String string) {
        Tr.entry(tc, "listServers");
        this.errCode = 0;
        this.errMsg = "";
        String[] stringArray = null;
        try {
            stringArray = this.epmService.listServers(string);
        }
        catch (Exception exception) {
            try {
                this.createEpmService();
                stringArray = this.epmService.listServers(string);
            }
            catch (Exception exception2) {
                if (this.debug) {
                    exception2.printStackTrace();
                }
                this.errCode = 4;
                this.errMsg = "Exception to listServers\n" + exception2.toString();
            }
        }
        Tr.exit(tc, "listServers");
        return stringArray;
    }

    public int getAdminState(String string) {
        Tr.entry(tc, "getAdminState()");
        this.errCode = 0;
        this.errMsg = "";
        try {
            return this.createNode(string).getCurrentState();
        }
        catch (Exception exception) {
            try {
                this.createEpmService();
                return this.createNode(string).getCurrentState();
            }
            catch (Exception exception2) {
                this.errCode = 11;
                this.errMsg = "Exception to get node admin state\n" + exception2.toString();
                if (this.debug) {
                    exception2.printStackTrace();
                }
                Tr.exit(tc, "getAdminState()");
                return -1;
            }
        }
    }

    public int getAdminState(String string, String string2) {
        Tr.entry(tc, "getAdminState()");
        this.errCode = 0;
        this.errMsg = "";
        try {
            return this.createNode(string).getCurrentState();
        }
        catch (Exception exception) {
            try {
                this.createEpmService();
                return this.createNode(string).getCurrentState();
            }
            catch (Exception exception2) {
                this.errCode = 11;
                this.errMsg = "Exception to get node admin state\n" + exception2.toString();
                if (this.debug) {
                    exception2.printStackTrace();
                }
                Tr.exit(tc, "getAdminState()");
                return -1;
            }
        }
    }

    public WpdCollection get(String string, String string2, DataDescriptor dataDescriptor, boolean bl) {
        WpdCollection wpdCollection;
        block5: {
            Tr.entry(tc, "get");
            wpdCollection = null;
            this.errCode = 0;
            this.errMsg = "";
            try {
                wpdCollection = EpmMapper.get(string, string2, dataDescriptor, bl, this.epmService);
            }
            catch (Exception exception) {
                try {
                    if (this.debug) {
                        System.out.println("CollectorEPM:get - Remote Exception: recreate new Epm Service Bean");
                    }
                    Tr.error(tc, "CollectorEPM:get - Remote Exception: recreate new Epm Service Bean", exception);
                    this.createEpmService();
                    wpdCollection = EpmMapper.get(string, string2, dataDescriptor, bl, this.epmService);
                }
                catch (Exception exception2) {
                    if (!this.debug) break block5;
                    exception2.printStackTrace();
                }
            }
        }
        return wpdCollection;
    }

    private Node createNode(String string) {
        Node node;
        block3: {
            Tr.entry(tc, "createNode");
            node = (Node)Nodes.get(string);
            if (node == null) {
                try {
                    String string2 = this.qualifiedPrefix + "NodeHome";
                    Object object = this.ic.lookup(string2);
                    NodeHome nodeHome = (NodeHome)PortableRemoteObject.narrow((Object)object, (Class)NodeHome.class);
                    node = nodeHome.findByName(string, true);
                    Nodes.put(string, node);
                }
                catch (Exception exception) {
                    System.out.println("Error creating node = " + exception);
                    if (!this.debug) break block3;
                    exception.printStackTrace();
                }
            }
        }
        Tr.exit(tc, "createNode");
        return node;
    }

    private DataDescriptor[] getCompressedDDs(DataDescriptor[] dataDescriptorArray, boolean bl) {
        int n;
        int n2 = 4;
        boolean bl2 = false;
        boolean bl3 = false;
        DataDescriptor dataDescriptor = null;
        DataDescriptor dataDescriptor2 = null;
        int n3 = -1;
        String string = null;
        if (bl || dataDescriptorArray == null || dataDescriptorArray.length < n2) {
            return null;
        }
        ArrayList<DataDescriptor> arrayList = new ArrayList<DataDescriptor>();
        for (n = 0; n < dataDescriptorArray.length; ++n) {
            if (dataDescriptorArray[n] == null || dataDescriptorArray[n].getType() != 13) continue;
            arrayList.add(dataDescriptorArray[n]);
            if (!bl2 && dataDescriptorArray[n].getModuleName().equals("beanModule")) {
                bl2 = true;
            }
            if (bl3 || !dataDescriptorArray[n].getModuleName().equals("beanModule")) continue;
            bl3 = true;
        }
        for (n = 0; n < dataDescriptorArray.length; ++n) {
            int n4;
            if (dataDescriptorArray[n] == null) {
                return new DataDescriptor[]{null};
            }
            n3 = -1;
            for (n4 = 0; n4 < arrayList.size(); ++n4) {
                dataDescriptor = (DataDescriptor)arrayList.get(n4);
                if (!dataDescriptorArray[n].isDescendant(dataDescriptor) && !dataDescriptorArray[n].isSamePath(dataDescriptor)) continue;
                n3 = n4;
                break;
            }
            if (n3 != -1) continue;
            for (n4 = 0; n4 < dataDescriptorArray.length; ++n4) {
                if (n == n4 || !dataDescriptorArray[n].isDescendant(dataDescriptorArray[n4])) continue;
                n3 = n4;
            }
            if (n3 != -1) continue;
            arrayList.add(dataDescriptorArray[n]);
        }
        n = 0;
        DataDescriptor dataDescriptor3 = null;
        while (n == 0) {
            int n5;
            n = 1;
            for (n5 = arrayList.size() - 1; n5 >= 0; --n5) {
                dataDescriptor = (DataDescriptor)arrayList.get(n5);
                if (dataDescriptor == null || dataDescriptor.getType() == 13) continue;
                n = 0;
                DataDescriptor dataDescriptor4 = dataDescriptor.parentDescriptor();
                string = dataDescriptor.getModuleName();
                int n6 = 1;
                int n7 = 1;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (n5 == i) continue;
                    dataDescriptor2 = (DataDescriptor)arrayList.get(i);
                    if (dataDescriptor4.isSamePath(dataDescriptor2.parentDescriptor())) {
                        ++n6;
                        continue;
                    }
                    if (!string.equals(dataDescriptor2.getModuleName())) continue;
                    ++n7;
                }
                if (n7 >= n2) {
                    dataDescriptor3 = new DataDescriptor(new String[]{string});
                    arrayList.add(dataDescriptor3);
                    break;
                }
                if (n6 >= n2) {
                    dataDescriptor3 = dataDescriptor4;
                    arrayList.add(dataDescriptor4);
                    break;
                }
                n = 1;
            }
            if (n != 0) break;
            for (n5 = arrayList.size() - 2; n5 >= 0; --n5) {
                dataDescriptor = (DataDescriptor)arrayList.get(n5);
                if (!dataDescriptor.isDescendant(dataDescriptor3)) continue;
                arrayList.remove(n5);
            }
        }
        if ((bl3 || bl2) && arrayList.size() >= n2) {
            return new DataDescriptor[]{null};
        }
        if (dataDescriptorArray.length - arrayList.size() < n2) {
            return null;
        }
        DataDescriptor[] dataDescriptorArray2 = new DataDescriptor[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            dataDescriptorArray2[i] = (DataDescriptor)arrayList.get(i);
        }
        return dataDescriptorArray2;
    }

    private WpdCollection getWpdCollection(WpdCollection[] wpdCollectionArray, DataDescriptor[] dataDescriptorArray, DataDescriptor dataDescriptor, boolean bl) {
        if (bl) {
            System.err.println("WARNING: CollectorEPM.getWpdCollection: cannot handle recursive case");
        }
        if (wpdCollectionArray == null) {
            if (this.debug) {
                System.out.println("CollectorEPM.getWpdCollection: cols is null");
            }
            return null;
        }
        for (int i = 0; i < wpdCollectionArray.length; ++i) {
            if (wpdCollectionArray[i] == null) continue;
            if (dataDescriptorArray[i] != null && dataDescriptor.isSamePath(dataDescriptorArray[i])) {
                WpdCollectionImpl wpdCollectionImpl = new WpdCollectionImpl(wpdCollectionArray[i].getName(), wpdCollectionArray[i].getType(), wpdCollectionArray[i].getLevel(), wpdCollectionArray[i].dataMembers(), null);
                return wpdCollectionImpl;
            }
            if (dataDescriptorArray[i] != null && !dataDescriptor.isDescendant(dataDescriptorArray[i])) continue;
            WpdCollection wpdCollection = wpdCollectionArray[i];
            String[] stringArray = null;
            stringArray = dataDescriptorArray[i] == null ? new String[]{} : dataDescriptorArray[i].getPath();
            String[] stringArray2 = dataDescriptor.getPath();
            Object var9_10 = null;
            for (int j = stringArray.length; j <= stringArray2.length - 1; ++j) {
                if ((wpdCollection = wpdCollection.getSubcollection(stringArray2[j])) != null) continue;
                return null;
            }
            return new WpdCollectionImpl(wpdCollection.getName(), wpdCollection.getType(), wpdCollection.getLevel(), wpdCollection.dataMembers(), null);
        }
        if (this.debug) {
            System.err.println("WARNING: CollectorEPM.getWpdCollection returns null");
        }
        return null;
    }

    public WpdCollection[] gets(String string, String string2, DataDescriptor[] dataDescriptorArray, boolean bl) {
        Tr.entry(tc, "gets");
        WpdCollection[] wpdCollectionArray = new WpdCollectionImpl[dataDescriptorArray.length];
        DataDescriptor[] dataDescriptorArray2 = this.getCompressedDDs(dataDescriptorArray, bl);
        if (dataDescriptorArray2 == null) {
            for (int i = 0; i < dataDescriptorArray.length; ++i) {
                wpdCollectionArray[i] = this.get(string, string2, dataDescriptorArray[i], bl);
            }
        } else {
            int n;
            WpdCollection[] wpdCollectionArray2 = new WpdCollectionImpl[dataDescriptorArray2.length];
            for (n = 0; n < dataDescriptorArray2.length; ++n) {
                wpdCollectionArray2[n] = this.get(string, string2, dataDescriptorArray2[n], true);
            }
            for (n = 0; n < dataDescriptorArray.length; ++n) {
                wpdCollectionArray[n] = this.getWpdCollection(wpdCollectionArray2, dataDescriptorArray2, dataDescriptorArray[n], bl);
            }
        }
        Tr.exit(tc, "gets");
        return wpdCollectionArray;
    }

    public DataDescriptor[] listMembers(String string, String string2, DataDescriptor dataDescriptor) {
        int n;
        Tr.entry(tc, "listMembers");
        PerfValueGroup perfValueGroup = (PerfValueGroup)this.getPerfValue(string, string2, dataDescriptor, false);
        if (perfValueGroup == null) {
            return null;
        }
        ArrayList<DataDescriptor> arrayList = null;
        PerfValue[] perfValueArray = perfValueGroup.listAll();
        int n2 = perfValueArray.length;
        arrayList = new ArrayList<DataDescriptor>(n2);
        String string3 = null;
        Object var10_9 = null;
        StringTokenizer stringTokenizer = null;
        Object var12_11 = null;
        String string4 = null;
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            string3 = null;
            var10_9 = null;
            n3 = -1;
            string4 = EpmMapper.EpmModulePath2PmiModulePath(perfValueArray[i].getName(), string, string2);
            if (string4 == null) {
                string4 = EpmMapper.EpmPath2PmiPath(perfValueArray[i].getName(), string, string2);
                if (string4 == null) {
                    continue;
                }
            } else {
                string3 = string4.substring(0, string4.indexOf("/"));
                PmiModuleConfig pmiModuleConfig = this.pmiClnt.getConfig(string3);
                n3 = pmiModuleConfig.getDataId(string4.substring(string4.lastIndexOf("/") + 1, string4.length()));
            }
            stringTokenizer = new StringTokenizer(string4, "/");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = stringTokenizer.nextToken();
            }
            arrayList.add(new DataDescriptor(stringArray, n3));
        }
        DataDescriptor[] dataDescriptorArray = new DataDescriptor[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            dataDescriptorArray[n] = (DataDescriptor)arrayList.get(n);
        }
        Tr.exit(tc, "listMembers");
        return dataDescriptorArray;
    }

    public PmiModuleConfig[] getConfigs() {
        return PerfModules.getConfigs40();
    }

    public PmiModuleConfig[] getConfigs(String string) {
        return PerfModules.getConfigs40();
    }

    public PmiModuleConfig[] getConfigs(String string, String string2) {
        return PerfModules.getConfigs40();
    }

    public void setInstrumentationLevel(String string, String string2, PerfLevelDescriptor[] perfLevelDescriptorArray, boolean bl) {
        block14: {
            Tr.entry(tc, "setInstrumentationLevel");
            try {
                ArrayList<EpmSpec> arrayList = new ArrayList<EpmSpec>((int)((double)perfLevelDescriptorArray.length * 1.5));
                int n = 0;
                int n2 = 0;
                String[] stringArray = null;
                String[] stringArray2 = null;
                EpmSpec[] epmSpecArray = null;
                String[] stringArray3 = null;
                String[] stringArray4 = null;
                int n3 = 0;
                boolean bl2 = false;
                for (n = 0; n < perfLevelDescriptorArray.length; ++n) {
                    n3 = perfLevelDescriptorArray[n].getLevel();
                    if (n3 == 15) {
                        n3 = 7;
                    }
                    if (perfLevelDescriptorArray[n].getPath().length == 1 && perfLevelDescriptorArray[0].getPath()[0].equals("pmi")) {
                        stringArray = new String[]{"epm"};
                        arrayList.add(new EpmSpec(stringArray, n3));
                        continue;
                    }
                    stringArray4 = new String[perfLevelDescriptorArray[n].getPath().length - 1];
                    System.arraycopy(perfLevelDescriptorArray[n].getPath(), 1, stringArray4, 0, stringArray4.length);
                    if (stringArray4[0].equals("transactionModule")) {
                        if (stringArray4.length != 1 || bl2) continue;
                        stringArray = new String[]{"epm", "transactionData"};
                        epmSpecArray = new EpmSpec[]{new EpmSpec(stringArray, n3)};
                        if (!bl) {
                            this.epmService.setEpmComponentsRecursive(string, string2, epmSpecArray);
                        } else {
                            arrayList.add(new EpmSpec(stringArray, n3));
                        }
                        bl2 = true;
                        continue;
                    }
                    stringArray3 = EpmMapper.PmiPath2EpmPath(stringArray4, string, string2, bl);
                    if (stringArray3 == null || stringArray4.length == 1 && (stringArray4[0].equals("threadPoolModule") || stringArray4[0].equals("jvmpiModule")) || stringArray4.length == 4 && stringArray4[3].equals("webAppModule.servlets")) continue;
                    for (n2 = 0; n2 < stringArray3.length; ++n2) {
                        stringArray = EpmMapper.EpmString2EpmArray(stringArray3[n2], string, string2);
                        stringArray2 = new String[stringArray.length + 1];
                        stringArray2[0] = "epm";
                        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
                        arrayList.add(new EpmSpec(stringArray2, n3));
                    }
                }
                if (arrayList.size() != 0) {
                    epmSpecArray = new EpmSpec[arrayList.size()];
                    System.arraycopy(arrayList.toArray(), 0, epmSpecArray, 0, epmSpecArray.length);
                    if (!bl) {
                        this.epmService.setEpmComponents(string, string2, epmSpecArray);
                    } else {
                        this.epmService.setEpmComponentsRecursive(string, string2, epmSpecArray);
                    }
                }
                Tr.exit(tc, "setInstrumentationLevel");
            }
            catch (OpException opException) {
                if (this.debug) {
                    opException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!this.debug) break block14;
                remoteException.printStackTrace();
            }
        }
    }

    public PerfLevelDescriptor[] getInstrumentationLevel(String string, String string2) {
        block12: {
            try {
                Tr.entry(tc, "getInstrumentationLevel");
                EpmSpec[] epmSpecArray = this.epmService.getEpmComponents(string, string2);
                if (epmSpecArray == null) {
                    return null;
                }
                String[] stringArray = null;
                String[] stringArray2 = null;
                String[] stringArray3 = null;
                ArrayList<PerfLevelDescriptor> arrayList = new ArrayList<PerfLevelDescriptor>(epmSpecArray.length);
                HashSet<String> hashSet = new HashSet<String>(epmSpecArray.length + 5);
                Object var9_11 = null;
                String string3 = null;
                String[] stringArray4 = null;
                for (int i = 0; i < epmSpecArray.length; ++i) {
                    stringArray3 = null;
                    stringArray4 = null;
                    stringArray = null;
                    stringArray2 = null;
                    stringArray3 = epmSpecArray[i].getPath();
                    if (stringArray3.length > 1) {
                        if (stringArray3[1].equals("transactionData") && stringArray3.length > 2 || stringArray3[1].equals("beanMethodData") && stringArray3.length < 4) continue;
                        stringArray2 = new String[stringArray3.length - 1];
                        System.arraycopy(stringArray3, 1, stringArray2, 0, stringArray2.length);
                        stringArray = EpmMapper.EpmPath2PmiPath(stringArray2, string, string2);
                        if (stringArray == null || hashSet.contains(string3 = EpmMapper.StringArrayToString(stringArray))) continue;
                        stringArray4 = new String[stringArray.length + 1];
                        stringArray4[0] = "pmi";
                        System.arraycopy(stringArray, 0, stringArray4, 1, stringArray.length);
                        if (string3.indexOf("threadPoolModule") != -1) {
                            String[] stringArray5 = new String[]{"pmi", "threadPoolModule"};
                            arrayList.add(new PerfLevelDescriptor(stringArray5, epmSpecArray[i].getLevel()));
                        } else if (string3.indexOf("webAppModule.servlets") != -1) {
                            int n = string3.indexOf("webAppModule.servlets");
                            StringBuffer stringBuffer = new StringBuffer(67);
                            stringBuffer.append(string3.substring(0, n + "webAppModule.servlets".length()));
                            if (!hashSet.contains(stringBuffer.toString())) {
                                String[] stringArray6 = new String[stringArray.length];
                                System.arraycopy(stringArray4, 0, stringArray6, 0, stringArray6.length);
                                arrayList.add(new PerfLevelDescriptor(stringArray6, epmSpecArray[i].getLevel()));
                                hashSet.add(stringBuffer.toString());
                            }
                        }
                        arrayList.add(new PerfLevelDescriptor(stringArray4, epmSpecArray[i].getLevel()));
                    } else {
                        arrayList.add(new PerfLevelDescriptor(null, epmSpecArray[i].getLevel()));
                    }
                    hashSet.add(string3);
                }
                PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[arrayList.size()];
                System.arraycopy(arrayList.toArray(), 0, perfLevelDescriptorArray, 0, perfLevelDescriptorArray.length);
                Tr.exit(tc, "getInstrumentationLevel");
                return perfLevelDescriptorArray;
            }
            catch (OpException opException) {
                if (this.debug) {
                    opException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!this.debug) break block12;
                remoteException.printStackTrace();
            }
        }
        return null;
    }

    public void enableData(String string, String string2, DataDescriptor[] dataDescriptorArray, boolean bl) {
        System.currentTimeMillis();
    }

    public void disableData(String string, String string2, DataDescriptor[] dataDescriptorArray, boolean bl) {
        System.currentTimeMillis();
    }

    public void disablePmi(String string, String string2) {
        block5: {
            try {
                Tr.entry(tc, "disablePMI");
                EpmSpec[] epmSpecArray = this.epmService.getEpmComponents(string, string2);
                for (int i = 0; i < epmSpecArray.length; ++i) {
                    epmSpecArray[i].setLevel(0);
                }
                this.epmService.setEpmComponents(string, string2, epmSpecArray);
                Tr.exit(tc, "getInstrumentationLevel");
            }
            catch (OpException opException) {
                if (this.debug) {
                    opException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!this.debug) break block5;
                remoteException.printStackTrace();
            }
        }
    }

    public boolean isAllLevelNone(String string, String string2) {
        block5: {
            try {
                Tr.entry(tc, "isAllLevelNone");
                EpmSpec[] epmSpecArray = this.epmService.getEpmComponents(string, string2);
                for (int i = 0; i < epmSpecArray.length; ++i) {
                    if (epmSpecArray[i].getLevel() == 0) continue;
                    Tr.exit(tc, "isAllLevelNone");
                    return false;
                }
            }
            catch (OpException opException) {
                if (this.debug) {
                    opException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!this.debug) break block5;
                remoteException.printStackTrace();
            }
        }
        Tr.exit(tc, "isAllLevelNone");
        return true;
    }

    public static String getLocalNodeName(boolean bl) throws UnknownHostException, RemoteException {
        Object object;
        Tr.entry(tc, "getLocalNodeName");
        InetAddress inetAddress = null;
        boolean bl2 = false;
        String string = null;
        inetAddress = Utils.getLocalHostIPAddress();
        string = inetAddress.getHostName();
        if (string == null) {
            string = inetAddress.getHostAddress();
            bl2 = true;
            Tr.event(tc, "IP address is used as node name");
        }
        if (bl && !bl2) {
            object = new StringTokenizer(string, ".");
            string = ((StringTokenizer)object).nextToken();
        }
        if (((String)(object = System.getProperty("os.name").toLowerCase())).indexOf("netware") != -1) {
            Tr.exit(tc, "getLocalNodeName");
            return string.toLowerCase();
        }
        Tr.exit(tc, "getLocalNodeName");
        return string;
    }

    private PerfValue getPerfValue(String string, String string2, DataDescriptor dataDescriptor, boolean bl) {
        try {
            if (dataDescriptor == null) {
                if (bl) {
                    return this.epmService.getRecursive(string, string2, null, true);
                }
                PerfValueGroup perfValueGroup = (PerfValueGroup)this.epmService.getRoots(string, string2);
                PerfValueGroup perfValueGroup2 = (PerfValueGroup)this.epmService.get(string, string2, "servletEngine.sessions");
                if (perfValueGroup2 != null) {
                    PerfValueGroup perfValueGroup3 = new PerfValueGroup();
                    PerfValueGroup perfValueGroup4 = (PerfValueGroup)perfValueGroup2.firstMember();
                    perfValueGroup3.setName(perfValueGroup4.getName());
                    perfValueGroup3.setUID(perfValueGroup4.getUID());
                    perfValueGroup3.setSnapshotTime(perfValueGroup4.getSnapshotTime());
                    perfValueGroup3.setTime(perfValueGroup4.getTime());
                    perfValueGroup.add((PerfValue)perfValueGroup3);
                }
                return perfValueGroup;
            }
            String[] stringArray = EpmMapper.PmiPath2EpmPath(dataDescriptor.getPath(), string, string2, bl);
            int n = stringArray.length;
            int n2 = 0;
            PerfValue perfValue = null;
            PerfValueGroup perfValueGroup = new PerfValueGroup();
            perfValueGroup.setName("EJBServerHome");
            for (n2 = 0; n2 < n; ++n2) {
                perfValue = !bl ? this.epmService.get(string, string2, stringArray[n2]) : this.epmService.getRecursive(string, string2, stringArray[n2], true);
                perfValueGroup.add(perfValue);
            }
            return perfValueGroup;
        }
        catch (Exception exception) {
            try {
                this.createEpmService();
                if (dataDescriptor == null) {
                    if (bl) {
                        return this.epmService.getRootsRecursive(string, string2);
                    }
                    PerfValueGroup perfValueGroup = (PerfValueGroup)this.epmService.getRoots(string, string2);
                    PerfValueGroup perfValueGroup5 = (PerfValueGroup)this.epmService.get(string, string2, "servletEngine.sessions");
                    if (perfValueGroup5 != null) {
                        PerfValueGroup perfValueGroup6 = new PerfValueGroup();
                        PerfValueGroup perfValueGroup7 = (PerfValueGroup)perfValueGroup5.firstMember();
                        perfValueGroup6.setName(perfValueGroup7.getName());
                        perfValueGroup6.setUID(perfValueGroup7.getUID());
                        perfValueGroup6.setSnapshotTime(perfValueGroup7.getSnapshotTime());
                        perfValueGroup6.setTime(perfValueGroup7.getTime());
                        perfValueGroup.add((PerfValue)perfValueGroup6);
                    }
                    return perfValueGroup;
                }
                String[] stringArray = EpmMapper.PmiPath2EpmPath(dataDescriptor.getPath(), string, string2, bl);
                int n = stringArray.length;
                int n3 = 0;
                PerfValue perfValue = null;
                PerfValueGroup perfValueGroup = new PerfValueGroup();
                perfValueGroup.setName("EJBServerHome");
                for (n3 = 0; n3 < n; ++n3) {
                    perfValue = !bl ? this.epmService.get(string, string2, stringArray[n3]) : this.epmService.getRecursive(string, string2, stringArray[n3], true);
                    perfValueGroup.add(perfValue);
                }
                return perfValueGroup;
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public void remove() {
        try {
            if (this.epmService != null) {
                this.epmService.remove();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
        EpmMapper.debug = bl;
    }

    public void setPmiClient(PmiClient pmiClient) {
        this.pmiClnt = pmiClient;
        if (pmiClient != null) {
            EpmMapper.setPmiConfigs(pmiClient.getConfigs());
        }
    }
}

