/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.perfServer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.pmi.PmiJmxMapper;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.client.PmiClient;
import com.ibm.websphere.pmi.extutils.AdminUtilClntImpl;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.websphere.pmi.stat.StatsImpl;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.pmi.perfServer.AbstractCollector;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.server.PmiJmxMapParser;
import com.ibm.ws.pmi.stat.StatsAdapter;
import com.ibm.ws.pmi.wire.WpdCollection;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CollectorJMX
extends AbstractCollector {
    public static final int RUNNING = 3;
    private PmiJmxMapper mapper = null;
    private AdminUtilClntImpl adminUtil = null;
    private ConfigServiceProxy configProxy = null;
    private HashMap pmiConfigMap = null;
    private HashMap acMap = null;
    private boolean isND = false;
    private String connectorType = "SOAP";
    private String port = "8880";
    private int collectorCount = 0;
    private String dmgrHost = null;
    private boolean includeDmgr = false;
    private String _sSecurity = null;
    private String _user = null;
    private String _password = null;
    private static final TraceComponent tc = Tr.register(CollectorJMX.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private boolean debug = false;

    public CollectorJMX(boolean bl) throws RemoteException {
        this(null, null, bl);
    }

    public CollectorJMX() throws RemoteException {
    }

    public CollectorJMX(String string, String string2, boolean bl) throws RemoteException {
        this.init(string, string2, bl);
    }

    public CollectorJMX(String string, String string2, boolean bl, String string3) throws RemoteException {
        this.init(string, string2, bl, string3, null);
    }

    public void init(String string, String string2, boolean bl) throws RemoteException {
        this.init(string, string2, bl, null, null);
    }

    public void init(String string, String string2, boolean bl, String string3, Properties properties) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CollectorJMX.init");
        }
        if (string3 != null) {
            this.connectorType = string3;
        }
        if (string2 != null) {
            this.port = string2;
        }
        if (properties == null) {
            properties = new Properties();
        } else {
            this._sSecurity = properties.getProperty("securityEnabled");
            this._user = properties.getProperty("username");
            this._password = properties.getProperty("password");
        }
        properties.setProperty("host", string);
        properties.setProperty("port", this.port);
        properties.setProperty("type", this.connectorType);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CollectorJMX.init() - connecting with " + string + ":" + this.port + ":" + this.connectorType);
        } else if (this.debug) {
            System.out.println("CollectorJMX.init() - connecting with " + string + ":" + this.port + ":" + this.connectorType);
        }
        try {
            this.mapper = new PmiJmxMapper(properties, bl, true);
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("CollectorJMX.init() - exception when connecting with " + string + ":" + this.port + ":" + this.connectorType);
            }
            throw new RemoteException("[CollectorJMX] Failed to initialize CollectorJMX. Error creating AdminClient", exception);
        }
        PmiJmxMapParser pmiJmxMapParser = new PmiJmxMapParser(this.mapper);
        pmiJmxMapParser.parse("/com/ibm/websphere/pmi/xml/pmiJmxMapper.xml");
        pmiJmxMapParser.parseExtensions();
        if (this.isNDVersion()) {
            this.isND = true;
            this.acMap = new HashMap();
            this.getDmgrInfo();
        }
        this.adminUtil = (AdminUtilClntImpl)this.mapper.getAdminUtil();
        if (this.adminUtil == null) {
            throw new RemoteException("Failed to initialize CollectorJMX - no AdminClient is created");
        }
        this.initConfigServiceProxy(this.adminUtil.getAdminClient());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CollectorJMX.init");
        }
    }

    public String getType() {
        return "WAS50";
    }

    public String[] listNodes() {
        ObjectName[] objectNameArray = null;
        ObjectName objectName = null;
        try {
            objectName = ConfigServiceHelper.createObjectName(null, "Node", null);
            objectNameArray = this.configProxy.queryConfigObjects(null, null, objectName, null);
        }
        catch (Exception exception) {
            if (this.debug) {
                exception.printStackTrace();
            }
            Tr.event(tc, "Caught exception in listNodes ; exception: " + exception);
            return null;
        }
        if (objectNameArray == null || objectNameArray.length == 0) {
            System.out.println("CollectorJMX.listNodes(): No node found");
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(objectNameArray.length);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = ConfigServiceHelper.getDisplayName(objectNameArray[i]);
            if (!this.includeDmgr && string.equals(this.dmgrHost)) continue;
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
            if (!this.debug) continue;
            System.out.println("[CollectorJMX]listNodes: return " + stringArray[i]);
        }
        return stringArray;
    }

    public String[] listServers(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServers " + string);
        }
        this.errCode = 0;
        this.errMsg = "";
        ObjectName[] objectNameArray = null;
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        boolean bl = false;
        Session session = new Session("pmiclient", true);
        try {
            objectName = ConfigServiceHelper.createObjectName(null, "Node", null);
            objectNameArray = this.configProxy.queryConfigObjects(session, null, objectName, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                if (!string.equals(ConfigServiceHelper.getDisplayName(objectNameArray[i]))) continue;
                objectName2 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                if (this.debug) {
                    System.out.println("[CollectorJmx]listServers: cannot find the node " + string);
                }
                try {
                    this.configProxy.discard(session);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            objectName = ConfigServiceHelper.createObjectName(null, "Server", null);
            objectNameArray = this.configProxy.queryConfigObjects(session, objectName2, objectName, null);
        }
        catch (Exception exception) {
            if (this.debug) {
                exception.printStackTrace();
            }
            Tr.event(tc, "Caught exception in initConfigServiceProxy ; exception: " + exception);
            try {
                this.configProxy.discard(session);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
        String[] stringArray = null;
        if (objectNameArray == null || objectNameArray.length == 0) {
            if (this.debug) {
                System.out.println("CollectorJMX:Error: cannot find any server for node " + string);
            }
        } else if (!this.isND) {
            stringArray = new String[objectNameArray.length];
            for (int i = 0; i < objectNameArray.length; ++i) {
                stringArray[i] = ConfigServiceHelper.getDisplayName(objectNameArray[i]);
                if (!this.debug) continue;
                System.out.println("CollectorJMX: listServers return base server " + stringArray[i]);
            }
        } else {
            int n;
            ArrayList<String> arrayList;
            block26: {
                ObjectName[] objectNameArray2 = null;
                arrayList = new ArrayList<String>(objectNameArray.length);
                AttributeList attributeList = null;
                try {
                    objectName = ConfigServiceHelper.createObjectName(null, "ServerEntry", null);
                    objectNameArray2 = this.configProxy.queryConfigObjects(session, objectName2, objectName, null);
                    if (objectNameArray2 != null) {
                        for (n = 0; n < objectNameArray2.length; ++n) {
                            attributeList = this.configProxy.getAttributes(session, objectNameArray2[n], null, false);
                            String string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "serverName");
                            String string3 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "serverType");
                            System.out.println("[CollectorJMX] name: " + string2 + " type: " + string3);
                            if (string3 == null || string2 == null) {
                                if (!this.debug) continue;
                                System.out.println("[CollectorJmx] null server type or name");
                                continue;
                            }
                            if (string3.equalsIgnoreCase("MESSAGE_BROKER") || string3.equalsIgnoreCase("DEPLOYMENT_MANAGER") || string3.equalsIgnoreCase("GENERIC_SERVER") || string3.equalsIgnoreCase("WEB_SERVER")) {
                                if (!this.debug) continue;
                                System.out.println("[CollectorJmx] filtered out server " + string2 + " with type " + string3);
                                continue;
                            }
                            arrayList.add(string2);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!this.debug) break block26;
                    System.out.println("[CollectorJmx] Caught Exception while querying ServerEntry ObjectNames:");
                    exception.printStackTrace();
                }
            }
            stringArray = new String[arrayList.size()];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = (String)arrayList.get(n);
                if (!this.debug) continue;
                System.out.println("[CollectorJMX]listServers return ND server " + stringArray[n]);
            }
        }
        try {
            this.configProxy.discard(session);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    public int getAdminState(String string) {
        ObjectName[] objectNameArray = this.mapper.findObjectNames(null, "Server", string, null);
        if (objectNameArray == null || objectNameArray.length == 0) {
            this.errCode = 11;
            return 5;
        }
        if (objectNameArray.length == 1) {
            return this.getAdminState(objectNameArray[0]);
        }
        for (int i = 0; i < objectNameArray.length; ++i) {
            if (!objectNameArray[i].getKeyProperty("processType").equals("NodeAgent")) continue;
            return this.getAdminState(objectNameArray[i]);
        }
        this.errCode = 11;
        return 5;
    }

    public int getAdminState(String string, String string2) {
        ObjectName objectName = this.mapper.findObjectName(null, "Server", string, string2);
        if (objectName == null) {
            this.errCode = 11;
            return 5;
        }
        AdminClient adminClient = this.getMyAdminClient(string, string2);
        if (adminClient == null) {
            return this.getAdminState(objectName);
        }
        try {
            String string3 = (String)adminClient.getAttribute(objectName, "state");
            if (string3 == null) {
                this.errCode = 11;
                return 5;
            }
            if (string3.equalsIgnoreCase("STARTED")) {
                return 3;
            }
            return 5;
        }
        catch (Exception exception) {
            if (this.debug) {
                exception.printStackTrace();
            }
            this.errCode = 11;
            return 5;
        }
    }

    public int getAdminState(ObjectName objectName) {
        if (objectName != null) {
            String string = (String)this.mapper.getAttribute(objectName, "state");
            if (string == null) {
                this.errCode = 11;
                return 5;
            }
            if (string.equalsIgnoreCase("STARTED")) {
                return 3;
            }
            return 5;
        }
        this.errCode = 11;
        return 5;
    }

    public WpdCollection get(String string, String string2, DataDescriptor dataDescriptor, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get");
        }
        this.errCode = 0;
        this.errMsg = "";
        return (WpdCollection)((Object)this.getStats(string, string2, dataDescriptor, bl));
    }

    public WpdCollection[] gets(String string, String string2, DataDescriptor[] dataDescriptorArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "gets");
        }
        this.errCode = 0;
        this.errMsg = "";
        if (dataDescriptorArray == null || dataDescriptorArray.length == 0) {
            return null;
        }
        Stats[] statsArray = this.getStats(string, string2, dataDescriptorArray, bl);
        if (statsArray == null || statsArray.length == 0) {
            return null;
        }
        WpdCollection[] wpdCollectionArray = new WpdCollection[statsArray.length];
        for (int i = 0; i < wpdCollectionArray.length; ++i) {
            wpdCollectionArray[i] = (WpdCollection)((Object)statsArray[i]);
        }
        return wpdCollectionArray;
    }

    public DataDescriptor[] listMembers(String string, String string2, DataDescriptor dataDescriptor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listMembers");
        }
        this.errCode = 0;
        this.errMsg = "";
        return this.listStatMembers(string, string2, dataDescriptor);
    }

    public PmiModuleConfig[] getConfigs() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigs");
        }
        this.errCode = 0;
        this.errMsg = "";
        String[] stringArray = this.listNodes();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigs");
        }
        if (stringArray == null || stringArray.length < 1) {
            return null;
        }
        return this.getConfigs(stringArray[0]);
    }

    public PmiModuleConfig[] getConfigs(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigs(nodeName)");
        }
        this.errCode = 0;
        this.errMsg = "";
        try {
            if (string == null) {
                return null;
            }
            String[] stringArray = this.listServers(string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConfigs(nodeName)");
            }
            if (stringArray == null || stringArray.length < 1) {
                return null;
            }
            return this.getConfigs(string, stringArray[0]);
        }
        catch (Exception exception) {
            if (this.debug) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    public PmiModuleConfig[] getConfigs(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigs");
        }
        this.errCode = 0;
        this.errMsg = "";
        return (PmiModuleConfig[])this.invoke(string, string2, "getConfigs", null, null, 10);
    }

    public PerfLevelDescriptor[] getInstrumentationLevel(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstrumentationLevel");
        }
        this.errCode = 0;
        this.errMsg = "";
        DataDescriptor dataDescriptor = new DataDescriptor(new String[]{"pmi"});
        return this.getInstrumentationLevel(string, string2, dataDescriptor, true);
    }

    public void enableData(String string, String string2, DataDescriptor[] dataDescriptorArray, boolean bl) {
    }

    public void disableData(String string, String string2, DataDescriptor[] dataDescriptorArray, boolean bl) {
    }

    public void disablePmi(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disablePmi");
        }
        this.errCode = 0;
        this.errMsg = "";
        this.setInstrumentationLevel(string, string2, new PerfLevelDescriptor(new String[]{"pmi"}, 0), true);
    }

    public boolean isAllLevelNone(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAllLevelNone");
        }
        this.errCode = 0;
        this.errMsg = "";
        PerfLevelDescriptor[] perfLevelDescriptorArray = this.getInstrumentationLevel(string, string2);
        for (int i = 0; i < perfLevelDescriptorArray.length; ++i) {
            if (perfLevelDescriptorArray[i].getLevel() == 0) continue;
            return false;
        }
        return true;
    }

    private Stats _convertTo50Format(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof WSStats) {
            return (Stats)StatsAdapter.createWAS5Stats((WSStats)object);
        }
        return (Stats)object;
    }

    private Stats[] _convertTo50Format2(Object[] objectArray) {
        if (objectArray instanceof WSStats[]) {
            return (Stats[])StatsAdapter.createWAS5Stats((WSStats[])objectArray);
        }
        return (Stats[])objectArray;
    }

    public Stats getStats(String string, String string2, DataDescriptor dataDescriptor, boolean bl) {
        if (dataDescriptor == null) {
            return null;
        }
        this.errCode = 0;
        this.errMsg = "";
        Object[] objectArray = new Object[]{dataDescriptor, new Boolean(bl)};
        String[] stringArray = new String[]{"com.ibm.ws.pmi.server.DataDescriptor", "java.lang.Boolean"};
        return this._convertTo50Format(this.invoke(string, string2, "getStatsObject", objectArray, stringArray, 10));
    }

    public Stats[] getStats(String string, String string2, DataDescriptor[] dataDescriptorArray, boolean bl) {
        if (dataDescriptorArray == null || dataDescriptorArray.length == 0) {
            return null;
        }
        this.errCode = 0;
        this.errMsg = "";
        Object[] objectArray = new Object[]{dataDescriptorArray, new Boolean(bl)};
        String[] stringArray = new String[]{"[Lcom.ibm.ws.pmi.server.DataDescriptor;", "java.lang.Boolean"};
        Object[] objectArray2 = (Object[])this.invoke(string, string2, "getStatsArray", objectArray, stringArray, 10);
        return this._convertTo50Format2(objectArray2);
    }

    public DataDescriptor[] listStatMembers(String string, String string2, DataDescriptor dataDescriptor) {
        Object[] objectArray = new Object[]{dataDescriptor};
        String[] stringArray = new String[]{"com.ibm.ws.pmi.server.DataDescriptor"};
        return (DataDescriptor[])this.invoke(string, string2, "listStatMembers", objectArray, stringArray, 10);
    }

    public void setInstrumentationLevel(String string, String string2, PerfLevelDescriptor perfLevelDescriptor, boolean bl) {
        if (perfLevelDescriptor == null) {
            return;
        }
        this.errCode = 0;
        this.errMsg = "";
        Object[] objectArray = new Object[]{perfLevelDescriptor, new Boolean(bl)};
        String[] stringArray = new String[]{"com.ibm.ws.pmi.server.PerfLevelDescriptor", "java.lang.Boolean"};
        this.invoke(string, string2, "setInstrumentationLevel", objectArray, stringArray, 8);
        PerfLevelDescriptor[] perfLevelDescriptorArray = new PerfLevelDescriptor[]{perfLevelDescriptor};
        this.persistConfigData(string, string2);
    }

    private void persistConfigData(String string, String string2) {
        this.invoke(string, string2, "savePMIConfiguration", null, null, 8);
    }

    public void setInstrumentationLevel(String string, String string2, PerfLevelDescriptor[] perfLevelDescriptorArray, boolean bl) {
        if (perfLevelDescriptorArray == null || perfLevelDescriptorArray.length == 0) {
            return;
        }
        this.errCode = 0;
        this.errMsg = "";
        Object[] objectArray = new Object[]{perfLevelDescriptorArray, new Boolean(bl)};
        String[] stringArray = new String[]{"[Lcom.ibm.ws.pmi.server.PerfLevelDescriptor;", "java.lang.Boolean"};
        this.invoke(string, string2, "setInstrumentationLevel", objectArray, stringArray, 8);
        this.persistConfigData(string, string2);
    }

    public PerfLevelDescriptor[] getInstrumentationLevel(String string, String string2, DataDescriptor dataDescriptor, boolean bl) {
        if (dataDescriptor == null) {
            return null;
        }
        Object[] objectArray = new Object[]{dataDescriptor, new Boolean(bl)};
        String[] stringArray = new String[]{"com.ibm.ws.pmi.server.DataDescriptor", "java.lang.Boolean"};
        return (PerfLevelDescriptor[])this.invoke(string, string2, "getInstrumentationLevel", objectArray, stringArray, 9);
    }

    public Stats getStats(String string, String string2, MBeanStatDescriptor mBeanStatDescriptor, boolean bl) {
        if (mBeanStatDescriptor == null) {
            return null;
        }
        this.errCode = 0;
        this.errMsg = "";
        Object[] objectArray = new Object[]{mBeanStatDescriptor, new Boolean(bl)};
        String[] stringArray = new String[]{"com.ibm.websphere.pmi.stat.MBeanStatDescriptor", "java.lang.Boolean"};
        return this._convertTo50Format(this.invoke(string, string2, "getStatsObject", objectArray, stringArray, 10));
    }

    public Stats[] getStats(String string, String string2, MBeanStatDescriptor[] mBeanStatDescriptorArray, boolean bl) {
        if (mBeanStatDescriptorArray == null || mBeanStatDescriptorArray.length == 0) {
            return null;
        }
        this.errCode = 0;
        this.errMsg = "";
        Object[] objectArray = new Object[]{mBeanStatDescriptorArray, new Boolean(bl)};
        String[] stringArray = new String[]{"[Lcom.ibm.websphere.pmi.stat.MBeanStatDescriptor;", "java.lang.Boolean"};
        Stats[] statsArray = this._convertTo50Format2((Object[])this.invoke(string, string2, "getStatsArray", objectArray, stringArray, 10));
        statsArray = this.filterStats(statsArray, mBeanStatDescriptorArray, string, string2);
        return statsArray;
    }

    public Stats[] filterStats(Stats[] statsArray, MBeanStatDescriptor[] mBeanStatDescriptorArray, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterStats(Stats []stats,MBeanStatDescriptor [] msds, String nodeName,String serverName)");
        }
        if (statsArray == null || mBeanStatDescriptorArray == null) {
            if (this.debug) {
                System.out.println("CollectorJMX: null stats returned from getStats");
            }
            return null;
        }
        if (statsArray.length != mBeanStatDescriptorArray.length) {
            mBeanStatDescriptorArray = this.findFilteredMSDs(statsArray, mBeanStatDescriptorArray);
            return null;
        }
        Stats[] statsArray2 = new Stats[statsArray.length];
        Stats[] statsArray3 = new Stats[1];
        for (int i = 0; i < statsArray.length; ++i) {
            statsArray3[0] = statsArray[i];
            if (mBeanStatDescriptorArray[i] != null) {
                DataDescriptor dataDescriptor = this.mapper.getDataDescriptor(mBeanStatDescriptorArray[i]);
                if (dataDescriptor != null) {
                    String[] stringArray;
                    String[] stringArray2 = dataDescriptor.getPath();
                    if (dataDescriptor.getName().equals("pmi")) {
                        stringArray = new String[]{string, string2};
                    } else {
                        stringArray = new String[stringArray2.length + 2];
                        stringArray[0] = string;
                        stringArray[1] = string2;
                        System.arraycopy(stringArray2, 0, stringArray, 2, stringArray2.length);
                    }
                    statsArray3 = this.filterStats(statsArray3, PmiClient.createPerfDescriptor(stringArray), string, string2, true);
                }
            } else {
                statsArray3 = this.filterStats(statsArray3, PmiClient.createPerfDescriptor(new String[]{string, string2}), string, string2, true);
            }
            if (statsArray3 == null || statsArray3.length == 0) {
                statsArray2[i] = null;
                statsArray3 = new Stats[1];
                continue;
            }
            statsArray2[i] = statsArray3[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterStats(Stats []stats,MBeanStatDescriptor [] msds, String nodeName,String serverName)");
        }
        return statsArray2;
    }

    public MBeanStatDescriptor[] findFilteredMSDs(Stats[] statsArray, MBeanStatDescriptor[] mBeanStatDescriptorArray) {
        Tr.error(tc, "CollectorJMX:filterStats() missing some MBeans. Returning null for getStats query");
        return null;
    }

    public Stats[] filterStats(Stats[] statsArray, PerfDescriptor perfDescriptor, String string, String string2, boolean bl) {
        if (statsArray == null) {
            return null;
        }
        StatsImpl statsImpl = null;
        ArrayList<StatsImpl> arrayList = new ArrayList<StatsImpl>();
        PerfDescriptor perfDescriptor2 = null;
        for (int i = 0; i < statsArray.length; ++i) {
            Stats[] statsArray2;
            Serializable serializable;
            statsImpl = (StatsImpl)statsArray[i];
            if (statsArray[i] == null) continue;
            if (perfDescriptor == null) {
                perfDescriptor2 = statsImpl.getType() == 11 ? PmiClient.createPerfDescriptor(new String[]{string}) : (statsImpl.getType() == 12 ? PmiClient.createPerfDescriptor(new String[]{string, string2}) : PmiClient.createPerfDescriptor(new String[]{string, string2, statsImpl.getName()}));
            } else {
                if (!bl) {
                    serializable = this.getTopLevelPd(perfDescriptor, statsImpl.getType());
                    perfDescriptor2 = PmiClient.createPerfDescriptor(serializable, statsImpl.getName());
                    bl = false;
                } else {
                    perfDescriptor2 = perfDescriptor;
                }
                if (perfDescriptor2 == null) {
                    return null;
                }
            }
            if (!this.hasMBeanMapping(statsImpl, perfDescriptor2, string, string2)) continue;
            arrayList.add(statsImpl);
            serializable = null;
            Stats[] statsArray3 = statsImpl.listSubStats();
            statsImpl.setSubStats((ArrayList)serializable);
            if (statsArray3 == null || statsArray3.length <= 0 || (statsArray2 = this.filterStats(statsArray3, perfDescriptor2, string, string2, false)) == null || statsArray2.length <= 0) continue;
            serializable = new ArrayList<Stats>(Arrays.asList(statsArray2));
            statsImpl.setSubStats((ArrayList)serializable);
        }
        Stats[] statsArray4 = new Stats[arrayList.size()];
        for (int i = 0; i < statsArray4.length; ++i) {
            statsArray4[i] = (Stats)arrayList.get(i);
        }
        return statsArray4;
    }

    private PerfDescriptor getTopLevelPd(PerfDescriptor perfDescriptor, int n) {
        if (perfDescriptor.getServerName() == null && perfDescriptor.getDataDescriptor() != null) {
            return PmiClient.createPerfDescriptor(new String[]{perfDescriptor.getNodeName()});
        }
        if (perfDescriptor.getType() != 18) {
            return perfDescriptor;
        }
        return PmiClient.createPerfDescriptor(perfDescriptor.getPath());
    }

    private boolean hasMBeanMapping(Stats stats, PerfDescriptor perfDescriptor, String string, String string2) {
        DataDescriptor dataDescriptor = perfDescriptor.getDataDescriptor();
        MBeanStatDescriptor mBeanStatDescriptor = this.mapper.getMBeanStatDescriptor(dataDescriptor, string, string2);
        return mBeanStatDescriptor != null;
    }

    public ObjectName[] listMBeans(String string, String string2) {
        return this.mapper.findObjectNames(null, null, string, string2);
    }

    public MBeanStatDescriptor[] listStatMembers(String string, String string2, ObjectName objectName) {
        Object[] objectArray = new Object[]{objectName};
        String[] stringArray = new String[]{"javax.management.ObjectName"};
        return (MBeanStatDescriptor[])this.invoke(string, string2, "listStatMembers", objectArray, stringArray, 10);
    }

    public MBeanStatDescriptor[] listStatMembers(String string, String string2, MBeanStatDescriptor mBeanStatDescriptor) {
        Object[] objectArray = new Object[]{mBeanStatDescriptor};
        String[] stringArray = new String[]{"com.ibm.websphere.pmi.stat.MBeanStatDescriptor"};
        return (MBeanStatDescriptor[])this.invoke(string, string2, "listStatMembers", objectArray, stringArray, 10);
    }

    public void setInstrumentationLevel(String string, String string2, MBeanLevelSpec mBeanLevelSpec, boolean bl) {
        if (mBeanLevelSpec == null) {
            return;
        }
        Object[] objectArray = new Object[]{mBeanLevelSpec, new Boolean(bl)};
        String[] stringArray = new String[]{"com.ibm.websphere.pmi.stat.MBeanLevelSpec", "java.lang.Boolean"};
        this.invoke(string, string2, "setInstrumentationLevel", objectArray, stringArray, 8);
        MBeanLevelSpec[] mBeanLevelSpecArray = new MBeanLevelSpec[]{mBeanLevelSpec};
        this.persistConfigData(string, string2);
    }

    public void setInstrumentationLevel(String string, String string2, MBeanLevelSpec[] mBeanLevelSpecArray, boolean bl) {
        if (mBeanLevelSpecArray == null || mBeanLevelSpecArray.length == 0) {
            return;
        }
        Object[] objectArray = new Object[]{mBeanLevelSpecArray, new Boolean(bl)};
        String[] stringArray = new String[]{"[Lcom.ibm.websphere.pmi.stat.MBeanLevelSpec;", "java.lang.Boolean"};
        this.invoke(string, string2, "setInstrumentationLevel", objectArray, stringArray, 8);
        this.persistConfigData(string, string2);
    }

    public MBeanLevelSpec[] getInstrumentationLevel(String string, String string2, MBeanStatDescriptor mBeanStatDescriptor, boolean bl) {
        if (mBeanStatDescriptor == null) {
            return null;
        }
        Object[] objectArray = new Object[]{mBeanStatDescriptor, new Boolean(bl)};
        String[] stringArray = new String[]{"com.ibm.websphere.pmi.stat.MBeanStatDescriptor", "java.lang.Boolean"};
        return (MBeanLevelSpec[])this.invoke(string, string2, "getInstrumentationLevel", objectArray, stringArray, 9);
    }

    public PmiModuleConfig getConfig(String string, String string2, ObjectName objectName) {
        if (objectName == null) {
            return null;
        }
        Object[] objectArray = new Object[]{objectName};
        String[] stringArray = new String[]{"javax.management.ObjectName"};
        return (PmiModuleConfig)this.invoke(string, string2, "getConfig", objectArray, stringArray, 10);
    }

    public void initConfigServiceProxy(AdminClient adminClient) {
        try {
            this.configProxy = new ConfigServiceProxy(adminClient);
        }
        catch (Exception exception) {
            if (this.debug) {
                exception.printStackTrace();
                System.out.println("CollectorJMX: \nWarning: exception to create ConfigServiceProxy.");
                System.out.println("You may still get PMI data, but you cannot save the PMI level change in the server config file.");
                System.out.println("To save the level settings in server config file(s) in WAS ND, you have to connect to NetManager");
            }
            return;
        }
        ObjectName[] objectNameArray = null;
        ObjectName[] objectNameArray2 = null;
        ObjectName objectName = null;
        this.pmiConfigMap = new HashMap();
        Session session = new Session("pmiclient", true);
        try {
            objectName = ConfigServiceHelper.createObjectName(null, "Node", null);
            objectNameArray = this.configProxy.queryConfigObjects(session, null, objectName, null);
        }
        catch (Exception exception) {
            Tr.event(tc, "Caught exception in initConfigServiceProxy ; exception: " + exception);
            try {
                this.configProxy.discard(session);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return;
        }
        if (objectNameArray == null || objectNameArray.length == 0) {
            if (this.debug) {
                System.out.println("CollectorJMX: Error: cannot find any node");
            }
        } else {
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string = ConfigServiceHelper.getDisplayName(objectNameArray[i]);
                try {
                    objectName = ConfigServiceHelper.createObjectName(null, "Server", null);
                    objectNameArray2 = this.configProxy.queryConfigObjects(session, objectNameArray[i], objectName, null);
                }
                catch (Exception exception) {
                    Tr.event(tc, "Caught exception in initConfigServiceProxy ; exception: " + exception);
                    break;
                }
                if (objectNameArray2 == null || objectNameArray2.length == 0) {
                    if (!this.debug) break;
                    System.out.println("CollectorJMX: Error: cannot find any server");
                    break;
                }
                ObjectName[] objectNameArray3 = null;
                for (int j = 0; j < objectNameArray2.length; ++j) {
                    try {
                        String string2 = ConfigServiceHelper.getDisplayName(objectNameArray2[j]);
                        objectName = ConfigServiceHelper.createObjectName(null, "PMIService", null);
                        objectNameArray3 = this.configProxy.queryConfigObjects(session, objectNameArray2[j], objectName, null);
                        if (objectNameArray3 != null && objectNameArray3.length == 1) {
                            String string3 = string + "/" + string2;
                            this.pmiConfigMap.put(string3, objectNameArray3[0]);
                            continue;
                        }
                        if (!this.debug) continue;
                        System.out.println("CollectorJMX: Warning: could not get PMIService config object for server " + string2);
                        continue;
                    }
                    catch (Exception exception) {
                        if (!this.debug) continue;
                        exception.printStackTrace();
                    }
                }
            }
        }
        try {
            this.configProxy.discard(session);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ObjectName getPmiService(String string, String string2, Session session) {
        if (this.pmiConfigMap == null) {
            Tr.warning(tc, "CollectorJMX: null pmiConfigMap");
            return null;
        }
        String string3 = string + "/" + string2;
        ObjectName objectName = (ObjectName)this.pmiConfigMap.get(string3);
        if (objectName != null) {
            return objectName;
        }
        ObjectName[] objectNameArray = null;
        ObjectName objectName2 = null;
        ObjectName objectName3 = null;
        boolean bl = false;
        try {
            int n;
            objectName2 = ConfigServiceHelper.createObjectName(null, "Node", null);
            objectNameArray = this.configProxy.queryConfigObjects(session, null, objectName2, null);
            if (objectNameArray != null) {
                for (n = 0; n < objectNameArray.length; ++n) {
                    if (!string.equals(ConfigServiceHelper.getDisplayName(objectNameArray[n]))) continue;
                    objectName3 = objectNameArray[n];
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                if (this.debug) {
                    System.out.println("[CollectorJmx]getPmiService: cannot find the node " + string);
                }
                return null;
            }
            bl = false;
            objectName2 = ConfigServiceHelper.createObjectName(null, "Server", null);
            objectNameArray = this.configProxy.queryConfigObjects(session, objectName3, objectName2, null);
            if (objectNameArray != null) {
                for (n = 0; n < objectNameArray.length; ++n) {
                    if (!string2.equals(ConfigServiceHelper.getDisplayName(objectNameArray[n]))) continue;
                    objectName3 = objectNameArray[n];
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                if (this.debug) {
                    System.out.println("[CollectorJmx]getPmiService: cannot find the server " + string2);
                }
                return null;
            }
            objectName2 = ConfigServiceHelper.createObjectName(null, "PMIService", null);
            ObjectName[] objectNameArray2 = this.configProxy.queryConfigObjects(session, objectName3, objectName2, null);
            if (objectNameArray2 != null && objectNameArray2.length == 1) {
                this.pmiConfigMap.put(string3, objectNameArray2[0]);
                if (this.debug) {
                    System.out.println("[CollectorJMX]getPmiService: find PMIService for server " + string3);
                }
                return objectNameArray2[0];
            }
            if (this.debug) {
                System.out.println("CollectorJMX: Warning: could not get PMIService config object for server " + string3);
            }
        }
        catch (Exception exception) {
            if (this.debug) {
                exception.printStackTrace();
            }
            Tr.event(tc, "Caught exception in initConfigServiceProxy ; exception: " + exception);
            return null;
        }
        return null;
    }

    private Object invoke(String string, String string2, String string3, Object[] objectArray, String[] stringArray, int n) {
        ObjectName objectName = this.mapper.findObjectName(null, "Perf", string, string2);
        if (objectName == null) {
            this.errCode = 16;
            this.errMsg = "No PerfMBean is found. Make sure PMI is enabled on the server";
            return null;
        }
        AdminClient adminClient = this.getMyAdminClient(string, string2);
        Object object = null;
        if (adminClient != null) {
            try {
                object = adminClient.invoke(objectName, string3, objectArray, stringArray);
            }
            catch (Exception exception) {
                if (this.debug) {
                    exception.printStackTrace();
                    System.out.println("CollectorJMX: Server may be stopped. Reconnecting now ...");
                }
                try {
                    adminClient.isAlive();
                    object = adminClient.invoke(objectName, string3, objectArray, stringArray);
                }
                catch (Exception exception2) {
                    if (this.debug) {
                        exception2.printStackTrace();
                        new AdminException(exception2).printStackTrace();
                        System.out.println("CollectorJMX: Exception to invoke on perf=" + objectName + ", opName=" + string3);
                    }
                    this.errCode = 10;
                    this.errMsg = "Exception to invoke " + string3 + " method for server=" + string2;
                    object = null;
                }
            }
        } else {
            object = this.mapper.invoke(objectName, string3, objectArray, stringArray);
        }
        if (object == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "WARNING: op=" + string3 + " returns null");
        }
        return object;
    }

    private AdminClient getMyAdminClient(String string, String string2) {
        if (!this.isND) {
            return null;
        }
        String string3 = string + "/" + string2;
        AdminClient adminClient = (AdminClient)this.acMap.get(string3);
        if (adminClient != null) {
            if (this.debug) {
                System.out.println("CollectorJMX: find AdminClient in cache: server=" + string3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "find AdminClient in cache: server=" + string3);
            }
            return adminClient;
        }
        if (this.configProxy == null) {
            Tr.warning(tc, "CollectorJMX: null configProxy");
            return null;
        }
        AdminClient adminClient2 = null;
        Session session = new Session("pmiclient", true);
        for (int i = 0; i < 2; ++i) {
            block28: {
                Properties properties;
                String string4;
                Integer n;
                AttributeList attributeList;
                ObjectName[] objectNameArray;
                String string5;
                if (i == 0 && this.connectorType.equals("RMI") || i == 1 && !this.connectorType.equals("RMI")) {
                    if (this.debug) {
                        System.out.println("CollectorJMX: get RMI connector for server " + string3);
                    }
                    try {
                        string5 = "Node=" + string + " : Server = " + string2 + ":NameServer";
                        objectNameArray = this.configProxy.resolve(session, string5);
                        if (objectNameArray == null || objectNameArray.length != 1) continue;
                        attributeList = (AttributeList)this.configProxy.getAttribute(session, objectNameArray[0], "BOOTSTRAP_ADDRESS");
                        n = (Integer)ConfigServiceHelper.getAttributeValue(attributeList, "port");
                        string4 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "host");
                        properties = new Properties();
                        properties.put("type", "RMI");
                        properties.put("host", string4);
                        properties.put("port", n.toString());
                        if (this._sSecurity != null && this._user != null && this._password != null) {
                            properties.setProperty("securityEnabled", this._sSecurity);
                            properties.setProperty("username", this._user);
                            properties.setProperty("password", this._password);
                        }
                        if ((adminClient2 = AdminClientFactory.createAdminClient(properties)) != null && tc.isDebugEnabled()) {
                            Tr.debug(tc, "successfully get AdminClient for server " + string3 + ",port=" + n + ", RMI");
                        }
                        if (adminClient2 == null || !this.connectorType.equals("RMI")) continue;
                        if (this.debug) {
                            System.out.println("CollectorJMX: Successfully get AdminClient for server " + string3 + ",port=" + n + ", RMI");
                        }
                        this.acMap.put(string3, adminClient2);
                        try {
                            this.configProxy.discard(session);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return adminClient2;
                    }
                    catch (Exception exception) {
                        if (!this.debug) continue;
                        System.out.println("CollectorJMX: Exception to get adminclient via RMI for server " + string3);
                        new AdminException(exception).printStackTrace();
                    }
                    continue;
                }
                try {
                    string5 = "Node=" + string + " : Server = " + string2 + " : AdminService=:SOAPConnector ";
                    objectNameArray = this.configProxy.resolve(session, string5);
                    if (objectNameArray != null && objectNameArray.length == 1) {
                        attributeList = (AttributeList)this.configProxy.getAttribute(session, objectNameArray[0], "SOAP_CONNECTOR_ADDRESS");
                        n = (Integer)ConfigServiceHelper.getAttributeValue(attributeList, "port");
                        string4 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "host");
                        properties = new Properties();
                        properties.put("type", "SOAP");
                        properties.put("host", string4);
                        properties.put("port", n.toString());
                        if (this._sSecurity != null && this._user != null && this._password != null) {
                            properties.setProperty("securityEnabled", this._sSecurity);
                            properties.setProperty("username", this._user);
                            properties.setProperty("password", this._password);
                        }
                        if ((adminClient = AdminClientFactory.createAdminClient(properties)) != null) {
                            if (this.debug) {
                                System.out.println("CollectorJMX: Successfully get AdminClient for server " + string3 + ", port=" + n + ", SOAP");
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "successfully get AdminClient for server " + string3 + ", port=" + n + ", SOAP");
                            }
                            this.acMap.put(string3, adminClient);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!this.debug) break block28;
                    exception.printStackTrace();
                }
            }
            try {
                this.configProxy.discard(session);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (adminClient != null) {
                return adminClient;
            }
            if (adminClient2 == null) continue;
            this.acMap.put(string3, adminClient2);
            return adminClient2;
        }
        if (session != null) {
            try {
                this.configProxy.discard(session);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.acMap.put(string3, this.adminUtil.getAdminClient());
        return this.adminUtil.getAdminClient();
    }

    private void getDmgrInfo() {
        ObjectName[] objectNameArray = this.mapper.findObjectNames(null, "Server", null, null);
        if (objectNameArray == null || objectNameArray.length == 0) {
            return;
        }
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = objectNameArray[i].getKeyProperty("processType");
            if (!string.equals("DeploymentManager")) continue;
            ObjectName objectName = this.mapper.findObjectName(null, "Perf", objectNameArray[i].getKeyProperty("node"), objectNameArray[i].getKeyProperty("process"));
            if (objectName != null) {
                this.includeDmgr = true;
            }
            this.dmgrHost = objectNameArray[i].getKeyProperty("node");
        }
    }

    public boolean isNDVersion() {
        ObjectName[] objectNameArray = this.mapper.findObjectNames(null, "Server", null, null);
        if (objectNameArray == null || objectNameArray.length == 0) {
            return false;
        }
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = objectNameArray[i].getKeyProperty("processType");
            if (!string.equalsIgnoreCase("DeploymentManager")) continue;
            return true;
        }
        return false;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
        this.adminUtil.setDebug(bl);
    }
}

