/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmStack;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmTx;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.asynchbeans.AsynchBeansServiceCollaborator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ServiceNotRegisteredException;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsXfc;
import com.ibm.ws.pmi.reqmetrics.PmiRmActivityService;
import com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper;
import com.ibm.ws.pmi.reqmetrics.PmiRmCallContext;
import com.ibm.ws.pmi.reqmetrics.PmiRmConfigData;
import com.ibm.ws.pmi.reqmetrics.PmiRmCorrelator;
import com.ibm.ws.pmi.reqmetrics.PmiRmEJBCollaborator;
import com.ibm.ws.pmi.reqmetrics.PmiRmFilterConfig;
import com.ibm.ws.pmi.reqmetrics.PmiRmJmxService;
import com.ibm.ws.pmi.reqmetrics.PmiRmProcessLevelInfo;
import com.ibm.ws.pmi.reqmetrics.PmiRmRegistration;
import com.ibm.ws.pmi.reqmetrics.PmiRmThreadCtx;
import com.ibm.ws.pmi.reqmetrics.PmiRmThreadCtxPool;
import com.ibm.ws.pmi.reqmetrics.PmiRmThreadLocal;
import com.ibm.ws.pmi.reqmetrics.PmiRmUtil;
import com.ibm.ws.pmi.reqmetrics.ReqMetricsAsyncBeanServiceImpl;
import com.ibm.ws.pmi.reqmetrics.WebAppReqMetricsListener;
import com.ibm.ws.pmi.reqmetrics.extensibleFilter.ExtensibleFilterContainer;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.pmi.reqmetrics.PmiRmArmComponentCallback;
import com.ibm.wsspi.pmi.reqmetrics.PmiRmArmTransactionCallback;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Properties;

public class PmiReqMetricsImpl
implements PmiReqMetricsXfc {
    private static final String SOURCE_FILE = "com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";
    private static final String FFDC_ID_7 = "FFDC-7";
    private static final String FFDC_ID_8 = "FFDC-8";
    private static final String FFDC_ID_9 = "FFDC-9";
    private static final String FFDC_ID_10 = "FFDC-10";
    private static final String LITE_SERVICE_NAME = "PMI.RequestMetrics";
    protected static boolean _rmNotEnabled = true;
    private static boolean isAgentOrDmgr = false;
    private static boolean passCorrelatorToDB = false;
    protected PmiRmActivityService pmirmAS = null;
    private static final int ARM_CORRELATOR_INDEX = 0;
    private static final int RM_CORRELATOR_INDEX = 1;
    public static final String RM_LOG_ENABLE_PROPERTY = "com.ibm.websphere.pmi.reqmetrics.loggingEnabled";
    private PmiRmConfigData _curConfig = null;
    protected boolean _fLiteServiceInitialized = false;
    protected PmiRmConfigData _newConfig = null;
    protected PmiRmProcessLevelInfo _procInfo = null;
    private static PmiReqMetricsImpl _instance = null;
    protected PmiRmThreadLocal _tls = null;
    protected static PmiRmArmWrapper _armWrapper = null;
    protected static AsynchBeansServiceCollaborator abSvc = null;
    private static boolean abSvcRegistered = false;
    private static PmiRmArmTransactionCallback armCallback = null;
    private static boolean[] componentsEnabledInArmCallback = null;
    private static final String[] nullCors = new String[]{null, null};
    protected static boolean isArmInitSuccess = true;
    public static final boolean isZOS = AdminHelper.getPlatformHelper().isZOS();
    protected static boolean _tranDetailSupported = true;
    private static final TraceComponent tc = Tr.register(PmiReqMetricsImpl.class.getName(), "pmi.rm", "com.ibm.ws.pmi.reqmetrics.reqmetrics");
    private int armType = -1;
    private static final String genericInboundName = "INBOUND";
    private static boolean needMethodInfo = false;
    private static boolean trDebug = false;

    public PmiReqMetricsImpl() {
        this.init_internal(new PmiRmConfigData());
    }

    public PmiReqMetricsImpl(PmiRmConfigData pmiRmConfigData) {
        this.init_internal(pmiRmConfigData);
    }

    public boolean isEnabled() {
        return !_rmNotEnabled;
    }

    public boolean isReallyEnabled() {
        if (_rmNotEnabled) {
            return false;
        }
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        return pmiRmConfigData.isRmReallyEnabled();
    }

    public boolean isARMEnabled() {
        if (_rmNotEnabled) {
            return false;
        }
        boolean bl = false;
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        bl = pmiRmConfigData.isRmEnabled() && pmiRmConfigData.isARMEnabled() && isArmInitSuccess;
        return bl;
    }

    public boolean isLogEnabled() {
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        return pmiRmConfigData.isLogEnabled();
    }

    public int getTraceLevel() {
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        return pmiRmConfigData.getTraceLevel();
    }

    public int getTranDetailLevel(Object object, int n) {
        if (_rmNotEnabled) {
            return 0;
        }
        if (!_tranDetailSupported || armCallback == null || !PmiReqMetricsImpl.getConfig().isARMEnabled()) {
            return 1;
        }
        boolean bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        int n2 = armCallback.getTraceDetail();
        if (n2 != -1) {
            if (bl) {
                Tr.debug(tc, "getTranDetailLevel, return shared level for all components/transactions: " + n2);
            }
            return n2;
        }
        byte[] byArray = PmiRmArmWrapper.getArmCorrelator(object);
        if (byArray == null) {
            if (bl) {
                Tr.debug(tc, "getTranDetailLevel, null ARM correlator bytes passed to isTraceEnabled, returns default in this case");
            }
            return 1;
        }
        PmiRmArmComponentCallback pmiRmArmComponentCallback = armCallback.getComponentCallback(byArray);
        if (pmiRmArmComponentCallback == null) {
            if (bl) {
                Tr.debug(tc, "getTranDetailLevel return 1");
            }
            return 1;
        }
        n2 = pmiRmArmComponentCallback.getTraceDetail(n);
        if (bl) {
            Tr.debug(tc, "getTranDetailLevel return " + n2);
        }
        return n2;
    }

    public boolean isComponentEnabled(int n) {
        if (_rmNotEnabled) {
            return false;
        }
        return PmiRmRegistration.isComponentEnabled(n);
    }

    public boolean isComponentEnabled(int n, int n2) {
        if (_rmNotEnabled) {
            return false;
        }
        if (n2 == 1 || n2 == 2) {
            return PmiRmRegistration.isComponentEnabled(n);
        }
        int n3 = PmiReqMetricsImpl.getConfig()._traceLevel;
        if (n3 < 3) {
            return false;
        }
        return PmiRmRegistration.isComponentEnabled(n);
    }

    public boolean isAgentOrDmgr() {
        return isAgentOrDmgr;
    }

    public boolean isPassCorrelatorToDB() {
        return passCorrelatorToDB && this.isARMEnabled();
    }

    public PmiRmThreadCtx resetContext(PmiRmThreadCtx pmiRmThreadCtx, boolean bl) {
        if (pmiRmThreadCtx == null) {
            pmiRmThreadCtx = (PmiRmThreadCtx)this._tls.get();
        }
        if (bl || pmiRmThreadCtx.getInboundComponent() < 0) {
            pmiRmThreadCtx.reset();
            pmiRmThreadCtx.setConfig(PmiReqMetricsImpl.getConfig());
            pmiRmThreadCtx.setInboundComponent(0);
            pmiRmThreadCtx.setInboundInstrumented(true);
        }
        return pmiRmThreadCtx;
    }

    public Object updateBegin(Object object, int n, String string, String string2, String[] stringArray) {
        PmiRmThreadCtx pmiRmThreadCtx;
        if (!PmiReqMetricsImpl.isComponentEnabledInArmCallback(n)) {
            return null;
        }
        if (trDebug) {
            Tr.debug(tc, "impl.updateBegin: " + string + "-" + string2);
        }
        if (object == null) {
            object = this._tls.get();
        }
        if (!(pmiRmThreadCtx = (PmiRmThreadCtx)object).getTrace()) {
            if (trDebug) {
                Tr.debug(tc, "ctx.getTrace returns false, do nothing");
            }
            return object;
        }
        _armWrapper.updateBegin(pmiRmThreadCtx, n, string, string2, stringArray);
        return object;
    }

    public Object updateBegin(Object object, int n, boolean bl, String string, String string2, String[] stringArray) {
        if (trDebug) {
            Tr.debug(tc, "impl.updateBegin with armTraceEnabled: " + string + "-" + string2);
        }
        if (object == null) {
            object = this._tls.get();
        }
        PmiRmThreadCtx pmiRmThreadCtx = (PmiRmThreadCtx)object;
        _armWrapper.updateBegin(pmiRmThreadCtx, n, bl, string, string2, stringArray);
        return pmiRmThreadCtx;
    }

    public void updateEnd(Object object, int n, int n2, Properties properties) {
        if (trDebug) {
            Tr.debug(tc, "impl.updateEnd");
        }
        PmiRmThreadCtx pmiRmThreadCtx = null;
        pmiRmThreadCtx = object == null ? (PmiRmThreadCtx)this._tls.get() : (PmiRmThreadCtx)object;
        if (!pmiRmThreadCtx.getTrace()) {
            if (trDebug) {
                Tr.debug(tc, "ctx.getTrace returns false, do nothing");
            }
            return;
        }
        _armWrapper.updateEnd(pmiRmThreadCtx, n, n2, properties);
    }

    public void updateEnd(Object object, boolean bl, int n, Properties properties) {
        if (trDebug) {
            Tr.debug(tc, "impl.updateEnd");
        }
        PmiRmThreadCtx pmiRmThreadCtx = null;
        pmiRmThreadCtx = object == null ? (PmiRmThreadCtx)this._tls.get() : (PmiRmThreadCtx)object;
        if (!pmiRmThreadCtx.getTrace()) {
            if (trDebug) {
                Tr.debug(tc, "ctx.getTrace returns false, do nothing");
            }
            return;
        }
        _armWrapper.updateEnd(pmiRmThreadCtx, bl, n, properties);
    }

    public void init(String string, Object object) {
        boolean bl;
        _armWrapper = new PmiRmArmWrapper();
        this.checkOldSystemProperties();
        boolean bl2 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "PmiRequestMetricsImpl.init: " + string);
        }
        EJBContainer eJBContainer = (EJBContainer)object;
        if (bl) {
            Tr.debug(tc, "PmiRequestMetricsImpl.init: setting up EJB collaborator");
        }
        if (eJBContainer != null) {
            eJBContainer.addCollaborator(new PmiRmEJBCollaborator(this));
            if (bl) {
                Tr.debug(tc, "PmiRequestMetricsImpl.init: done setting up EJB collaborator");
            }
        }
        _armWrapper.init(string, "*");
        PmiReqMetrics.setInstance(this);
    }

    public void end() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "PmiRequestMetricsImpl.end");
        }
    }

    public void start() {
        boolean bl;
        boolean bl2 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "PmiRequestMetricsImpl.start ");
        }
        try {
            if (this._fLiteServiceInitialized) {
                if (this.isReallyEnabled()) {
                    ActivityService.enableLiteService(LITE_SERVICE_NAME);
                    if (bl) {
                        Tr.debug(tc, "enableLiteService(PMI.RequestMetrics)");
                    }
                } else {
                    ActivityService.disableLiteService(LITE_SERVICE_NAME);
                    if (bl) {
                        Tr.debug(tc, "disableLiteService(PMI.RequestMetrics)");
                    }
                }
            }
        }
        catch (ServiceNotRegisteredException serviceNotRegisteredException) {
            FFDCFilter.processException((Throwable)serviceNotRegisteredException, "com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl.start", FFDC_ID_4, this);
            Tr.error(tc, "PMRM0100E", new Object[]{serviceNotRegisteredException.getMessage()});
        }
    }

    public void stop() {
        boolean bl;
        boolean bl2 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "PmiRequestMetricsImpl.stop ");
        }
        try {
            if (this._fLiteServiceInitialized) {
                ActivityService.disableLiteService(LITE_SERVICE_NAME);
            }
        }
        catch (ServiceNotRegisteredException serviceNotRegisteredException) {
            FFDCFilter.processException((Throwable)serviceNotRegisteredException, "com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl.stop", FFDC_ID_5, this);
            Tr.error(tc, "PMRM0100E", new Object[]{serviceNotRegisteredException.getMessage()});
        }
    }

    public Object setArrivalTime(Object object, int n, long l) {
        PmiRmThreadCtx pmiRmThreadCtx = null;
        pmiRmThreadCtx = object == null ? (PmiRmThreadCtx)this._tls.get() : (PmiRmThreadCtx)object;
        int n2 = pmiRmThreadCtx.getInboundCorrelatorType();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setArrivalTime, passed ctx=" + object + ", used ctx=" + pmiRmThreadCtx + ", incomingCorStatus=" + n2);
        }
        if (n2 == -1 || n2 == -2) {
            pmiRmThreadCtx.reset();
        }
        pmiRmThreadCtx.setArrivalTime(l);
        return null;
    }

    public Object setInboundCorrelators(Object object, int n, String[] stringArray, boolean bl) {
        PmiRmThreadCtx pmiRmThreadCtx = null;
        if (object == null) {
            pmiRmThreadCtx = (PmiRmThreadCtx)this._tls.get();
            pmiRmThreadCtx.reset();
        } else {
            pmiRmThreadCtx = (PmiRmThreadCtx)object;
        }
        boolean bl2 = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        int n2 = 0;
        String string = PmiRmRegistration.getIdentityName(n);
        String string2 = null;
        String string3 = null;
        if (stringArray != null && stringArray.length == 1) {
            string2 = stringArray[0];
        } else if (stringArray != null && stringArray.length > 1) {
            string2 = stringArray[0];
            string3 = stringArray[1];
        }
        if (bl2) {
            Tr.debug(tc, "setInboundCorrelators: passed context=" + object + ", used context=" + pmiRmThreadCtx + ", regId=" + n + ", armStr=" + string2 + ", rmStr=" + string3 + ", filterPassed=" + bl);
        }
        byte[] byArray = null;
        if (string2 != null && !string2.equals("")) {
            if (string2.equalsIgnoreCase("DoNotTraceLowerProtocol")) {
                if (bl2) {
                    Tr.exit(tc, "setInboundCorrelators, special correlator is set so do not trace for lower protocol");
                }
                pmiRmThreadCtx.setInboundCorrelatorType(3);
                return pmiRmThreadCtx;
            }
            byArray = PmiRmArmWrapper.fromHexString(string2);
        }
        PmiRmCorrelator pmiRmCorrelator = null;
        if (string3 != null && !string3.equals("")) {
            pmiRmCorrelator = PmiRmCorrelator.getPmiRmCorrelatorFromString(string3);
        }
        boolean bl3 = false;
        if (pmiRmCorrelator == null && byArray == null) {
            bl3 = bl;
            n2 = 1;
            if (!bl3) {
                pmiRmCorrelator = new PmiRmCorrelator(-10, "na", "na", -1L, -1L, -1L);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setInboundCorrelators: no incoming correlator and filterPassed=false");
                }
            }
        } else if (pmiRmCorrelator == null) {
            pmiRmCorrelator = new PmiRmCorrelator(-1, "na", "na", -1L, -1L, -1L);
        }
        if (pmiRmCorrelator != null) {
            pmiRmCorrelator.setArmCorrelator(byArray);
            bl3 = pmiRmCorrelator.isTraceOn();
            if (pmiRmCorrelator.getVersion() == -10) {
                n2 = 2;
                bl3 = false;
            } else {
                n2 = 0;
            }
            PmiRmArmWrapper.pushParentContext(pmiRmThreadCtx, pmiRmCorrelator, string, "UNKNOWN");
        }
        pmiRmThreadCtx.setTrace(bl3);
        pmiRmThreadCtx.setInboundCorrelatorType(n2);
        return pmiRmThreadCtx;
    }

    public Object reqStart(PmiRmThreadCtx pmiRmThreadCtx, int n, String string, String[] stringArray) {
        boolean bl = trDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (trDebug) {
            Tr.debug(tc, "impl.reqStart: " + PmiRmRegistration.getIdentityName(n) + "-" + string);
        }
        _armWrapper.start(pmiRmThreadCtx, n, string, stringArray);
        return pmiRmThreadCtx;
    }

    public Object reqStart(PmiRmThreadCtx pmiRmThreadCtx, int n, boolean bl, String string, String[] stringArray) {
        boolean bl2 = trDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (trDebug) {
            Tr.debug(tc, "impl.reqStart: " + PmiRmRegistration.getIdentityName(n) + "-" + string);
        }
        _armWrapper.start(pmiRmThreadCtx, n, bl, string, stringArray);
        return pmiRmThreadCtx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object reqStart(Object object, int n, int n2, String[] stringArray) {
        Object object2;
        PmiRmThreadCtx pmiRmThreadCtx = null;
        boolean bl = trDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (trDebug) {
            object2 = new StringBuffer();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    ((StringBuffer)object2).append(stringArray[i] + ",");
                }
            }
            Tr.debug(tc, "reqStart, context=" + object + ", regId=" + n + ", component=" + PmiRmRegistration.getIdentityName(n) + ", reqScope=" + n2 + ", ctx=" + ((StringBuffer)object2).toString());
        }
        pmiRmThreadCtx = object == null ? (PmiRmThreadCtx)this._tls.get() : (PmiRmThreadCtx)object;
        if (n2 == 3) {
            object2 = pmiRmThreadCtx.getConfig();
            if (!pmiRmThreadCtx.getTrace() || !this.isComponentEnabled(n) || ((PmiRmConfigData)object2).getTraceLevel() <= 1) {
                if (!trDebug) return null;
                Tr.debug(tc, "reqStart, the inprocess request is disabled for insturmentation.");
                return null;
            }
            if (((PmiRmConfigData)object2).getTraceLevel() == 2) {
                if (n != 0 && n != 1) return null;
                _armWrapper.start(pmiRmThreadCtx, n, null, stringArray);
            } else if (((PmiRmConfigData)object2).getTraceLevel() == 3) {
                _armWrapper.start(pmiRmThreadCtx, n, null, stringArray);
            }
        } else if (n2 == 1) {
            int n3 = pmiRmThreadCtx.getInboundCorrelatorType();
            if (trDebug) {
                Tr.debug(tc, "reqStart inbound: incomingCorStatus=" + n3);
            }
            if (n3 == -1 || n3 == -2) {
                pmiRmThreadCtx.reset();
            } else {
                pmiRmThreadCtx.setInboundCorrelatorType(-1);
            }
            if (n3 == 3) {
                return null;
            }
            if (n3 == 2) {
                pmiRmThreadCtx.setTrace(false);
                return null;
            }
            pmiRmThreadCtx.setInboundComponent(n);
            pmiRmThreadCtx.setTrace(true);
            if (n3 == 1 || PmiRmRegistration.isComponentEnabled(n)) {
                pmiRmThreadCtx.setInboundInstrumented(true);
                _armWrapper.start(pmiRmThreadCtx, n, null, stringArray);
            } else {
                pmiRmThreadCtx.setInboundInstrumented(false);
            }
        } else if (n2 == 2 || n2 == 4) {
            if (!pmiRmThreadCtx.getTrace() || !this.isComponentEnabled(n)) {
                if (!trDebug) return null;
                Tr.debug(tc, "reqStart, the request is disabled for insturmentation.");
                return null;
            }
            object2 = new StringBuffer();
            if (stringArray != null) {
                if (stringArray.length > 1) {
                    ((StringBuffer)object2).append(stringArray[0]).append('.').append(stringArray[stringArray.length - 1]);
                } else {
                    ((StringBuffer)object2).append(stringArray[0]);
                }
            }
            _armWrapper.updateBegin(pmiRmThreadCtx, n, PmiRmRegistration.getIdentityName(n), ((StringBuffer)object2).toString(), stringArray);
        } else if (n2 == 5) {
            Object object3 = object2 = PmiRmRegistration.getIdentityName(n);
            if (stringArray != null && stringArray.length >= 1) {
                object3 = stringArray[0];
            }
            this.bindThread(pmiRmThreadCtx, n, (String)object2, (String)object3);
        } else {
            Tr.warning(tc, "PMRM0215W", new Object[]{"reqStart", "reqScope", new Integer(n2), "PmiReqMetrics.INBOUND, PmiReqMetrics.OUTBOUND, PmiReqMetrics.BLOCKED, PmiReqMetrics.INPROCESS, PmiReqMetrics.BINDTHREAD"});
        }
        if (!trDebug) return pmiRmThreadCtx;
        Tr.debug(tc, "reqStart: complete");
        return pmiRmThreadCtx;
    }

    public void reqStop(Object object, int n, int n2) {
        if (!this.isReallyEnabled()) {
            return;
        }
        if (trDebug) {
            Tr.debug(tc, "impl.reqStop, ctx=" + object + ", regId=" + n + ", status=" + n2);
        }
        PmiRmThreadCtx pmiRmThreadCtx = null;
        pmiRmThreadCtx = object == null ? (PmiRmThreadCtx)this._tls.get() : (PmiRmThreadCtx)object;
        if (!pmiRmThreadCtx.getTrace()) {
            return;
        }
        _armWrapper.stop((PmiRmThreadCtx)object, n, n2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reqStop(Object object, int n, int n2, int n3, Properties properties) {
        if (!this.isReallyEnabled()) {
            return;
        }
        if (trDebug) {
            if (properties != null) {
                Tr.debug(tc, "impl.reqStop, ctx=" + object + ", regId=" + n + ", status=" + n3 + "props=" + properties.toString());
            } else {
                Tr.debug(tc, "impl.reqStop, ctx=" + object + ", regId=" + n + ", status=" + n3 + "props=null");
            }
        }
        PmiRmThreadCtx pmiRmThreadCtx = null;
        pmiRmThreadCtx = object == null ? (PmiRmThreadCtx)this._tls.get() : (PmiRmThreadCtx)object;
        if (!pmiRmThreadCtx.getTrace()) {
            return;
        }
        if (n2 == 1) {
            if (pmiRmThreadCtx.getInboundComponent() != n) {
                Tr.warning(tc, "PMRM0215W", new Object[]{"reqStop", "regId", new Integer(n), "the inbound component regId=" + pmiRmThreadCtx.getInboundComponent()});
                return;
            }
            if (!pmiRmThreadCtx.isInboundInstrumented()) {
                if (!trDebug) return;
                Tr.debug(tc, "reqStop, the inbound is not instrumented with reqStart.");
                return;
            }
            _armWrapper.stop(pmiRmThreadCtx, n, n3, properties);
            if (!pmiRmThreadCtx.isInContextPool() || pmiRmThreadCtx.getReqCallLevel() != 0) return;
            if (trDebug) {
                Tr.debug(tc, "reqStop, putRmContext, threadCtx=" + pmiRmThreadCtx + "size=" + PmiRmThreadCtxPool.size());
            }
            PmiRmThreadCtxPool.putRmContext(pmiRmThreadCtx);
            return;
        } else if (n2 == 3) {
            PmiRmConfigData pmiRmConfigData = pmiRmThreadCtx.getConfig();
            if (!pmiRmThreadCtx.getTrace() || !this.isComponentEnabled(n) || pmiRmConfigData.getTraceLevel() <= 1) {
                if (!trDebug) return;
                Tr.debug(tc, "reqStop, the inprocess request is disabled for insturmentation.");
                return;
            }
            if (pmiRmConfigData.getTraceLevel() == 2) {
                if (n != 0 && n != 1) return;
                _armWrapper.stop(pmiRmThreadCtx, n, n3, properties);
                return;
            } else {
                if (pmiRmConfigData.getTraceLevel() != 3) return;
                _armWrapper.stop(pmiRmThreadCtx, n, n3, properties);
            }
            return;
        } else if (n2 == 2) {
            if (!pmiRmThreadCtx.getTrace() || !this.isComponentEnabled(n)) return;
            _armWrapper.updateEnd(pmiRmThreadCtx, n, n3, properties);
            return;
        } else {
            if (n2 != 5) return;
            this.unbindThread(pmiRmThreadCtx, n, n3);
        }
    }

    public void reqStop(Object object, boolean bl, int n, Properties properties) {
        if (!this.isReallyEnabled()) {
            return;
        }
        if (trDebug) {
            Tr.debug(tc, "impl.reqStop with armTraceEnabled");
        }
        PmiRmThreadCtx pmiRmThreadCtx = null;
        pmiRmThreadCtx = object == null ? (PmiRmThreadCtx)this._tls.get() : (PmiRmThreadCtx)object;
        _armWrapper.stop(pmiRmThreadCtx, bl, n, properties);
    }

    public Object bindThread(int n, String string, String string2) {
        return this.bindThread(null, n, string, string2);
    }

    public Object bindThread(Object object, int n, String string, String string2) {
        if (!this.isReallyEnabled() || !this.isComponentEnabled(n)) {
            return null;
        }
        if (trDebug) {
            Tr.debug(tc, "bindThread reqType=" + string + ", reqDetail=" + string2);
        }
        PmiRmThreadCtx pmiRmThreadCtx = null;
        pmiRmThreadCtx = object == null ? (PmiRmThreadCtx)this._tls.get() : (PmiRmThreadCtx)object;
        _armWrapper.bindThread(pmiRmThreadCtx, n, string, string2);
        return pmiRmThreadCtx;
    }

    public void unbindThread(Object object, int n, int n2) {
        if (!this.isReallyEnabled() || !this.isComponentEnabled(n)) {
            return;
        }
        if (trDebug) {
            Tr.debug(tc, "unbindThread");
        }
        PmiRmThreadCtx pmiRmThreadCtx = null;
        pmiRmThreadCtx = object == null ? (PmiRmThreadCtx)this._tls.get() : (PmiRmThreadCtx)object;
        _armWrapper.unbindThread(pmiRmThreadCtx, n, n2);
    }

    public static PmiReqMetricsImpl getInstance() {
        return _instance;
    }

    public byte[] getArmCorrelator(Object object) {
        return PmiRmArmWrapper.getArmCorrelator(object);
    }

    public String getArmCorrelatorInString(Object object) {
        byte[] byArray = PmiRmArmWrapper.getArmCorrelator(object);
        return PmiRmArmWrapper.toHexString(byArray);
    }

    public static PmiRmCorrelator createCorrelator(PmiRmThreadCtx pmiRmThreadCtx) {
        if (_instance == null) {
            Tr.error(tc, "PMRM0101E");
            return null;
        }
        return PmiReqMetricsImpl._instance._procInfo.createCorrelator(pmiRmThreadCtx);
    }

    public String[] getCorrelatorsInString(Object object) {
        if (trDebug) {
            Tr.entry(tc, "getCorrelatorsInString. context=" + object);
        }
        if (!this.isEnabled()) {
            return null;
        }
        try {
            PmiRmArmTx pmiRmArmTx = null;
            pmiRmArmTx = object == null ? PmiRmArmStack.peekTransaction() : (PmiRmArmTx)((PmiRmThreadCtx)object).peekContext();
            if (pmiRmArmTx == null) {
                Tr.debug(tc, "getCorrelators: PmiRmArmStack.peekTransaction returns null");
                return nullCors;
            }
            String string = null;
            String string2 = null;
            byte[] byArray = pmiRmArmTx.getCorrelatorBytes();
            string = PmiRmArmWrapper.toHexString(byArray);
            if (pmiRmArmTx instanceof PmiRmCallContext) {
                PmiRmCallContext pmiRmCallContext = (PmiRmCallContext)pmiRmArmTx;
                PmiRmCorrelator pmiRmCorrelator = pmiRmCallContext.getCorrelator();
                string2 = PmiRmCorrelator.getStringFromPmiRmCorrelator(pmiRmCorrelator);
            }
            if (trDebug) {
                Tr.debug(tc, "getCorrelatorsInString returns armCor=" + string + ", rmCor=" + string2);
                Tr.exit(tc, "getCorrelatorsInString - returns the correlator string");
            }
            return new String[]{string, string2};
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.getClass().getName() + "getCorrelatorsInString", "953", this);
            if (tc.isEntryEnabled()) {
                exception.printStackTrace();
                Tr.exit(tc, "getCorrelatorsInString - returns null correlator string");
            }
            return nullCors;
        }
    }

    public static void updateConfig(boolean bl, boolean bl2, int n, boolean bl3, int n2, String string, ArrayList arrayList, ArrayList arrayList2, PmiRmFilterConfig pmiRmFilterConfig, PmiRmFilterConfig pmiRmFilterConfig2, PmiRmFilterConfig pmiRmFilterConfig3, PmiRmFilterConfig pmiRmFilterConfig4, PmiRmFilterConfig pmiRmFilterConfig5, ExtensibleFilterContainer extensibleFilterContainer) {
        if (_instance == null) {
            return;
        }
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl._instance._newConfig;
        pmiRmConfigData._fRmEnabled = bl;
        pmiRmConfigData._fARMEnabled = bl2;
        pmiRmConfigData._traceLevel = n;
        pmiRmConfigData._filters[0] = pmiRmFilterConfig;
        pmiRmConfigData._filters[1] = pmiRmFilterConfig2;
        pmiRmConfigData._filters[2] = pmiRmFilterConfig3;
        pmiRmConfigData._filters[3] = pmiRmFilterConfig4;
        pmiRmConfigData._filters[4] = pmiRmFilterConfig5;
        pmiRmConfigData._armType = n2;
        pmiRmConfigData._fLogEnabled = bl3;
        pmiRmConfigData.armTransactionFactory = string;
        pmiRmConfigData.enabledComponents = arrayList;
        pmiRmConfigData.instrumentedComponents = arrayList2;
        pmiRmConfigData.setExtensibleFilterContainer(extensibleFilterContainer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "updateConfig: fRmReallyEnabled=" + pmiRmConfigData._fRmReallyEnabled);
        }
        PmiReqMetricsImpl._instance._newConfig = pmiRmConfigData;
        PmiReqMetricsImpl.commitConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PmiRmConfigData getConfigOld() {
        if (_instance == null) {
            return null;
        }
        PmiReqMetricsImpl pmiReqMetricsImpl = _instance;
        synchronized (pmiReqMetricsImpl) {
            return PmiReqMetricsImpl._instance._curConfig;
        }
    }

    public static PmiRmConfigData getConfig() {
        return PmiReqMetricsImpl._instance._curConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void commitConfig() {
        if (isAgentOrDmgr) {
            return;
        }
        boolean bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        Tr.entry(tc, "commitConfig");
        if (_instance == null || PmiReqMetricsImpl._instance._newConfig == null) {
            return;
        }
        PmiReqMetricsImpl pmiReqMetricsImpl = _instance;
        synchronized (pmiReqMetricsImpl) {
            PmiReqMetricsImpl._instance._newConfig._fRmReallyEnabled = PmiReqMetricsImpl._instance._newConfig._fRmEnabled;
            if (PmiReqMetricsImpl._instance._newConfig._traceLevel == 0) {
                PmiReqMetricsImpl._instance._newConfig._fRmReallyEnabled = false;
            }
            PmiReqMetricsImpl._instance._curConfig = PmiReqMetricsImpl._instance._newConfig.copy();
            if (PmiReqMetricsImpl._instance._curConfig.isRmEnabled()) {
                _rmNotEnabled = false;
                PmiReqMetrics.setEnable(true);
                WebAppReqMetricsListener.addListener();
                if (PmiReqMetricsImpl._instance._curConfig._traceLevel == 3) {
                    WebAppReqMetricsListener.addFilterListener();
                } else {
                    WebAppReqMetricsListener.removeFilterListener();
                }
            } else {
                _rmNotEnabled = true;
                PmiReqMetrics.setEnable(false);
                WebAppReqMetricsListener.removeListener();
                WebAppReqMetricsListener.removeFilterListener();
            }
            PmiRmRegistration.updateComponentEnablement(PmiReqMetricsImpl._instance._curConfig.enabledComponents, PmiReqMetricsImpl._instance._curConfig.getTraceLevel());
            try {
                if (PmiReqMetricsImpl._instance._curConfig.isRmEnabled()) {
                    if (PmiReqMetricsImpl._instance._fLiteServiceInitialized) {
                        ActivityService.enableLiteService(LITE_SERVICE_NAME);
                        if (bl) {
                            Tr.debug(tc, "enableLiteService(PMI.RequestMetrics)");
                        }
                    } else if (bl) {
                        Tr.debug(tc, "unable to enable lite service since it has not been registered.");
                    }
                } else if (PmiReqMetricsImpl._instance._fLiteServiceInitialized) {
                    ActivityService.disableLiteService(LITE_SERVICE_NAME);
                    if (bl) {
                        Tr.debug(tc, "disableLiteService(PMI.RequestMetrics)");
                    }
                } else if (bl) {
                    Tr.debug(tc, "unable to disable lite service since it has not been registered.");
                }
                int n = PmiReqMetricsImpl._instance._curConfig.instrumentedComponents.size();
                if (componentsEnabledInArmCallback == null || componentsEnabledInArmCallback.length < n) {
                    componentsEnabledInArmCallback = new boolean[n];
                }
                for (int i = 0; i < componentsEnabledInArmCallback.length; ++i) {
                    PmiReqMetricsImpl.componentsEnabledInArmCallback[i] = armCallback == null ? true : armCallback.isComponentEnabled(i);
                    if (!bl) continue;
                    Tr.debug(tc, "commitConfig, componentEnabledInArmCallback for regId=" + i + " is " + componentsEnabledInArmCallback[i]);
                }
            }
            catch (ServiceNotRegisteredException serviceNotRegisteredException) {
                FFDCFilter.processException((Throwable)serviceNotRegisteredException, "com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl.commitConfig", FFDC_ID_7, _instance);
                Tr.error(tc, "PMRM0100E", new Object[]{serviceNotRegisteredException.getMessage()});
            }
        }
        if (null != _armWrapper) {
            _armWrapper.initArmImpl(PmiReqMetricsImpl._instance._curConfig);
        }
        Tr.exit(tc, "commitConfig");
    }

    protected String getSystemProperty(String string) {
        String string2 = null;
        final String[] stringArray = new String[]{null};
        final String[] stringArray2 = new String[]{null};
        stringArray2[0] = string;
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                stringArray[0] = System.getProperty(stringArray2[0]);
                return null;
            }
        });
        if (stringArray[0] != null) {
            string2 = stringArray[0];
        }
        return string2;
    }

    private void checkAndRegisterArmCallback() {
        block4: {
            String string = this.getSystemProperty("com.ibm.websphere.pmi.reqmetrics.PmiRmArmTransactionCallback");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "checkAndRegisterArmCallback armCallbackClass=" + string);
            }
            if (string == null) {
                needMethodInfo = false;
                return;
            }
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                Object obj = clazz.newInstance();
                PmiRmArmTransactionCallback pmiRmArmTransactionCallback = (PmiRmArmTransactionCallback)obj;
                PmiReqMetricsImpl.registerArmCallback(pmiRmArmTransactionCallback);
                needMethodInfo = pmiRmArmTransactionCallback.isMethodInfoNeeded();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl.checkAndRegisterArmCallback", FFDC_ID_10, this);
                Tr.warning(tc, "PMRM0108E", "checkAndRegisterArmCallback");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                throwable.printStackTrace();
            }
        }
    }

    private void checkAndSetPassCorrelatorToDB() {
        String string = this.getSystemProperty("com.ibm.websphere.pmi.reqmetrics.PassCorrelatorToDB");
        if (string != null && string.equalsIgnoreCase("true")) {
            passCorrelatorToDB = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "PassCorrelatorToDB is set to true");
            }
        } else {
            passCorrelatorToDB = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "PassCorrelatorToDB is false");
            }
        }
    }

    private void checkOldSystemProperties() {
        int n;
        String string = "com.ibm.websphere.pmi.reqmetrics.ARMIMPL";
        String string2 = "ArmTransactionFactory";
        String string3 = RM_LOG_ENABLE_PROPERTY;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "checkOldSystemProperties");
        }
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        String string4 = null;
        String string5 = null;
        string4 = this.getSystemProperty(string);
        if (string4 != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "checkOldSystemProperties: ARMIMPL=" + string4);
            }
            if (string4.equalsIgnoreCase(string5 = (n = pmiRmConfigData._armType) == 0 ? "arm4" : (n == 1 ? "ewlm" : (n == 2 ? "tivoli" : "unknown")))) {
                Tr.warning(tc, "PMRM0211W", new Object[]{string, string4});
            } else {
                Tr.warning(tc, "PMRM0212W", new Object[]{string, string4, string5});
            }
        }
        if ((string4 = this.getSystemProperty(string2)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "checkOldSystemProperties: ArmTransactionFactory=" + string4);
            }
            if (string4.equalsIgnoreCase(string5 = pmiRmConfigData.getArmTransactionFactory())) {
                Tr.warning(tc, "PMRM0211W", new Object[]{string2, string4});
            } else {
                Tr.warning(tc, "PMRM0212W", new Object[]{string2, string4, string5});
            }
        }
        if ((string4 = this.getSystemProperty(string3)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "checkOldSystemProperties: loggingEnabled=" + string4);
            }
            if (string4.equalsIgnoreCase(string5 = (n = (int)(pmiRmConfigData.isLogEnabled() ? 1 : 0)) != 0 ? "true" : "false")) {
                Tr.warning(tc, "PMRM0211W", new Object[]{string3, string4});
            } else {
                Tr.warning(tc, "PMRM0212W", new Object[]{string3, string4, string5});
            }
        }
    }

    protected void init_internal(PmiRmConfigData pmiRmConfigData) {
        boolean bl;
        boolean bl2 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "Creating PmiReqMetrics ");
        }
        _rmNotEnabled = true;
        this._curConfig = pmiRmConfigData;
        String string = AdminServiceFactory.getAdminService().getProcessType();
        if (string.equals("NodeAgent") || string.equals("DeploymentManager")) {
            isAgentOrDmgr = true;
            _instance = this;
            return;
        }
        String string2 = this.getSystemProperty("com.ibm.websphere.pmi.reqmetrics.ArmCorrelatorHeaderName");
        if (string2 != null) {
            this._curConfig.setArmCorrelatorHeaderName(string2);
        }
        if (bl) {
            Tr.debug(tc, "ARM correlator header name = " + this._curConfig.getArmCorrelatorHeaderName());
        }
        this._newConfig = pmiRmConfigData.copy();
        this.checkAndRegisterArmCallback();
        this.checkAndSetPassCorrelatorToDB();
        if (_instance == null) {
            _instance = this;
            this._tls = new PmiRmThreadLocal();
            this._procInfo = new PmiRmProcessLevelInfo();
            try {
                PmiRmJmxService pmiRmJmxService = new PmiRmJmxService();
                DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(pmiRmJmxService);
                MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
                String string3 = "com/ibm/ws/management/descriptor/xml/PmiRmJmxService.xml";
                mBeanFactory.activateMBean("PmiRmJmxService", defaultRuntimeCollaborator, "PmiRmJmxService", string3);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl.init_internal", FFDC_ID_2, this);
                Tr.error(tc, "PMRM0103E");
            }
        } else if (bl) {
            Tr.debug(tc, "Multiple creates of PmiReqMetricsImpl disregarded.");
        }
        this.pmirmAS = new PmiRmActivityService(this);
        try {
            ActivityService.registerLiteService(LITE_SERVICE_NAME, this.pmirmAS);
            this._fLiteServiceInitialized = true;
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl.init_internal", FFDC_ID_3, this);
            Tr.error(tc, "PMRM0100E", new Object[]{systemException.getMessage()});
        }
        try {
            ActivityService.disableLiteService(LITE_SERVICE_NAME);
        }
        catch (ServiceNotRegisteredException serviceNotRegisteredException) {
            FFDCFilter.processException((Throwable)serviceNotRegisteredException, "com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl.init_internal", FFDC_ID_6, this);
            Tr.error(tc, "PMRM0100E", new Object[]{serviceNotRegisteredException.getMessage()});
        }
    }

    public PmiRmArmWrapper getArmWrapper() {
        return _armWrapper;
    }

    public PmiRmThreadCtx getThreadContext() {
        return (PmiRmThreadCtx)this._tls.get();
    }

    public void setArmType(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setArmType: " + n);
        }
        this.armType = n;
    }

    public int getArmType() {
        return this.armType;
    }

    public static boolean isReqMetricsEnabled() {
        return PmiReqMetricsImpl._instance._curConfig.isRmEnabled();
    }

    public static boolean registerArmCallback(PmiRmArmTransactionCallback pmiRmArmTransactionCallback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "registerArmCallback armCallback=" + pmiRmArmTransactionCallback);
        }
        armCallback = pmiRmArmTransactionCallback;
        return pmiRmArmTransactionCallback != null;
    }

    public static boolean unregisterArmCallback() {
        armCallback = null;
        return true;
    }

    public static PmiRmArmTransactionCallback getArmCallback() {
        return armCallback;
    }

    public static boolean isComponentEnabledInArmCallback(int n) {
        if (n >= 0 && n < componentsEnabledInArmCallback.length) {
            return componentsEnabledInArmCallback[n];
        }
        return true;
    }

    public static void setABSvc(AsynchBeansServiceCollaborator asynchBeansServiceCollaborator, boolean bl) {
        abSvc = asynchBeansServiceCollaborator;
        abSvcRegistered = bl;
    }

    public static synchronized boolean registerABSvc(AsynchBeansServiceCollaborator asynchBeansServiceCollaborator) {
        if (abSvcRegistered) {
            return false;
        }
        asynchBeansServiceCollaborator.register(new ReqMetricsAsyncBeanServiceImpl(), true);
        abSvcRegistered = true;
        return true;
    }

    public static AsynchBeansServiceCollaborator getABSvc() {
        return abSvc;
    }

    public int register(String string, Properties properties, String[] stringArray) {
        return PmiRmRegistration.register(string, properties, stringArray);
    }

    public boolean isFilterPassed(String string, String string2) {
        ExtensibleFilterContainer extensibleFilterContainer = this._curConfig.getExtensibleFilterContainer();
        PmiRmFilterConfig pmiRmFilterConfig = extensibleFilterContainer.getFilterConfig(string);
        if (pmiRmFilterConfig == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "isFilterPassed, cannot find filter type " + string + ", return true");
            }
            return true;
        }
        if (!pmiRmFilterConfig.isEnabled()) {
            return true;
        }
        if (string2 == null) {
            return true;
        }
        for (int i = 0; i < pmiRmFilterConfig.numFilters(); ++i) {
            if (!pmiRmFilterConfig.isFilterEnabled(i) || !PmiRmUtil.isStrMatched(pmiRmFilterConfig.getFilter(i), string2)) continue;
            return true;
        }
        return false;
    }

    public Object getRMContext(boolean bl) {
        if (bl) {
            Object object = this._tls.get();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getRmContext, return context with thread, ctx=" + object);
            }
            return object;
        }
        PmiRmThreadCtx pmiRmThreadCtx = (PmiRmThreadCtx)PmiRmThreadCtxPool.getRmContext();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRmContext, threadCtx=" + pmiRmThreadCtx + "size=" + PmiRmThreadCtxPool.size());
        }
        if (pmiRmThreadCtx == null) {
            pmiRmThreadCtx = new PmiRmThreadCtx();
        }
        pmiRmThreadCtx.reset();
        pmiRmThreadCtx.setInContextPool(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRMContext, return contxt with pool, ctx=" + pmiRmThreadCtx);
        }
        return pmiRmThreadCtx;
    }

    public void setRMContext(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setRMContext, new contextObj=contextObj, old contextObj=" + this._tls.get());
        }
        this._tls.set(object);
    }

    public void setRMContextPoolSize(int n, int n2) {
        if (n > n2) {
            n2 = n;
            Tr.warning(tc, "PMRM0215W", new Object[]{"setRMContextPoolSize", "maxSize", new Integer(n2), "a number greater than minSize"});
        }
        if (n < 2) {
            n = 2;
            Tr.warning(tc, "PMRM0215W", new Object[]{"setRMContextPoolSize", "minSize", new Integer(n), "a number greater than 1"});
        }
        if (n2 > 400) {
            n2 = 400;
            Tr.warning(tc, "PMRM0215W", new Object[]{"setRMContextPoolSize", "maxSize", new Integer(n2), "a number no more than 400"});
        }
        PmiRmThreadCtxPool.setRMContextPoolSize(n, n2);
    }

    public static void setTranDetailSupported(boolean bl) {
        _tranDetailSupported = bl;
    }

    public static boolean isTranDetailSupported() {
        return _tranDetailSupported;
    }
}

