/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmStack;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmTx;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmTxFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl;
import com.ibm.ws.pmi.reqmetrics.PmiRmArmXfc;
import com.ibm.ws.pmi.reqmetrics.PmiRmCallContext;
import com.ibm.ws.pmi.reqmetrics.PmiRmConfigData;
import com.ibm.ws.pmi.reqmetrics.PmiRmCorrelator;
import com.ibm.ws.pmi.reqmetrics.PmiRmRegistration;
import com.ibm.ws.pmi.reqmetrics.PmiRmThreadCtx;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.pmi.reqmetrics.PmiRmArmComponentCallback;
import com.ibm.wsspi.pmi.reqmetrics.PmiRmArmTransactionCallback;
import java.security.PrivilegedAction;
import java.util.Properties;

public class PmiRmArmWrapper {
    private PmiRmArmXfc armImpl = null;
    private String appName = null;
    private String userId = null;
    private static final String SOURCE_FILE = "com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    private static final String FFDC_ID_6 = "FFDC-6";
    private static final String FFDC_ID_7 = "FFDC-7";
    private static final String FFDC_ID_8 = "FFDC-8";
    private static PmiReqMetricsImpl pmirm = null;
    private static PmiRmArmXfc arm4Impl = null;
    private static PmiRmArmXfc tivoliArmImpl = null;
    private static boolean trDebug = true;
    private static final TraceComponent tc = Tr.register(PmiRmArmWrapper.class, "pmi.rm", "com.ibm.ws.pmi.reqmetrics.reqmetrics");

    public PmiRmArmWrapper() {
        trDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        Tr.entry(tc, "PmiRmArmWrapper");
        pmirm = PmiReqMetricsImpl.getInstance();
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        if (pmiRmConfigData.isRmEnabled()) {
            this.initArmImpl(pmiRmConfigData);
        }
    }

    protected void initArmImpl(PmiRmConfigData pmiRmConfigData) {
        block26: {
            Object object;
            String[] stringArray;
            int n;
            boolean bl;
            boolean bl2;
            block25: {
                bl2 = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
                Tr.entry(tc, "initArmImpl");
                bl = pmiRmConfigData.isARMEnabled();
                if (!bl) {
                    if (this.armImpl != null) {
                        this.armImpl.undo_init();
                    }
                    Tr.exit(tc, "initArmImpl - ARM is disabled");
                    return;
                }
                n = pmiRmConfigData._armType;
                if (bl2) {
                    Tr.debug(tc, "larmType=" + n);
                }
                if (n == 2 && tivoliArmImpl != null && tivoliArmImpl.isInitSuccess()) {
                    this.armImpl = tivoliArmImpl;
                    if (bl2) {
                        Tr.exit(tc, "initArmImpl - already initialized, arm type is Tivoli");
                    }
                    return;
                }
                if (n == 0 && arm4Impl != null && arm4Impl.isInitSuccess()) {
                    this.armImpl = arm4Impl;
                    if (bl2) {
                        Tr.exit(tc, "initArmImpl - already initialized, arm type is ARM40");
                    }
                    return;
                }
                stringArray = new String[]{null};
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "PmiRmArmWrapper: about to create armImpl");
                    }
                    if (n == 0) {
                        stringArray[0] = "com.ibm.ws.pmi.reqmetrics.arm.PmiRmArmXfcArm4Impl";
                        object = PmiReqMetricsImpl.getInstance();
                        ((PmiReqMetricsImpl)object).setArmType(PmiRmArmTxFactory.ARM4_TYPE);
                    } else if (n == 2) {
                        stringArray[0] = "com.ibm.ws.pmi.reqmetrics.arm.PmiRmArmXfcTivoliImpl";
                        object = PmiReqMetricsImpl.getInstance();
                        ((PmiReqMetricsImpl)object).setArmType(PmiRmArmTxFactory.TIVOLI_TYPE);
                    } else {
                        Tr.warning(tc, "PMRM0214W", new Integer(n));
                    }
                }
                catch (Exception exception) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block25;
                    Tr.debug(tc, "PmiRmArmWrapper: exception to create armImpl " + stringArray[0]);
                    exception.printStackTrace();
                }
            }
            if (bl || bl2) {
                Tr.info(tc, "PMRM0001I", new Object[]{stringArray[0] == null ? "none" : stringArray[0]});
            }
            if (stringArray[0] != null) {
                try {
                    object = new boolean[]{false};
                    object[0] = bl || bl2;
                    final Class[] classArray = new Class[]{null};
                    AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((boolean[])object, stringArray, classArray){
                        private final /* synthetic */ boolean[] val$fReportingExceptions;
                        private final /* synthetic */ String[] val$className;
                        private final /* synthetic */ Class[] val$classFor;
                        {
                            this.val$fReportingExceptions = blArray;
                            this.val$className = stringArray;
                            this.val$classFor = classArray;
                        }

                        public Object run() {
                            block3: {
                                try {
                                    if (this.val$fReportingExceptions[0]) {
                                        Tr.debug(tc, "before loadClass " + this.val$className[0]);
                                        Tr.debug(tc, "contextClassLoader=" + Thread.currentThread().getContextClassLoader());
                                        Tr.debug(tc, "currentClassLoader=" + this.getClass().getClassLoader());
                                    }
                                    this.val$classFor[0] = Thread.currentThread().getContextClassLoader().loadClass(this.val$className[0]);
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException(throwable, "com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper.run", PmiRmArmWrapper.FFDC_ID_4, this);
                                    this.val$classFor[0] = null;
                                    if (!this.val$fReportingExceptions[0]) break block3;
                                    Tr.debug(tc, "initArmImpl: throw exception to new class " + this.val$className[0]);
                                    throwable.printStackTrace();
                                }
                            }
                            return null;
                        }
                    });
                    final PmiRmArmXfc[] pmiRmArmXfcArray = new PmiRmArmXfc[]{null};
                    if (classArray[0] != null) {
                        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((boolean[])object, stringArray){
                            private final /* synthetic */ boolean[] val$fReportingExceptions;
                            private final /* synthetic */ String[] val$className;
                            {
                                this.val$fReportingExceptions = blArray;
                                this.val$className = stringArray;
                            }

                            public Object run() {
                                block2: {
                                    try {
                                        pmiRmArmXfcArray[0] = (PmiRmArmXfc)classArray[0].newInstance();
                                        pmiRmArmXfcArray[0].firstInit(PmiRmArmWrapper.getArmTxFactoryName());
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper.run", PmiRmArmWrapper.FFDC_ID_5, this);
                                        pmiRmArmXfcArray[0] = null;
                                        if (!this.val$fReportingExceptions[0]) break block2;
                                        Tr.debug(tc, "initArmImpl: throw exception to new instance " + this.val$className[0]);
                                        throwable.printStackTrace();
                                    }
                                }
                                return null;
                            }
                        });
                    }
                    if (pmiRmArmXfcArray[0] == null || classArray[0] == null) {
                        throw new Exception(stringArray[0]);
                    }
                    this.armImpl = pmiRmArmXfcArray[0];
                    if (n == 0) {
                        arm4Impl = this.armImpl;
                    } else if (n == 2) {
                        tivoliArmImpl = this.armImpl;
                    }
                    if (this.armImpl != null && this.appName != null) {
                        this.armImpl.init(this.appName, this.userId);
                        PmiReqMetricsImpl.isArmInitSuccess = true;
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper.initArmImpl", FFDC_ID_6, this);
                    PmiReqMetricsImpl.isArmInitSuccess = false;
                    if (!pmirm.getConfig().isLogEnabled()) {
                        PmiRmArmWrapper.pmirm.getConfig()._fRmReallyEnabled = false;
                    }
                    this.armImpl = null;
                    if (!bl && !bl2) break block26;
                    Tr.warning(tc, "PMRM0002E", new Object[]{stringArray[0]});
                    throwable.printStackTrace();
                }
            }
        }
        Tr.exit(tc, "initArmImpl");
    }

    public static byte[] getArmCorrelator(Object object) {
        byte[] byArray = null;
        boolean bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        Tr.entry(tc, "getArmCorrelator");
        PmiRmArmTx pmiRmArmTx = null;
        pmiRmArmTx = object == null ? PmiRmArmStack.peekTransaction() : (PmiRmArmTx)((PmiRmThreadCtx)object).peekContext();
        try {
            if (pmiRmArmTx != null) {
                byArray = pmiRmArmTx.getCorrelatorBytes();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper.getArmCorrelator", FFDC_ID_7);
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ARM Correlator: ");
            if (byArray == null) {
                stringBuffer.append("was null");
            } else {
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append(Integer.toHexString(byArray[i]));
                    stringBuffer.append(" ");
                }
            }
            Tr.debug(tc, stringBuffer.toString());
        }
        Tr.exit(tc, "getArmCorrelator");
        return byArray;
    }

    public static byte[] getArmCorrelator(PmiRmThreadCtx pmiRmThreadCtx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getArmCorrelator with PmiRmThreadCtx");
        }
        PmiRmArmTx pmiRmArmTx = PmiRmArmWrapper.peekArmTransaction(pmiRmThreadCtx);
        byte[] byArray = null;
        try {
            if (pmiRmArmTx != null) {
                byArray = pmiRmArmTx.getCorrelatorBytes();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getArmCorrelator(rmContext) cannot find a ARM transaction on the stack");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper.getArmCorrelator", FFDC_ID_7);
        }
        return byArray;
    }

    protected PmiRmArmXfc getArmImpl(PmiRmConfigData pmiRmConfigData) {
        if (pmiRmConfigData.isARMEnabled()) {
            return this.armImpl;
        }
        return null;
    }

    protected void init(String string, String string2) {
        boolean bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        Tr.entry(tc, "init");
        this.appName = string;
        this.userId = string2;
        this.writeRmInitTraceLog(string, string2);
        if (bl) {
            String string3 = "ARM implementation is " + (this.armImpl == null ? "not " : "") + "enabled.";
            Tr.debug(tc, string3);
        }
        if (this.armImpl != null) {
            this.armImpl.init(string, string2);
        }
        Tr.exit(tc, "init");
    }

    protected void end(PmiRmThreadCtx pmiRmThreadCtx, String string, String string2) {
        Tr.entry(tc, "end");
        if (PmiReqMetricsImpl.getInstance().isLogEnabled()) {
            this.writeRmTraceLog("end", pmiRmThreadCtx, string, string2);
        }
        if (this.armImpl != null) {
            this.armImpl.end(pmiRmThreadCtx, string, string2);
        }
        Tr.exit(tc, "end");
    }

    protected void setArrivalTime(PmiRmThreadCtx pmiRmThreadCtx, int n) {
        Tr.entry(tc, "setArrivalTime");
        PmiRmArmXfc pmiRmArmXfc = this.getArmImpl(pmiRmThreadCtx.getConfig());
        if (pmiRmArmXfc != null) {
            pmiRmArmXfc.setArrivalTime(pmiRmThreadCtx, n);
        }
        Tr.exit(tc, "setArrivalTime");
    }

    protected void start(PmiRmThreadCtx pmiRmThreadCtx, int n, String string, String[] stringArray) {
        boolean bl = trDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (trDebug) {
            Tr.debug(tc, "start, compId=" + n + ", reqDetail=" + string);
        }
        byte[] byArray = PmiRmArmWrapper.getArmCorrelator(pmiRmThreadCtx);
        boolean bl2 = this.isArmTraceEnabled(n, byArray);
        this.start(pmiRmThreadCtx, n, bl2, string, stringArray);
    }

    protected void start(PmiRmThreadCtx pmiRmThreadCtx, int n, boolean bl, String string, String[] stringArray) {
        int n2;
        trDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        PmiRmCallContext pmiRmCallContext = null;
        if (trDebug) {
            Tr.debug(tc, "start with armTraceEnabled=" + bl + ", compId=" + n + ", reqDetail=" + string);
        }
        PmiRmArmXfc pmiRmArmXfc = this.getArmImpl(pmiRmThreadCtx.getConfig());
        String string2 = PmiRmRegistration.getIdentityName(n);
        if (string == null) {
            string = this.getDetailFromContext(n, stringArray);
        }
        if (bl && pmiRmArmXfc != null && (pmiRmCallContext = pmiRmArmXfc.start(pmiRmThreadCtx, n, n2 = pmiRmArmXfc.getid(pmiRmThreadCtx, string2, string), string2, string, stringArray)) != null) {
            PmiRmArmWrapper.pushContext(pmiRmThreadCtx, pmiRmCallContext);
            if (pmiRmThreadCtx.isInContextPool()) {
                pmiRmThreadCtx.updateReqCallLevel(1);
            }
        }
        if (pmiRmCallContext == null && PmiReqMetricsImpl.getInstance().isLogEnabled()) {
            PmiRmArmWrapper.createOrCopyCorrelatorAndPush(pmiRmThreadCtx, string2, string);
            if (pmiRmThreadCtx.isInContextPool()) {
                pmiRmThreadCtx.updateReqCallLevel(1);
            }
        }
    }

    private String getDetailFromContext(int n, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "UNKNOWN";
        }
        return stringArray[0];
    }

    protected static void createOrCopyCorrelatorAndPush(PmiRmThreadCtx pmiRmThreadCtx, String string, String string2) {
        Object var3_3 = null;
        PmiRmCorrelator pmiRmCorrelator = null;
        pmiRmCorrelator = PmiRmArmWrapper.createOrCopyCorrelator(pmiRmThreadCtx, string, string2);
        if (pmiRmCorrelator != null) {
            PmiRmArmWrapper.pushContext(pmiRmThreadCtx, pmiRmCorrelator, string, string2);
        }
    }

    public static PmiRmCorrelator createOrCopyCorrelator(PmiRmThreadCtx pmiRmThreadCtx, String string, String string2) {
        PmiRmCorrelator pmiRmCorrelator = null;
        try {
            PmiRmArmTx pmiRmArmTx = PmiRmArmWrapper.peekArmTransaction(pmiRmThreadCtx);
            byte[] byArray = null;
            if (pmiRmArmTx != null) {
                byArray = pmiRmArmTx.getCorrelatorBytes();
            }
            pmiRmCorrelator = PmiReqMetricsImpl.createCorrelator(pmiRmThreadCtx);
            pmiRmCorrelator._armCorrelator = byArray;
            return pmiRmCorrelator;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper.createOrCopyCorrelator", FFDC_ID_8);
            exception.printStackTrace();
            return null;
        }
    }

    protected void stop(PmiRmThreadCtx pmiRmThreadCtx, int n, int n2, Properties properties) {
        if (trDebug) {
            Tr.debug(tc, "stop");
        }
        byte[] byArray = PmiRmArmWrapper.getArmCorrelator(pmiRmThreadCtx);
        boolean bl = this.isArmTraceEnabled(n, byArray);
        this.stop(pmiRmThreadCtx, bl, n2, properties);
    }

    protected void stop(PmiRmThreadCtx pmiRmThreadCtx, boolean bl, int n, Properties properties) {
        PmiRmCallContext pmiRmCallContext;
        if (trDebug) {
            Tr.debug(tc, "stop with armTraceEnabled=" + bl);
        }
        if ((pmiRmCallContext = PmiRmArmWrapper.cleanupAndPeekContext(pmiRmThreadCtx)) != null) {
            PmiRmArmXfc pmiRmArmXfc = this.getArmImpl(pmiRmThreadCtx.getConfig());
            boolean bl2 = false;
            if (pmiRmThreadCtx.getConfig().isLogEnabled()) {
                this.writeRmTraceLog(pmiRmThreadCtx, pmiRmCallContext);
                bl2 = true;
            }
            if (bl && pmiRmArmXfc != null) {
                pmiRmArmXfc.stop(n, pmiRmThreadCtx, pmiRmCallContext._reqType, pmiRmCallContext._reqDetail, properties);
                bl2 = true;
            }
            if (bl2) {
                PmiRmArmWrapper.popContext(pmiRmThreadCtx);
                if (pmiRmThreadCtx.isInContextPool()) {
                    pmiRmThreadCtx.updateReqCallLevel(-1);
                }
            }
        } else if (trDebug) {
            Tr.debug(tc, "stop, cleanupAndPeekContext returns null, so do nothing for stop");
        }
    }

    protected void updateBegin(PmiRmThreadCtx pmiRmThreadCtx, int n, String string, String string2, String[] stringArray) {
        block7: {
            if (trDebug) {
                Tr.debug(tc, "updateBegin, rmContxt=" + pmiRmThreadCtx + ", regId=" + n + ", reqType=" + string);
            }
            try {
                PmiRmArmTx pmiRmArmTx = (PmiRmArmTx)pmiRmThreadCtx.peekContext();
                if (pmiRmArmTx == null) {
                    if (trDebug) {
                        Tr.debug(tc, "updateBegin: do nothing since no corrlator is at stack");
                    }
                    return;
                }
                boolean bl = pmirm.isARMEnabled();
                if (!bl) {
                    this.updateBegin(pmiRmThreadCtx, n, false, string, string2, stringArray);
                } else {
                    byte[] byArray = pmiRmArmTx.getCorrelatorBytes();
                    boolean bl2 = this.isArmTraceEnabled(n, byArray);
                    this.updateBegin(pmiRmThreadCtx, n, bl2, string, string2, stringArray);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper.updateBegin", FFDC_ID_1, this);
                if (!trDebug) break block7;
                exception.printStackTrace();
            }
        }
    }

    protected void updateBegin(PmiRmThreadCtx pmiRmThreadCtx, int n, boolean bl, String string, String string2, String[] stringArray) {
        if (trDebug) {
            Tr.debug(tc, "updateBegin with armTraceEnabled=" + bl);
        }
        PmiRmCallContext pmiRmCallContext = null;
        PmiRmArmXfc pmiRmArmXfc = this.getArmImpl(pmiRmThreadCtx.getConfig());
        if (bl && pmiRmArmXfc != null) {
            pmiRmCallContext = pmiRmArmXfc.updateBegin(pmiRmThreadCtx, n, string, string2, stringArray, pmiRmThreadCtx.getConfig().isLogEnabled());
            if (pmiRmCallContext != null) {
                PmiRmArmWrapper.pushContext(pmiRmThreadCtx, pmiRmCallContext);
            }
            if (pmirm.getArmType() == PmiRmArmTxFactory.ARM4_TYPE && pmiRmThreadCtx.getConfig().isTraceDebugEnabled()) {
                PmiRmCallContext pmiRmCallContext2 = pmiRmArmXfc.start(pmiRmThreadCtx, n, 1, string, string2, stringArray);
                PmiRmArmWrapper.pushContext(pmiRmThreadCtx, pmiRmCallContext2);
            }
        }
        if (pmiRmCallContext == null && pmirm.isLogEnabled()) {
            PmiRmArmWrapper.createOrCopyCorrelatorAndPush(pmiRmThreadCtx, string, string2);
        }
    }

    protected void updateEnd(PmiRmThreadCtx pmiRmThreadCtx, int n, int n2, Properties properties) {
        block7: {
            if (trDebug) {
                Tr.debug(tc, "updateEnd, rmContext=" + pmiRmThreadCtx + ", compId=" + n + ", status=" + n2);
            }
            try {
                PmiRmArmTx pmiRmArmTx = (PmiRmArmTx)pmiRmThreadCtx.peekContext();
                if (pmiRmArmTx == null) {
                    if (trDebug) {
                        Tr.debug(tc, "updateEnd: do nothing since no corrlator is at stack");
                    }
                    return;
                }
                boolean bl = pmirm.isARMEnabled();
                if (!bl) {
                    this.updateEnd(pmiRmThreadCtx, false, n2, properties);
                } else {
                    byte[] byArray = pmiRmArmTx.getCorrelatorBytes();
                    boolean bl2 = this.isArmTraceEnabled(n, byArray);
                    this.updateEnd(pmiRmThreadCtx, bl2, n2, properties);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper.updateEnd", FFDC_ID_2, this);
                if (!trDebug) break block7;
                exception.printStackTrace();
            }
        }
    }

    protected void updateEnd(PmiRmThreadCtx pmiRmThreadCtx, boolean bl, int n, Properties properties) {
        PmiRmCallContext pmiRmCallContext;
        if (trDebug) {
            Tr.debug(tc, "updateEnd with armTraceEnabled=" + bl + ", armType=" + pmirm.getArmType());
        }
        if ((pmiRmCallContext = PmiRmArmWrapper.cleanupAndPeekContext(pmiRmThreadCtx)) != null) {
            boolean bl2;
            PmiRmArmXfc pmiRmArmXfc = this.getArmImpl(pmiRmThreadCtx.getConfig());
            if (bl && pmiRmArmXfc != null) {
                if (pmirm.getArmType() == PmiRmArmTxFactory.ARM4_TYPE && pmiRmThreadCtx.getConfig().isTraceDebugEnabled()) {
                    pmiRmArmXfc.stop(n, pmiRmThreadCtx, pmiRmCallContext._reqType, pmiRmCallContext._reqDetail, properties);
                    PmiRmArmWrapper.popContext(pmiRmThreadCtx);
                }
                pmiRmArmXfc.updateEnd(n, pmiRmThreadCtx, pmiRmCallContext._reqType, pmiRmCallContext._reqDetail, properties, pmiRmThreadCtx.getConfig().isLogEnabled());
            }
            if (bl2 = pmirm.isLogEnabled()) {
                this.writeRmTraceLog(pmiRmThreadCtx, pmiRmCallContext);
            }
            if (bl2 || bl && pmirm.getArmType() == PmiRmArmTxFactory.TIVOLI_TYPE && pmiRmArmXfc != null) {
                PmiRmArmWrapper.popContext(pmiRmThreadCtx);
            }
        }
    }

    protected void bindThread(PmiRmThreadCtx pmiRmThreadCtx, int n, String string, String string2) {
        PmiRmCallContext pmiRmCallContext = null;
        if (trDebug) {
            Tr.debug(tc, "bindThread");
        }
        byte[] byArray = PmiRmArmWrapper.getArmCorrelator(pmiRmThreadCtx);
        boolean bl = this.isArmTraceEnabled(n, byArray);
        PmiRmArmXfc pmiRmArmXfc = this.getArmImpl(pmiRmThreadCtx.getConfig());
        if (bl && pmiRmArmXfc != null && (pmiRmCallContext = pmiRmArmXfc.bindThread(pmiRmThreadCtx, string, string2)) != null) {
            PmiRmArmWrapper.pushContext(pmiRmThreadCtx, pmiRmCallContext);
        }
        if (pmiRmCallContext == null && PmiReqMetricsImpl.getInstance().isLogEnabled()) {
            PmiRmArmWrapper.createOrCopyCorrelatorAndPush(pmiRmThreadCtx, string, string2);
        }
    }

    protected void unbindThread(PmiRmThreadCtx pmiRmThreadCtx, int n, int n2) {
        PmiRmCallContext pmiRmCallContext;
        if (trDebug) {
            Tr.debug(tc, "unbindThread");
        }
        if ((pmiRmCallContext = PmiRmArmWrapper.cleanupAndPeekContext(pmiRmThreadCtx)) != null) {
            byte[] byArray = PmiRmArmWrapper.getArmCorrelator(pmiRmThreadCtx);
            boolean bl = this.isArmTraceEnabled(n, byArray);
            PmiRmArmXfc pmiRmArmXfc = this.getArmImpl(pmiRmThreadCtx.getConfig());
            boolean bl2 = false;
            if (bl && pmiRmArmXfc != null) {
                pmiRmArmXfc.unbindThread(n2, pmiRmThreadCtx, pmiRmCallContext._reqType, pmiRmCallContext._reqDetail);
                bl2 = true;
            }
            if (pmirm.isLogEnabled()) {
                this.writeRmTraceLog(pmiRmThreadCtx, pmiRmCallContext);
                bl2 = true;
            }
            if (bl2) {
                PmiRmArmWrapper.popContext(pmiRmThreadCtx);
            }
        }
    }

    private void writeRmTraceLog(String string, PmiRmThreadCtx pmiRmThreadCtx, String string2, Object object) {
    }

    private void writeRmTraceLog(PmiRmThreadCtx pmiRmThreadCtx, PmiRmCallContext pmiRmCallContext) {
        if (trDebug) {
            Tr.debug(tc, "writeRmTraceLog");
        }
        PmiRmCorrelator pmiRmCorrelator = null;
        PmiRmCorrelator pmiRmCorrelator2 = null;
        PmiRmCallContext pmiRmCallContext2 = PmiRmArmWrapper.peekContext(pmiRmThreadCtx);
        PmiRmCallContext pmiRmCallContext3 = PmiRmArmWrapper.peekParentContext(pmiRmThreadCtx);
        if (pmiRmCallContext2 != null) {
            pmiRmCorrelator = pmiRmCallContext2.getCorrelator();
            if (trDebug) {
                Tr.debug(tc, "writeRmTraceLog: curCC != null");
                if (pmiRmCorrelator != null) {
                    Tr.debug(tc, "writeRmTraceLog: curCorr._fTrace=" + pmiRmCorrelator._fTrace);
                }
            }
        }
        if (pmiRmCallContext3 != null) {
            if (trDebug) {
                Tr.debug(tc, "writeRmTraceLog: parentCC != null");
            }
            if ((pmiRmCorrelator2 = pmiRmCallContext3.getCorrelator()).getVersion() == -1) {
                pmiRmCorrelator2 = null;
            }
        }
        if (pmiRmCorrelator != null && pmiRmCorrelator._fTrace) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" ");
            if (pmiRmCorrelator2 != null) {
                stringBuffer.append(pmiRmCorrelator2.formatAsParent());
            } else {
                stringBuffer.append(pmiRmCorrelator.formatAsParent());
            }
            stringBuffer.append(" - ");
            stringBuffer.append(pmiRmCorrelator.formatAsCurrent());
            stringBuffer.append(" type=");
            stringBuffer.append(pmiRmCallContext2._reqType);
            stringBuffer.append(" detail=");
            stringBuffer.append(pmiRmCallContext2._reqDetail);
            stringBuffer.append(" elapsed=");
            stringBuffer.append(System.currentTimeMillis() - pmiRmCallContext2._startTime);
            Tr.info(tc, "PMRM0003I", new Object[]{stringBuffer.toString()});
        }
    }

    public byte[] correlatorFromString(String string) {
        Tr.entry(tc, "correlatorFromString");
        byte[] byArray = PmiRmArmWrapper.fromHexString(string);
        Tr.exit(tc, "correlatorFromString");
        return byArray;
    }

    public static byte[] fromHexString(String string) {
        int n = 0;
        byte[] byArray = null;
        if (string != null) {
            n = string.length() / 2;
            byArray = new byte[n];
            for (int i = 0; i < n * 2; i += 2) {
                String string2 = "0x" + string.substring(i, i + 2);
                int n2 = Integer.decode(string2);
                byte by = n2 < 128 ? (byte)n2 : (byte)(n2 -= 256);
                byArray[i / 2] = by;
            }
        }
        return byArray;
    }

    public static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null && byArray.length > 0) {
            for (int i = 0; i < byArray.length; ++i) {
                String string = PmiRmArmWrapper.byteToHexString(byArray[i]);
                if (string.length() == 1) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public static String byteToHexString(byte by) {
        String string = Integer.toHexString(by);
        if (by < 0) {
            int n = string.length();
            string = string.substring(n - 2, n);
        }
        return string.toUpperCase();
    }

    private void writeRmInitTraceLog(String string, String string2) {
        if (PmiReqMetricsImpl.getInstance().isARMEnabled() || this.armImpl != null) {
            Tr.info(tc, "PMRM0004I", new Object[]{string});
        }
    }

    protected static void setTranId(PmiRmThreadCtx pmiRmThreadCtx, int n) {
        Tr.entry(tc, "setTranId");
        PmiRmCallContext pmiRmCallContext = PmiRmArmWrapper.peekContext(pmiRmThreadCtx);
        if (pmiRmCallContext != null) {
            pmiRmCallContext._tranId = n;
        }
        Tr.exit(tc, "setTranId");
    }

    protected static int getTranId(PmiRmThreadCtx pmiRmThreadCtx) {
        Tr.entry(tc, "getTranId");
        int n = 0;
        PmiRmCallContext pmiRmCallContext = PmiRmArmWrapper.peekContext(pmiRmThreadCtx);
        if (pmiRmCallContext != null) {
            n = pmiRmCallContext._tranId;
        }
        Tr.exit(tc, "getTranId");
        return n;
    }

    protected static void setStartHandle(PmiRmThreadCtx pmiRmThreadCtx, int n) {
        Tr.entry(tc, "setStartHandle");
        PmiRmCallContext pmiRmCallContext = PmiRmArmWrapper.peekContext(pmiRmThreadCtx);
        if (pmiRmCallContext != null) {
            pmiRmCallContext._startHandle = n;
        }
        Tr.exit(tc, "setStartHandle");
    }

    public static int getStartHandle(PmiRmThreadCtx pmiRmThreadCtx) {
        Tr.entry(tc, "getStartHandle");
        int n = -1;
        PmiRmCallContext pmiRmCallContext = PmiRmArmWrapper.peekContext(pmiRmThreadCtx);
        if (pmiRmCallContext != null) {
            n = pmiRmCallContext._startHandle;
        }
        Tr.exit(tc, "getStartHandle");
        return n;
    }

    protected static PmiRmCallContext pushParentContext(PmiRmThreadCtx pmiRmThreadCtx, PmiRmCorrelator pmiRmCorrelator, String string, String string2) {
        Tr.entry(tc, "pushContext");
        pmiRmCorrelator.setTrace(pmiRmThreadCtx.getTrace());
        PmiRmCallContext pmiRmCallContext = PmiRmArmWrapper.peekContext(pmiRmThreadCtx);
        PmiRmCallContext pmiRmCallContext2 = null;
        pmiRmCallContext2 = (PmiRmCallContext)pmiRmThreadCtx.acquireCacheObject(0);
        if (null == pmiRmCallContext2) {
            pmiRmCallContext2 = new PmiRmCallContext(pmiRmCorrelator, string, string2, pmiRmCallContext);
        } else {
            pmiRmCallContext2.setCorrelator(pmiRmCorrelator);
            pmiRmCallContext2._reqType = string;
            pmiRmCallContext2._reqDetail = string2;
            pmiRmCallContext2._parent = pmiRmCallContext;
        }
        pmiRmThreadCtx._contextStack.push(pmiRmCallContext2);
        Tr.exit(tc, "pushContext");
        return pmiRmCallContext2;
    }

    protected static PmiRmCallContext pushContext(PmiRmThreadCtx pmiRmThreadCtx, PmiRmCorrelator pmiRmCorrelator, String string, String string2) {
        Tr.entry(tc, "pushContext");
        pmiRmCorrelator.setTrace(pmiRmThreadCtx.getTrace());
        PmiRmCallContext pmiRmCallContext = PmiRmArmWrapper.peekContext(pmiRmThreadCtx);
        ++pmiRmCorrelator._eventCtr;
        PmiRmCallContext pmiRmCallContext2 = null;
        pmiRmCallContext2 = (PmiRmCallContext)pmiRmThreadCtx.acquireCacheObject(0);
        if (null == pmiRmCallContext2) {
            pmiRmCallContext2 = new PmiRmCallContext(pmiRmCorrelator, string, string2, pmiRmCallContext);
        } else {
            pmiRmCallContext2.setCorrelator(pmiRmCorrelator);
            pmiRmCallContext2._reqType = string;
            pmiRmCallContext2._reqDetail = string2;
            pmiRmCallContext2._parent = pmiRmCallContext;
        }
        pmiRmThreadCtx._contextStack.push(pmiRmCallContext2);
        Tr.exit(tc, "pushContext");
        return pmiRmCallContext2;
    }

    protected static PmiRmCallContext pushParentContext(PmiRmThreadCtx pmiRmThreadCtx, PmiRmCallContext pmiRmCallContext) {
        Tr.entry(tc, "pushContext");
        PmiRmCorrelator pmiRmCorrelator = pmiRmCallContext.getCorrelator();
        pmiRmCorrelator.setTrace(pmiRmThreadCtx.getTrace());
        pmiRmThreadCtx._contextStack.push(pmiRmCallContext);
        Tr.exit(tc, "pushContext");
        return pmiRmCallContext;
    }

    protected static PmiRmCallContext pushContext(PmiRmThreadCtx pmiRmThreadCtx, PmiRmCallContext pmiRmCallContext) {
        Tr.entry(tc, "pushContext");
        PmiRmCorrelator pmiRmCorrelator = pmiRmCallContext.getCorrelator();
        pmiRmCorrelator.setTrace(pmiRmThreadCtx.getTrace());
        ++pmiRmCorrelator._eventCtr;
        pmiRmThreadCtx._contextStack.push(pmiRmCallContext);
        Tr.exit(tc, "pushContext");
        return pmiRmCallContext;
    }

    protected static PmiRmCallContext popContext(PmiRmThreadCtx pmiRmThreadCtx) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "popContext");
        }
        PmiRmCallContext pmiRmCallContext = null;
        if (!pmiRmThreadCtx._contextStack.empty()) {
            Object e2 = pmiRmThreadCtx._contextStack.pop();
            if (e2 instanceof PmiRmCallContext) {
                pmiRmCallContext = (PmiRmCallContext)e2;
            } else {
                Tr.warning(tc, "PMRM0208W", "(method popContxt)");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "popContext");
        }
        return pmiRmCallContext;
    }

    public static PmiRmCallContext cleanupAndPopContext(PmiRmThreadCtx pmiRmThreadCtx) {
        Tr.entry(tc, "cleanupAndPopContext");
        PmiRmCallContext pmiRmCallContext = null;
        while (!pmiRmThreadCtx._contextStack.empty()) {
            Object e2 = pmiRmThreadCtx._contextStack.pop();
            if (e2 instanceof PmiRmCallContext) {
                pmiRmCallContext = (PmiRmCallContext)e2;
                break;
            }
            Tr.warning(tc, "PMRM0207W", "(method popContxt)");
        }
        Tr.exit(tc, "cleanAndPopContext");
        return pmiRmCallContext;
    }

    public static PmiRmArmTx peekArmTransaction(PmiRmThreadCtx pmiRmThreadCtx) {
        Tr.entry(tc, "peekArmTransaction");
        if (pmiRmThreadCtx == null) {
            return null;
        }
        PmiRmArmTx pmiRmArmTx = null;
        if (!pmiRmThreadCtx._contextStack.empty()) {
            pmiRmArmTx = (PmiRmArmTx)pmiRmThreadCtx._contextStack.peek();
        }
        Tr.exit(tc, "peekArmTransaction");
        return pmiRmArmTx;
    }

    public static PmiRmCallContext peekContext(PmiRmThreadCtx pmiRmThreadCtx) {
        Tr.entry(tc, "peekContext");
        PmiRmCallContext pmiRmCallContext = null;
        if (!pmiRmThreadCtx._contextStack.empty()) {
            Object e2 = pmiRmThreadCtx._contextStack.peek();
            if (e2 instanceof PmiRmCallContext) {
                pmiRmCallContext = (PmiRmCallContext)e2;
            } else {
                Tr.warning(tc, "PMRM0208W", "(method peekContxt)");
            }
        }
        Tr.exit(tc, "peekContext");
        return pmiRmCallContext;
    }

    public static PmiRmCallContext cleanupAndPeekContext(PmiRmThreadCtx pmiRmThreadCtx) {
        Tr.entry(tc, "cleanupAndPeekContext");
        PmiRmCallContext pmiRmCallContext = null;
        while (!pmiRmThreadCtx._contextStack.empty()) {
            Object e2 = pmiRmThreadCtx._contextStack.peek();
            if (e2 instanceof PmiRmCallContext) {
                pmiRmCallContext = (PmiRmCallContext)e2;
                break;
            }
            Tr.warning(tc, "PMRM0207W", "(method cleanupAndPeekContxt)");
            pmiRmThreadCtx._contextStack.pop();
        }
        Tr.exit(tc, "cleanupAndPeekContext");
        return pmiRmCallContext;
    }

    public static PmiRmCallContext peekParentContext(PmiRmThreadCtx pmiRmThreadCtx) {
        Tr.entry(tc, "peekParentContext");
        PmiRmCallContext pmiRmCallContext = null;
        PmiRmCallContext pmiRmCallContext2 = null;
        if (!pmiRmThreadCtx._contextStack.empty() && (pmiRmCallContext2 = (PmiRmCallContext)pmiRmThreadCtx._contextStack.peek()) != null) {
            pmiRmCallContext = pmiRmCallContext2.getParent();
        }
        Tr.exit(tc, "peekParentContext");
        return pmiRmCallContext;
    }

    protected static PmiRmCorrelator getCorrelator(PmiRmThreadCtx pmiRmThreadCtx) {
        Tr.entry(tc, "getCorrelator");
        PmiRmCorrelator pmiRmCorrelator = null;
        PmiRmCallContext pmiRmCallContext = PmiRmArmWrapper.peekContext(pmiRmThreadCtx);
        if (pmiRmCallContext != null) {
            pmiRmCorrelator = pmiRmCallContext.getCorrelator();
        }
        Tr.exit(tc, "getCorrelator");
        return pmiRmCorrelator;
    }

    protected static PmiRmCorrelator getParentCorrelator(PmiRmThreadCtx pmiRmThreadCtx) {
        Tr.entry(tc, "getParentCorrelator");
        PmiRmCorrelator pmiRmCorrelator = null;
        PmiRmCallContext pmiRmCallContext = null;
        PmiRmCallContext pmiRmCallContext2 = null;
        pmiRmCallContext2 = PmiRmArmWrapper.peekContext(pmiRmThreadCtx);
        if (pmiRmCallContext2 != null) {
            pmiRmCallContext = pmiRmCallContext2.getParent();
        }
        if (pmiRmCallContext != null) {
            pmiRmCorrelator = pmiRmCallContext.getCorrelator();
        }
        Tr.exit(tc, "getParentCorrelator");
        return pmiRmCorrelator;
    }

    protected static void setArmTx(PmiRmThreadCtx pmiRmThreadCtx, Object object) {
        PmiRmCallContext pmiRmCallContext = PmiRmArmWrapper.peekContext(pmiRmThreadCtx);
        if (pmiRmCallContext != null) {
            pmiRmCallContext.setArmTxObj(object);
        }
    }

    protected static Object getArmTx(PmiRmThreadCtx pmiRmThreadCtx) {
        Object object = null;
        PmiRmCallContext pmiRmCallContext = PmiRmArmWrapper.peekContext(pmiRmThreadCtx);
        if (pmiRmCallContext != null) {
            object = pmiRmCallContext.getArmTxObj();
        }
        return object;
    }

    protected static String getArmTxFactoryName() {
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        return pmiRmConfigData.getArmTransactionFactory();
    }

    public boolean isArmTraceEnabled(int n, byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (byArray == null) {
            if (bl) {
                Tr.debug(tc, "null ARM correlator bytes passed to isTraceEnabled, returns true in this case");
            }
            return true;
        }
        PmiRmArmTransactionCallback pmiRmArmTransactionCallback = pmirm.getArmCallback();
        boolean bl3 = true;
        if (pmiRmArmTransactionCallback != null) {
            PmiRmArmComponentCallback pmiRmArmComponentCallback = pmiRmArmTransactionCallback.getComponentCallback(byArray);
            if (pmiRmArmComponentCallback != null) {
                bl3 = pmiRmArmComponentCallback.isTraceEnabled(n);
            }
        } else if (bl) {
            Tr.debug(tc, "isTraceEnabled: no PmiRmArmTransactionCallback is registered with request metrics");
        }
        if (bl) {
            Tr.debug(tc, "isTraceEnabled returns " + bl3);
        }
        return bl3;
    }
}

