/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.pmi.reqmetrics.PmiRmCallContext;
import com.ibm.ws.pmi.reqmetrics.PmiRmCorrelator;
import java.util.ArrayList;

public class PmiRmCache {
    private static final TraceComponent tc = Tr.register(PmiRmCache.class, "pmi.rm", "com.ibm.ws.pmi.reqmetrics.reqmetrics");
    private ArrayList cache;
    private int currObjectToReturn = 0;
    private int cacheType = -1;
    boolean fDebug = tc.isDebugEnabled();

    PmiRmCache(int n) {
        this.cacheType = n;
        this.cache = new ArrayList();
    }

    protected Object acquireCacheObject() {
        this.fDebug = tc.isDebugEnabled();
        if (this.fDebug) {
            Tr.entry(tc, "acquireCacheObject");
        }
        if (this.cache.isEmpty()) {
            if (this.fDebug) {
                Tr.debug(tc, "CACHE IS EMPTY");
            }
            return null;
        }
        --this.currObjectToReturn;
        Object e2 = this.cache.remove(this.currObjectToReturn);
        PmiRmCallContext pmiRmCallContext = null;
        PmiRmCorrelator pmiRmCorrelator = null;
        if (this.cacheType == 0) {
            pmiRmCallContext = (PmiRmCallContext)e2;
            pmiRmCallContext.reset();
            if (this.fDebug) {
                Tr.debug(tc, "Cache hit for Call context cache");
                Tr.exit(tc, "acquireCacheObject");
            }
            return pmiRmCallContext;
        }
        if (this.cacheType == 1) {
            pmiRmCorrelator = (PmiRmCorrelator)e2;
            pmiRmCorrelator.reset();
            if (this.fDebug) {
                Tr.debug(tc, "Cache hit for Correlator cache");
                Tr.exit(tc, "acquireCacheObject");
            }
            return pmiRmCorrelator;
        }
        if (this.fDebug) {
            Tr.debug(tc, "Cache miss for cache type " + this.cacheType);
            Tr.exit(tc, "acquireCacheObject");
        }
        return null;
    }

    protected boolean releaseCacheObject(Object object) {
        this.fDebug = tc.isDebugEnabled();
        if (this.fDebug) {
            Tr.entry(tc, "releaseCacheObject");
        }
        if (null == object) {
            if (this.fDebug) {
                Tr.debug(tc, "CACHE OBJECT PASSED IS NULL");
            }
            return false;
        }
        this.cache.add(object);
        ++this.currObjectToReturn;
        if (this.fDebug) {
            Tr.debug(tc, "Grew cache by 1 for cache type " + this.cacheType);
            Tr.exit(tc, "releaseCacheObject");
        }
        return true;
    }
}

