/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.pmi.reqmetrics.PmiRmFilterConfig;
import com.ibm.ws.pmi.reqmetrics.PmiRmFilterConfigImpl;
import com.ibm.ws.pmi.reqmetrics.extensibleFilter.ExtensibleFilterContainer;
import com.ibm.ws.pmi.reqmetrics.jms.JmsFilterCfg;
import com.ibm.ws.pmi.reqmetrics.wsHandlers.WsFilterCfg;
import java.util.ArrayList;

public class PmiRmConfigData {
    protected boolean _fRmEnabled = false;
    protected boolean _fRmReallyEnabled = false;
    protected boolean _fARMEnabled = false;
    protected boolean _fLogEnabled = true;
    protected int _traceLevel = 0;
    protected PmiRmFilterConfig[] _filters = new PmiRmFilterConfigImpl[5];
    protected ArrayList enabledComponents = null;
    protected ArrayList instrumentedComponents = null;
    protected int _armType = 0;
    protected String armTransactionFactory = "";
    protected ExtensibleFilterContainer filterCtr = null;
    protected int _traceBufferSz = 64;
    protected String _ARM_CORRELATOR_HEADER_NAME = "ARM_CORRELATOR";
    public static final int _ARM_NONE = 0;
    public static final int _TRACE_NONE = 0;
    public static final int _TRACE_HOPS = 1;
    public static final int _TRACE_PERF_DEBUG = 2;
    public static final int _TRACE_DEBUG = 3;
    private static final TraceComponent tc = Tr.register(PmiRmConfigData.class.getName(), "pmi.rm", "com.ibm.ws.pmi.reqmetrics.reqmetrics");

    public PmiRmConfigData() {
        this._filters[0] = new PmiRmFilterConfigImpl("URI");
        this._filters[1] = new PmiRmFilterConfigImpl("EJB");
        this._filters[2] = new PmiRmFilterConfigImpl("SOURCE_IP");
        this._filters[3] = new JmsFilterCfg();
        this._filters[4] = new WsFilterCfg();
    }

    public PmiRmFilterConfig getIpFilterConfig() {
        if (!this._filters[2].getFilterType().equals("SOURCE_IP")) {
            Tr.error(tc, "PMRM0104E");
        }
        return this._filters[2];
    }

    public PmiRmFilterConfig getUriFilterConfig() {
        if (!this._filters[0].getFilterType().equals("URI")) {
            Tr.error(tc, "PMRM0105E");
        }
        return this._filters[0];
    }

    public PmiRmFilterConfig getEjbFilterConfig() {
        if (!this._filters[1].getFilterType().equals("EJB")) {
            Tr.error(tc, "PMRM0106E");
        }
        return this._filters[1];
    }

    public PmiRmFilterConfig getJmsFilterConfig() {
        if (!this._filters[3].getFilterType().equals("JMS")) {
            Tr.error(tc, "PMRM0106E");
        }
        return this._filters[3];
    }

    public PmiRmFilterConfig getWSFilterConfig() {
        if (!this._filters[4].getFilterType().equals("WEB_SERVICES")) {
            Tr.error(tc, "PMRM0106E");
        }
        return this._filters[4];
    }

    public boolean isRmEnabled() {
        return this._fRmEnabled;
    }

    public boolean isRmReallyEnabled() {
        return this._fRmReallyEnabled;
    }

    public boolean isARMEnabled() {
        return this._fARMEnabled;
    }

    public boolean isLogEnabled() {
        return this._fLogEnabled;
    }

    public boolean isTraceEnabled() {
        return this._traceLevel >= 1;
    }

    public boolean isTraceDebugEnabled() {
        return this._traceLevel >= 3;
    }

    public boolean isTracePerfDebugEnabled() {
        return this._traceLevel >= 2;
    }

    public int getTraceLevel() {
        return this._traceLevel;
    }

    public void setTraceLevel(int n) {
        this._traceLevel = n;
    }

    protected synchronized PmiRmConfigData copy() {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copy");
        }
        PmiRmConfigData pmiRmConfigData = new PmiRmConfigData();
        pmiRmConfigData._fRmEnabled = this._fRmEnabled;
        pmiRmConfigData._fRmReallyEnabled = this._fRmReallyEnabled;
        pmiRmConfigData._fARMEnabled = this._fARMEnabled;
        pmiRmConfigData._fLogEnabled = this._fLogEnabled;
        pmiRmConfigData._armType = this._armType;
        pmiRmConfigData._traceLevel = this._traceLevel;
        pmiRmConfigData._traceBufferSz = this._traceBufferSz;
        pmiRmConfigData._ARM_CORRELATOR_HEADER_NAME = this._ARM_CORRELATOR_HEADER_NAME;
        pmiRmConfigData.enabledComponents = new ArrayList();
        pmiRmConfigData.instrumentedComponents = new ArrayList();
        if (this.enabledComponents == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copy, null enabledComponents");
            }
        } else {
            for (n = 0; n < this.enabledComponents.size(); ++n) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "copy, enable component=" + (String)this.enabledComponents.get(n));
                }
                pmiRmConfigData.enabledComponents.add(this.enabledComponents.get(n));
            }
        }
        if (this.instrumentedComponents == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copy, null enabledComponents");
            }
        } else {
            for (n = 0; n < this.instrumentedComponents.size(); ++n) {
                pmiRmConfigData.instrumentedComponents.add(this.instrumentedComponents.get(n));
            }
        }
        pmiRmConfigData.armTransactionFactory = this.armTransactionFactory;
        pmiRmConfigData.filterCtr = this.filterCtr;
        for (n = 0; n < this._filters.length; ++n) {
            pmiRmConfigData._filters[n] = this._filters[n].copy();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copy");
        }
        return pmiRmConfigData;
    }

    public String getArmCorrelatorHeaderName() {
        return this._ARM_CORRELATOR_HEADER_NAME;
    }

    protected void setArmCorrelatorHeaderName(String string) {
        this._ARM_CORRELATOR_HEADER_NAME = string;
    }

    protected String getArmTransactionFactory() {
        return this.armTransactionFactory;
    }

    protected void setArmTransactionFactory(String string) {
        this.armTransactionFactory = string;
    }

    protected void setExtensibleFilterContainer(ExtensibleFilterContainer extensibleFilterContainer) {
        this.filterCtr = extensibleFilterContainer;
    }

    protected ExtensibleFilterContainer getExtensibleFilterContainer() {
        return this.filterCtr;
    }
}

