/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl;
import com.ibm.ws.pmi.reqmetrics.PmiRmThreadCtx;
import java.io.Serializable;

public class PmiRmCorrelator
implements Serializable {
    private static final long serialVersionUID = -945270137139783508L;
    private static final String SOURCE_FILE = "com.ibm.ws.pmi.reqmetrics.PmiRmCorrelator";
    private static final String FFDC_ID_1 = "FFDC-1";
    public static String NOT_IN_FILTER_CORRELATOR_STRING = "filterOut";
    public static String DUMMY_CORRELATOR_STRING = "dummyCorrelator";
    public static String RM_CORRELATOR_HEADER = "rmcorrelator";
    public static final int NOT_IN_FILTER = -10;
    public static final int DUMMY_CORRELATOR = -1;
    protected int _version = 1;
    protected String _hostIP = null;
    protected String _pid = null;
    protected long _time = 0L;
    protected long _reqCtr = 0L;
    protected long _eventCtr = 0L;
    protected boolean _fTrace = false;
    protected byte[] _armCorrelator = null;
    private static TraceComponent tc = Tr.register(PmiRmCorrelator.class.getName(), "pmi.rm", "com.ibm.ws.pmi.reqmetrics.reqmetrics");

    public PmiRmCorrelator(String string, String string2, long l, long l2) {
        this._hostIP = string;
        this._pid = string2;
        this._time = l;
        this._reqCtr = l2;
        this._eventCtr = 0L;
        this._armCorrelator = null;
    }

    public PmiRmCorrelator(int n, String string, String string2, long l, long l2, long l3) {
        this._version = n;
        this._hostIP = string;
        this._pid = string2;
        this._time = l;
        this._reqCtr = l2;
        this._eventCtr = l3;
        this._armCorrelator = null;
        this._fTrace = n != -10;
    }

    public void setTrace(boolean bl) {
        this._fTrace = bl;
    }

    public boolean isTraceOn() {
        return this._fTrace;
    }

    public void setArmCorrelator(byte[] byArray) {
        this._armCorrelator = byArray;
    }

    public byte[] getArmCorrelator() {
        return this._armCorrelator;
    }

    public void incEventCtr() {
        ++this._eventCtr;
    }

    public void dump() {
        Tr.dump(tc, "Correlator dump. ");
        Tr.dump(tc, "\t_fTrace   = " + this._fTrace);
        Tr.dump(tc, "\t_hostIP   = " + this._hostIP);
        Tr.dump(tc, "\t_pid      = " + this._pid);
        Tr.dump(tc, "\t_time     = " + this._time);
        Tr.dump(tc, "\t_reqID    = " + this._reqCtr);
        Tr.dump(tc, "\t_eventCtr = " + this._eventCtr);
    }

    public String formatAsParent() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("parent:");
        this.formatBase(stringBuffer);
        return stringBuffer.toString();
    }

    public String formatAsCurrent() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("current:");
        this.formatBase(stringBuffer);
        return stringBuffer.toString();
    }

    protected StringBuffer formatBase(StringBuffer stringBuffer) {
        stringBuffer.append("ver=");
        stringBuffer.append(this._version);
        stringBuffer.append(",ip=");
        stringBuffer.append(this._hostIP);
        stringBuffer.append(",time=");
        stringBuffer.append(this._time);
        stringBuffer.append(",pid=");
        stringBuffer.append(this._pid);
        stringBuffer.append(",reqid=");
        stringBuffer.append(this._reqCtr);
        stringBuffer.append(",event=");
        stringBuffer.append(this._eventCtr);
        return stringBuffer;
    }

    public static PmiRmCorrelator getPmiRmCorrelatorFromString(String string) {
        boolean bl = tc.isEntryEnabled();
        PmiReqMetricsImpl pmiReqMetricsImpl = PmiReqMetricsImpl.getInstance();
        PmiRmThreadCtx pmiRmThreadCtx = pmiReqMetricsImpl.getThreadContext();
        PmiRmCorrelator pmiRmCorrelator = null;
        if (bl) {
            Tr.entry(tc, "getPmiRmCorrelatorFromString " + string);
        }
        Tr.debug(tc, "getPmiRmCorrelatorFromString " + string);
        try {
            if (string == null || string.equals("")) {
                if (bl) {
                    Tr.exit(tc, "getPmiRmCorrelatorFromString, empty string parameter");
                }
                return null;
            }
            if (string.equals(NOT_IN_FILTER_CORRELATOR_STRING)) {
                pmiRmCorrelator = (PmiRmCorrelator)pmiRmThreadCtx.acquireCacheObject(1);
                if (null == pmiRmCorrelator) {
                    return new PmiRmCorrelator(-10, "na", "na", -1L, -1L, -1L);
                }
                pmiRmCorrelator._version = -10;
                pmiRmCorrelator._hostIP = "na";
                pmiRmCorrelator._pid = "na";
                pmiRmCorrelator._time = -1L;
                pmiRmCorrelator._reqCtr = -1L;
                pmiRmCorrelator._eventCtr = -1L;
                pmiRmCorrelator._armCorrelator = null;
                pmiRmCorrelator._fTrace = false;
                return pmiRmCorrelator;
            }
            if (string.equals(DUMMY_CORRELATOR_STRING)) {
                pmiRmCorrelator = (PmiRmCorrelator)pmiRmThreadCtx.acquireCacheObject(1);
                if (null == pmiRmCorrelator) {
                    return new PmiRmCorrelator(-1, "na", "na", -1L, -1L, -1L);
                }
                pmiRmCorrelator._version = -1;
                pmiRmCorrelator._hostIP = "na";
                pmiRmCorrelator._pid = "na";
                pmiRmCorrelator._time = -1L;
                pmiRmCorrelator._reqCtr = -1L;
                pmiRmCorrelator._eventCtr = -1L;
                pmiRmCorrelator._armCorrelator = null;
                pmiRmCorrelator._fTrace = true;
                return pmiRmCorrelator;
            }
            Integer n = new Integer(PmiRmCorrelator.getValueOf("ver=", string));
            String string2 = PmiRmCorrelator.getValueOf("ip=", string);
            Long l = new Long(PmiRmCorrelator.getValueOf("time=", string));
            String string3 = PmiRmCorrelator.getValueOf("pid=", string);
            Long l2 = new Long(PmiRmCorrelator.getValueOf("reqid=", string));
            Long l3 = new Long(PmiRmCorrelator.getValueOf("event=", string));
            if (bl) {
                Tr.debug(tc, "PmiRmCorrelator: getCorrelatorFromString: ver=" + n + ",ip=" + string2 + ",time=" + l + ",pid=" + string3 + ",reqid=" + l2 + ", eventId=" + l3);
            }
            PmiRmCorrelator pmiRmCorrelator2 = null;
            pmiRmCorrelator2 = (PmiRmCorrelator)pmiRmThreadCtx.acquireCacheObject(1);
            if (null == pmiRmCorrelator2) {
                pmiRmCorrelator2 = new PmiRmCorrelator(n, string2, string3, l, l2, l3);
            } else {
                pmiRmCorrelator2._version = n;
                pmiRmCorrelator2._hostIP = string2;
                pmiRmCorrelator2._pid = string3;
                pmiRmCorrelator2._time = l;
                pmiRmCorrelator2._reqCtr = l2;
                pmiRmCorrelator2._eventCtr = l3;
                pmiRmCorrelator2._armCorrelator = null;
                pmiRmCorrelator2._fTrace = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPmiRmCorrelatorFromString");
            }
            return pmiRmCorrelator2;
        }
        catch (NumberFormatException numberFormatException) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMRM0032E", numberFormatException.toString());
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.pmi.reqmetrics.PmiRmCorrelator.getPmiRmCorrelatorFromString", FFDC_ID_1);
            Tr.warning(tc, "PMRM0032E", exception.toString());
            if (tc.isDebugEnabled()) {
                exception.printStackTrace();
            }
            if (bl) {
                Tr.exit(tc, "getPmiRmCorrelatorFromString");
            }
            return null;
        }
    }

    protected static String getValueOf(String string, String string2) {
        boolean bl = tc.isDebugEnabled();
        int n = string2.indexOf(string);
        if (n < 0) {
            if (bl) {
                Tr.debug(tc, "getValueOf: label=" + string + ", correlator=" + string2 + ", index=" + n);
            }
            return "";
        }
        int n2 = n + string.length();
        if (bl) {
            Tr.debug(tc, "getValueOf: label=" + string + ", correlator=" + string2 + ", index=" + n + ", valueStartIndex=" + n2);
        }
        if (n2 >= string2.length()) {
            return "";
        }
        int n3 = string2.indexOf(",", n2);
        if (n3 < 0) {
            n3 = string2.length();
        }
        String string3 = string2.substring(n2, n3);
        if (bl) {
            Tr.debug(tc, "getValueOf: valueEndIndex=" + n3 + ", value=" + string3);
        }
        return string3;
    }

    public static String getStringFromPmiRmCorrelator(PmiRmCorrelator pmiRmCorrelator) {
        if (pmiRmCorrelator == null) {
            return null;
        }
        if (pmiRmCorrelator.getVersion() == -10) {
            return NOT_IN_FILTER_CORRELATOR_STRING;
        }
        if (pmiRmCorrelator.getVersion() == -1) {
            return DUMMY_CORRELATOR_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("ver=").append(pmiRmCorrelator._version).append(",ip=").append(pmiRmCorrelator._hostIP).append(",time=").append(pmiRmCorrelator._time).append(",pid=").append(pmiRmCorrelator._pid);
        stringBuffer.append(",reqid=").append(pmiRmCorrelator._reqCtr).append(",event=").append(pmiRmCorrelator._eventCtr);
        return stringBuffer.toString();
    }

    public int getVersion() {
        return this._version;
    }

    public void copy(PmiRmCorrelator pmiRmCorrelator) {
        this._version = pmiRmCorrelator._version;
        this._hostIP = pmiRmCorrelator._hostIP;
        this._pid = pmiRmCorrelator._pid;
        this._time = pmiRmCorrelator._time;
        this._reqCtr = pmiRmCorrelator._reqCtr;
        this._eventCtr = pmiRmCorrelator._eventCtr;
        this._fTrace = pmiRmCorrelator._fTrace;
        this._armCorrelator = pmiRmCorrelator._armCorrelator;
    }

    protected PmiRmCorrelator() {
        this._version = 1;
        this._hostIP = "?.?.?.?";
        this._pid = "-1";
        this._time = 0L;
        this._reqCtr = 0L;
        this._eventCtr = 0L;
        this._fTrace = false;
        this._armCorrelator = null;
    }

    protected void reset() {
        this._version = 1;
        this._hostIP = null;
        this._pid = null;
        this._time = 0L;
        this._reqCtr = 0L;
        this._eventCtr = 0L;
        this._fTrace = false;
        this._armCorrelator = null;
    }
}

