/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.reqmetrics;

import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.BeforeActivationAfterCompletionCollaborator;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CollaboratorCookie;
import com.ibm.websphere.csi.EJBConfigData;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl;
import com.ibm.ws.pmi.reqmetrics.PmiRmActivityService;
import com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper;
import com.ibm.ws.pmi.reqmetrics.PmiRmCallContext;
import com.ibm.ws.pmi.reqmetrics.PmiRmConfigData;
import com.ibm.ws.pmi.reqmetrics.PmiRmCorrelator;
import com.ibm.ws.pmi.reqmetrics.PmiRmRegistration;
import com.ibm.ws.pmi.reqmetrics.PmiRmThreadCtx;
import com.ibm.ws.pmi.reqmetrics.PmiRmUtil;
import com.ibm.ws.threadContext.EJSDeployedSupportAccessorImpl;
import java.util.Properties;

public class PmiRmEJBCollaborator
implements BeforeActivationAfterCompletionCollaborator {
    private static final String SOURCE_FILE = "com.ibm.ws.pmi.reqmetrics.PmiRmEJBCollaborator";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private PmiReqMetricsImpl rmImpl = null;
    protected PmiRmActivityService pmirmAS = null;
    private static final TraceComponent tc = Tr.register(PmiRmEJBCollaborator.class.getName(), "pmi.rm", "com.ibm.ws.pmi.reqmetrics.reqmetrics");

    public PmiRmEJBCollaborator(PmiReqMetricsImpl pmiReqMetricsImpl) {
        this.rmImpl = pmiReqMetricsImpl;
        this.pmirmAS = new PmiRmActivityService(pmiReqMetricsImpl);
    }

    public CollaboratorCookie beanInstalled(EJBConfigData eJBConfigData) {
        return null;
    }

    public void beanUninstalled(CollaboratorCookie collaboratorCookie) {
    }

    public CollaboratorCookie preInvoke(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo, CollaboratorCookie collaboratorCookie) throws CSIException {
        if (PmiReqMetricsImpl._rmNotEnabled) {
            return null;
        }
        PmiRmThreadCtx pmiRmThreadCtx = (PmiRmThreadCtx)collaboratorCookie;
        String string = eJBMethodInfo.getAbstractBeanClassName() + "." + eJBMethodInfo.getMethodName();
        if (!eJBMethodInfo.getEJBComponentMetaData().isMessageDrivenBean()) {
            pmiRmThreadCtx = this.ejsPreInvoke(pmiRmThreadCtx, string, this.getEjbContextValues(string, eJBMethodInfo));
        } else {
            pmiRmThreadCtx = this.rmImpl.getThreadContext();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PmiRequestMetricsImpl.ejsPreInvoke, MDB case, do nothing in EJB");
            }
        }
        return pmiRmThreadCtx;
    }

    public void postInvoke(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo, CollaboratorCookie collaboratorCookie, CollaboratorCookie collaboratorCookie2) {
        if (collaboratorCookie == null) {
            return;
        }
        boolean bl = eJBMethodInfo.isLocalInterface();
        this.ejsPostInvoke((PmiRmThreadCtx)collaboratorCookie, eJBMethodInfo, bl);
    }

    private void processInboundEJB(PmiRmConfigData pmiRmConfigData, PmiRmThreadCtx pmiRmThreadCtx, String string, String[] stringArray) {
        Object object;
        boolean bl = false;
        boolean bl2 = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        PmiRmCallContext pmiRmCallContext = PmiRmArmWrapper.peekContext(pmiRmThreadCtx);
        PmiRmCorrelator pmiRmCorrelator = null;
        if (pmiRmCallContext != null) {
            pmiRmCorrelator = pmiRmCallContext.getCorrelator();
            bl = pmiRmCorrelator._fTrace;
        } else {
            object = pmiRmConfigData.getEjbFilterConfig();
            boolean bl3 = object.isEnabled();
            boolean bl4 = false;
            if (bl3) {
                if (bl2) {
                    Tr.debug(tc, "checkingEjbFilter is true for ejb = " + string);
                }
                for (int i = 0; !(i >= object.numFilters() || object.isFilterEnabled(i) && (bl4 = PmiRmUtil.isStrMatched(object.getFilter(i), string))); ++i) {
                }
                bl = bl4;
            } else {
                bl = true;
            }
            if (bl2) {
                Tr.debug(tc, "fTraceRequest = " + bl);
            }
        }
        pmiRmThreadCtx.setInboundInstrumented(bl);
        pmiRmThreadCtx.setTrace(bl);
        if (bl) {
            this.rmImpl.reqStart(pmiRmThreadCtx, 0, string, stringArray);
            pmiRmThreadCtx._ejbTraceLevel = pmiRmThreadCtx._ejbNestingLevel;
        } else if (pmiRmCallContext != null) {
            object = new PmiRmCorrelator(-1, "na", "na", -1L, -1L, -1L);
            PmiRmArmWrapper.pushParentContext(pmiRmThreadCtx, (PmiRmCorrelator)object, "EJB", string);
        }
    }

    public PmiRmThreadCtx ejsPreInvoke(PmiRmThreadCtx pmiRmThreadCtx, String string, String[] stringArray) {
        boolean bl;
        block25: {
            block24: {
                if (!this.rmImpl.isReallyEnabled()) break block24;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback(0)) break block25;
            }
            return null;
        }
        PmiRmEJBCollaborator pmiRmEJBCollaborator = this;
        PmiRmConfigData pmiRmConfigData = pmiRmEJBCollaborator.rmImpl.getConfig();
        boolean bl2 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (pmiRmThreadCtx == null) {
            pmiRmThreadCtx = this.rmImpl.resetContext(pmiRmThreadCtx, false);
        }
        if (bl) {
            Tr.debug(tc, "PmiRequestMetricsImpl.ejsPreInvoke: " + string);
            Tr.debug(tc, "PmiRequestMetricsImpl.ejsPreInvoke:inboundComponent=" + pmiRmThreadCtx.getInboundComponent());
        }
        boolean bl3 = false;
        pmiRmThreadCtx.incrEjbNestingLevel();
        if (pmiRmThreadCtx.getInboundComponent() == 0) {
            if (pmiRmThreadCtx._ejbNestingLevel > 1) {
                bl3 = true;
            }
        } else {
            if (pmiRmThreadCtx.getInboundComponent() < 0) {
                if (bl) {
                    Tr.debug(tc, "PmiRequestMetricsImpl.ejsPreInvoke, MDB case, do nothing in EJB");
                }
                return pmiRmThreadCtx;
            }
            bl3 = true;
            if (pmiRmThreadCtx._ejbNestingLevel == 1) {
                pmiRmThreadCtx.incrEjbNestingLevel();
            }
        }
        if (!bl3 && pmiRmThreadCtx.isInboundInstrumented()) {
            if (bl) {
                Tr.debug(tc, "ejsPreInvoke: inbound EJB request has no incoming correlator, so always instrument it");
            }
        } else if (!PmiRmRegistration.isComponentEnabled(0)) {
            if (bl) {
                Tr.debug(tc, "ejsPreInvoke: EJB component is disabled for request metrics instrumentation");
            }
            return pmiRmThreadCtx;
        }
        if (pmiRmConfigData._traceLevel < 2 && bl3) {
            return pmiRmThreadCtx;
        }
        if (pmiRmConfigData._traceLevel == 2 && pmiRmThreadCtx._ejbNestingLevel > 2) {
            return pmiRmThreadCtx;
        }
        if (bl3) {
            if (bl) {
                Tr.debug(tc, "ejsPreInvoke: nested call, thread context _fTrace=" + pmiRmThreadCtx._fTrace);
            }
            if (!pmiRmThreadCtx._fTrace) {
                return pmiRmThreadCtx;
            }
            this.rmImpl.reqStart(pmiRmThreadCtx, 0, string, stringArray);
            pmiRmThreadCtx._ejbTraceLevel = pmiRmThreadCtx._ejbNestingLevel;
        } else {
            if (bl) {
                Tr.debug(tc, "ejsPreInvoke: call processInboundEJB");
            }
            this.processInboundEJB(pmiRmConfigData, pmiRmThreadCtx, string, stringArray);
        }
        return pmiRmThreadCtx;
    }

    public void ejsPostInvoke(PmiRmThreadCtx pmiRmThreadCtx, EJBMethodInfo eJBMethodInfo, boolean bl) {
        if (!this.rmImpl.isReallyEnabled() || !PmiReqMetricsImpl.isComponentEnabledInArmCallback(0)) {
            return;
        }
        if (pmiRmThreadCtx.getInboundComponent() == 8) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ejsPostInvoke, ejbNestingLevel=" + pmiRmThreadCtx._ejbNestingLevel + ". MDB case, do nothing in EJB");
            }
            return;
        }
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        if (!PmiRmRegistration.isComponentEnabled(0)) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ejsPostInvoke, ejbNestingLevel=" + pmiRmThreadCtx._ejbNestingLevel);
        }
        if (pmiRmThreadCtx._ejbTraceLevel < pmiRmThreadCtx._ejbNestingLevel) {
            pmiRmThreadCtx.decrEjbNestingLevel();
            return;
        }
        int n = 0;
        ContainerTx containerTx = EJSDeployedSupportAccessorImpl.getEJSDeployedSupportAccessor().getEJSDeployedSupport().getCurrentTx();
        if (containerTx == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ejsPostInvoke: containerTx is null, set status to be GOOD");
            }
        } else if (containerTx.getRollbackOnly()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ejsPostInvoke: containerTx.getRollbackOnly returns true, set status to be FAILED");
            }
            n = 2;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ejsPostInvoke: containerTx.getRollbackOnly returns false, set status to be GOOD");
        }
        Properties properties = this.getTranDetailData(pmiRmThreadCtx, eJBMethodInfo);
        if (pmiRmThreadCtx._ejbNestingLevel != 1) {
            this.rmImpl.reqStop(pmiRmThreadCtx, 0, 3, n, properties);
            pmiRmThreadCtx.decrEjbNestingLevel();
            pmiRmThreadCtx._ejbTraceLevel = pmiRmThreadCtx._ejbNestingLevel;
        } else {
            pmiRmThreadCtx.setEjbTranStatus(n);
            pmiRmThreadCtx.setTranDetailProps(properties);
            if (bl) {
                this.pmirmAS.requestComplete();
            }
        }
    }

    private String[] getEjbContextValues(String string, EJBMethodInfo eJBMethodInfo) {
        if (!PmiReqMetricsImpl.getConfig().isARMEnabled()) {
            return null;
        }
        return new String[]{string, eJBMethodInfo.getJ2EEName().getApplication(), eJBMethodInfo.getJ2EEName().getModule(), string};
    }

    private Properties getTranDetailData(PmiRmThreadCtx pmiRmThreadCtx, EJBMethodInfo eJBMethodInfo) {
        int n = this.rmImpl.getTranDetailLevel(pmiRmThreadCtx, 0);
        if (n < 2) {
            return null;
        }
        Properties properties = new Properties();
        boolean bl = false;
        properties.put("EJBName", eJBMethodInfo.getAbstractBeanClassName());
        properties.put("EJB name", eJBMethodInfo.getAbstractBeanClassName());
        properties.put("MethodName", eJBMethodInfo.getMethodName());
        properties.put("ApplicationName", eJBMethodInfo.getJ2EEName().getApplication());
        properties.put("ModuleName", eJBMethodInfo.getJ2EEName().getModule());
        bl = eJBMethodInfo.isStatefulSessionBean();
        if (bl) {
            properties.put("EJBType", "StatefulSession");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getTranDetailData: props=" + properties.toString());
            }
            return properties;
        }
        bl = eJBMethodInfo.isStatelessSessionBean();
        if (bl) {
            properties.put("EJBType", "StatelessSession");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getTranDetailData: props=" + properties.toString());
            }
            return properties;
        }
        properties.put("EJBType", "Entity");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTranDetailData: props=" + properties.toString());
        }
        return properties;
    }
}

