/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.reqmetrics.PmiRmFilterConfig;
import com.ibm.ws.pmi.reqmetrics.jms.JmsFilterCfg;
import com.ibm.ws.pmi.reqmetrics.wsHandlers.WsFilterCfg;

public class PmiRmFilterConfigImpl
implements PmiRmFilterConfig {
    private static final String SOURCE_FILE = "com.ibm.ws.pmi.reqmetrics.PmiRmFilterConfig";
    private static final String FFDC_ID_1 = "FFDC-1";
    protected boolean _fEnabled = false;
    protected String _filterType;
    protected String[] _filters = null;
    protected Boolean[] _filterEnabled = null;
    private static final TraceComponent tc = Tr.register(PmiRmFilterConfig.class.getName(), "pmi.rm", "com.ibm.ws.pmi.reqmetrics.reqmetrics");

    public PmiRmFilterConfigImpl(String string) {
        this._filterType = string;
        this._filters = null;
        this._filterEnabled = null;
    }

    public String getFilterType() {
        return this._filterType;
    }

    public void enableFilters(boolean bl) {
        this._fEnabled = bl;
    }

    public void addFilters(Boolean[] booleanArray, String[] stringArray) {
        this._filters = stringArray;
        this._filterEnabled = booleanArray;
    }

    public int numFilters() {
        return this._filters.length;
    }

    public String[] getFilters() {
        return this._filters;
    }

    public Boolean[] getFiltersEnabled() {
        return this._filterEnabled;
    }

    public String getFilter(int n) {
        return this._filters[n];
    }

    public boolean isFilterEnabled(int n) {
        Boolean bl = this._filterEnabled[n];
        return bl;
    }

    public boolean isEnabled() {
        return this._fEnabled;
    }

    public synchronized PmiRmFilterConfig copy() {
        boolean bl = tc.isDebugEnabled();
        PmiRmFilterConfigImpl pmiRmFilterConfigImpl = null;
        Tr.entry(tc, "copy");
        try {
            pmiRmFilterConfigImpl = this._filterType.equals("JMS") ? new JmsFilterCfg() : (this._filterType.equals("WEB_SERVICES") ? new WsFilterCfg() : new PmiRmFilterConfigImpl(this._filterType));
            pmiRmFilterConfigImpl._fEnabled = this._fEnabled;
            if (this._filters != null) {
                String[] stringArray = new String[this._filters.length];
                Boolean[] booleanArray = new Boolean[this._filters.length];
                if (bl) {
                    Tr.debug(tc, "copy: loop to copy filters");
                }
                for (int i = 0; i < this._filters.length; ++i) {
                    if (this._filters[i] != null && this._filterEnabled[i] != null) {
                        if (bl) {
                            Tr.debug(tc, "copy: create new filter entry copy and enabled entry copy");
                        }
                        stringArray[i] = new String(this._filters[i].toCharArray());
                        booleanArray[i] = new Boolean(this._filterEnabled[i]);
                        continue;
                    }
                    Tr.error(tc, "PMRM0107E");
                }
                pmiRmFilterConfigImpl.addFilters(booleanArray, stringArray);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.pmi.reqmetrics.PmiRmFilterConfig.copy", FFDC_ID_1, this);
            Tr.error(tc, "PMRM0108E", new Object[]{"PmiRmFilterConfig.copy - " + throwable.getMessage()});
        }
        Tr.exit(tc, "copy");
        return pmiRmFilterConfigImpl;
    }
}

