/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.asynchbeans.AsynchBeansServiceCollaborator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.MBeanStateConsumer;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl;
import com.ibm.ws.pmi.reqmetrics.PmiRmConfigData;
import com.ibm.ws.pmi.reqmetrics.PmiRmConstants;
import com.ibm.ws.pmi.reqmetrics.PmiRmFilterConfig;
import com.ibm.ws.pmi.reqmetrics.dynamicproxy.PmiRmMBeanState;
import com.ibm.ws.pmi.reqmetrics.dynamicproxy.PmiRmMBeanStateEntry;
import com.ibm.ws.runtime.component.ComponentImpl;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class PmiRmJmxService
extends ComponentImpl
implements MBeanStateConsumer {
    private static final String SOURCE_FILE = "com.ibm.ws.pmi.reqmetrics.PmiRmJmxService";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final TraceComponent tc = Tr.register(PmiRmJmxService.class.getName(), "pmi.rm", "com.ibm.ws.pmi.reqmetrics.reqmetrics");

    public Integer getTraceBufferSz() {
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        int n = pmiRmConfigData._traceBufferSz;
        return new Integer(n);
    }

    public void setTraceBufferSz(Integer n) {
        if (n < 0) {
            Tr.warning(tc, "PMRM0215W", new Object[]{"setTraceBufferSz", "buffSz", n, "buffSz > 0"});
        }
        PmiReqMetricsImpl pmiReqMetricsImpl = PmiReqMetricsImpl.getInstance();
        if (n != null && n instanceof Integer) {
            pmiReqMetricsImpl._newConfig._traceBufferSz = n;
        }
    }

    public Integer getTraceLevel() {
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        int n = pmiRmConfigData._traceLevel;
        return new Integer(n);
    }

    public void setTraceLevel(Integer n) {
        if (n < 0) {
            Tr.warning(tc, "PMRM0215W", new Object[]{"setTraceLevel", "traceLevel", n, "traceLevel > 0"});
        }
        PmiReqMetricsImpl pmiReqMetricsImpl = PmiReqMetricsImpl.getInstance();
        pmiReqMetricsImpl._newConfig._traceLevel = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilters(String string, String[] stringArray, Boolean[] booleanArray) {
        if (string == null) {
            Tr.warning(tc, "PMRM0215W", new Object[]{"setFilters", "filterType", string, "filterType != null"});
        }
        if (stringArray == null) {
            Tr.warning(tc, "PMRM0215W", new Object[]{"setFilters", "filters", stringArray, "filters!= null"});
        }
        if (booleanArray == null) {
            Tr.warning(tc, "PMRM0215W", new Object[]{"setFilters", "filterEnabled", booleanArray, "filterEnabled != null"});
        }
        if (string.equalsIgnoreCase("IP")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setFilters: Filter type IP is accepted, but the real name is SOURCE_IP");
            }
            string = "SOURCE_IP";
        }
        PmiReqMetricsImpl pmiReqMetricsImpl = PmiReqMetricsImpl.getInstance();
        PmiRmFilterConfig[] pmiRmFilterConfigArray = pmiReqMetricsImpl._newConfig._filters;
        int n = -1;
        if (string == null) {
            Tr.error(tc, "PMRM0109E");
            return;
        }
        if (pmiRmFilterConfigArray == null) {
            Tr.error(tc, "PMRM0110E");
            return;
        }
        if (stringArray == null || booleanArray == null) {
            Tr.error(tc, "PMRM0111E");
            return;
        }
        for (int i = 0; i < pmiRmFilterConfigArray.length; ++i) {
            if (!pmiRmFilterConfigArray[i].getFilterType().equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            Tr.error(tc, "PMRM0112E", new Object[]{string});
            return;
        }
        PmiRmConfigData pmiRmConfigData = pmiReqMetricsImpl._newConfig;
        synchronized (pmiRmConfigData) {
            pmiRmFilterConfigArray[n].addFilters(booleanArray, stringArray);
        }
    }

    public String[] getFilters(String string) {
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        PmiRmFilterConfig[] pmiRmFilterConfigArray = pmiRmConfigData._filters;
        int n = -1;
        if (string == null) {
            Tr.error(tc, "PMRM0109E");
            return null;
        }
        if (pmiRmFilterConfigArray == null) {
            Tr.error(tc, "PMRM0110E");
            return null;
        }
        if (string.equalsIgnoreCase("IP")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getFilters: Filter type IP is accepted, but the real name is SOURCE_IP");
            }
            string = "SOURCE_IP";
        }
        for (int i = 0; i < pmiRmFilterConfigArray.length; ++i) {
            if (!pmiRmFilterConfigArray[i].getFilterType().equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            Tr.error(tc, "PMRM0112E", new Object[]{string});
            return null;
        }
        return pmiRmFilterConfigArray[n].getFilters();
    }

    public Boolean[] getFiltersEnabled(String string) {
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        PmiRmFilterConfig[] pmiRmFilterConfigArray = pmiRmConfigData._filters;
        int n = -1;
        if (string == null) {
            Tr.error(tc, "PMRM0109E");
            return null;
        }
        if (pmiRmFilterConfigArray == null) {
            Tr.error(tc, "PMRM0110E");
            return null;
        }
        if (string.equalsIgnoreCase("IP")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getFiltersEnabled: Filter type IP is accepted, but the real name is SOURCE_IP");
            }
            string = "SOURCE_IP";
        }
        for (int i = 0; i < pmiRmFilterConfigArray.length; ++i) {
            if (!pmiRmFilterConfigArray[i].getFilterType().equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            Tr.error(tc, "PMRM0112E", new Object[]{string});
            return null;
        }
        return pmiRmFilterConfigArray[n].getFiltersEnabled();
    }

    public void enableFilter(String string, Boolean bl) {
        if (string == null) {
            Tr.warning(tc, "PMRM0215W", new Object[]{"enableFilter", "filterType", string, "filterType != null"});
        }
        if (bl == null) {
            Tr.warning(tc, "PMRM0215W", new Object[]{"enableFilter", "fEnable", bl, "fEnable != null"});
        }
        if (string.equalsIgnoreCase("IP")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "enableFilter: Filter type IP is accepted, but the real name is SOURCE_IP");
            }
            string = "SOURCE_IP";
        }
        PmiReqMetricsImpl pmiReqMetricsImpl = PmiReqMetricsImpl.getInstance();
        PmiRmFilterConfig[] pmiRmFilterConfigArray = pmiReqMetricsImpl._newConfig._filters;
        int n = -1;
        if (string == null) {
            Tr.error(tc, "PMRM0113E");
            return;
        }
        if (pmiRmFilterConfigArray == null) {
            Tr.error(tc, "PMRM0110E");
            return;
        }
        for (int i = 0; i < pmiRmFilterConfigArray.length; ++i) {
            if (!pmiRmFilterConfigArray[i].getFilterType().equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            Tr.error(tc, "PMRM0112E", new Object[]{string});
            return;
        }
        pmiRmFilterConfigArray[n].enableFilters(bl);
    }

    public void enableRm(Boolean bl) {
        if (bl == null) {
            Tr.warning(tc, "PMRM0215W", new Object[]{"enableRm", "fEnable", bl, "fEnable != null"});
        }
        boolean bl2 = bl;
        PmiReqMetricsImpl pmiReqMetricsImpl = PmiReqMetricsImpl.getInstance();
        pmiReqMetricsImpl._newConfig._fRmEnabled = bl2;
    }

    public Boolean isRmEnabled() {
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        return new Boolean(pmiRmConfigData._fRmEnabled);
    }

    public void enableARM(Boolean bl) {
        if (bl == null) {
            Tr.warning(tc, "PMRM0215W", new Object[]{"enableARM", "fEnable", bl, "fEnable != null"});
        }
        boolean bl2 = bl;
        PmiReqMetricsImpl pmiReqMetricsImpl = PmiReqMetricsImpl.getInstance();
        pmiReqMetricsImpl._newConfig._fARMEnabled = bl2;
    }

    public Boolean isARMEnabled() {
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        return new Boolean(pmiRmConfigData._fARMEnabled);
    }

    public void enableLogging(Boolean bl) {
        if (bl == null) {
            Tr.warning(tc, "PMRM0215W", new Object[]{"enableLogging", "fEnable", bl, "fEnable != null"});
        }
        boolean bl2 = bl;
        PmiReqMetricsImpl pmiReqMetricsImpl = PmiReqMetricsImpl.getInstance();
        pmiReqMetricsImpl._newConfig._fLogEnabled = bl2;
    }

    public Boolean isLogEnabled() {
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        return new Boolean(pmiRmConfigData._fLogEnabled);
    }

    public String getArmType() {
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        int n = pmiRmConfigData._armType;
        return PmiRmConstants.armTypes[n];
    }

    public void setArmType(String string) {
        if (string == null) {
            Tr.warning(tc, "PMRM0215W", new Object[]{"setArmType", "armType", string, "armType != null"});
        }
        PmiReqMetricsImpl pmiReqMetricsImpl = PmiReqMetricsImpl.getInstance();
        for (int i = 0; i < Array.getLength(PmiRmConstants.armTypes); ++i) {
            if (!PmiRmConstants.armTypes[i].equalsIgnoreCase(string)) continue;
            pmiReqMetricsImpl._newConfig._armType = i;
        }
    }

    public void setArmTransactionFactory(String string) {
        if (string == null) {
            Tr.warning(tc, "PMRM0215W", new Object[]{"setArmTransactionFactory", "sFactory", string, "sFactory != null"});
        }
        PmiReqMetricsImpl pmiReqMetricsImpl = PmiReqMetricsImpl.getInstance();
        pmiReqMetricsImpl._newConfig.armTransactionFactory = string;
    }

    public String getArmTransactionFactory() {
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        return pmiRmConfigData.armTransactionFactory;
    }

    public void setEnabledComponent(String string, Boolean bl) {
        int n;
        if (string == null) {
            Tr.warning(tc, "PMRM0215W", new Object[]{"setEnabledComponent", "compName", string, "compName != null"});
        }
        if (bl == null) {
            Tr.warning(tc, "PMRM0215W", new Object[]{"setEnabledComponent", "enabled", bl, "enabled != null"});
        }
        PmiReqMetricsImpl pmiReqMetricsImpl = PmiReqMetricsImpl.getInstance();
        String string2 = null;
        boolean bl2 = bl;
        for (n = 0; n < pmiReqMetricsImpl._newConfig.enabledComponents.size(); ++n) {
            string2 = (String)pmiReqMetricsImpl._newConfig.enabledComponents.get(n);
            if (string2.equalsIgnoreCase(string) && bl2) {
                return;
            }
            if (!string2.equalsIgnoreCase(string) || bl2) continue;
            pmiReqMetricsImpl._newConfig.enabledComponents.remove(n);
            return;
        }
        if (bl2) {
            if (string.equalsIgnoreCase("all")) {
                pmiReqMetricsImpl._newConfig.enabledComponents.clear();
                for (n = 0; n < pmiReqMetricsImpl._newConfig.instrumentedComponents.size(); ++n) {
                    pmiReqMetricsImpl._newConfig.enabledComponents.add(pmiReqMetricsImpl._newConfig.instrumentedComponents.get(n));
                }
            } else {
                pmiReqMetricsImpl._newConfig.enabledComponents.add(string);
            }
        }
    }

    public Boolean isComponentEnabled(String string) {
        if (string == null) {
            Tr.warning(tc, "PMRM0215W", new Object[]{"isComponentEnabled", "compName", string, "compName != null"});
        }
        PmiReqMetricsImpl.getInstance();
        PmiRmConfigData pmiRmConfigData = PmiReqMetricsImpl.getConfig();
        ArrayList arrayList = pmiRmConfigData.enabledComponents;
        String string2 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            string2 = (String)arrayList.get(i);
            if (!string2.equals("all") && !string2.equals(string)) continue;
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    public String[] listComponents() {
        PmiReqMetricsImpl.getInstance();
        ArrayList arrayList = PmiReqMetricsImpl.getConfig().instrumentedComponents;
        if (arrayList != null) {
            String[] stringArray = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
            return stringArray;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PmiRmJmxService listComponents returns null");
        }
        return null;
    }

    public String[] getFilterTypes() {
        String[] stringArray = new String[]{"SOURCE_IP", "URI", "EJB", "JMS", "WEB_SERVICES"};
        return stringArray;
    }

    public void commitConfigWithComment(String string) {
        PmiReqMetricsImpl.commitConfig();
        if (PmiReqMetricsImpl.isReqMetricsEnabled()) {
            AsynchBeansServiceCollaborator asynchBeansServiceCollaborator = PmiReqMetricsImpl.getABSvc();
            if (asynchBeansServiceCollaborator != null) {
                boolean bl = PmiReqMetricsImpl.registerABSvc(asynchBeansServiceCollaborator);
                if (bl && tc.isDebugEnabled()) {
                    Tr.debug(tc, "commitConfigWithComment, register ReqMetricsAsyncBeanServiceImpl");
                }
            } else {
                Tr.error(tc, "commitConfigWithComment, getService on AsynchBeansService returns null");
            }
        }
        Tr.info(tc, "PMRM0300I", new Object[]{string == null ? "" : string});
    }

    public void commitConfig() {
        this.commitConfigWithComment(null);
    }

    public void setMBeanState(Serializable serializable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMBeanState - updating Request Metrics MBean State");
        }
        if (serializable == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Request Metrics state object is null");
            }
        } else if (serializable instanceof PmiRmMBeanState) {
            PmiRmMBeanState pmiRmMBeanState = (PmiRmMBeanState)serializable;
            this.updateRuntimeWithStateObject(pmiRmMBeanState);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invalid PmiRmMBeanState object type: " + serializable.getClass().getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMBeanState");
        }
    }

    private void updateRuntimeWithStateObject(PmiRmMBeanState pmiRmMBeanState) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRuntimeWithStateObject");
        }
        boolean bl = tc.isDebugEnabled();
        if (pmiRmMBeanState.isConfigCommitted()) {
            if (bl) {
                Tr.debug(tc, "updateRuntimeWithStateObject, isConfigCommitted returns true");
            }
            this.updateRuntimeWithEntryList(pmiRmMBeanState.getCommittedConfig());
            this.commitConfigWithComment(null);
        }
        if (pmiRmMBeanState.isConfigUpdated()) {
            if (bl) {
                Tr.debug(tc, "updateRuntimeWithStateObject, isConfigUpdated returns true");
            }
            this.updateRuntimeWithEntryList(pmiRmMBeanState.getNewConfig());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRuntimeWithStateObject");
        }
    }

    private void updateRuntimeWithEntryList(ArrayList arrayList) {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updateRuntimeWithEntryList");
            }
            if (arrayList == null) {
                return;
            }
            try {
                PmiRmMBeanStateEntry pmiRmMBeanStateEntry = null;
                String string = null;
                Object[] objectArray = null;
                for (int i = 0; i < arrayList.size(); ++i) {
                    String[] stringArray;
                    String string2;
                    pmiRmMBeanStateEntry = (PmiRmMBeanStateEntry)arrayList.get(i);
                    string = pmiRmMBeanStateEntry.getMethodName();
                    objectArray = pmiRmMBeanStateEntry.getParams();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "updateRuntimeWithEntryList, i: methodName=" + string);
                    }
                    if (string.equals("setTraceBufferSz")) {
                        this.setTraceBufferSz((Integer)objectArray[0]);
                        continue;
                    }
                    if (string.equals("setTraceLevel")) {
                        this.setTraceLevel((Integer)objectArray[0]);
                        continue;
                    }
                    if (string.startsWith("setEnabledComponent")) {
                        this.setEnabledComponent((String)objectArray[0], (Boolean)objectArray[1]);
                        continue;
                    }
                    if (string.startsWith("setFilters")) {
                        string2 = (String)objectArray[0];
                        stringArray = (String[])objectArray[1];
                        Boolean[] booleanArray = (Boolean[])objectArray[2];
                        this.setFilters(string2, stringArray, booleanArray);
                        continue;
                    }
                    if (string.startsWith("enableFilter")) {
                        string2 = (String)objectArray[0];
                        stringArray = (Boolean)objectArray[1];
                        this.enableFilter(string2, (Boolean)stringArray);
                        continue;
                    }
                    if (string.equals("enableRm")) {
                        this.enableRm((Boolean)objectArray[0]);
                        continue;
                    }
                    if (string.equals("enableARM")) {
                        this.enableARM((Boolean)objectArray[0]);
                        continue;
                    }
                    if (string.equals("enableLogging")) {
                        this.enableLogging((Boolean)objectArray[0]);
                        continue;
                    }
                    if (string.equals("setArmType")) {
                        this.setArmType((String)objectArray[0]);
                        continue;
                    }
                    if (!string.equals("setArmTransactionFactory")) continue;
                    this.setArmTransactionFactory((String)objectArray[0]);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.pmi.reqmetrics.PmiRmJmxService.updateRuntimeWithEntryList", FFDC_ID_1, this);
                if (!tc.isDebugEnabled()) break block16;
                exception.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRuntimeWithEntryList");
        }
    }
}

