/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.pmi.reqmetrics.PmiRmCorrelator;
import com.ibm.ws.pmi.reqmetrics.PmiRmThreadCtx;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.security.util.AccessController;
import java.net.InetAddress;
import java.security.PrivilegedAction;

public class PmiRmProcessLevelInfo {
    private static final String SOURCE_FILE = "com.ibm.ws.pmi.reqmetrics.PmiRmProcessLevelInfo";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    protected String _hostIP = null;
    protected String _pid = null;
    protected long _time = 0L;
    protected long _reqCtr = 0L;
    protected static final int REQUEST_ID_BLK_SZ = 4096;
    private static final TraceComponent tc = Tr.register(PmiRmProcessLevelInfo.class.getName(), "pmi.rm", "com.ibm.ws.pmi.reqmetrics.reqmetrics");

    public PmiRmProcessLevelInfo() {
        this.init_internal();
    }

    protected void init_internal() {
        Object object;
        boolean bl = tc.isDebugEnabled();
        try {
            object = new String[]{null};
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((String[])object){
                private final /* synthetic */ String[] val$hostip;
                {
                    this.val$hostip = stringArray;
                }

                public Object run() {
                    block4: {
                        try {
                            AdminService adminService = AdminServiceFactory.getAdminService();
                            if (adminService != null) {
                                String string = adminService.getNodeName();
                                String string2 = AdminHelper.getInstance().getNodeHostName(string);
                                InetAddress inetAddress = InetAddress.getByName(string2);
                                this.val$hostip[0] = inetAddress.getHostAddress();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Address set to hostname of the node: " + inetAddress);
                                }
                                break block4;
                            }
                            throw new Exception("Request Metrics Unable to access admin service to retrieve address");
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.pmi.reqmetrics.PmiRmProcessLevelInfo.run", PmiRmProcessLevelInfo.FFDC_ID_3, this);
                            this.val$hostip[0] = null;
                        }
                    }
                    return null;
                }
            });
            if (object[0] == null) {
                throw new Exception();
            }
            this._hostIP = object[0];
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.pmi.reqmetrics.PmiRmProcessLevelInfo.init_internal", FFDC_ID_1, this);
            this._hostIP = "?.?.?.?";
        }
        this._pid = "-1";
        try {
            object = ProcessFactory.createSelf();
            this._pid = object.id();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.pmi.reqmetrics.PmiRmProcessLevelInfo.init_internal", FFDC_ID_2, this);
            this._pid = "-1";
            Tr.error(tc, "PMRM0114E");
        }
        this._time = System.currentTimeMillis();
        this._reqCtr = 0L;
        if (bl) {
            Tr.debug(tc, "PmiRmProcessLevelInfo.init_internal: " + this._hostIP + "/" + this._time);
        }
    }

    PmiRmCorrelator createCorrelator(PmiRmThreadCtx pmiRmThreadCtx) {
        long l = pmiRmThreadCtx.getNextRequestId(this);
        PmiRmCorrelator pmiRmCorrelator = null;
        pmiRmCorrelator = (PmiRmCorrelator)pmiRmThreadCtx.acquireCacheObject(1);
        if (null == pmiRmCorrelator) {
            pmiRmCorrelator = new PmiRmCorrelator(this._hostIP, this._pid, this._time, l);
        } else {
            pmiRmCorrelator._version = 1;
            pmiRmCorrelator._hostIP = this._hostIP;
            pmiRmCorrelator._pid = this._pid;
            pmiRmCorrelator._time = this._time;
            pmiRmCorrelator._reqCtr = l;
            pmiRmCorrelator._eventCtr = 0L;
            pmiRmCorrelator._armCorrelator = null;
        }
        return pmiRmCorrelator;
    }

    protected synchronized long getNextRequestIdBlock() {
        long l = this._reqCtr;
        this._reqCtr += 4096L;
        return l;
    }
}

