/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.ArrayList;
import java.util.Properties;

public class PmiRmRegistration {
    private static final TraceComponent tc = Tr.register(PmiRmRegistration.class.getName(), "pmi.rm", "com.ibm.ws.pmi.reqmetrics.reqmetrics");
    private static ArrayList compRegistration = new ArrayList();
    private static String[] enabledComponents = new String[0];

    protected static int register(String string, Properties properties, String[] stringArray) {
        int n;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "register, compName=" + string);
        }
        if (string == null) {
            Tr.warning(tc, "PMRM0215W", new Object[]{"register", "null", "not null String"});
            return -1;
        }
        ComponentInfo componentInfo = null;
        String string2 = string;
        String string3 = null;
        if (properties != null) {
            string3 = properties.getProperty("identity");
        }
        if (properties != null && string3 == null) {
            string3 = properties.getProperty("IDENTIFY");
        }
        if (string3 != null && !string3.equals("")) {
            string2 = string + " " + string3;
        }
        if (tc.isDebugEnabled()) {
            for (n = 0; n < compRegistration.size(); ++n) {
                componentInfo = (ComponentInfo)compRegistration.get(n);
                if (!componentInfo.componentName.equals(string) || !string2.equals(componentInfo.identityName)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.warning(tc, "PMRM0216W", new Object[]{new Integer(n), string, string3});
                }
                return n;
            }
        }
        componentInfo = new ComponentInfo(string, properties, stringArray);
        for (n = 0; n < enabledComponents.length; ++n) {
            if (!enabledComponents[n].equalsIgnoreCase("all") && !enabledComponents[n].equals(string)) continue;
            componentInfo.isEnabled = true;
            break;
        }
        compRegistration.add(componentInfo);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "register: component registered, compName=" + string + "identityName=" + string2 + ", regId=" + (compRegistration.size() - 1));
        }
        return compRegistration.size() - 1;
    }

    public static int getNumRegisteredComponents() {
        return compRegistration.size();
    }

    private static String getComponentName(int n) {
        if (n < 0 || n >= compRegistration.size()) {
            Tr.debug(tc, "getComponentName, request metrics cannot find this component since the id " + n + " is unknown");
            return null;
        }
        ComponentInfo componentInfo = (ComponentInfo)compRegistration.get(n);
        return componentInfo.componentName;
    }

    public static String getIdentityName(int n) {
        if (n < 0 || n >= compRegistration.size()) {
            Tr.debug(tc, "getComponentName, request metrics cannot find this component since the id " + n + " is unknown");
            return null;
        }
        ComponentInfo componentInfo = (ComponentInfo)compRegistration.get(n);
        return componentInfo.identityName;
    }

    public static String[] getContextNamesForComponent(int n) {
        if (n < 0 || n >= compRegistration.size()) {
            Tr.debug(tc, "getContextNamesForComponent, request metrics cannot find this component since the id " + n + " is unknown");
            return null;
        }
        ComponentInfo componentInfo = (ComponentInfo)compRegistration.get(n);
        return componentInfo.contextNames;
    }

    protected static synchronized void updateComponentEnablement(ArrayList arrayList, int n) {
        enabledComponents = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            PmiRmRegistration.enabledComponents[i] = (String)arrayList.get(i);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "updateComponentEnablement: enabledComponent " + enabledComponents[i]);
        }
        ComponentInfo componentInfo = null;
        for (int i = 0; i < compRegistration.size(); ++i) {
            componentInfo = (ComponentInfo)compRegistration.get(i);
            componentInfo.isEnabled = false;
            for (int j = 0; j < enabledComponents.length; ++j) {
                if (!enabledComponents[j].equalsIgnoreCase("all") && !enabledComponents[j].equals(componentInfo.componentName)) continue;
                componentInfo.isEnabled = true;
                break;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "updateComponentEnablement: comp=" + componentInfo.componentName + ", enabled=" + componentInfo.isEnabled);
        }
    }

    public static boolean isComponentEnabled(int n) {
        ComponentInfo componentInfo = (ComponentInfo)compRegistration.get(n);
        return componentInfo.isEnabled;
    }

    static class ComponentInfo {
        String componentName;
        String identityName;
        Properties identity;
        String[] contextNames;
        boolean isEnabled = false;

        ComponentInfo(String string, Properties properties, String[] stringArray) {
            CharSequence charSequence;
            this.componentName = string;
            this.identity = properties;
            this.contextNames = stringArray;
            this.identityName = string;
            if (this.identity != null) {
                charSequence = this.identity.getProperty("identity");
                if (charSequence == null) {
                    charSequence = this.identity.getProperty("IDENTIFY");
                }
                if (charSequence != null && !((String)charSequence).equals("")) {
                    this.identityName = string + " " + (String)charSequence;
                }
            }
            this.isEnabled = false;
            if (tc.isDebugEnabled()) {
                charSequence = new StringBuffer();
                if (this.contextNames != null) {
                    for (int i = 0; i < this.contextNames.length; ++i) {
                        ((StringBuffer)charSequence).append(this.contextNames[i]).append(",");
                    }
                }
                Tr.debug(tc, "register ComponentInfo: compName=" + string + ", identity=" + this.identity + ", contextNames=" + ((StringBuffer)charSequence).toString());
            }
        }
    }
}

