/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CollaboratorCookie;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl;
import com.ibm.ws.pmi.reqmetrics.PmiRmCache;
import com.ibm.ws.pmi.reqmetrics.PmiRmConfigData;
import com.ibm.ws.pmi.reqmetrics.PmiRmProcessLevelInfo;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;

public class PmiRmThreadCtx
implements CollaboratorCookie {
    public static final int NO_REQUEST_LEVEL = 0;
    private ArrayList filterListenerNames = null;
    protected Vector _txTypes = null;
    protected boolean _fTrace = false;
    protected int _inboundCorrelatorType = -2;
    protected int _ejbNestingLevel = 0;
    protected int _servletNestingLevel = 0;
    protected int _servletFilterNestingLevel = 0;
    protected Stack _contextStack = null;
    protected long _nextRequestId = -1L;
    protected Object[] _armTxObj = null;
    protected Object _curArmTxObj = null;
    protected static final int JDBC_TX_IDX = 0;
    protected static final int EJB_TX_IDX = 1;
    protected static final int URI_TX_IDX = 2;
    protected static final int ARM_TX_OBJS = 3;
    protected long _blockedId = -1L;
    private int armType = -1;
    private int ejb_tran_status = 0;
    private Properties _tranDetailProps = null;
    protected int _ejbTraceLevel = 0;
    protected int _servletTraceLevel = 0;
    protected int _servletFilterTraceLevel = 0;
    protected int _inboundComponent = -1;
    protected boolean _inboundInstrumented = false;
    private PmiRmConfigData _config = null;
    private PmiRmCache callcontextCache = null;
    private PmiRmCache correlatorCache = null;
    private boolean _inContextPool = false;
    private int _reqCallLevel = 0;
    private long _arrivalTime = 0L;
    public static final int CALL_CONTEXT_CACHE = 0;
    public static final int CORRELATOR_CACHE = 1;
    private boolean trDebug = tc.isDebugEnabled();
    private static final TraceComponent tc = Tr.register(PmiRmThreadCtx.class.getName(), "pmi.rm", "com.ibm.ws.pmi.reqmetrics.reqmetrics");

    public PmiRmThreadCtx() {
        if (this.trDebug) {
            Tr.debug(tc, "PmiRmThreadCtx created");
        }
        this._contextStack = new Stack();
        this.reset();
        this._txTypes = new Vector();
        this._nextRequestId = -1L;
        this._armTxObj = new Object[3];
        for (int i = 0; i < 3; ++i) {
            this._armTxObj[i] = null;
        }
        this._curArmTxObj = null;
        this.callcontextCache = new PmiRmCache(0);
        this.correlatorCache = new PmiRmCache(1);
        this.filterListenerNames = new ArrayList();
    }

    protected void setTrace(boolean bl) {
        this._fTrace = bl;
    }

    public boolean getTrace() {
        return this._fTrace;
    }

    protected synchronized void incrEjbNestingLevel() {
        ++this._ejbNestingLevel;
    }

    protected synchronized void decrEjbNestingLevel() {
        --this._ejbNestingLevel;
    }

    protected synchronized void incrServletNestingLevel() {
        ++this._servletNestingLevel;
    }

    protected synchronized void incrServletFilterNestingLevel() {
        ++this._servletFilterNestingLevel;
    }

    protected synchronized void decrServletNestingLevel() {
        --this._servletNestingLevel;
    }

    protected synchronized void decrServletFilterNestingLevel() {
        --this._servletFilterNestingLevel;
    }

    protected void reset() {
        this.trDebug = tc.isDebugEnabled();
        if (this.trDebug) {
            Tr.debug(tc, "reset is called");
        }
        this._fTrace = false;
        this._inboundInstrumented = false;
        this._inboundComponent = -1;
        this._ejbNestingLevel = 0;
        this._servletNestingLevel = 0;
        this._ejbTraceLevel = 0;
        this._servletTraceLevel = 0;
        this._servletFilterTraceLevel = 0;
        this._servletFilterNestingLevel = 0;
        this._arrivalTime = 0L;
        this._tranDetailProps = null;
        this._inboundCorrelatorType = -2;
        if (!this._contextStack.empty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "reset: stack is not empty. Clean it up.");
            }
            while (!this._contextStack.empty()) {
                this._contextStack.pop();
            }
        }
        this._config = PmiReqMetricsImpl.getConfig();
    }

    public byte[] acquireByteArray(String string) {
        if (this.trDebug) {
            Tr.entry(tc, "acquireByteArray");
        }
        byte[] byArray = null;
        ArmTxInfo armTxInfo = null;
        int n = this._txTypes.size();
        for (int i = 0; i < n; ++i) {
            armTxInfo = (ArmTxInfo)this._txTypes.get(i);
            if (!armTxInfo._type.equalsIgnoreCase(string)) continue;
            if (armTxInfo._byteArrayStack.isEmpty()) break;
            byArray = (byte[])armTxInfo.popByteArray();
            if (!this.trDebug) break;
            Tr.debug(tc, " Cache hit for byte array");
            break;
        }
        if (this.trDebug) {
            if (null == byArray) {
                Tr.debug(tc, " Cache miss for byte array");
            }
            Tr.exit(tc, "acquireByteArray");
        }
        return byArray;
    }

    public Object getArmTxObject(String string) {
        if (this.trDebug) {
            Tr.entry(tc, "getArmTxObject");
        }
        Object object = null;
        ArmTxInfo armTxInfo = null;
        int n = this._txTypes.size();
        for (int i = 0; i < n; ++i) {
            armTxInfo = (ArmTxInfo)this._txTypes.get(i);
            if (!armTxInfo._type.equalsIgnoreCase(string)) continue;
            if (!armTxInfo._stack.isEmpty()) {
                object = armTxInfo.pop();
                if (!this.trDebug) break;
                Tr.debug(tc, " Cache hit for ArmTransaction cacheof ArmTxType = " + string);
                break;
            }
            if (!this.trDebug) break;
            Tr.debug(tc, "ARM Transaction cache is empty for ArmTxType=" + string);
            break;
        }
        if (this.trDebug) {
            if (null == object) {
                Tr.debug(tc, " Cache miss for ArmTransaction cache of ArmTxType = " + string);
            }
            Tr.exit(tc, "getArmTxObject");
        }
        return object;
    }

    public void releaseArmTxObject(String string, Object object) {
        if (this.trDebug) {
            Tr.entry(tc, "releaseArmTxObject");
        }
        boolean bl = false;
        int n = this._txTypes.size();
        for (int i = 0; i < n; ++i) {
            ArmTxInfo armTxInfo = (ArmTxInfo)this._txTypes.get(i);
            if (!armTxInfo._type.equalsIgnoreCase(string)) continue;
            armTxInfo.push(object);
            if (this.trDebug) {
                Tr.debug(tc, " grew armtx cache by 1 size is " + armTxInfo._stack.size() + "for type" + string);
            }
            bl = true;
            break;
        }
        if (!bl) {
            ArmTxInfo armTxInfo = new ArmTxInfo();
            armTxInfo._type = string;
            armTxInfo._stack = new ArrayList();
            armTxInfo._byteArrayStack = new ArrayList();
            armTxInfo.push(object);
            this._txTypes.add(armTxInfo);
            if (this.trDebug) {
                Tr.debug(tc, " grew armtx cache by 1 size is " + armTxInfo._stack.size() + "type is = " + string);
                Tr.exit(tc, "releaseArmTxObject");
            }
        }
    }

    public void releaseByteArray(String string, byte[] byArray) {
        boolean bl = false;
        int n = this._txTypes.size();
        for (int i = 0; i < n; ++i) {
            ArmTxInfo armTxInfo = (ArmTxInfo)this._txTypes.get(i);
            if (!armTxInfo._type.equalsIgnoreCase(string)) continue;
            armTxInfo.pushByteArray(byArray);
            bl = true;
            break;
        }
    }

    public void setCurArmTxObject(Object object) {
        this._curArmTxObj = object;
    }

    public Object getCurArmTxObject() {
        return this._curArmTxObj;
    }

    public void setArmTxObject(String string, Object object) {
        if (string.equalsIgnoreCase("URI")) {
            this._armTxObj[2] = object;
        } else if (string.equalsIgnoreCase("EJB")) {
            this._armTxObj[1] = object;
        } else {
            this._armTxObj[0] = object;
        }
    }

    protected long getNextRequestId(PmiRmProcessLevelInfo pmiRmProcessLevelInfo) {
        long l = -1L;
        if (this._nextRequestId == -1L || this._nextRequestId % 4096L == 0L) {
            this._nextRequestId = pmiRmProcessLevelInfo.getNextRequestIdBlock();
            if (this._nextRequestId == 0L) {
                this._nextRequestId = 1L;
            }
        }
        l = this._nextRequestId++;
        return l;
    }

    public void setBlockedId(long l) {
        this._blockedId = l;
    }

    public long getBlockedId() {
        return this._blockedId;
    }

    public boolean isEmpty() {
        return this._contextStack.empty();
    }

    public Object peekContext() {
        if (!this._contextStack.empty()) {
            return this._contextStack.peek();
        }
        if (this.trDebug) {
            Tr.debug(tc, "peekContext: Thread Context stack is empty, returning null call context");
        }
        return null;
    }

    public Object popContext() {
        Object var1_1 = null;
        if (!this._contextStack.empty()) {
            return this._contextStack.pop();
        }
        if (this.trDebug) {
            Tr.debug(tc, "peekContext: Thread Context stack is empty, returning null call context");
        }
        return var1_1;
    }

    public void pushContext(Object object) {
        if (this.trDebug) {
            Tr.debug(tc, "Pushing a user passed armtransaction/callcontext/servicecontext onto the stack");
        }
        this._contextStack.push(object);
    }

    protected void setInboundComponent(int n) {
        this._inboundComponent = n;
    }

    public int getInboundComponent() {
        return this._inboundComponent;
    }

    protected void setInboundInstrumented(boolean bl) {
        this._inboundInstrumented = bl;
    }

    public boolean isInboundInstrumented() {
        return this._inboundInstrumented;
    }

    protected void setEjbTranStatus(int n) {
        this.ejb_tran_status = n;
    }

    protected int getEjbTranStatus() {
        return this.ejb_tran_status;
    }

    protected void setInboundCorrelatorType(int n) {
        this._inboundCorrelatorType = n;
    }

    public int getInboundCorrelatorType() {
        return this._inboundCorrelatorType;
    }

    private void collectFilterListener(String string) {
        this.filterListenerNames.add(string);
    }

    private ArrayList getFilterListenerNamesList() {
        return this.filterListenerNames;
    }

    public Object acquireCacheObject(int n) {
        if (n == 0) {
            return this.callcontextCache.acquireCacheObject();
        }
        if (n == 1) {
            return this.correlatorCache.acquireCacheObject();
        }
        return null;
    }

    public boolean releaseCacheObject(int n, Object object) {
        if (n == 0) {
            return this.callcontextCache.releaseCacheObject(object);
        }
        if (n == 1) {
            return this.correlatorCache.releaseCacheObject(object);
        }
        return false;
    }

    public void setConfig(PmiRmConfigData pmiRmConfigData) {
        this._config = pmiRmConfigData;
    }

    public PmiRmConfigData getConfig() {
        return this._config;
    }

    protected void setInContextPool(boolean bl) {
        this._inContextPool = bl;
    }

    protected boolean isInContextPool() {
        return this._inContextPool;
    }

    protected void setArrivalTime(long l) {
        this._arrivalTime = l;
    }

    protected long getArrivalTime() {
        return this._arrivalTime;
    }

    public void setTranDetailProps(Properties properties) {
        this._tranDetailProps = properties;
    }

    protected Properties getTranDetailProps() {
        return this._tranDetailProps;
    }

    protected int getReqCallLevel() {
        return this._reqCallLevel;
    }

    protected void updateReqCallLevel(int n) {
        this._reqCallLevel += n;
    }

    class ArmTxInfo {
        String _type = null;
        ArrayList _stack = new ArrayList();
        ArrayList _byteArrayStack = new ArrayList();
        int cur = 0;
        int curArray = 0;

        ArmTxInfo() {
        }

        protected void push(Object object) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "For ARMTXCACHE Adding at cur =" + this.cur);
            }
            this._stack.add(this.cur, object);
            ++this.cur;
        }

        protected Object pop() {
            if (this.cur == 0) {
                return null;
            }
            --this.cur;
            if (PmiRmThreadCtx.this.trDebug) {
                Tr.debug(tc, "For ARMTXCACHE popping at cur =" + this.cur);
            }
            return this._stack.remove(this.cur);
        }

        protected void pushByteArray(Object object) {
            this._byteArrayStack.add(this.curArray, object);
            ++this.curArray;
        }

        protected Object popByteArray() {
            if (this.curArray == 0) {
                return null;
            }
            --this.curArray;
            return this._byteArrayStack.remove(this.curArray);
        }
    }
}

