/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.reqmetrics.wsHandlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmTx;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmTxFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl;
import com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper;
import com.ibm.ws.pmi.reqmetrics.PmiRmCallContext;
import com.ibm.ws.pmi.reqmetrics.PmiRmConfigData;
import com.ibm.ws.pmi.reqmetrics.PmiRmCorrelator;
import com.ibm.ws.pmi.reqmetrics.PmiRmThreadCtx;
import com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsHandlerBase;
import com.ibm.wsspi.webservices.rpc.handler.MessageContext;
import com.ibm.wsspi.webservices.rpc.handler.RPCContext;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class ReqMetricsClientHandler
extends ReqMetricsHandlerBase {
    private static final TraceComponent tc = Tr.register(ReqMetricsClientHandler.class.getName(), "pmi.rm", "com.ibm.ws.pmi.reqmetrics.reqmetrics");
    private boolean trDebug = false;
    private static final String SOURCE_FILE = "com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsClientHandler";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    public static final String PORT_NAME = "wsdlPort";
    public static final String OP_NAME = "opName";
    public static final String TRANSPORT_NAME = "transportName";
    public static final String TARGET_ENDPOINRT = "targetEndpoint";
    public static final String PARAM_NAMES = "paramNames";
    public static final String SERVICE_REF_NAME = "serviceReferenceName";
    public static final String RESPONSE_MSG = "responseMessage";
    public static final int PORT_ID = 0;
    public static final int OP_ID = 1;
    public static final int TRANSPORT_ID = 2;
    public static final int PARAMS_ID = 3;
    public static final String RM_CLNT_START = "REQMETRICS_WS_CLIENT_START";

    public ReqMetricsClientHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ReqMetricsClientHandler is initialized");
        }
    }

    public boolean handleRequest(javax.xml.rpc.handler.MessageContext messageContext) {
        block25: {
            block27: {
                block26: {
                    if (this.impl == null) {
                        this.impl = PmiReqMetricsImpl.getInstance();
                        if (this.impl == null) {
                            Tr.debug(tc, "handleRequest :PmiReqMetricsImpl is null");
                            return true;
                        }
                    }
                    if (!this.impl.isReallyEnabled()) break block26;
                    if (PmiReqMetricsImpl.isComponentEnabledInArmCallback(4)) break block27;
                }
                return true;
            }
            boolean bl = this.trDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
            if (this.trDebug) {
                Tr.debug(tc, "handleRequest");
            }
            PmiRmArmTx pmiRmArmTx = null;
            PmiRmThreadCtx pmiRmThreadCtx = null;
            try {
                String[] stringArray;
                Object object;
                Object object2;
                Object object3;
                pmiRmThreadCtx = this.impl.getThreadContext();
                if (!this.impl.isComponentEnabled(4)) {
                    if (this.trDebug) {
                        Tr.debug(tc, "handleRequest: Web Sevices component is not enabled for request metrics instrumentation. Do not create sub-transaction");
                    }
                } else {
                    if (!pmiRmThreadCtx.getTrace()) {
                        return true;
                    }
                    object3 = PmiRmArmWrapper.getArmCorrelator(pmiRmThreadCtx);
                    boolean bl2 = this.isTraceEnabled((byte[])object3);
                    if (bl2 || this.impl.isLogEnabled()) {
                        object2 = this.getTranName(messageContext);
                        object = pmiRmThreadCtx.getConfig();
                        if (object == null) {
                            ReqMetricsClientHandler reqMetricsClientHandler = this;
                            object = reqMetricsClientHandler.impl.getConfig();
                        }
                        stringArray = null;
                        if (((PmiRmConfigData)object).isTraceDebugEnabled() && ((PmiRmConfigData)object).isARMEnabled() && this.impl.getArmType() == PmiRmArmTxFactory.ARM4_TYPE) {
                            stringArray = this.getContextValues(messageContext);
                        }
                        this.impl.updateBegin(pmiRmThreadCtx, 4, bl2, "Web Services Requestor", (String)object2, stringArray);
                        if (bl2) {
                            int n = PmiRmArmWrapper.getStartHandle(pmiRmThreadCtx);
                            messageContext.setProperty(RM_CLNT_START, (Object)new Integer(n));
                            if (this.trDebug) {
                                Tr.debug(tc, "calling MessageContext.setProperty for startHandle=" + n);
                            }
                        }
                    }
                }
                pmiRmArmTx = PmiRmArmWrapper.peekArmTransaction(pmiRmThreadCtx);
                object3 = null;
                PmiRmCorrelator pmiRmCorrelator = null;
                if (pmiRmArmTx == null) {
                    Tr.warning(tc, "PMRM0210W", "handleRequest");
                    return true;
                }
                if (this.trDebug) {
                    Tr.debug(tc, "handleRequest: find a correlator on stack");
                }
                if (pmiRmArmTx instanceof PmiRmCallContext) {
                    if (this.trDebug) {
                        Tr.debug(tc, "handleRequest: get PmiRmCallContext");
                    }
                    object3 = (PmiRmCallContext)pmiRmArmTx;
                    pmiRmCorrelator = object3.getCorrelator();
                } else if (this.trDebug) {
                    Tr.debug(tc, "handleRequest: get armTx");
                }
                object2 = pmiRmArmTx.getCorrelatorBytes();
                this.impl.getArmWrapper();
                object = PmiRmArmWrapper.toHexString((byte[])object2);
                stringArray = PmiRmCorrelator.getStringFromPmiRmCorrelator(pmiRmCorrelator);
                if (object == null && stringArray == null) {
                    Tr.warning(tc, "both ARM and request metrics correlators are null");
                    Tr.exit(tc, "handleRequest");
                    return true;
                }
                this.addCorrelatorsToSoapHeader(messageContext, (String)object, (String)stringArray);
                ReqMetricsClientHandler reqMetricsClientHandler = this;
                this.updateHttpHeader(messageContext, reqMetricsClientHandler.impl.getConfig().getArmCorrelatorHeaderName(), "DoNotTraceLowerProtocol");
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsClientHandler.handleRequest", FFDC_ID_1);
                Tr.warning(tc, "PMRM0108E", exception.toString());
                if (!this.trDebug) break block25;
                exception.printStackTrace();
            }
        }
        return true;
    }

    private void addCorrelatorsToSoapHeader(javax.xml.rpc.handler.MessageContext messageContext, String string, String string2) {
        block7: {
            try {
                SOAPMessageContext sOAPMessageContext;
                SOAPMessage sOAPMessage;
                SOAPPart sOAPPart;
                SOAPEnvelope sOAPEnvelope;
                SOAPHeader sOAPHeader;
                if (this.trDebug) {
                    Tr.entry(tc, "addCorrelatorsToSoapHeader");
                }
                if ((sOAPHeader = (sOAPEnvelope = (sOAPPart = (sOAPMessage = (sOAPMessageContext = (SOAPMessageContext)messageContext).getMessage()).getSOAPPart()).getEnvelope()).getHeader()) == null) {
                    sOAPHeader = sOAPEnvelope.addHeader();
                }
                Name name2 = sOAPEnvelope.createName("arm_correlator", "reqmetrics", "http://websphere.ibm.com");
                SOAPHeaderElement sOAPHeaderElement = sOAPHeader.addHeaderElement(name2);
                sOAPHeaderElement.addTextNode(string);
                sOAPHeaderElement.setActor("reqmetricsURI");
                if (string2 != null) {
                    Name name3 = sOAPEnvelope.createName("rm_correlator", "", "");
                    sOAPHeaderElement.addAttribute(name3, string2);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "addCorrelatorsToSoapHeader: add rm cor attribute=" + sOAPHeaderElement.getAttributeValue(name3));
                    }
                }
                if (this.trDebug) {
                    Tr.debug(tc, "addCorrelatorsToSoapHeader: add arm cor value=" + sOAPHeaderElement.getValue());
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsClientHandler.addCorrelatorsToSoapHeader", FFDC_ID_5, this);
                exception.printStackTrace();
                if (!this.trDebug) break block7;
                exception.printStackTrace();
            }
        }
    }

    private void updateHttpHeader(javax.xml.rpc.handler.MessageContext messageContext, String string, String string2) {
        HashMap<String, String> hashMap;
        if (this.trDebug) {
            Tr.entry(tc, "updateHttpHeader");
        }
        if ((hashMap = (HashMap<String, String>)messageContext.getProperty("com.ibm.websphere.webservices.requestTransportProperties")) == null) {
            hashMap = new HashMap<String, String>();
            if (this.trDebug) {
                Tr.debug(tc, "updateHttpHeader: no HashMap is found, create a new one");
            }
        } else if (this.trDebug) {
            Tr.debug(tc, "updateHttpHeader: nHashMap is found, use the existing one");
        }
        if (this.trDebug) {
            Tr.debug(tc, "updateHttpHeader: requestheaders.put name=" + string + ", value=" + string2);
        }
        hashMap.put(string, string2);
        messageContext.setProperty("com.ibm.websphere.webservices.requestTransportProperties", hashMap);
        if (this.trDebug) {
            Tr.exit(tc, "udpateHttpHeader");
        }
    }

    public boolean handleResponse(javax.xml.rpc.handler.MessageContext messageContext) {
        block5: {
            block4: {
                if (this.impl == null || !this.impl.isEnabled()) break block4;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback(4) && this.impl.isComponentEnabled(4)) break block5;
            }
            return true;
        }
        if (this.trDebug) {
            Tr.debug(tc, "handleResponse");
        }
        this.tranEnd(messageContext, 0);
        return true;
    }

    public boolean handleFault(javax.xml.rpc.handler.MessageContext messageContext) {
        block5: {
            block4: {
                if (this.impl == null || !this.impl.isEnabled()) break block4;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback(4) && this.impl.isComponentEnabled(4)) break block5;
            }
            return true;
        }
        if (this.trDebug) {
            Tr.debug(tc, "handleFault");
        }
        this.tranEnd(messageContext, 2);
        return true;
    }

    public void handleClosure(javax.xml.rpc.handler.MessageContext messageContext) {
        block5: {
            block4: {
                if (this.impl == null || !this.impl.isEnabled()) break block4;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback(4) && this.impl.isComponentEnabled(4)) break block5;
            }
            return;
        }
        if (this.trDebug) {
            Tr.debug(tc, "handleClosure");
        }
        this.tranEnd(messageContext, 0);
    }

    private void tranEnd(javax.xml.rpc.handler.MessageContext messageContext, int n) {
        block7: {
            try {
                PmiRmThreadCtx pmiRmThreadCtx = this.impl.getThreadContext();
                if (!pmiRmThreadCtx.getTrace()) {
                    return;
                }
                boolean bl = false;
                Integer n2 = (Integer)messageContext.getProperty(RM_CLNT_START);
                if (n2 != null) {
                    int n3;
                    int n4 = n2;
                    if (n4 != (n3 = PmiRmArmWrapper.getStartHandle(pmiRmThreadCtx))) {
                        Tr.warning(tc, "PMRM0213W", "tranEnd");
                    } else {
                        bl = true;
                    }
                }
                Properties properties = null;
                if (bl) {
                    properties = this.getContextInfo(pmiRmThreadCtx, messageContext);
                }
                this.impl.updateEnd((Object)pmiRmThreadCtx, bl, n, properties);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsClientHandler.tranEnd", FFDC_ID_2);
                Tr.warning(tc, "PMRM0108E", exception.toString());
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                exception.printStackTrace();
            }
        }
    }

    protected Properties getMetricsData(javax.xml.rpc.handler.MessageContext messageContext, int n, boolean bl) {
        Properties properties;
        block12: {
            StringBuffer stringBuffer;
            Object object;
            QName qName;
            if (this.trDebug) {
                Tr.debug(tc, "getMetricsData: level=" + n);
            }
            properties = new Properties();
            MessageContext messageContext2 = (MessageContext)messageContext;
            RPCContext rPCContext = messageContext2.getRPCContext();
            if (n >= 2) {
                qName = rPCContext.getWSDLPort();
                object = rPCContext.getWSDLParameters();
                stringBuffer = new StringBuffer();
                if (object != null && ((QName[])object).length > 0) {
                    for (int i = 0; i < ((QName[])object).length; ++i) {
                        if (object[i] != null) {
                            stringBuffer.append(((QName)object[i]).getLocalPart());
                        } else {
                            stringBuffer.append("");
                        }
                        if (i >= ((Object)object).length - 1) continue;
                        stringBuffer.append(",");
                    }
                }
                if (qName != null) {
                    properties.put("WS_PORT_NM", qName.getLocalPart());
                } else {
                    properties.put("WS_PORT_NM", "");
                }
                properties.put("WS_OP_NM", rPCContext.getWSDLOperation());
                properties.put("WS_TRAN_NM", rPCContext.getTransportName());
                properties.put("WS_PRM_Q_NM_LST", stringBuffer.toString());
            }
            if (n == 3) {
                properties.put("WS_TGT_E_ADR", rPCContext.getTargetEndpointAddress());
                properties.put("WS_SVC_REF_NM", rPCContext.getServiceRefName());
                if (bl) {
                    try {
                        qName = ((com.ibm.ws.webservices.engine.MessageContext)messageContext).getMessage();
                        object = (com.ibm.ws.webservices.engine.SOAPPart)qName.getSOAPPart();
                        stringBuffer = ((com.ibm.ws.webservices.engine.SOAPPart)object).getEnvelope();
                        SOAPBody sOAPBody = stringBuffer.getBody();
                        properties.put("WS_RESP_MSG", sOAPBody);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, "com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsClientHandler.getMetricsData", FFDC_ID_4);
                        Tr.warning(tc, "PMRM0108E", exception.toString());
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block12;
                        exception.printStackTrace();
                    }
                }
            }
        }
        return properties;
    }

    protected String getTranName(javax.xml.rpc.handler.MessageContext messageContext) {
        MessageContext messageContext2 = (MessageContext)messageContext;
        RPCContext rPCContext = messageContext2.getRPCContext();
        QName qName = rPCContext.getWSDLPort();
        QName[] qNameArray = rPCContext.getWSDLParameters();
        StringBuffer stringBuffer = new StringBuffer();
        if (qNameArray != null && qNameArray.length > 0) {
            for (int i = 0; i < qNameArray.length; ++i) {
                if (qNameArray[i] != null) {
                    stringBuffer.append(qNameArray[i].getLocalPart());
                } else {
                    stringBuffer.append("");
                    if (this.trDebug) {
                        Tr.debug(tc, "getTranName, params " + i + " is null");
                    }
                }
                if (i >= qNameArray.length - 1) continue;
                stringBuffer.append(",");
            }
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("wsrequestor:");
        if (qName != null) {
            stringBuffer2.append(qName.getLocalPart());
        } else {
            if (this.trDebug) {
                Tr.debug(tc, "getTranName, portQName is null");
            }
            stringBuffer2.append("");
        }
        String string = rPCContext.getWSDLOperation();
        if (string == null) {
            stringBuffer2.append(".");
        } else {
            stringBuffer2.append(".").append(string);
        }
        stringBuffer2.append("?transport=").append(rPCContext.getTransportName());
        stringBuffer2.append("&parameters=").append(stringBuffer.toString());
        String string2 = stringBuffer2.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTranName returns " + string2);
        }
        return string2;
    }

    protected String[] getContextValues(javax.xml.rpc.handler.MessageContext messageContext) {
        String[] stringArray = new String[4];
        MessageContext messageContext2 = (MessageContext)messageContext;
        RPCContext rPCContext = messageContext2.getRPCContext();
        QName qName = rPCContext.getWSDLPort();
        QName[] qNameArray = rPCContext.getWSDLParameters();
        StringBuffer stringBuffer = new StringBuffer();
        if (qNameArray != null && qNameArray.length > 0) {
            for (int i = 0; i < qNameArray.length; ++i) {
                if (qNameArray[i] != null) {
                    stringBuffer.append(qNameArray[i].getLocalPart());
                } else {
                    stringBuffer.append("");
                }
                if (i >= qNameArray.length - 1) continue;
                stringBuffer.append(",");
            }
        }
        stringArray[0] = qName != null ? qName.getLocalPart() : "";
        stringArray[1] = rPCContext.getWSDLOperation();
        stringArray[2] = rPCContext.getTransportName();
        stringArray[3] = stringBuffer.toString();
        return stringArray;
    }

    public Properties getTranDetailProps(PmiRmThreadCtx pmiRmThreadCtx, int n, javax.xml.rpc.handler.MessageContext messageContext, boolean bl) {
        int n2 = this.impl.getTranDetailLevel(pmiRmThreadCtx, 4);
        if (n2 < 2 || messageContext == null) {
            return null;
        }
        return this.getContextInfo(pmiRmThreadCtx, messageContext);
    }
}

