/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.reqmetrics.wsHandlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmStack;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmTx;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl;
import com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper;
import com.ibm.ws.pmi.reqmetrics.PmiRmCallContext;
import com.ibm.ws.pmi.reqmetrics.PmiRmConfigData;
import com.ibm.ws.pmi.reqmetrics.PmiRmCorrelator;
import com.ibm.ws.pmi.reqmetrics.PmiRmThreadCtx;
import com.ibm.ws.pmi.reqmetrics.PmiRmUtil;
import com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsHandlerBase;
import com.ibm.ws.pmi.reqmetrics.wsHandlers.WsFilterCfg;
import com.ibm.ws.pmi.reqmetrics.wsHandlers.WsFilterValue;
import com.ibm.wsspi.webservices.rpc.handler.MessageContext;
import com.ibm.wsspi.webservices.rpc.handler.RPCContext;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class ReqMetricsServerHandler
extends ReqMetricsHandlerBase {
    private static final TraceComponent tc = Tr.register(ReqMetricsServerHandler.class.getName(), "pmi.rm", "com.ibm.ws.pmi.reqmetrics.reqmetrics");
    private static final String SOURCE_FILE = "com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsServerHandler";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    public static final int PORT_ID = 0;
    public static final int OP_ID = 1;
    public static final int TRANSPORT_ID = 2;
    public static final int NAMESPACE_ID = 3;
    public static final int INPUT_MESSAGE_ID = 4;
    public static final int METHOD_INFO_OFFSET = 0;
    public static final String RM_SRV_START = "REQMETRICS_WS_SERVER_START";
    public static final int num_webservices_ctx_names = 5;

    public ReqMetricsServerHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ReqMetricsServerHandler is initialized");
        }
    }

    public boolean handleRequest(javax.xml.rpc.handler.MessageContext messageContext) {
        block30: {
            boolean bl;
            block32: {
                block31: {
                    if (this.impl == null) {
                        Tr.debug(tc, "handleRequest :PmiReqMetricsImpl is null");
                        return true;
                    }
                    if (!this.impl.isEnabled()) break block31;
                    if (PmiReqMetricsImpl.isComponentEnabledInArmCallback(3)) break block32;
                }
                return true;
            }
            boolean bl2 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
            if (bl) {
                Tr.entry(tc, "handleRequest");
            }
            try {
                int n;
                Object object;
                String[] stringArray;
                PmiRmThreadCtx pmiRmThreadCtx = this.impl.getThreadContext();
                ReqMetricsServerHandler reqMetricsServerHandler = this;
                PmiRmConfigData pmiRmConfigData = reqMetricsServerHandler.impl.getConfig();
                String[] stringArray2 = null;
                byte[] byArray = null;
                Object var7_8 = null;
                boolean bl3 = false;
                boolean bl4 = true;
                PmiRmArmTx pmiRmArmTx = PmiRmArmStack.peekTransaction();
                if (pmiRmArmTx != null) {
                    if (bl) {
                        Tr.debug(tc, "handleRequest: peekTransaction returns a PmiRmArmTx");
                    }
                    if (pmiRmArmTx instanceof PmiRmCallContext) {
                        stringArray = (String[])pmiRmArmTx;
                        object = stringArray.getCorrelator();
                        if (bl) {
                            Tr.debug(tc, "PmiRmCorrelator is " + ((PmiRmCorrelator)object).formatAsParent());
                        }
                        bl3 = true;
                        byArray = pmiRmArmTx.getCorrelatorBytes();
                    } else {
                        if (bl) {
                            Tr.debug(tc, "The parent correlator is not a PmiRmCallContext");
                        }
                        bl3 = true;
                        byArray = pmiRmArmTx.getCorrelatorBytes();
                    }
                }
                if (!bl3) {
                    if (bl) {
                        Tr.debug(tc, "handleRequest: do not have correlator on the stack, check incoming correlator");
                    }
                    stringArray = this.getCorrelatorsFromContext(messageContext);
                    boolean bl5 = true;
                    if (stringArray[0] == null && stringArray[1] == null) {
                        stringArray2 = this.getContextValues(messageContext);
                        bl5 = this.isFilterPassed(stringArray2, pmiRmConfigData);
                    }
                    this.impl.setInboundCorrelators(pmiRmThreadCtx, 3, stringArray, bl5);
                    n = pmiRmThreadCtx.getInboundCorrelatorType();
                    if (n == 1) {
                        bl4 = false;
                    } else {
                        if (n == 2) {
                            if (bl) {
                                Tr.exit(tc, "handleRequest: request not pass filter at upstream, stop instrumentation now");
                            }
                            return true;
                        }
                        bl4 = true;
                    }
                    if (bl) {
                        Tr.debug(tc, "handleRequest: pushIncomingCorrelators return status=" + n + ", hasIncomingCorrelator=" + bl4);
                    }
                }
                if (!pmiRmThreadCtx.getTrace()) {
                    return true;
                }
                if (!this.impl.isComponentEnabled(3) && (bl3 || bl4)) {
                    if (bl) {
                        Tr.exit(tc, "handleRequest: Web Sevices component is not enabled for request metrics instrumentation. Do not create sub-transaction");
                    }
                    return true;
                }
                boolean bl6 = this.isTraceEnabled(byArray);
                if (!bl6 && !this.impl.isLogEnabled()) {
                    if (bl) {
                        Tr.exit(tc, "handleRequest: stop tracing because this transaction is not enabled for ARM and log tracing");
                    }
                    return true;
                }
                if (stringArray2 == null) {
                    stringArray2 = this.getContextValues(messageContext);
                }
                object = this.getTranName(stringArray2);
                this.impl.reqStart(pmiRmThreadCtx, 3, bl6, (String)object, stringArray2);
                if (bl6) {
                    n = PmiRmArmWrapper.getStartHandle(pmiRmThreadCtx);
                    if (bl) {
                        Tr.debug(tc, "calling MessageContext.setProperty for startHandler=" + n);
                    }
                    messageContext.setProperty(RM_SRV_START, (Object)new Integer(n));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsServerHandler.handleRequest", FFDC_ID_1);
                Tr.warning(tc, "PMRM0108E", exception.toString());
                if (!bl) break block30;
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "handleRequest");
        return true;
    }

    public boolean handleResponse(javax.xml.rpc.handler.MessageContext messageContext) {
        boolean bl;
        block7: {
            block6: {
                if (this.impl == null) {
                    Tr.debug(tc, "handleResponse :PmiReqMetricsImpl is null");
                    return true;
                }
                if (!this.impl.isEnabled()) break block6;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback(3)) break block7;
            }
            return true;
        }
        boolean bl2 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "handleResponse");
        }
        this.tranEnd(messageContext, 0);
        if (bl) {
            Tr.exit(tc, "handleResponse");
        }
        return true;
    }

    public boolean handleFault(javax.xml.rpc.handler.MessageContext messageContext) {
        boolean bl;
        block7: {
            block6: {
                if (this.impl == null) {
                    Tr.debug(tc, "handleFault :PmiReqMetricsImpl is null");
                    return true;
                }
                if (!this.impl.isEnabled()) break block6;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback(3)) break block7;
            }
            return true;
        }
        boolean bl2 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "handleFault");
        }
        this.tranEnd(messageContext, 2);
        if (bl) {
            Tr.exit(tc, "handleFault");
        }
        return true;
    }

    public void handleClosure(javax.xml.rpc.handler.MessageContext messageContext) {
        boolean bl;
        block7: {
            block6: {
                if (this.impl == null) {
                    Tr.debug(tc, "handleClosure :PmiReqMetricsImpl is null");
                    return;
                }
                if (!this.impl.isEnabled()) break block6;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback(3)) break block7;
            }
            return;
        }
        boolean bl2 = bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (bl) {
            Tr.entry(tc, "handleClosure");
        }
        this.tranEnd(messageContext, 0);
        if (bl) {
            Tr.exit(tc, "handleClosure");
        }
    }

    private void tranEnd(javax.xml.rpc.handler.MessageContext messageContext, int n) {
        block11: {
            Tr.entry(tc, "tranEnd");
            try {
                PmiRmArmTx pmiRmArmTx;
                PmiRmThreadCtx pmiRmThreadCtx = this.impl.getThreadContext();
                if (!this.impl.isComponentEnabled(3)) {
                    if (pmiRmThreadCtx.getInboundComponent() != 3) {
                        return;
                    }
                    if (!pmiRmThreadCtx.isInboundInstrumented()) {
                        return;
                    }
                }
                if ((pmiRmArmTx = PmiRmArmWrapper.peekArmTransaction(pmiRmThreadCtx)) == null) {
                    Tr.error(tc, "PMRM0030E");
                    Tr.exit(tc, "tranEnd");
                    return;
                }
                boolean bl = false;
                Integer n2 = (Integer)messageContext.getProperty(RM_SRV_START);
                if (n2 != null) {
                    int n3;
                    int n4 = n2;
                    if (n4 != (n3 = PmiRmArmWrapper.getStartHandle(pmiRmThreadCtx))) {
                        Tr.warning(tc, "PMRM0213W", "tranEnd");
                    } else {
                        bl = true;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "tranEnd: armStartCalled=" + bl);
                }
                Properties properties = null;
                if (bl) {
                    properties = this.getContextInfo(pmiRmThreadCtx, messageContext);
                }
                this.impl.reqStop(pmiRmThreadCtx, bl, n, properties);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsServerHandler.tranEnd", FFDC_ID_2);
                Tr.warning(tc, "PMRM0108E", exception.toString());
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "tranEnd");
    }

    private String getTranName(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTranName");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("wsprovider:");
        stringBuffer.append(stringArray[0]);
        if (stringArray[1] == null) {
            stringBuffer.append(".");
        } else {
            stringBuffer.append(".").append(stringArray[1]);
        }
        stringBuffer.append("?transport=").append(stringArray[2]);
        if (stringArray[3] == null) {
            stringBuffer.append("&namespace=");
        } else {
            stringBuffer.append("&namespace=").append(stringArray[3]);
        }
        stringBuffer.append("&input=").append(stringArray[4]);
        String string = stringBuffer.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTranName returns " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTranName");
        }
        return string;
    }

    private String[] getContextValues(javax.xml.rpc.handler.MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getContextValues");
        }
        String[] stringArray = new String[5];
        if (messageContext == null) {
            return stringArray;
        }
        MessageContext messageContext2 = (MessageContext)messageContext;
        RPCContext rPCContext = messageContext2.getRPCContext();
        QName qName = rPCContext.getWSDLPort();
        QName qName2 = rPCContext.getWSDLInputMessageName();
        if (qName == null) {
            stringArray[0] = "";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ReqMetricsServerHandler.getContextValues: portQName is null");
            }
        } else {
            stringArray[0] = qName.getLocalPart();
        }
        stringArray[1] = rPCContext.getWSDLOperation();
        stringArray[2] = rPCContext.getTransportName();
        stringArray[3] = rPCContext.getWSDLTargetNamespace();
        if (qName2 == null) {
            stringArray[4] = "";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ReqMetricsServerHandler.getContextValues: inputMsg is null");
            }
        } else {
            stringArray[4] = qName2.getLocalPart();
        }
        return stringArray;
    }

    protected Properties getMetricsData(javax.xml.rpc.handler.MessageContext messageContext, int n, boolean bl) {
        Properties properties;
        block13: {
            Serializable serializable;
            QName qName;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.entry(tc, "getMetricsData: level=" + n);
            }
            if (messageContext == null) {
                return null;
            }
            properties = new Properties();
            MessageContext messageContext2 = (MessageContext)messageContext;
            RPCContext rPCContext = messageContext2.getRPCContext();
            if (n >= 2) {
                qName = rPCContext.getWSDLPort();
                serializable = rPCContext.getWSDLInputMessageName();
                if (qName != null) {
                    properties.put("WS_PORT_NM", qName.getLocalPart());
                } else {
                    properties.put("WS_PORT_NM", "");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getMetricsData: WSDLPort QName is null");
                    }
                }
                properties.put("WS_OP_NM", rPCContext.getWSDLOperation());
                properties.put("WS_TRAN_NM", rPCContext.getTransportName());
                properties.put("WS_TGT_NS", rPCContext.getWSDLTargetNamespace());
                if (serializable != null) {
                    properties.put("WS_IN_MSG_NM", ((QName)serializable).getLocalPart());
                } else {
                    properties.put("WS_IN_MSG_NM", "");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getMetricsData: inputMsg QName is null");
                    }
                }
            }
            if (n == 3) {
                properties.put("WS_WSDL_LOC", rPCContext.getWSDLLocation());
                if (bl) {
                    try {
                        qName = ((com.ibm.ws.webservices.engine.MessageContext)messageContext).getMessage();
                        serializable = (com.ibm.ws.webservices.engine.SOAPPart)qName.getSOAPPart();
                        SOAPEnvelope sOAPEnvelope = ((com.ibm.ws.webservices.engine.SOAPPart)serializable).getEnvelope();
                        SOAPBody sOAPBody = sOAPEnvelope.getBody();
                        properties.put("WS_SOAP_BD", sOAPBody);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, "com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsServerHandler.getMetricsData", FFDC_ID_4);
                        Tr.warning(tc, "PMRM0108E", exception.toString());
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                        exception.printStackTrace();
                    }
                }
            }
        }
        return properties;
    }

    private String[] getCorrelatorsFromContext(javax.xml.rpc.handler.MessageContext messageContext) {
        try {
            boolean bl = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
            SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
            String string = null;
            String string2 = null;
            if (sOAPHeader != null) {
                Name name2 = sOAPEnvelope.createName("rm_correlator", "", "");
                Iterator iterator = sOAPHeader.examineHeaderElements("reqmetricsURI");
                boolean bl2 = false;
                com.ibm.ws.webservices.engine.xmlsoap.Name name3 = null;
                String string3 = null;
                while (iterator.hasNext()) {
                    SOAPHeaderElement sOAPHeaderElement;
                    if (bl) {
                        Tr.debug(tc, "ReqMetricsServerHandler.getCorrelatorsFromContext: find a header element");
                    }
                    if ((string3 = (name3 = (com.ibm.ws.webservices.engine.xmlsoap.Name)(sOAPHeaderElement = (SOAPHeaderElement)iterator.next()).getElementName()).getLocalName()).indexOf("arm_correlator") != -1 || string3.indexOf("correlator") != -1) {
                        string = sOAPHeaderElement.getValue();
                        string2 = sOAPHeaderElement.getAttributeValue(name2);
                        bl2 = true;
                    }
                    if (bl2 && bl) {
                        Tr.debug(tc, "getCorrelatorsFromContext armCorStr=" + string + ", rmCorStr=" + string2);
                    }
                    if (!bl2) continue;
                    break;
                }
            }
            return new String[]{string, string2};
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsServerHandler.getCorrelatorsFromContext", FFDC_ID_5, this);
            exception.printStackTrace();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                exception.printStackTrace();
            }
            return new String[]{null, null};
        }
    }

    private boolean isFilterPassed(String[] stringArray, PmiRmConfigData pmiRmConfigData) {
        WsFilterCfg wsFilterCfg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFilterPassed");
        }
        if (!(wsFilterCfg = (WsFilterCfg)pmiRmConfigData.getWSFilterConfig()).isEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFilterPassed returns true because this filter is not enabled");
            }
            return true;
        }
        for (int i = 0; i < wsFilterCfg.getParsedValues().length; ++i) {
            WsFilterValue wsFilterValue = wsFilterCfg.getParsedValues()[i];
            if (!wsFilterValue.isEnabled() || !PmiRmUtil.isStrMatched(wsFilterValue.getPort(), stringArray[0]) || !PmiRmUtil.isStrMatched(wsFilterValue.getOperation(), stringArray[1]) || !PmiRmUtil.isStrMatched(wsFilterValue.getNameSpace(), stringArray[3])) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFilterPassed returns true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFilterPassed returns false");
        }
        return false;
    }

    public Properties getTranDetailProps(PmiRmThreadCtx pmiRmThreadCtx, int n, javax.xml.rpc.handler.MessageContext messageContext, boolean bl) {
        int n2 = this.impl.getTranDetailLevel(pmiRmThreadCtx, 3);
        if (n2 < 2 || messageContext == null) {
            return null;
        }
        return this.getContextInfo(pmiRmThreadCtx, messageContext);
    }
}

