/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.stat.StatsConfigHelper;
import com.ibm.ws.xml.ParserFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class ModuleConfigParser
extends DefaultHandler
implements PmiConstants {
    public static final String STATS_DTD = "/com/ibm/websphere/pmi/xml/stats.dtd";
    public static final String VALIDATE_DESCRIPTOR_PROPERTY = "com.ibm.websphere.pmi.validateDescriptors";
    private PmiModuleConfig oneModule = null;
    private PmiDataInfo currentData;
    private PmiDataInfo submoduleData;
    private String currentChars = null;
    private final TraceComponent tc = Tr.register(ModuleConfigParser.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private String submoduleName = null;
    private boolean isModule = true;
    private String _fileName = null;
    private boolean _validate = false;
    private boolean bExtension = false;
    private Locator locator = null;
    private static String PERF_MODULE = "PerfModule";
    private static String STATS = "Stats";
    private static String PERF_LONG = "PerfLong";
    private static String COUNT_STAT = "CountStatistic";
    private static String PERF_DOUBLE = "PerfDouble";
    private static String DOUBLE_STAT = "DoubleStatistic";
    private static String PERF_LOAD = "PerfLoad";
    private static String BOUNDED_RANGE_STAT = "BoundedRangeStatistic";
    private static String PERF_STAT = "PerfStat";
    private static String TIME_STAT = "TimeStatistic";
    private static String AVG_STAT = "AverageStatistic";
    private static String RANGE_STAT = "RangeStatistic";
    private static String PERF_SUBMODULE = "PerfSubModule";
    private static String UID = "UID";
    private static String DESCRIPTION = "description";
    private static String NAME = "name";
    private static String LEVEL = "level";
    private static String STATISTICSET = "statisticSet";
    private static String PLATFORM = "platform";
    private static String UNIT = "unit";
    private static String RESETTABLE = "resettable";
    private static String AGGREGATABLE = "aggregatable";
    private static String ZOS_AGGREGATABLE = "zosAggregatable";
    private static String ON_REQUEST = "updateOnRequest";
    private static String CATEGORY = "category";
    private static String COMMENT = "comment";
    private static String DEPENDENCY = "dependency";
    private static String MBEAN_TYPE = "mBeanType";
    private static String STATS_NLS_FILE = "resourceBundle";
    private static String TYPE = "type";
    private static String EXTENSION_TAG = "EXTENSION";
    private static AttributesImpl attrList;

    public PmiModuleConfig parse(String string) throws Exception {
        return this.loadDescriptor(string, false);
    }

    public synchronized PmiModuleConfig parse(String string, boolean bl) throws Exception {
        return this.loadDescriptor(string, bl);
    }

    public PmiModuleConfig loadDescriptor(String string, boolean bl) throws Exception {
        return this.loadDescriptor(string, bl, true);
    }

    public PmiModuleConfig loadDescriptor(String string, boolean bl, boolean bl2) throws Exception {
        Object object;
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "loadDescriptor: parsing stats xml " + string + "; dtd validation: " + bl);
        }
        this.oneModule = null;
        this.currentData = null;
        this.submoduleName = null;
        this.submoduleData = null;
        this._fileName = string;
        this._validate = bl;
        InputStream inputStream = null;
        boolean bl3 = false;
        if (string.indexOf(61) != -1 && ((String[])(object = string.split("="))).length > 1 && object[0].equalsIgnoreCase(EXTENSION_TAG)) {
            this.bExtension = true;
            this._fileName = object[1];
            try {
                this.parseFromExtension(this._fileName);
            }
            catch (Exception exception) {
                if (this.tc.isDebugEnabled()) {
                    exception.printStackTrace();
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.pmi.server.ModuleConfigParser.loadDescriptor", "97", this);
                throw exception;
            }
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "loadDescriptor");
            }
            return this.oneModule;
        }
        this.bExtension = false;
        if (inputStream == null) {
            if (bl2) {
                inputStream = this.getClass().getResourceAsStream(string);
                bl3 = false;
                if (inputStream == null) {
                    inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
                    bl3 = true;
                }
                if (inputStream == null) {
                    inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string.substring(1));
                    bl3 = true;
                }
                if (inputStream == null) {
                    Tr.error(this.tc, "PMI0010W", string);
                    return null;
                }
            } else {
                inputStream = new FileInputStream(string);
                if (inputStream == null) {
                    Tr.error(this.tc, "PMI0010W", string);
                    return null;
                }
            }
        }
        try {
            object = ParserFactory.createXMLReader();
            object.setFeature("http://xml.org/sax/features/namespaces", true);
            object.setFeature("http://xml.org/sax/features/validation", bl);
            object.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", bl);
            object.setEntityResolver(this);
            object.setContentHandler(this);
            object.setErrorHandler(this);
            object.parse(new InputSource(inputStream));
        }
        catch (Exception exception) {
            if (this.tc.isDebugEnabled()) {
                exception.printStackTrace();
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.pmi.server.ModuleConfigParser.loadDescriptor", "97", this);
            throw exception;
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "loadDescriptor");
        }
        if (bl3) {
            StatsConfigHelper.translateAndCache(this.oneModule, null);
        }
        return this.oneModule;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "resolveEntity", string2);
        }
        InputSource inputSource = null;
        try {
            if (string2.endsWith("stats.dtd")) {
                InputStream inputStream = this.getClass().getResourceAsStream(STATS_DTD);
                inputSource = new InputSource(inputStream);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.pmi.server.ModuleConfigParser.resolveEntity", "126", this);
            Tr.error(this.tc, "PMI0010W", string2);
            return null;
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "resolveEntity");
        }
        return inputSource;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "error", sAXParseException);
        }
        throw new SAXException(sAXParseException);
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXException {
        if (string3.equals(PERF_MODULE)) {
            this.isModule = true;
            String string4 = PerfModules.getModuleUID(this._fileName);
            int n = string4.lastIndexOf(".");
            String string5 = string4.substring(n + 1);
            this.oneModule = new PmiModuleConfig(string5);
            return;
        }
        if (string3.equals(STATS)) {
            String string6;
            this.isModule = true;
            String string7 = attributes2.getValue(TYPE);
            if (this._validate && !(string6 = this.bExtension ? this._fileName : PerfModules.getModuleUID(this._fileName)).equals(string7)) {
                throw new SAXException("Stats template name does not match with stat type: template = " + this._fileName + "; stats type = " + string7);
            }
            this.oneModule = new PmiModuleConfig(string7);
            return;
        }
        if (!string3.equals(DESCRIPTION) && !string3.equals(STATS_NLS_FILE)) {
            if (string3.equals(COUNT_STAT) || string3.equals(TIME_STAT) || string3.equals(RANGE_STAT) || string3.equals(BOUNDED_RANGE_STAT) || string3.equals(AVG_STAT) || string3.equals(DOUBLE_STAT) || string3.equals(PERF_LONG) || string3.equals(PERF_LOAD) || string3.equals(PERF_STAT) || string3.equals(PERF_DOUBLE) || string3.equals(PERF_SUBMODULE)) {
                this.isModule = false;
                int n = Integer.parseInt(attributes2.getValue("ID"));
                this.currentData = new PmiDataInfo(n);
                this.currentData.setName(attributes2.getValue(NAME));
                this.currentData.setSubmoduleName(this.submoduleName);
                if (string3.equals(COUNT_STAT) || string3.equals(PERF_LONG)) {
                    this.currentData.setType(2);
                } else if (string3.equals(BOUNDED_RANGE_STAT) || string3.equals(PERF_LOAD)) {
                    this.currentData.setType(5);
                } else if (string3.equals(RANGE_STAT)) {
                    this.currentData.setType(7);
                } else if (string3.equals(PERF_STAT) || string3.equals(TIME_STAT)) {
                    this.currentData.setType(4);
                } else if (string3.equals(PERF_DOUBLE) || string3.equals(DOUBLE_STAT)) {
                    this.currentData.setType(3);
                } else if (string3.equals(AVG_STAT)) {
                    this.currentData.setType(6);
                } else if (string3.equals(PERF_SUBMODULE)) {
                    this.currentData.setType(15);
                    this.submoduleName = this.currentData.getName();
                }
                this.oneModule.addData(this.currentData);
            } else if (string3.equals(LEVEL) || string3.equals(CATEGORY) || string3.equals(UNIT) || string3.equals(AGGREGATABLE) || string3.equals(ZOS_AGGREGATABLE) || string3.equals(RESETTABLE) || string3.equals(COMMENT)) {
                // empty if block
            }
        }
        this.currentChars = null;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!string3.equals(PERF_MODULE) && !string3.equals(STATS)) {
            if (string3.equals(DESCRIPTION)) {
                if (this.isModule) {
                    this.oneModule.setDescription(this.currentChars);
                } else {
                    this.currentData.setDescription(this.currentChars);
                }
            } else if (string3.equals(STATS_NLS_FILE)) {
                if (this.isModule) {
                    this.oneModule.setResourceBundle(this.currentChars);
                }
            } else if (!(string3.equals(PERF_LONG) || string3.equals(PERF_LOAD) || string3.equals(PERF_STAT) || string3.equals(PERF_DOUBLE) || string3.equals(COUNT_STAT) || string3.equals(BOUNDED_RANGE_STAT) || string3.equals(RANGE_STAT) || string3.equals(AVG_STAT) || string3.equals(TIME_STAT) || string3.equals(DOUBLE_STAT))) {
                if (string3.equals(PERF_SUBMODULE)) {
                    this.submoduleName = null;
                } else if (string3.equals(LEVEL)) {
                    if (this.currentChars.equals("low")) {
                        this.currentData.setLevel(1);
                    } else if (this.currentChars.equals("medium")) {
                        this.currentData.setLevel(3);
                    } else if (this.currentChars.equals("high")) {
                        this.currentData.setLevel(7);
                    } else if (this.currentChars.equals("maximum")) {
                        this.currentData.setLevel(15);
                    } else {
                        this.currentData.setLevel(1000);
                    }
                } else if (string3.equals(CATEGORY)) {
                    this.currentData.setCategory(this.currentChars);
                } else if (string3.equals(UNIT)) {
                    this.currentData.setUnit(this.currentChars);
                } else if (string3.equals(STATISTICSET)) {
                    this.currentData.setStatisticSet(this.currentChars);
                } else if (string3.equals(PLATFORM)) {
                    this.currentData.setPlatform(this.currentChars);
                } else if (string3.equals(RESETTABLE)) {
                    if (this.currentChars.equals("false")) {
                        this.currentData.setResettable(false);
                    }
                } else if (string3.equals(AGGREGATABLE)) {
                    if (this.currentChars.equals("false")) {
                        this.currentData.setAggregatable(false);
                    }
                } else if (string3.equals(ZOS_AGGREGATABLE)) {
                    if (this.currentChars.equals("false")) {
                        this.currentData.setZosAggregatable(false);
                    }
                } else if (string3.equals(COMMENT)) {
                    this.currentData.setComment(this.currentChars);
                } else if (string3.equals(ON_REQUEST)) {
                    if (this.currentChars.equals("true")) {
                        this.currentData.setOnRequest(true);
                    }
                } else if (string3.equals(DEPENDENCY)) {
                    try {
                        int n = Integer.parseInt(this.currentChars);
                        this.currentData.addDependency(n);
                    }
                    catch (Exception exception) {}
                } else if (string3.equals(MBEAN_TYPE)) {
                    this.oneModule.setMbeanType(this.currentChars);
                    if (this.isModule) {
                        PmiRegistry.jmxMapper.setMapping(this.oneModule.getShortName(), null, null, this.currentChars);
                    } else {
                        PmiRegistry.jmxMapper.setMapping(this.oneModule.getShortName(), null, this.currentData.getName(), this.currentChars);
                    }
                }
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this.currentChars = this.currentChars == null ? string : this.currentChars + string;
    }

    private String getXmlFileName(String string) {
        String string2 = "/" + string.replace('.', '/') + ".xml";
        return string2;
    }

    private void parseFromExtension(String string) {
        IExtension iExtension;
        String string2;
        IExtensionPoint iExtensionPoint;
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (iExtensionRegistry == null) {
            Tr.error(this.tc, "Unable to get eclipse extension registry");
        }
        if ((iExtensionPoint = iExtensionRegistry.getExtensionPoint(string2 = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".pmiCustomExtension")) == null) {
            Tr.error(this.tc, "Unable to get extension point - " + string2);
        }
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "Processing extension point " + string2);
        }
        if ((iExtension = iExtensionPoint.getExtension(string)) == null) {
            Tr.error(this.tc, "PMI0010W", string);
            return;
        }
        attrList = new AttributesImpl();
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            this.processExtensionElement(iConfigurationElementArray[i]);
        }
    }

    private void processExtensionElement(IConfigurationElement iConfigurationElement) {
        block5: {
            try {
                this.getAttributesFromExtensionElement(iConfigurationElement);
                String string = iConfigurationElement.getName();
                this.startElement("", "", string, attrList);
                IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
                if (iConfigurationElementArray != null) {
                    for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                        this.processExtensionElement(iConfigurationElementArray[i]);
                    }
                }
                this.currentChars = iConfigurationElement.getValue();
                if (this.currentChars == null) {
                    this.currentChars = "";
                }
                this.endElement("", "", string);
            }
            catch (Exception exception) {
                if (!this.tc.isDebugEnabled()) break block5;
                exception.printStackTrace();
            }
        }
    }

    private void getAttributesFromExtensionElement(IConfigurationElement iConfigurationElement) {
        attrList.clear();
        String[] stringArray = iConfigurationElement.getAttributeNames();
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = iConfigurationElement.getAttribute(stringArray[i]);
                attrList.addAttribute(stringArray[i], stringArray[i], stringArray[i], "String", string);
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        ModuleConfigParser moduleConfigParser = new ModuleConfigParser();
        moduleConfigParser.parse("/com/ibm/websphere/pmi/custom/test/PmiServletModule1.xml", true);
    }
}

