/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.StatLevelSpec;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.management.MBeanStateConsumer;
import com.ibm.ws.pmi.component.PMIImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PMIServiceState;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.server.PmiCollaborator;
import com.ibm.ws.pmi.server.PmiConfigManager;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.server.StatsHelper;
import com.ibm.ws.pmi.stat.StatsImpl;
import java.io.Serializable;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.management.ObjectName;

public class PmiCollaboratorImpl
implements PmiCollaborator,
PmiConstants,
MBeanStateConsumer {
    private static final TraceComponent tc = Tr.register(PmiCollaboratorImpl.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private static PmiCollaboratorImpl _instance = null;

    private PmiCollaboratorImpl() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "init: PmiCollaboratorImpl");
        }
    }

    public static PmiCollaborator getSingletonInstance() {
        if (_instance == null) {
            _instance = new PmiCollaboratorImpl();
        }
        return _instance;
    }

    public MBeanStatDescriptor[] listStatMembers(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listStatMembers(ObjectName)");
        }
        MBeanStatDescriptor[] mBeanStatDescriptorArray = PmiRegistry.listStatMembers(objectName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listStatMembers(ObjectName)");
        }
        return mBeanStatDescriptorArray;
    }

    public MBeanStatDescriptor[] listStatMembers(MBeanStatDescriptor mBeanStatDescriptor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listStatMembers(MBeanStatDescriptor");
        }
        MBeanStatDescriptor[] mBeanStatDescriptorArray = PmiRegistry.listStatMembers(mBeanStatDescriptor);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listStatMembers(MBeanStatDescriptor)");
        }
        return mBeanStatDescriptorArray;
    }

    public StatDescriptor[] listStatMembers(StatDescriptor statDescriptor, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listStatMembers(StatDescriptor, Boolean)");
        }
        StatDescriptor[] statDescriptorArray = PmiRegistry.listStatMembers(statDescriptor, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listStatMembers(StatDescriptor, Boolean)");
        }
        return statDescriptorArray;
    }

    public void savePMIConfiguration() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "savePMIConfiguration");
        }
        PmiConfigManager.saveSpec();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "savePMIConfiguration");
        }
    }

    public void setStatisticSet(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStatisticSet(statSet): " + string);
        }
        PmiRegistry.setInstrumentationLevel(string);
        PMIImpl.setStatisticSet(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStatisticSet(statSet)");
        }
    }

    public String getStatisticSet() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatisticSet");
        }
        String string = PMIImpl.getStatisticSet();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatisticSet: " + string);
        }
        return string;
    }

    public void setSynchronizedUpdate(Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSynchronizedUpdate(): " + bl);
        }
        PmiRegistry.setSynchronizedUpdate(bl);
        PMIImpl.setSynchronizedUpdate(bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSynchronizedUpdate())");
        }
    }

    public Boolean getSynchronizedUpdate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSynchronizedUpdate");
        }
        boolean bl = PMIImpl.getSynchronizedUpdate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSynchronizedUpdate: " + bl);
        }
        return new Boolean(bl);
    }

    public String getCustomSetString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomSetString");
        }
        String string = PmiRegistry.getInstrumentationLevelString60();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomSetString");
        }
        return string;
    }

    public void setCustomSetString(String string, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCustomSetString (String, Boolean): " + string);
        }
        this.setInstrumentationLevel(this._createSLSFromString(string), bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCustomSetString");
        }
    }

    public void appendCustomSetString(String string, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appendCustomSetString (String, Boolean): " + string);
        }
        this.appendInstrumentationLevel(this._createSLSFromString(string), bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appendCustomSetString");
        }
    }

    private StatLevelSpec[] _createSLSFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = stringTokenizer.countTokens();
        StatLevelSpec[] statLevelSpecArray = new StatLevelSpec[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            statLevelSpecArray[n2++] = this._createSLS(stringTokenizer.nextToken());
        }
        return statLevelSpecArray;
    }

    private StatLevelSpec _createSLS(String string) {
        String string2;
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        try {
            stringArray = PmiConfigManager.parsePath(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            return null;
        }
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            string2 = null;
        }
        return new StatLevelSpec(stringArray, PmiConfigManager.parseSpecStr(string2));
    }

    public WSStats getStatsObject(ObjectName objectName, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsObject(ObjectName, Boolean)");
        }
        StatsImpl statsImpl = PmiRegistry.getStats(new MBeanStatDescriptor(objectName), (boolean)bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsObject(ObjectName, Boolean)");
        }
        return statsImpl;
    }

    public WSStats getStatsObject(MBeanStatDescriptor mBeanStatDescriptor, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsObject(MBeanStatDescriptor, Boolean)");
        }
        StatsImpl statsImpl = PmiRegistry.getStats(mBeanStatDescriptor, (boolean)bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsObject(MBeanStatDescriptor, Boolean)");
        }
        return statsImpl;
    }

    public WSStats[] getStatsArray(ObjectName[] objectNameArray, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsArray (ObjectName[], Boolean)");
        }
        if (objectNameArray == null || objectNameArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ObjectName is null or empty");
            }
            return null;
        }
        WSStats[] wSStatsArray = PmiRegistry.getStats(objectNameArray, (boolean)bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsArray (ObjectName[], Boolean)");
        }
        return wSStatsArray;
    }

    public WSStats[] getStatsArray(StatDescriptor[] statDescriptorArray, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsArray (StatDescriptor[], Boolean)");
        }
        if (statDescriptorArray == null || statDescriptorArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StatDescriptor is null or empty");
            }
            return null;
        }
        WSStats[] wSStatsArray = PmiRegistry.getStats(statDescriptorArray, (boolean)bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsArray (StatDescriptor[], Boolean)");
        }
        return wSStatsArray;
    }

    public WSStats[] getStatsArray(MBeanStatDescriptor[] mBeanStatDescriptorArray, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsArray (MBeanStatDescriptor[], Boolean)");
        }
        if (mBeanStatDescriptorArray == null || mBeanStatDescriptorArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MBeanStatDescriptor is null or empty");
            }
            return null;
        }
        WSStats[] wSStatsArray = PmiRegistry.getStats(mBeanStatDescriptorArray, (boolean)bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsArray (MBeanStatDescriptor[], Boolean)");
        }
        return wSStatsArray;
    }

    public void setInstrumentationLevel(MBeanLevelSpec mBeanLevelSpec, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInstrumentationLevel (MBeanLevelSpec, Boolean)");
        }
        PmiRegistry.setMBeanLevel(mBeanLevelSpec, (boolean)bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInstrumentationLevel (MBeanLevelSpec, Boolean)");
        }
    }

    public void setInstrumentationLevel(MBeanLevelSpec[] mBeanLevelSpecArray, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInstrumentationLevel (MBeanLevelSpec[], Boolean)");
        }
        if (mBeanLevelSpecArray == null || mBeanLevelSpecArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MBeanLevelSpec is null or empty");
            }
            return;
        }
        PmiRegistry.setMBeanLevel(mBeanLevelSpecArray, (boolean)bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInstrumentationLevel (MBeanLevelSpec[], Boolean)");
        }
    }

    public void setInstrumentationLevel(StatLevelSpec[] statLevelSpecArray, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInstrumentationLevel (StatLevelSpec[], Boolean)");
        }
        if (statLevelSpecArray == null || statLevelSpecArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StatLevelSpec is null or empty");
            }
            return;
        }
        PmiRegistry.setInstrumentationLevel(statLevelSpecArray, (boolean)bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInstrumentationLevel (StatLevelSpec[], Boolean)");
        }
    }

    public void appendInstrumentationLevel(StatLevelSpec[] statLevelSpecArray, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appendInstrumentationLevel (StatLevelSpec[], Boolean)");
        }
        if (statLevelSpecArray == null || statLevelSpecArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StatLevelSpec is null or empty");
            }
            return;
        }
        PmiRegistry.appendInstrumentationLevel(statLevelSpecArray, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appendInstrumentationLevel (StatLevelSpec[], Boolean)");
        }
    }

    public MBeanLevelSpec[] getInstrumentationLevel(ObjectName objectName, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstrumentationLevel (ObjectName, Boolean");
        }
        if (objectName == null) {
            return null;
        }
        MBeanLevelSpec[] mBeanLevelSpecArray = PmiRegistry.getMBeanLevelSpecs(objectName, null, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstrumentationLevel (ObjectName, Boolean");
        }
        return mBeanLevelSpecArray;
    }

    public StatLevelSpec[] getInstrumentationLevel(StatDescriptor statDescriptor, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstrumentationLevel (StatDescriptor, Boolean)");
        }
        if (statDescriptor == null) {
            return null;
        }
        StatLevelSpec[] statLevelSpecArray = PmiRegistry.getInstrumentationLevel(statDescriptor, (boolean)bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstrumentationLevel (StatDescriptor, Boolean)");
        }
        return statLevelSpecArray;
    }

    public MBeanLevelSpec[] getInstrumentationLevel(MBeanStatDescriptor mBeanStatDescriptor, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstrumentationLevel (MBeanStatDescriptor, Boolean)");
        }
        if (mBeanStatDescriptor == null || mBeanStatDescriptor.getObjectName() == null) {
            return null;
        }
        MBeanLevelSpec[] mBeanLevelSpecArray = PmiRegistry.getMBeanLevelSpecs(mBeanStatDescriptor.getObjectName(), mBeanStatDescriptor.getStatDescriptor(), bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstrumentationLevel (MBeanStatDescriptor, Boolean)");
        }
        return mBeanLevelSpecArray;
    }

    public PmiModuleConfig[] getConfigs() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigs");
        }
        PmiModuleConfig[] pmiModuleConfigArray = PmiRegistry.getConfigs();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigs");
        }
        return pmiModuleConfigArray;
    }

    public PmiModuleConfig[] getConfigs(Locale locale) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigs (Locale)");
        }
        PmiModuleConfig[] pmiModuleConfigArray = PmiRegistry.getConfigs(locale);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigs (Locale)");
        }
        return pmiModuleConfigArray;
    }

    public PmiModuleConfig getConfig(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigs (statsType)");
        }
        PmiModuleConfig pmiModuleConfig = PmiRegistry.getConfig(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigs (statsType)");
        }
        return pmiModuleConfig;
    }

    public PmiModuleConfig getConfig(ObjectName objectName) {
        PmiConstants pmiConstants;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigs (ObjectName)");
        }
        if (objectName == null) {
            return null;
        }
        String string = PmiRegistry.jmxMapper.getPmiModuleName(objectName);
        if (string == null && (pmiConstants = PmiRegistry.findModuleItem(objectName)) != null) {
            string = ((ModuleItem)pmiConstants).getInstance().getModuleID();
        }
        pmiConstants = PmiRegistry.getConfig(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigs (ObjectName)");
        }
        return pmiConstants;
    }

    public String getInstrumentationLevelString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstrumentationLevelString");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstrumentationLevelString");
        }
        return PmiRegistry.getInstrumentationLevelString();
    }

    public void setInstrumentationLevel(String string, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInstrumentationLevel (String, Boolean): " + string);
        }
        PerfLevelDescriptor[] perfLevelDescriptorArray = PmiUtil.getPerfLevelSpecsFromString(string);
        PmiRegistry.setInstrumentationLevel(perfLevelDescriptorArray, (boolean)bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInstrumentationLevel (String, Boolean)");
        }
    }

    public String getStatsString(ObjectName objectName, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsString (ObjectName, Boolean)");
        }
        StatsImpl statsImpl = (StatsImpl)this.getStatsObject(objectName, bl);
        String string = null;
        if (statsImpl != null) {
            DataDescriptor dataDescriptor = PmiRegistry.mBeanToDataDescriptor(new MBeanStatDescriptor(objectName, null));
            string = StatsHelper.statsToTclAttrString(statsImpl, dataDescriptor, PmiRegistry.nodeName, PmiRegistry.serverName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsString (ObjectName, Boolean)");
        }
        return string;
    }

    public String getStatsString(ObjectName objectName, String string, Boolean bl) {
        StatDescriptor statDescriptor = new StatDescriptor(new String[]{string});
        MBeanStatDescriptor mBeanStatDescriptor = new MBeanStatDescriptor(objectName, statDescriptor);
        StatsImpl statsImpl = (StatsImpl)this.getStatsObject(mBeanStatDescriptor, bl);
        if (statsImpl == null) {
            return null;
        }
        DataDescriptor dataDescriptor = PmiRegistry.mBeanToDataDescriptor(new MBeanStatDescriptor(objectName, statDescriptor));
        return StatsHelper.statsToTclAttrString(statsImpl, dataDescriptor, PmiRegistry.nodeName, PmiRegistry.serverName);
    }

    public String listStatMemberNames(ObjectName objectName) {
        MBeanStatDescriptor[] mBeanStatDescriptorArray;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "listStatMemberNames (ObjectName): " + objectName.toString());
        }
        if ((mBeanStatDescriptorArray = this.listStatMembers(objectName)) == null || mBeanStatDescriptorArray.length == 0) {
            return "";
        }
        String string = "";
        boolean bl = true;
        for (int i = 0; i < mBeanStatDescriptorArray.length; ++i) {
            if (mBeanStatDescriptorArray[i] == null || mBeanStatDescriptorArray[i].getStatDescriptor() == null) continue;
            if (bl) {
                bl = false;
                string = mBeanStatDescriptorArray[i].getStatDescriptor().getName();
                continue;
            }
            string = string + " " + mBeanStatDescriptorArray[i].getStatDescriptor().getName();
        }
        return string;
    }

    public WSStats getStatsObject(DataDescriptor dataDescriptor, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsObject(DataDescriptor, Boolean)");
        }
        StatsImpl statsImpl = PmiRegistry.getStats(dataDescriptor, (boolean)bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsObject(DataDescriptor)");
        }
        return statsImpl;
    }

    public WSStats[] getStatsArray(DataDescriptor[] dataDescriptorArray, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsArray(DataDescriptor[], Boolean)");
        }
        if (dataDescriptorArray == null || dataDescriptorArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatsArray - null ObjectName");
            }
            return null;
        }
        WSStats[] wSStatsArray = PmiRegistry.getStats(dataDescriptorArray, (boolean)bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsArray(DataDescriptor)" + wSStatsArray.length);
        }
        return wSStatsArray;
    }

    public DataDescriptor[] listStatMembers(DataDescriptor dataDescriptor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listStatMembers(DataDescriptor)");
        }
        DataDescriptor[] dataDescriptorArray = PmiRegistry.listMembers(dataDescriptor);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listStatMembers(DataDescriptor)");
        }
        return dataDescriptorArray;
    }

    public void setInstrumentationLevel(PerfLevelDescriptor perfLevelDescriptor, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInstrumentationLevel(PerfLevelDescriptor, Boolean)");
        }
        PmiRegistry.setInstrumentationLevel(perfLevelDescriptor, (boolean)bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInstrumentationLevel(PerfLevelDescriptor)");
        }
    }

    public void setInstrumentationLevel(PerfLevelDescriptor[] perfLevelDescriptorArray, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInstrumentationLevel(PerfLevelDescriptor[], Boolean)");
        }
        PmiRegistry.setInstrumentationLevel(perfLevelDescriptorArray, (boolean)bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInstrumentationLevel(PerfLevelDescriptor)");
        }
    }

    public PerfLevelDescriptor[] getInstrumentationLevel(DataDescriptor dataDescriptor, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstrumentationLevel(DataDescriptor, Boolean)");
        }
        if (dataDescriptor == null) {
            return null;
        }
        PerfLevelDescriptor[] perfLevelDescriptorArray = PmiRegistry.getInstrumentationLevel(dataDescriptor, (boolean)bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstrumentationLevel(DataDescriptor)");
        }
        return perfLevelDescriptorArray;
    }

    public void setMBeanState(Serializable serializable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMBeanState - updating PMI service with PMIServiceState");
        }
        if (serializable == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PMI state object is null");
            }
        } else if (serializable instanceof PMIServiceState) {
            PMIServiceState pMIServiceState = (PMIServiceState)serializable;
            PMIImpl.updateRuntimeWithStateObject(pMIServiceState);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invalid PMI state object type: " + serializable.getClass().getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMBeanState");
        }
    }
}

