/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.models.config.pmiservice.PMIModule;
import com.ibm.websphere.models.config.pmiservice.impl.PmiserviceFactoryImpl;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.ws.pmi.component.PMIImpl;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.server.RtPMIModule;
import com.ibm.ws.pmi.stat.StatsConfigHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class PmiConfigManager
implements PmiConstants {
    private static TraceComponent tc = Tr.register(PmiConfigManager.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private static final int NOT_OLD_SPEC = -9999;
    private static PMIModule serverPMIModule;
    private static ConfigRepository _cfgRepo;

    public static void init(PMIModule pMIModule) {
        serverPMIModule = pMIModule;
    }

    public static void initSpec(Resource resource) {
        serverPMIModule = (PMIModule)resource.getContents().get(0);
    }

    public static void initSpec(String string) {
        serverPMIModule = PmiConfigManager.createPMIModule("pmi", "", "", "");
        PerfLevelDescriptor[] perfLevelDescriptorArray = PmiUtil.getPerfLevelSpecsFromString(string);
        if (perfLevelDescriptorArray != null) {
            for (int i = 0; i < perfLevelDescriptorArray.length; ++i) {
                PmiConfigManager.updateSpec(perfLevelDescriptorArray[i].getPath(), perfLevelDescriptorArray[i].getWCCMType(), perfLevelDescriptorArray[i].getLevel(), false, false);
            }
        }
    }

    public static boolean isInitialized() {
        return serverPMIModule != null;
    }

    public static PMIModule getServerPMIModule() {
        return serverPMIModule;
    }

    public static int[][] getSpec(String[] stringArray) {
        if (serverPMIModule == null) {
            return null;
        }
        List list = PmiConfigManager.getModule(stringArray, true);
        PMIModule pMIModule = null;
        if (list.size() <= 0) {
            return null;
        }
        pMIModule = (PMIModule)list.get(0);
        int n = PmiConfigManager.getOldSpec(pMIModule);
        int[] nArray = null;
        int[] nArray2 = null;
        int[] nArray3 = new int[]{};
        if (n == -9999) {
            nArray2 = PmiConfigManager.parseSpecStr(pMIModule.getEnable());
        } else {
            nArray = new int[]{n};
        }
        return new int[][]{nArray, nArray2, nArray3};
    }

    public static void updateSpec(String[] stringArray, String string, int[] nArray, int[] nArray2, boolean bl, boolean bl2) {
        List list = PmiConfigManager.getModule(stringArray, false);
        boolean bl3 = false;
        PMIModule pMIModule = null;
        String string2 = PmiConfigManager.buildSpecStr(nArray);
        String string3 = PmiConfigManager.buildSpecStr(nArray2);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                pMIModule = (PMIModule)list.get(i);
                PmiConfigManager.updateSpec(pMIModule, string, string2, string3, bl);
                if (!pMIModule.getModuleName().equals("*")) continue;
                bl3 = true;
            }
        } else {
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            pMIModule = PmiConfigManager.createPMIModule(stringArray[stringArray.length - 1], string, string2, string3);
            PmiConfigManager.insertModule(pMIModule, stringArray);
            if (pMIModule.getModuleName().equals("*")) {
                bl3 = true;
            }
        }
        if (bl2 && stringArray[stringArray.length - 1].equals("*") && !bl3) {
            PMIModule pMIModule2 = PmiConfigManager.createPMIModule("*", string, string2, string3);
            PmiConfigManager.insertModule(pMIModule2, stringArray);
        }
    }

    public static void updateSpec(String[] stringArray, String string, int n, boolean bl, boolean bl2) {
        List list = PmiConfigManager.getModule(stringArray, false);
        boolean bl3 = false;
        PMIModule pMIModule = null;
        String string2 = PmiConfigManager.getLevelString(n);
        String string3 = "";
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                pMIModule = (PMIModule)list.get(i);
                PmiConfigManager.updateSpec(pMIModule, string, n, bl);
                if (!pMIModule.getModuleName().equals("*")) continue;
                bl3 = true;
            }
        } else {
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            pMIModule = PmiConfigManager.createPMIModule(stringArray[stringArray.length - 1], string, string2, string3);
            PmiConfigManager.insertModule(pMIModule, stringArray);
        }
        if (bl2 && stringArray[stringArray.length - 1].equals("*") && !bl3) {
            PMIModule pMIModule2 = PmiConfigManager.createPMIModule("*", string, string2, string3);
            PmiConfigManager.insertModule(pMIModule2, stringArray);
        }
    }

    public static boolean saveSpec() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "saveSpec");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processing customized PMI settings");
        }
        if (serverPMIModule == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loading PMI settings from pmi-config.xml");
            }
            if (!PMIImpl.initSpecFromPmiConfigDocument()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pmi-config.xml not found");
                }
                serverPMIModule = PmiConfigManager.createPMIModule("pmi", "", "", "");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updating config with current runtime spec");
        }
        ModuleItem moduleItem = PmiRegistry.findModuleItem(new String[]{"pmi"});
        PmiConfigManager.updateWithRuntimeSpec(moduleItem);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "COMPRESSING DISABLED.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "persisting config in pmi-config.xml");
        }
        PmiConfigManager.persistConfig();
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "saveSpec");
        }
        return true;
    }

    public static List getModule(String[] stringArray, boolean bl) {
        if (stringArray.length > 0 && stringArray[0].equals(serverPMIModule.getModuleName())) {
            return PmiConfigManager.getModule(stringArray, serverPMIModule, 1, bl);
        }
        return PmiConfigManager.getModule(stringArray, serverPMIModule, 0, bl);
    }

    public static List getModule(String[] stringArray, PMIModule pMIModule, int n, boolean bl) {
        ArrayList<PMIModule> arrayList = new ArrayList<PMIModule>();
        if (n == stringArray.length) {
            arrayList.add(pMIModule);
            return arrayList;
        }
        EList eList = pMIModule.getPmimodules();
        int n2 = -1;
        for (int i = 0; i < eList.size(); ++i) {
            String string = ((PMIModule)eList.get(i)).getModuleName();
            if (stringArray[n].equals("*") || string.equals(stringArray[n])) {
                arrayList.addAll(PmiConfigManager.getModule(stringArray, (PMIModule)eList.get(i), n + 1, bl));
            }
            if (!string.equals("*")) continue;
            n2 = i;
        }
        if (bl && n2 != -1) {
            arrayList.addAll(PmiConfigManager.getModule(stringArray, (PMIModule)eList.get(n2), n + 1, bl));
        }
        return arrayList;
    }

    private static void updateSpec(PMIModule pMIModule, String string, String string2, String string3, boolean bl) {
        pMIModule.setEnable(string2);
        if (pMIModule.getType() == null) {
            pMIModule.setType(string);
        }
        if (bl) {
            EList eList = pMIModule.getPmimodules();
            for (int i = 0; i < eList.size(); ++i) {
                PmiConfigManager.updateSpec((PMIModule)eList.get(i), string, string2, string3, bl);
            }
        }
    }

    public static String getLevelString(int n) {
        switch (n) {
            case 0: {
                return "N";
            }
            case 1: {
                return "L";
            }
            case 3: {
                return "M";
            }
            case 7: {
                return "H";
            }
            case 15: {
                return "X";
            }
        }
        return "";
    }

    public static int getLevel(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equals("low")) {
            return 1;
        }
        if (string.equals("none")) {
            return 0;
        }
        if (string.equals("medium")) {
            return 3;
        }
        if (string.equals("high")) {
            return 7;
        }
        if (string.equals("maximum")) {
            return 15;
        }
        return -1;
    }

    public static boolean isV5Spec(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.length() == 1 && (string.equals("X") || string.equals("H") || string.equals("M") || string.equals("L") || string.equals("N"));
    }

    private static void updateSpec(PMIModule pMIModule, String string, int n, boolean bl) {
        String string2 = PmiConfigManager.getLevelString(n);
        pMIModule.setEnable(string2);
        if (pMIModule.getType() == null) {
            pMIModule.setType(string);
        }
        if (bl) {
            EList eList = pMIModule.getPmimodules();
            for (int i = 0; i < eList.size(); ++i) {
                PmiConfigManager.updateSpec((PMIModule)eList.get(i), string, n, bl);
            }
        }
    }

    public static boolean isBeanMethodDisabled() {
        return false;
    }

    public static int[] parseSpecStr(String string) {
        if (string == null) {
            return new int[0];
        }
        string = string.replaceAll(" ", "");
        if ((string = string.trim()).length() == 0) {
            return new int[0];
        }
        String[] stringArray = string.split(",");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[i] = stringArray[i].equals("*") && i == 0 ? -3 : -1;
            }
        }
        return nArray;
    }

    public static int[] parseSpecStr(String string, String string2) {
        if (PmiConfigManager.isV5Spec(string2)) {
            PmiModuleConfig pmiModuleConfig = StatsConfigHelper.getStatsConfig(string);
            if (pmiModuleConfig != null) {
                PmiDataInfo[] pmiDataInfoArray = pmiModuleConfig.listLevelData(PmiConfigManager.getLevel(string2));
                int n = pmiDataInfoArray.length;
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = pmiDataInfoArray[i].getId();
                }
                return nArray;
            }
            return new int[0];
        }
        return PmiConfigManager.parseSpecStr(string2);
    }

    private static int getOldSpec(PMIModule pMIModule) {
        String string = pMIModule.getEnable();
        if (string.length() == 1) {
            char c = string.charAt(0);
            switch (c) {
                case 'N': {
                    return 0;
                }
                case 'L': {
                    return 1;
                }
                case 'M': {
                    return 3;
                }
                case 'H': {
                    return 7;
                }
                case 'X': {
                    return 15;
                }
            }
            return -9999;
        }
        return -9999;
    }

    public static String buildSpecStr(int[] nArray) {
        if (nArray.length == 1 && nArray[0] == -3) {
            return "*";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            if (i == nArray.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private static void insertModule(PMIModule pMIModule, String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].equals(serverPMIModule.getModuleName())) {
            PmiConfigManager.insertModule(pMIModule, stringArray, 1, serverPMIModule);
        } else {
            PmiConfigManager.insertModule(pMIModule, stringArray, 0, serverPMIModule);
        }
    }

    private static void insertModule(PMIModule pMIModule, String[] stringArray, int n, PMIModule pMIModule2) {
        List list;
        if (n == stringArray.length - 1 && (list = PmiConfigManager.hasChild(pMIModule2, stringArray[n], false)).size() == 0) {
            pMIModule2.getPmimodules().add((Object)pMIModule);
            return;
        }
        list = PmiConfigManager.hasChild(pMIModule2, stringArray[n], true);
        PMIModule pMIModule3 = null;
        if (list.size() == 0) {
            String[] stringArray2 = new String[n + 1];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = stringArray[i];
            }
            String string = null;
            if (PmiRegistry.isDisabled()) {
                string = new PerfLevelDescriptor(stringArray2, 0).getWCCMType();
            } else {
                ModuleItem moduleItem = PmiRegistry.findModuleItem(stringArray2);
                if (moduleItem != null && moduleItem.getInstance() != null) {
                    string = moduleItem.getInstance().getWCCMStatsType();
                }
            }
            if (string == null) {
                string = pMIModule2.getType();
            }
            pMIModule3 = PmiConfigManager.createPMIModule(stringArray[n], string, "", "");
            pMIModule2.getPmimodules().add((Object)pMIModule3);
            PmiConfigManager.insertModule(pMIModule, stringArray, n + 1, pMIModule3);
        } else {
            for (int i = 0; i < list.size(); ++i) {
                pMIModule3 = (PMIModule)list.get(i);
                if (i > 0) {
                    pMIModule = PmiConfigManager.createPMIModule(pMIModule.getModuleName(), pMIModule.getType(), pMIModule.getEnable(), "");
                }
                PmiConfigManager.insertModule(pMIModule, stringArray, n + 1, pMIModule3);
            }
        }
    }

    private static PMIModule createPMIModule(String string, String string2, String string3, String string4) {
        PMIModule pMIModule = PmiserviceFactoryImpl.eINSTANCE.createPMIModule();
        pMIModule.setModuleName(string);
        pMIModule.setType(string2);
        pMIModule.setEnable(string3);
        return pMIModule;
    }

    public static String[] parsePath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ">");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static void printSpecTree() {
        System.out.println("**** fine grained spec ****");
        PmiConfigManager._print(serverPMIModule, 1);
        System.out.println();
    }

    public static void printSpecTree(PMIModule pMIModule) {
        System.out.println("[PmiConfigManager] printing spec");
        PmiConfigManager._print(pMIModule, 1);
        System.out.println();
    }

    private static void _print(PMIModule pMIModule, int n) {
        if (pMIModule == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append("moduleName=").append(pMIModule.getModuleName());
        stringBuffer.append("; type=").append(pMIModule.getType());
        stringBuffer.append("; enable=").append(pMIModule.getEnable());
        System.out.println(stringBuffer.toString());
        EList eList = pMIModule.getPmimodules();
        if (eList == null) {
            return;
        }
        int n2 = eList.size();
        ++n;
        for (int i = 0; i < n2; ++i) {
            PmiConfigManager._print((PMIModule)eList.get(i), n);
        }
    }

    private static List hasChild(PMIModule pMIModule, String string, boolean bl) {
        EList eList = pMIModule.getPmimodules();
        if (bl && string.equals("*")) {
            return eList;
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < eList.size(); ++i) {
            String string2 = ((PMIModule)eList.get(i)).getModuleName();
            if (!string2.equals(string)) continue;
            arrayList.add(eList.get(i));
            return arrayList;
        }
        return arrayList;
    }

    private static void clear(PMIModule pMIModule) {
        pMIModule.setEnable("");
        EList eList = pMIModule.getPmimodules();
        if (eList.size() == 0) {
            return;
        }
        for (int i = 0; i < eList.size(); ++i) {
            PmiConfigManager.clear((PMIModule)eList.get(i));
        }
    }

    public static void removeModules(String[] stringArray, boolean bl) {
        List list = PmiConfigManager.getModule(stringArray, bl);
        for (int i = 0; i < list.size(); ++i) {
            PMIModule pMIModule = (PMIModule)list.get(i);
            PMIModule pMIModule2 = (PMIModule)pMIModule.eContainer();
            if (!pMIModule2.getPmimodules().contains((Object)pMIModule)) continue;
            pMIModule2.getPmimodules().remove((Object)pMIModule);
        }
    }

    public static synchronized ConfigRepository getCfgRepo() {
        if (_cfgRepo != null) {
            return _cfgRepo;
        }
        try {
            Properties properties = new Properties();
            properties.setProperty("location", "local");
            _cfgRepo = ConfigRepositoryClientFactory.getConfigRepositoryClient(properties);
            return _cfgRepo;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static RtPMIModule convertToRt(PMIModule pMIModule) {
        RtPMIModule rtPMIModule = new RtPMIModule();
        rtPMIModule.setModuleName(pMIModule.getModuleName());
        rtPMIModule.setType(pMIModule.getType());
        rtPMIModule.setEnable(pMIModule.getEnable());
        ArrayList<RtPMIModule> arrayList = new ArrayList<RtPMIModule>();
        for (int i = 0; i < pMIModule.getPmimodules().size(); ++i) {
            arrayList.add(PmiConfigManager.convertToRt((PMIModule)pMIModule.getPmimodules().get(i)));
        }
        rtPMIModule.setPmimodules(arrayList);
        return rtPMIModule;
    }

    public static RtPMIModule getRuntimePMISpec() {
        ModuleItem moduleItem = PmiRegistry.findModuleItem(new String[]{"pmi"});
        if (moduleItem != null) {
            return PmiConfigManager.createRtSpec(moduleItem);
        }
        return null;
    }

    public static boolean isValidStatisticSet(String string) {
        return string.equals("none") || string.equals("basic") || string.equals("extended") || string.equals("all");
    }

    private static void updateWithRuntimeSpec(ModuleItem moduleItem) {
        ModuleItem[] moduleItemArray;
        if (moduleItem != null && (moduleItemArray = moduleItem.children()) != null) {
            for (int i = 0; i < moduleItemArray.length; ++i) {
                PmiAbstractModule pmiAbstractModule = (PmiAbstractModule)moduleItemArray[i].getInstance();
                if (pmiAbstractModule == null) continue;
                if (pmiAbstractModule.getInstrumentationLevel() == -2) {
                    PmiConfigManager.updateSpec(pmiAbstractModule.getPath(), pmiAbstractModule.getWCCMStatsType(), pmiAbstractModule.getEnabled(), pmiAbstractModule.getEnabledSync(), false, false);
                } else {
                    PmiConfigManager.updateSpec(pmiAbstractModule.getPath(), pmiAbstractModule.getWCCMStatsType(), pmiAbstractModule.getInstrumentationLevel(), false, false);
                }
                PmiConfigManager.updateWithRuntimeSpec(moduleItemArray[i]);
            }
        }
    }

    private static RtPMIModule createRtSpec(ModuleItem moduleItem) {
        RtPMIModule rtPMIModule = new RtPMIModule();
        PmiAbstractModule pmiAbstractModule = (PmiAbstractModule)moduleItem.getInstance();
        if (pmiAbstractModule == null) {
            rtPMIModule.setModuleName("pmi");
            rtPMIModule.setType("");
            rtPMIModule.setEnable("");
            rtPMIModule.setEnableSync("");
        } else {
            rtPMIModule.setModuleName(pmiAbstractModule.getName());
            rtPMIModule.setType(pmiAbstractModule.getWCCMStatsType());
            rtPMIModule.setEnable(PmiConfigManager.buildSpecStr(pmiAbstractModule.getEnabled()));
            rtPMIModule.setEnableSync("");
        }
        ArrayList<RtPMIModule> arrayList = new ArrayList<RtPMIModule>();
        ModuleItem[] moduleItemArray = moduleItem.children();
        if (moduleItemArray != null) {
            for (int i = 0; i < moduleItemArray.length; ++i) {
                arrayList.add(PmiConfigManager.createRtSpec(moduleItemArray[i]));
            }
        }
        rtPMIModule.setPmimodules(arrayList);
        return rtPMIModule;
    }

    private static void compress(PMIModule pMIModule) {
        EList eList = pMIModule.getPmimodules();
        if (eList != null) {
            int n = eList.size();
            for (int i = n - 1; i >= 0; --i) {
                EList eList2;
                PMIModule pMIModule2 = (PMIModule)eList.get(i);
                if (pMIModule2.getPmimodules() != null) {
                    PmiConfigManager.compress(pMIModule2);
                }
                if (pMIModule.getModuleName().equals("pmi") || (eList2 = pMIModule2.getPmimodules()) == null || eList2.size() != 0 || !pMIModule.getEnable().equals(pMIModule2.getEnable())) continue;
                eList.remove(i);
            }
        }
    }

    private boolean isCompressable(PMIModule pMIModule) {
        return false;
    }

    private static void persistConfig() {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "persistConfig");
        }
        ConfigService configService = null;
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService.getProcessType().equals("UnManagedProcess")) {
            configService = ConfigServiceFactory.getConfigService();
        } else {
            try {
                object = adminService.getDeploymentManagerAdminClient();
                configService = new ConfigServiceProxy((AdminClient)object);
            }
            catch (Exception exception) {
                Tr.warning(tc, "PMI9999E", exception);
            }
        }
        if (configService != null) {
            try {
                ObjectName objectName;
                ObjectName[] objectNameArray;
                object = new String(adminService.getNodeName() + adminService.getProcessName());
                Session session = new Session("PmiCM" + Integer.toHexString(((String)object).hashCode()) + "_", false);
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Node", adminService.getNodeName());
                ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, null, objectName2, null);
                if (objectNameArray2 != null && objectNameArray2.length == 1 && (objectNameArray = configService.queryConfigObjects(session, objectNameArray2[0], objectName = ConfigServiceHelper.createObjectName(null, "Server", adminService.getProcessName()), null)) != null && objectNameArray.length == 1) {
                    AttributeList attributeList;
                    ObjectName objectName3;
                    ObjectName[] objectNameArray3;
                    if (PMIImpl.isSpecUpdated() && (objectNameArray3 = configService.queryConfigObjects(session, objectNameArray[0], objectName3 = ConfigServiceHelper.createObjectName(null, "PMIService", null), null)) != null && objectNameArray3.length == 1) {
                        attributeList = new AttributeList();
                        attributeList.add(new Attribute("initialSpecLevel", ""));
                        attributeList.add(new Attribute("synchronizedUpdate", new Boolean(PMIImpl.getSynchronizedUpdate())));
                        attributeList.add(new Attribute("statisticSet", PMIImpl.getStatisticSet()));
                        configService.setAttributes(session, objectNameArray3[0], attributeList);
                    }
                    if ((objectNameArray3 = configService.queryConfigObjects(session, objectNameArray[0], objectName3 = ConfigServiceHelper.createObjectName(null, "PMIModule", null), null)) != null && objectNameArray3.length == 1) {
                        configService.deleteConfigData(session, objectNameArray3[0]);
                        attributeList = new AttributeList();
                        attributeList.add(new Attribute("moduleName", "pmi"));
                        attributeList.add(new Attribute("type", ""));
                        attributeList.add(new Attribute("enable", ""));
                        ObjectName objectName4 = configService.createConfigData(session, objectNameArray[0], "PMIModule", "PMIModule", attributeList);
                        int n = serverPMIModule.getPmimodules().size();
                        for (int i = 0; i < n; ++i) {
                            PmiConfigManager.persistOnePmiModule((PMIModule)serverPMIModule.getPmimodules().get(i), session, configService, objectName4);
                        }
                    }
                    configService.save(session, false);
                    configService.discard(session);
                }
            }
            catch (Exception exception) {
                Tr.warning(tc, "PMI0027W", exception);
            }
        } else {
            Tr.warning(tc, "PMI0028W");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "persistConfig");
        }
    }

    private static void persistOnePmiModule(PMIModule pMIModule, Session session, ConfigService configService, ObjectName objectName) throws Exception {
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("moduleName", pMIModule.getModuleName()));
        attributeList.add(new Attribute("type", pMIModule.getType()));
        attributeList.add(new Attribute("enable", pMIModule.getEnable()));
        ObjectName objectName2 = configService.createConfigData(session, objectName, "pmimodules", "PMIModule", attributeList);
        for (int i = 0; i < pMIModule.getPmimodules().size(); ++i) {
            PmiConfigManager.persistOnePmiModule((PMIModule)pMIModule.getPmimodules().get(i), session, configService, objectName2);
        }
    }

    public static void updateSpec(String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            int[] nArray;
            String[] stringArray;
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
            try {
                stringArray = PmiConfigManager.parsePath(stringTokenizer2.nextToken());
            }
            catch (Exception exception) {
                continue;
            }
            try {
                nArray = PmiConfigManager.parseSpecStr(stringTokenizer2.nextToken());
            }
            catch (Exception exception) {
                nArray = new int[]{};
            }
            PmiConfigManager.updateSpec(stringArray, null, nArray, new int[0], false, false);
        }
    }

    public static void updateSpec(PMIModule pMIModule, String[] stringArray) {
        int[] nArray;
        String[] stringArray2;
        if (stringArray == null || stringArray.length == 0) {
            stringArray2 = new String[1];
        } else {
            stringArray2 = new String[stringArray.length + 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i];
            }
        }
        stringArray2[stringArray2.length - 1] = pMIModule.getModuleName();
        try {
            nArray = PmiConfigManager.parseSpecStr(pMIModule.getEnable());
        }
        catch (Exception exception) {
            nArray = new int[]{};
        }
        PmiConfigManager.updateSpec(stringArray2, pMIModule.getType(), nArray, new int[0], false, false);
        EList eList = pMIModule.getPmimodules();
        for (int i = 0; i < eList.size(); ++i) {
            PMIModule pMIModule2 = (PMIModule)eList.get(i);
            PmiConfigManager.updateSpec(pMIModule2, stringArray2);
        }
    }
}

