/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.CachePerf;
import com.ibm.websphere.pmi.ConnPoolPerf;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.ServletSessionsPerf;
import com.ibm.websphere.pmi.ThreadPoolPerf;
import com.ibm.websphere.pmi.WLMPerf;
import com.ibm.websphere.pmi.WebServicesPerf;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.server.PmiModuleGenericImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiCallback;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.modules.CachePerfModule;
import com.ibm.ws.pmi.server.modules.ConnPoolModule;
import com.ibm.ws.pmi.server.modules.J2CModule;
import com.ibm.ws.pmi.server.modules.ResourcePmiModule;
import com.ibm.ws.pmi.server.modules.RuntimeModule;
import com.ibm.ws.pmi.server.modules.ServletSessionsModule;
import com.ibm.ws.pmi.server.modules.SystemModule;
import com.ibm.ws.pmi.server.modules.ThreadPoolModule;
import com.ibm.ws.pmi.server.modules.WLMModule;
import com.ibm.ws.pmi.server.modules.WSGWModule;
import com.ibm.ws.pmi.server.modules.WebServicesModule;
import com.ibm.ws390.sm.smf.SmfServletSessionsModule;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.ObjectName;

public class PmiFactory
implements PmiConstants {
    private static HashMap webAppMap = new HashMap();
    private static HashMap webServicesMap = new HashMap();
    private static final TraceComponent tc = Tr.register(PmiFactory.class, null, "com.ibm.ws.pmi.properties.PMIMessages");

    public static PmiModule createPmiModule(String string) {
        return PmiFactory.createPmiModule(string, (ArrayList)null);
    }

    public static PmiModule createPmiModule(String string, String string2) {
        if (string2 == null) {
            return PmiFactory.createPmiModule(string, (ArrayList)null);
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string2);
        return PmiFactory.createPmiModule(string, arrayList);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static PmiModule createPmiModule(String string, ArrayList arrayList) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        if (string == null) {
            Tr.warning(tc, "PMI0013W", "createPmiModule");
            return null;
        }
        Object object = null;
        String string2 = null;
        if (arrayList != null && arrayList.size() > 0 && arrayList.get(0) instanceof String) {
            string2 = (String)arrayList.get(0);
        }
        if (string.equals("threadPoolModule")) {
            if (string2 != null && arrayList.size() == 3) {
                int n = (Integer)arrayList.get(1);
                int n2 = (Integer)arrayList.get(2);
                object = PmiFactory.createThreadPoolPerf(string2, n, n2, null);
                return (PmiModule)object;
            }
            Tr.warning(tc, "PMI0012W", "createPmiModule.threadPool");
            return (PmiModule)object;
        }
        if (string.equals("connectionPoolModule")) {
            if (string2 == null) {
                Tr.warning(tc, "PMI0012W", "createPmiModule.connectionPool");
                return (PmiModule)object;
            }
            object = PmiFactory.createConnPoolPerf(string2, null, null, null);
            return (PmiModule)object;
        }
        if (string.equals("j2cModule")) {
            if (string2 == null) {
                Tr.warning(tc, "PMI0012W", "createPmiModule.j2c");
                return (PmiModule)object;
            }
            object = PmiFactory.createJ2CPerf(string2, null, null, null);
            return (PmiModule)object;
        }
        if (string.equals("jvmRuntimeModule")) {
            object = PmiFactory.createJvmPerf(-1, -1);
            return (PmiModule)object;
        }
        if (string.equals("servletSessionsModule")) {
            object = PmiFactory.createServletSessionsPerf();
            return (PmiModule)object;
        }
        if (string.equals("transactionModule")) {
            if (arrayList != null && arrayList.size() == 1) {
                object = PmiFactory.createTransactionPerf(arrayList.get(0), null);
                return (PmiModule)object;
            }
            Tr.warning(tc, "PMI0012W", "createPmiModule.JTA");
            return null;
        }
        if (string.equals("webServicesModule")) {
            if (arrayList == null || arrayList.size() != 2) {
                Tr.warning(tc, "PMI0012W", "createPmiModule.webservices");
                return null;
            }
            if (arrayList.get(0) instanceof String && arrayList.get(1) instanceof String) {
                object = PmiFactory.createWebServicesPerf((String)arrayList.get(0), (String)arrayList.get(1));
                return (PmiModule)object;
            }
            Tr.warning(tc, "PMI0013W", "createPmiModule.webservices");
            return null;
        }
        if (string.equals("wlmModule")) {
            if (arrayList != null && arrayList.size() == 1) {
                object = PmiFactory.createWLMPerf((String)arrayList.get(0));
                return (PmiModule)object;
            }
            Tr.warning(tc, "PMI0012W", "createPmiModule.WLM");
            return null;
        }
        if (!string.equals("wsgwModule")) {
            object = new PmiModuleGenericImpl(string, string2);
            return (PmiModule)object;
        }
        if (arrayList != null && arrayList.size() == 1) {
            object = PmiFactory.createWSGWPerf((String)arrayList.get(0));
            return (PmiModule)object;
        }
        Tr.warning(tc, "PMI0012W", "createPmiModule.webservices");
        return null;
    }

    public static ThreadPoolPerf createThreadPoolPerf(String string, int n, int n2) {
        return PmiFactory.createThreadPoolPerf(string, n, n2, null);
    }

    public static ThreadPoolPerf createThreadPoolPerf(String string, int n, int n2, PmiCallback pmiCallback) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        return new ThreadPoolModule(string, n, n2, pmiCallback);
    }

    public static ConnPoolPerf createConnPoolPerf(String string, ObjectName objectName, ObjectName objectName2) {
        return PmiFactory.createConnPoolPerf(string, null, objectName, objectName2);
    }

    public static ConnPoolPerf createConnPoolPerf(String string, PmiCallback pmiCallback, ObjectName objectName, ObjectName objectName2) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        return new ConnPoolModule(string, objectName, objectName2);
    }

    public static SystemModule createSystemPerf(String string) {
        return PmiFactory.createSystemPerf(string, null);
    }

    public static SystemModule createSystemPerf(String string, PmiCallback pmiCallback) {
        if (!PmiRegistry.isDisabled()) {
            return new SystemModule(string);
        }
        return null;
    }

    public static void initJ2CPerf(ObjectName objectName) {
        if (PmiRegistry.isDisabled()) {
            return;
        }
        String string = objectName.getKeyProperty("name");
        String string2 = "J2CResourceAdapter";
        if (objectName != null) {
            string2 = objectName.getKeyProperty("type");
        }
        if (string2.equals("JDBCProvider")) {
            new ResourcePmiModule("connectionPoolModule", string, objectName);
        } else {
            new ResourcePmiModule("j2cModule", string, objectName);
        }
    }

    public static J2CPerf createJ2CPerf(String string, ObjectName objectName, ObjectName objectName2, ObjectName objectName3) {
        return PmiFactory.createJ2CPerf(string, null, objectName, objectName2, objectName3, false);
    }

    public static J2CPerf createJ2CPerf(String string, ObjectName objectName, ObjectName objectName2) {
        return PmiFactory.createJ2CPerf(string, null, objectName, objectName2, null, false);
    }

    public static J2CPerf createJ2CPerf(String string, ObjectName objectName, ObjectName objectName2, boolean bl) {
        return PmiFactory.createJ2CPerf(string, null, objectName, objectName2, null, bl);
    }

    public static J2CPerf createJ2CPerf(String string, PmiCallback pmiCallback, ObjectName objectName, ObjectName objectName2, ObjectName objectName3, boolean bl) {
        PmiModule pmiModule;
        ModuleItem moduleItem;
        int n;
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createJ2CPerf: providerName=" + objectName + ", eisName=" + string);
        }
        String string2 = "J2CResourceAdapter";
        if (objectName != null) {
            string2 = objectName.getKeyProperty("type");
        }
        if (string2.equals("JDBCProvider")) {
            return new J2CModule("connectionPoolModule", string, objectName, objectName2, objectName3, bl);
        }
        if (string != null && (n = string.indexOf("$JMSManagedConnection@")) > 0 && (moduleItem = PmiRegistry.findModuleItem(new String[]{"j2cModule", "jmsConnections", string = string.substring(0, n)})) != null && (pmiModule = moduleItem.getInstance()) != null && pmiModule instanceof J2CPerf) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createJ2CPerf: returning previously created PMI module for: " + string);
            }
            return (J2CPerf)((Object)pmiModule);
        }
        return new J2CModule("j2cModule", string, objectName, objectName2, objectName3, bl);
    }

    public static RuntimeModule createJvmPerf(int n, int n2) {
        if (!PmiRegistry.isDisabled()) {
            return new RuntimeModule(n, n2);
        }
        return null;
    }

    public static ServletSessionsPerf createServletSessionsPerf() {
        return PmiFactory.createServletSessionsPerf("unknownWebApp", null);
    }

    public static ServletSessionsPerf createServletSessionsPerf(String string) {
        return PmiFactory.createServletSessionsPerf(string, null);
    }

    public static ServletSessionsPerf createServletSessionsPerf(String string, PmiCallback pmiCallback) {
        if (PmiRegistry.Z) {
            return new SmfServletSessionsModule(string, pmiCallback);
        }
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        return new ServletSessionsModule(string, pmiCallback);
    }

    public static PmiModule createTransactionPerf(Object object) {
        return PmiFactory.createTransactionPerf(object, null);
    }

    public static PmiModule createTransactionPerf(Object object, PmiCallback pmiCallback) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        String string = "com.ibm.ws.pmi.server.modules.TransactionModule";
        PmiModule pmiModule = null;
        try {
            Class<?> clazz = Class.forName(string);
            pmiModule = (PmiModule)clazz.newInstance();
            Object[] objectArray = new Object[]{object};
            pmiModule.init(objectArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.pmi.server.PmiFactory.createTransactionPerf", "275");
            Tr.warning(tc, "PMI0014W", exception.toString());
        }
        return pmiModule;
    }

    public static WLMPerf createWLMPerf(String string) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        return new WLMModule(string);
    }

    public static WSGWModule createWSGWPerf(String string) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        return new WSGWModule(string);
    }

    public static CachePerf createCachePerf() {
        return PmiFactory.createCachePerf("Dynamic Cache");
    }

    public static CachePerf createCachePerf(String string) {
        return PmiFactory.createCachePerf("cache.servlet", "Dynamic Cache");
    }

    public static CachePerf createCachePerf(String string, String string2) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        return new CachePerfModule(string, string2, null);
    }

    public static WebServicesPerf createWebServicesPerf(String string, String string2) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        String string3 = WebServicesModule.buildInstanceName(string, string2);
        WebServicesPerf webServicesPerf = (WebServicesPerf)webServicesMap.get(string3);
        if (webServicesPerf == null) {
            webServicesPerf = new WebServicesModule(string3);
            webServicesMap.put(string3, webServicesPerf);
        }
        return webServicesPerf;
    }

    public static void removePmiModule(Object object) {
        String[] stringArray;
        if (object == null) {
            return;
        }
        Object object2 = null;
        if (PmiRegistry.Z && object instanceof SmfServletSessionsModule && (object2 = ((SmfServletSessionsModule)object).getPmiModule()) == null) {
            return;
        }
        if (object2 == null) {
            object2 = object;
        }
        if (!(object2 instanceof PmiModule)) {
            Tr.warning(tc, "PMI9999E", "removePmiModule(): parameter should be PmiModule type");
            return;
        }
        PmiModule pmiModule = (PmiModule)object2;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removePmiModule: " + pmiModule.getModuleID() + ", " + pmiModule.getName());
        }
        if ((stringArray = pmiModule.getPath()).length == 2 && stringArray[0].equals("webServicesModule")) {
            webServicesMap.remove(stringArray[1]);
        }
        pmiModule.unregister();
    }
}

